// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Modern Greek (`el`).
class AppLocalizationsEl extends AppLocalizations {
  AppLocalizationsEl([String locale = 'el']) : super(locale);

  @override
  String get open => 'Άνοιγμα';

  @override
  String get settings => 'Ρυθμίσεις';

  @override
  String get personalization => 'Εξατομικοποίηση';

  @override
  String get theme => 'Θέμα';

  @override
  String get darkTheme => 'Σκοτεινό θέμα';

  @override
  String get lightTheme => 'Φωτεινό θέμα';

  @override
  String get systemTheme => 'Χρήση προεπιλεγμένου θέματος συστήματος';

  @override
  String get view => 'Προβολή';

  @override
  String get edit => 'Επεξεργασία';

  @override
  String get export => 'Εξαγωγή';

  @override
  String get save => 'Αποθήκευση';

  @override
  String get zoom => 'Εστίαση';

  @override
  String get zoomIn => 'Μεγέθυνση';

  @override
  String get zoomOut => 'Σμίκρυνση';

  @override
  String get resetZoom => 'Reset zoom';

  @override
  String get strokeWidth => 'Πλάτος περιγράμματος';

  @override
  String get includeEraser => 'Συμπεριλάβετε γόμα?';

  @override
  String get thinning => 'Λέπτυνση';

  @override
  String get pen => 'Πένα';

  @override
  String get invertedPen => 'Ανεστραμμένη Πένα';

  @override
  String get eraser => 'Eraser';

  @override
  String get pathEraser => 'Διαδρομή γόμας';

  @override
  String get label => 'Ετικέτα';

  @override
  String get delete => 'Διαγραφή';

  @override
  String get areYouSure => 'Είσαι σίγουρος?';

  @override
  String get reallyDelete =>
      'Θέλετε πραγματικά να διαγράψετε αυτό το στοιχείο?';

  @override
  String get no => 'Όχι';

  @override
  String get yes => 'Ναι';

  @override
  String get undo => 'Αναίρεση';

  @override
  String get redo => 'Επανάληψη';

  @override
  String get general => 'Γενικά';

  @override
  String get copyTitle => 'Αντιγράφηκε στο πρόχειρο';

  @override
  String get loading => 'Φόρτωση...';

  @override
  String get enterText => 'Εισάγετε το κείμενο';

  @override
  String get size => 'Μέγεθος';

  @override
  String get width => 'Width';

  @override
  String get height => 'Ύψος';

  @override
  String get count => 'Μέτρηση';

  @override
  String get space => 'Κενό';

  @override
  String get background => 'Φόντο';

  @override
  String get box => 'Κουτί';

  @override
  String get locale => 'Τοπική';

  @override
  String get systemLocale => 'Τοπική ρύθμιση συστήματος';

  @override
  String get information => 'Πληροφορίες';

  @override
  String get license => 'Άδεια';

  @override
  String get imprint => 'Αποτύπωμα';

  @override
  String get privacypolicy => 'Πολιτική απορρήτου';

  @override
  String get sourceCode => 'Πηγαίος κώδικας';

  @override
  String get documentation => 'Τεκμηρίωση';

  @override
  String get changelog => 'Αρχείο Αλλαγών';

  @override
  String get source => 'Πηγή';

  @override
  String get existOverride => 'Αυτό το στοιχείο υπάρχει ήδη. Αντικατάσταση?';

  @override
  String get description => 'Περιγραφή';

  @override
  String get fill => 'Γέμισμα';

  @override
  String get defaultPalette => 'Προεπιλεγμένη παλέτα';

  @override
  String get highlighter => 'Επισήμανση';

  @override
  String get add => 'Προσθήκη';

  @override
  String get remove => 'Αφαίρεση';

  @override
  String get removeConfirm => 'Θέλετε πραγματικά να το αφαιρέσετε αυτό?';

  @override
  String get resetPalette => 'Reset palette';

  @override
  String get custom => 'Προσαρμοσμένο';

  @override
  String get decoration => 'Διακόσμηση';

  @override
  String get underline => 'Υπογράμμιση';

  @override
  String get overline => 'Συνολική';

  @override
  String get strikethrough => 'Επιγράμμιση';

  @override
  String get thickness => 'Πάχος';

  @override
  String get style => 'Στυλ';

  @override
  String get solid => 'Solid';

  @override
  String get double => 'Διπλό';

  @override
  String get dotted => 'Διακεκομμένη';

  @override
  String get dashed => 'Διακεκομμένη';

  @override
  String get wavy => 'Κυματιστό';

  @override
  String get fontWeight => 'Βάρος γραμματοσειράς';

  @override
  String get normal => 'Κανονικό';

  @override
  String get bold => 'Bold';

  @override
  String get italic => 'Italic';

  @override
  String get clipboard => 'Πρόχειρο';

  @override
  String get file => 'Αρχείο';

  @override
  String get data => 'Δεδομένα';

  @override
  String get share => 'Κοινοποίηση';

  @override
  String get spacing => 'Απόσταση';

  @override
  String get image => 'Εικόνα';

  @override
  String get enterUrl => 'Εισάγετε τη διεύθυνση url';

  @override
  String get scale => 'Κλίμακα';

  @override
  String get help => 'Βοήθεια';

  @override
  String get reallyReset => 'Θέλετε πραγματικά να το επαναφέρετε?';

  @override
  String get whatToDo => 'Τι θέλετε να κάνετε?';

  @override
  String get ignore => 'Παράβλεψη';

  @override
  String get backup => 'Αντίγραφα Ασφαλείας';

  @override
  String createdInNewerVersion(String fileName, int fileVersion) {
    return 'Το αρχείο $fileName δημιουργήθηκε σε μια νεότερη έκδοση ($fileVersion). Τι πρέπει να γίνει με αυτό το αρχείο?';
  }

  @override
  String get waypoints => 'Σημεία';

  @override
  String get origin => 'Καταγωγή';

  @override
  String get import => 'Εισαγωγή';

  @override
  String get newContent => 'Νέο';

  @override
  String get selectElement => 'Επιλογή στοιχείου';

  @override
  String get ctrlKey => 'Ctrl';

  @override
  String get shiftKey => 'Shift';

  @override
  String get altKey => 'Alt';

  @override
  String get copyVersion => 'Αντιγραφή έκδοσης';

  @override
  String get input => 'Input';

  @override
  String get behaviors => 'Συμπεριφορές';

  @override
  String get dataDirectory => 'Κατάλογος δεδομένων';

  @override
  String get defaultPath => 'Προεπιλεγμένη διαδρομή';

  @override
  String get dateFormat => 'Μορφή ημερομηνίας';

  @override
  String updatedAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'Ενημερώθηκε στο: $dateTimeString';
  }

  @override
  String createdAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'Δημιουργήθηκε στο: $dateTimeString';
  }

  @override
  String get rename => 'Μετονομασία';

  @override
  String get duplicate => 'Duplicate';

  @override
  String get hand => 'Χέρι';

  @override
  String get folder => 'Φάκελος';

  @override
  String get move => 'Μετακίνηση';

  @override
  String get copy => 'Αντιγραφή';

  @override
  String get back => 'Πίσω';

  @override
  String get zoomDependent => 'Εξαρτώμενο από ζουμ';

  @override
  String get shapeDetection => 'Ανίχνευση Σχήματος';

  @override
  String get delay => 'Καθυστέρηση';

  @override
  String get defaultLayer => 'Προεπιλεγμένο επίπεδο';

  @override
  String get layer => 'Στρώμα';

  @override
  String get layers => 'Επίπεδα';

  @override
  String get notSet => 'Δεν έχει οριστεί';

  @override
  String get enterLayer => 'Εισάγετε το όνομα του επιπέδου';

  @override
  String get selectElements => 'Επιλογή στοιχείων';

  @override
  String get deleteElements => 'Διαγραφή στοιχείων';

  @override
  String get deleteElementsConfirm =>
      'Θέλετε πραγματικά να διαγράψετε τα επιλεγμένα στοιχεία?';

  @override
  String get selectCustomCollection => 'Επιλέξτε μια προσαρμοσμένη συλλογή';

  @override
  String get svg => 'SVG';

  @override
  String get sensitivity => 'Ευαισθησία';

  @override
  String get sensitivityHint =>
      'Όσο υψηλότερη είναι η τιμή, τόσο πιο ευαίσθητη είναι η είσοδος';

  @override
  String get horizontal => 'Οριζόντια';

  @override
  String get vertical => 'Κατακόρυφα';

  @override
  String get plain => 'Απλό';

  @override
  String get light => 'Φωτεινό';

  @override
  String get ruled => 'Εκτελέστηκε';

  @override
  String get quad => 'Τετράγωνο';

  @override
  String get music => 'Μουσική';

  @override
  String get dark => 'Σκοτεινό';

  @override
  String get plainDark => 'Σκοτεινό';

  @override
  String get ruledDark => 'Τυχόν σκούρο';

  @override
  String get quadDark => 'Τετραπλή σκοτεινή';

  @override
  String get musicDark => 'Σκοτεινή μουσική';

  @override
  String get templates => 'Πρότυπα';

  @override
  String get untitled => 'Άτιτλο';

  @override
  String get createTemplate => 'Δημιουργία προτύπου';

  @override
  String get createTemplateContent =>
      'Θέλετε πραγματικά να δημιουργήσετε ένα πρότυπο από αυτό το έγγραφο? Το αρχικό έγγραφο θα διαγραφεί.';

  @override
  String get replace => 'Αντικατάσταση';

  @override
  String get reallyReplace =>
      'Θέλετε πραγματικά να αντικαταστήσετε το πρότυπο? Αυτή η λειτουργία δεν μπορεί να αναιρεθεί!';

  @override
  String get defaultTemplate => 'Προεπιλεγμένο πρότυπο';

  @override
  String get insert => 'Insert';

  @override
  String get document => 'Έγγραφο';

  @override
  String get camera => 'Κάμερα';

  @override
  String get printout => 'Εκτύπωση';

  @override
  String get selectCamera => 'Επιλογή κάμερας';

  @override
  String get changeDocumentPath => 'Αλλαγή διαδρομής εγγράφου';

  @override
  String get deleteWholeStroke => 'Διαγραφή ολόκληρου του κτυπήματος';

  @override
  String get alpha => 'Άλφα';

  @override
  String get area => 'Ζώνη';

  @override
  String get selectArea => 'Επιλέξτε μια περιοχή';

  @override
  String get aspectRatio => 'Αναλογία διαστάσεων';

  @override
  String get presets => 'Προεπιλογές';

  @override
  String get pagePortrait => 'Πορτρέτο σελίδας';

  @override
  String get pageLandscape => 'Οριζόντια σελίδα';

  @override
  String get square => 'Τετράγωνο';

  @override
  String get areas => 'Περιοχές';

  @override
  String get enterArea => 'Εισάγετε την περιοχή';

  @override
  String get exitArea => 'Έξοδος από την περιοχή';

  @override
  String get currentArea => 'Τρέχουσα περιοχή';

  @override
  String get design => 'Σχεδιασμός';

  @override
  String get text => 'Κείμενο';

  @override
  String welcome(String codeName) {
    return 'Hey, this is Linwood Butterfly $codeName';
  }

  @override
  String get welcomeContent =>
      'Ένας ελεύθερος και ανοιχτού κώδικα χώρος σχεδίασης!';

  @override
  String updated(String version) {
    return 'Η εφαρμογή ενημερώθηκε στην έκδοση $version';
  }

  @override
  String get releaseNotes => 'Σημειώσεις έκδοσης';

  @override
  String get constraints => 'Περιορισμοί';

  @override
  String get scaled => 'Κλιμάκωση';

  @override
  String get fixed => 'Σταθερό';

  @override
  String get dynamicContent => 'Δυναμικό';

  @override
  String get none => 'Κανένα';

  @override
  String get includeArea => 'Ενσωμάτωση περιοχής';

  @override
  String get verticalAlignment => 'Κατακόρυφη στοίχιση';

  @override
  String get horizontalAlignment => 'Οριζόντια στοίχιση';

  @override
  String get top => 'Πάνω';

  @override
  String get center => 'Κέντρο';

  @override
  String get bottom => 'Κάτω';

  @override
  String get left => 'Αριστερά';

  @override
  String get right => 'Δεξιά';

  @override
  String get justify => 'Στοίχιση';

  @override
  String get constraint => 'Περιορισμός';

  @override
  String get length => 'Μήκος';

  @override
  String get exportSvg => 'Εξαγωγή SVG';

  @override
  String get pdf => 'PDF';

  @override
  String get selectPages => 'Επιλογή σελίδων';

  @override
  String get recentFiles => 'Πρόσφατα αρχεία';

  @override
  String get start => 'Έναρξη';

  @override
  String get noRecentFiles => 'Κανένα πρόσφατο αρχείο';

  @override
  String countPages(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count σελίδες',
      one: '1 σελίδα',
      zero: 'Καμία σελίδα',
    );
    return '$_temp0';
  }

  @override
  String pageIndex(int index) {
    return 'Σελίδα $index';
  }

  @override
  String get exit => 'Έξοδος';

  @override
  String get noElements => 'Δεν υπάρχουν στοιχεία';

  @override
  String get invertSelection => 'Αντιστροφή επιλογής';

  @override
  String get errorWhileImporting => 'Σφάλμα κατά την εισαγωγή';

  @override
  String get errorWhileImportingContent =>
      'Παρουσιάστηκε σφάλμα κατά την εισαγωγή του αρχείου';

  @override
  String get showDetails => 'Εμφάνιση λεπτομερειών';

  @override
  String get hideDetails => 'Απόκρυψη λεπτομερειών';

  @override
  String get error => 'Σφάλμα';

  @override
  String get stackTrace => 'Ίχνη στοίβας';

  @override
  String get laser => 'Λέιζερ';

  @override
  String get duration => 'Διάρκεια';

  @override
  String get quality => 'Ποιότητα';

  @override
  String get exportPdf => 'Εξαγωγή PDF';

  @override
  String get local => 'Τοπικό';

  @override
  String get addConnection => 'Προσθήκη σύνδεσης';

  @override
  String get connections => 'Συνδέσεις';

  @override
  String get noConnections => 'Δεν υπάρχουν συνδέσεις';

  @override
  String get url => 'URL';

  @override
  String get connect => 'Σύνδεση';

  @override
  String get username => 'Όνομα Χρήστη';

  @override
  String get password => 'Κωδικός';

  @override
  String get webNotSupported => 'Το Web δεν υποστηρίζεται';

  @override
  String get advanced => 'Προχωρημένα';

  @override
  String get directory => 'Κατάλογος';

  @override
  String get documentsDirectory => 'Κατάλογος εγγράφων';

  @override
  String get templatesDirectory => 'Κατάλογος προτύπων';

  @override
  String get errorWhileCreatingConnection =>
      'Σφάλμα κατά τη δημιουργία σύνδεσης';

  @override
  String get cannotConnect => 'Αδυναμία σύνδεσης';

  @override
  String get urlNotValid => 'Μη έγκυρο URL';

  @override
  String get icon => 'Εικονίδιο';

  @override
  String get update => 'Ενημέρωση';

  @override
  String get updateAvailable => 'Διαθέσιμη ενημέρωση';

  @override
  String get stable => 'Σταθερό';

  @override
  String get nightly => 'Νυχτερινή';

  @override
  String get checkForUpdates => 'Έλεγχος ενημερώσεων';

  @override
  String get checkForUpdatesWarning =>
      'Εκτελώντας έναν έλεγχο για ενημερώσεις θα συνδεθείτε στην ιστοσελίδα Butterfly για να πάρετε τις πληροφορίες.';

  @override
  String get usingLatestStable => 'Χρησιμοποιείτε την τελευταία σταθερή έκδοση';

  @override
  String get usingLatestNightly =>
      'Χρησιμοποιείτε την τελευταία νυχτερινή έκδοση';

  @override
  String get currentVersion => 'Τρέχουσα έκδοση';

  @override
  String get updateNow => 'Ενημέρωση τώρα';

  @override
  String get shape => 'Σχήμα';

  @override
  String get circle => 'Κύκλος';

  @override
  String get rectangle => 'Ορθογώνιο';

  @override
  String get triangle => 'Τρίγωνο';

  @override
  String get line => 'Γραμμή';

  @override
  String get cornerRadius => 'Corner radius';

  @override
  String get topLeft => 'Πάνω αριστερά';

  @override
  String get topRight => 'Πάνω δεξιά';

  @override
  String get bottomLeft => 'Κάτω αριστερά';

  @override
  String get bottomRight => 'Κάτω δεξιά';

  @override
  String get caches => 'Κρύπτες';

  @override
  String get manage => 'Διαχείριση';

  @override
  String get clearCaches => 'Εκκαθάριση κρυπτών';

  @override
  String get createCache => 'Δημιουργία προσωρινής μνήμης';

  @override
  String get thirdPartyLicenses => 'Άδειες χρήσης τρίτων';

  @override
  String get syncing => 'Συγχρονισμός...';

  @override
  String get synced => 'Συγχρονισμένα';

  @override
  String get notSynced => 'Δεν συγχρονίστηκε';

  @override
  String get conflict => 'Σύγκρουση';

  @override
  String get keepLocal => 'Διατήρηση τοπικών';

  @override
  String get keepConnection => 'Διατήρηση σύνδεσης';

  @override
  String get keepBoth => 'Κρατήστε και τα δύο';

  @override
  String get forAll => 'Για όλους';

  @override
  String fileConflict(String file, String connection) {
    return '$file σε $connection έχει μια σύγκρουση';
  }

  @override
  String get offline => 'Αποσυνδεδεμένος';

  @override
  String get localLatest => 'Τοπική πιο πρόσφατη';

  @override
  String get connectionLatest => 'Σύνδεση τελευταία';

  @override
  String get path => 'Διαδρομή';

  @override
  String get folderSynced => 'Ο φάκελος συγχρονίστηκε';

  @override
  String get syncRootDirectory => 'Συγχρονισμός ριζικού καταλόγου';

  @override
  String get penOnlyInput => 'Είσοδος μόνο πένας';

  @override
  String get inputGestures => 'Input gestures';

  @override
  String get nativeTitleBar => 'Εγγενής γραμμή τίτλου';

  @override
  String get syncMode => 'Λειτουργία συγχρονισμού';

  @override
  String get connection => 'Σύνδεση';

  @override
  String get always => 'Πάντα';

  @override
  String get noMobile => 'Χωρίς κινητό';

  @override
  String get manual => 'Χειροκίνητα';

  @override
  String get search => 'Αναζήτηση';

  @override
  String get properties => 'Ιδιότητες';

  @override
  String get pin => 'Καρφίτσα';

  @override
  String get unpin => 'Unpin';

  @override
  String get element => 'Στοιχείο';

  @override
  String get painter => 'Ζωγράφος';

  @override
  String get position => 'Θέση';

  @override
  String get note => 'Σημείωση';

  @override
  String get packs => 'Πακέτα';

  @override
  String get pack => 'Πακέτο';

  @override
  String get more => 'Περισσότερα';

  @override
  String get askForName => 'Ερώτηση ονόματος';

  @override
  String areaIndex(int index) {
    return 'Περιοχή $index';
  }

  @override
  String get startInFullScreen => 'Έναρξη σε πλήρη οθόνη';

  @override
  String get inputs => 'Inputs';

  @override
  String get mouse => 'Ποντίκι';

  @override
  String get touch => 'Άγγιγμα';

  @override
  String get keyboard => 'Keyboard';

  @override
  String get shortcuts => 'Συντομεύσεις';

  @override
  String get middle => 'Μεσαία';

  @override
  String get first => 'Πρώτη';

  @override
  String get second => 'Δευτερόλεπτο';

  @override
  String get activeTool => 'Ενεργό Εργαλείο';

  @override
  String get activeToolDescription =>
      'Χρήση του τρέχοντος επιλεγμένου εργαλείου στη γραμμή εργαλείων';

  @override
  String get handTool => 'Εργαλείο Χεριών';

  @override
  String get handToolDescription => 'Σύρετε για να μετακινηθείτε στον καμβά';

  @override
  String get toolOnToolbar => 'Συγκεκριμένο εργαλείο στη γραμμή εργαλείων';

  @override
  String get toolOnToolbarDescription =>
      'Χρησιμοποιήστε το εργαλείο στην καθορισμένη θέση στη γραμμή εργαλείων, ξεκινώντας από τα αριστερά';

  @override
  String toolOnToolbarShort(int display_position) {
    return 'Toolbar Position: $display_position';
  }

  @override
  String get tools => 'Εργαλεία';

  @override
  String get showGrid => 'Εμφάνιση καννάβου';

  @override
  String get grid => 'Πλέγμα';

  @override
  String get ruler => 'Κανόνας';

  @override
  String get angle => 'Γωνία';

  @override
  String get report => 'Αναφορά';

  @override
  String get newFolder => 'Νέος φάκελος';

  @override
  String get createPack => 'Δημιουργία πακέτου';

  @override
  String get editPack => 'Επεξεργασία πακέτου';

  @override
  String get packsDirectory => 'Κατάλογος πακέτων';

  @override
  String get stamp => 'Σφραγίδα';

  @override
  String get addToPack => 'Προσθήκη στο πακέτο';

  @override
  String get sureImportPack =>
      'Είστε σίγουροι ότι θέλετε να εισαγάγετε το πακέτο?';

  @override
  String byAuthor(String author) {
    return 'από $author';
  }

  @override
  String get author => 'Συγγραφέας';

  @override
  String get addAsset => 'Προσθήκη στοιχείου';

  @override
  String get editAsset => 'Επεξεργασία στοιχείου';

  @override
  String get scope => 'Πεδίο';

  @override
  String get noPacks => 'Προς το παρόν δεν υπάρχουν διαθέσιμα πακέτα';

  @override
  String get components => 'Συστατικά';

  @override
  String get waypoint => 'Σημείο Πορείας';

  @override
  String get actions => 'Ενέργειες';

  @override
  String get painters => 'Ζωγράφοι';

  @override
  String get breakingChangesTitle => 'Σπάζοντας τις αλλαγές';

  @override
  String breakingChangesMessage(int version, int newVersion) {
    return 'Υπάρχουν αλλαγές σε αυτήν την έκδοση. Παρακαλώ διαβάστε το αρχείο αλλαγών πριν από την ενημέρωση. Η τρέχουσα έκδοση του αρχείου είναι $version, η νέα έκδοση είναι $newVersion.';
  }

  @override
  String get styles => 'Styles';

  @override
  String get paragraph => 'Παράγραφος';

  @override
  String get fontFamily => 'Οικογένεια γραμματοσειρών';

  @override
  String get smoothing => 'Εξομάλυνση';

  @override
  String get streamline => 'Ροή';

  @override
  String get presentation => 'Παρουσίαση';

  @override
  String get selectAsset => 'Επιλέξτε στοιχείο';

  @override
  String get clearStyle => 'Καθαρισμός στυλ';

  @override
  String get unknownImportType => 'Άγνωστος τύπος εισαγωγής';

  @override
  String get sureImportTemplate =>
      'Είστε βέβαιοι ότι θέλετε να εισαγάγετε το πρότυπο?';

  @override
  String get frame => 'Frame';

  @override
  String get play => 'Αναπαραγωγή';

  @override
  String get video => 'Βίντεο';

  @override
  String get fps => 'FPS';

  @override
  String get breakpoint => 'Σημείο διακοπής';

  @override
  String get presentationControls => 'Στοιχεία ελέγχου παρουσίασης';

  @override
  String get nextSlide => 'Επόμενη διαφάνεια';

  @override
  String get nextSlideDescription =>
      'Σύρετε προς τα δεξιά ή πατήστε το δεξί πλήκτρο βέλους για να μεταβείτε στην επόμενη διαφάνεια';

  @override
  String get previousSlide => 'Προηγούμενη διαφάνεια';

  @override
  String get previousSlideDescription =>
      'Σύρετε προς τα αριστερά ή πατήστε το αριστερό πλήκτρο βέλους για να μεταβείτε στο προηγούμενο σλάιντ';

  @override
  String get exitPresentation => 'Παρουσίαση εξόδου';

  @override
  String get exitPresentationDescription =>
      'Πατήστε το πλήκτρο διαφυγής ή σαρώστε προς τα κάτω για να βγείτε από την παρουσίαση';

  @override
  String get pausePresentation => 'Παύση παρουσίασης';

  @override
  String get pausePresentationDescription =>
      'Πατήστε την οθόνη ή πατήστε το πλήκτρο διαστήματος για παύση ή συνέχιση της παρουσίασης';

  @override
  String get keyframe => 'Keyframe';

  @override
  String get endOfPresentation => 'Έχετε φτάσει στο τέλος της παρουσίασης';

  @override
  String get startOfPresentation => 'Έχετε φτάσει στην αρχή της παρουσίασης';

  @override
  String get palettes => 'Palettes';

  @override
  String headline(int index) {
    return 'Επικεφαλίδα $index';
  }

  @override
  String get code => 'Κωδικός';

  @override
  String get quote => 'Παράθεση';

  @override
  String get link => 'Σύνδεσμος';

  @override
  String get checkbox => 'Πλαίσιο';

  @override
  String get deleted => 'Διαγράφηκε';

  @override
  String get emphasis => 'Έμφαση';

  @override
  String get listBullet => 'Λίστα κουκκίδας';

  @override
  String get strong => 'Ισχυρός';

  @override
  String get markdown => 'Markdown';

  @override
  String get home => 'Αρχική';

  @override
  String get files => 'Αρχεία';

  @override
  String get sortBy => 'Ταξινόμηση κατά';

  @override
  String get location => 'Τοποθεσία';

  @override
  String get whatsNew => 'Τι νέο υπάρχει?';

  @override
  String get unstar => 'Unstar';

  @override
  String get star => 'Αστέρι';

  @override
  String get goUp => 'Μετάβαση πάνω';

  @override
  String get created => 'Δημιουργήθηκε';

  @override
  String get modified => 'Τροποποιήθηκε';

  @override
  String get quickstart => 'Γρήγορη Έναρξη';

  @override
  String get noTemplates => 'Προς το παρόν δεν υπάρχουν διαθέσιμα πρότυπα';

  @override
  String get importCorePack => 'Εισαγωγή βασικού πακέτου';

  @override
  String get importCorePackDescription =>
      'Εισαγωγή του βασικού πακέτου που περιέχει όλα τα βασικά στοιχεία ενεργητικού για να ξεκινήσετε. Αυτό θα αντικαταστήσει το τρέχον βασικό πακέτο.';

  @override
  String get never => 'Ποτέ';

  @override
  String get onlyOnUpdates => 'Μόνο στις ενημερώσεις';

  @override
  String get visibility => 'Ορατότητα';

  @override
  String get captureThumbnail => 'Σύλληψη μικρογραφίας';

  @override
  String get capturedThumbnail => 'Επιτυχής λήψη μικρογραφίας';

  @override
  String get chooseLabelMode => 'Επιλέξτε λειτουργία ετικέτας';

  @override
  String get foreground => 'Προσκήνιο';

  @override
  String get version => 'Έκδοση';

  @override
  String get repository => 'Αποθετήριο';

  @override
  String get pages => 'Σελίδες';

  @override
  String get navigator => 'Navigator';

  @override
  String get arrange => 'Τακτοποίηση';

  @override
  String get bringToFront => 'Φέρτε μπροστά';

  @override
  String get sendToBack => 'Αποστολή πίσω';

  @override
  String get bringForward => 'Φέρτε μπροστά';

  @override
  String get sendBackward => 'Αποστολή πίσω';

  @override
  String get rotation => 'Περιστροφή';

  @override
  String get onlyAvailableLargerScreen =>
      'Διαθέσιμο μόνο σε μεγαλύτερες οθόνες';

  @override
  String get toolbarPosition => 'Θέση γραμμής εργαλείων';

  @override
  String get rotate => 'Περιστροφή';

  @override
  String get spacer => 'Διάστημα';

  @override
  String get navigationRail => 'Σιδηρόδρομος πλοήγησης';

  @override
  String get cut => 'Αποκοπή';

  @override
  String get insertBefore => 'Εισαγωγή πριν';

  @override
  String get insertAfter => 'Εισαγωγή μετά';

  @override
  String get insertFirst => 'Εισαγωγή πρώτα';

  @override
  String get insertLast => 'Insert last';

  @override
  String get paste => 'Επικόλληση';

  @override
  String get ascending => 'Αύξουσα';

  @override
  String get descending => 'Φθίνουσα';

  @override
  String get imageScale => 'Κλίμακα εικόνας';

  @override
  String get select => 'Επιλογή';

  @override
  String get tool => 'Εργαλείο';

  @override
  String get texture => 'Υφή';

  @override
  String get platformTheme => 'Θέμα πλατφόρμας';

  @override
  String get desktop => 'Επιφάνεια Εργασίας';

  @override
  String get mobile => 'Κινητό';

  @override
  String get pdfQuality => 'Ποιότητα PDF';

  @override
  String get surface => 'Επιφάνεια';

  @override
  String get pattern => 'Μοτίβο';

  @override
  String get sureClose => 'Είστε βέβαιοι ότι θέλετε να κλείσετε το έγγραφο?';

  @override
  String get thereAreUnsavedChanges =>
      'Υπάρχουν αλλαγές που δεν έχουν αποθηκευτεί';

  @override
  String get page => 'Σελίδα';

  @override
  String get iceServers => 'Διακομιστές ICE';

  @override
  String get collaboration => 'Συνεργασία';

  @override
  String get webRtc => 'Web RTC';

  @override
  String get webSocket => 'Υποδοχή Ιστού';

  @override
  String get iceServer => 'Εξυπηρετητής ICE';

  @override
  String get port => 'Θύρα';

  @override
  String get type => 'Τύπος';

  @override
  String get side => 'Πλευρά';

  @override
  String get client => 'Πελάτης';

  @override
  String get server => 'Διακομιστής';

  @override
  String get switchView => 'Εναλλαγή Προβολής';

  @override
  String get lasso => 'Lasso';

  @override
  String get hideUI => 'Απόκρυψη UI';

  @override
  String get density => 'Πυκνότητα';

  @override
  String get compact => 'Συμπαγής';

  @override
  String get comfortable => 'Άνετο';

  @override
  String get standard => 'Τυπικό';

  @override
  String get lock => 'Κλείδωμα';

  @override
  String get addElement => 'Προσθήκη στοιχείου';

  @override
  String get notDefaultConnection => 'Μη προεπιλεγμένη σύνδεση';

  @override
  String get defaultConnection => 'Προεπιλεγμένη σύνδεση';

  @override
  String get hide => 'Απόκρυψη';

  @override
  String get show => 'Εμφάνιση';

  @override
  String get pause => 'Παύση';

  @override
  String get stop => 'Διακοπή';

  @override
  String get refresh => 'Ανανέωση';

  @override
  String get print => 'Εκτύπωση';

  @override
  String get dav => 'DAV';

  @override
  String get eyeDropper => 'Σταγονόμετρο ματιών';

  @override
  String get users => 'Χρήστες';

  @override
  String get experiments => 'Πειράματα';

  @override
  String get experimentsWarning =>
      'Αυτά τα χαρακτηριστικά είναι πειραματικά και μπορεί να αλλάξουν, να σπάσουν ή να εξαφανιστούν ανά πάσα στιγμή. Η ενεργοποίηση τους μπορεί να προκαλέσει αστάθεια ή απώλεια δεδομένων. Συνεχίστε με προσοχή. Παρακαλώ αναφέρετε τυχόν σφάλματα.';

  @override
  String get address => 'Διεύθυνση';

  @override
  String get spreadToPages => 'Διαδώστε στις σελίδες';

  @override
  String get rootDirectorySpecifiedDescription =>
      'Ο ριζικός κατάλογος έχει καθοριστεί. Όλες οι προχωρημένες διαδρομές καταλόγου θα είναι σχετικές με αυτόν τον κατάλογο. Κρατήστε τον κενό για να απενεργοποιήσετε αυτόν τον τύπο καταλόγου.';

  @override
  String get rootDirectoryNotSpecifiedDescription =>
      'Ο ριζικός κατάλογος δεν έχει καθοριστεί. Απαιτείται ένα όνομα. Όλες οι προχωρημένες διαδρομές καταλόγου θα είναι απόλυτες. Κρατήστε το κενό για να απενεργοποιήσετε αυτόν τον τύπο καταλόγου.';

  @override
  String get unsecureConnectionTitle => 'Μη ασφαλής σύνδεση';

  @override
  String unsecureConnectionMessage(String fingerprint) {
    return 'The connection is not secure. This can be a security risk. Please only continue if you trust the connection. The sha1 fingerprint is $fingerprint.';
  }

  @override
  String get continueAnyway => 'Συνεχίστε οπωσδήποτε';

  @override
  String get zoomControl => 'Έλεγχος εστίασης';

  @override
  String get highContrast => 'Υψηλή αντίθεση';

  @override
  String get shouldANumber => 'Αυτή η τιμή πρέπει να είναι έγκυρος αριθμός';

  @override
  String get createAreas => 'Δημιουργία περιοχών';

  @override
  String get autosave => 'Autosave';

  @override
  String get invert => 'Invert';

  @override
  String get operations => 'Λειτουργίες';

  @override
  String get medium => 'Μεσαίο';

  @override
  String get large => 'Μεγάλο';

  @override
  String get toolbarSize => 'Μέγεθος γραμμής εργαλείων';

  @override
  String get addAll => 'Προσθήκη όλων';

  @override
  String get onlyCurrentPage => 'Μόνο η τρέχουσα σελίδα';

  @override
  String get smoothNavigation => 'Ομαλή πλοήγηση';

  @override
  String get exact => 'Ακριβής';

  @override
  String get inline => 'Εμβόλιμο';

  @override
  String get toolbarRows => 'Γραμμές γραμμής εργαλείων';

  @override
  String get pointerTest => 'Δοκιμή δείκτη';

  @override
  String get pressure => 'Πίεση';

  @override
  String get small => 'Μικρό';

  @override
  String get tiny => 'Μικροσκοπικό';

  @override
  String get selectAll => 'Επιλογή όλων';

  @override
  String get overrideTools => 'Παράκαμψη εργαλείων';

  @override
  String get hideCursorWhileDrawing => 'Απόκρυψη δρομέα κατά το σχέδιο';

  @override
  String get installed => 'Εγκατεστημένο';

  @override
  String get install => 'Εγκατάσταση';

  @override
  String get deselect => 'Αποεπιλογή';

  @override
  String get changeCollection => 'Αλλαγή συλλογής';

  @override
  String get collections => 'Συλλογές';

  @override
  String get fullSelection => 'Πλήρης επιλογή';

  @override
  String get fullSelectionDescription =>
      'Απαιτεί στοιχεία να είναι πλήρως εντός του πλαισίου επιλογής για την επιλογή.';

  @override
  String get collection => 'Συλλογή';

  @override
  String get defaultCollection => 'Προεπιλεγμένη συλλογή';

  @override
  String get scroll => 'Κύλιση';

  @override
  String get onStartup => 'Κατά την εκκίνηση';

  @override
  String get homeScreen => 'Αρχική οθόνη';

  @override
  String get lastNote => 'Τελευταία σημείωση';

  @override
  String get newNote => 'Νέα σημείωση';

  @override
  String get convertToLayer => 'Μετατροπή σε επίπεδο';

  @override
  String get merge => 'Συγχώνευση';

  @override
  String get up => 'Επάνω';

  @override
  String get down => 'Κάτω';

  @override
  String get other => 'Άλλο';

  @override
  String countElements(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count στοιχεία',
      one: '1 στοιχείο',
      zero: 'Κανένα στοιχείο',
    );
    return '$_temp0';
  }

  @override
  String get colorToolbar => 'Γραμμή εργαλείων χρωμάτων';

  @override
  String get yesButShowButtons => 'Ναι, αλλά εμφάνιση κουμπιών';

  @override
  String get optionsPanelPosition => 'Θέση πίνακα επιλογών';

  @override
  String get hideDuration => 'Διάρκεια απόκρυψης';

  @override
  String get animation => 'Κίνηση';

  @override
  String get performance => 'Επιδόσεις';

  @override
  String get performanceDescription =>
      'Βελτιστοποιημένο για τη χρήση ταχύτητας και μνήμης. Μόνο το ορατό τμήμα της σημείωσης ψήνεται μέσα στην εικόνα.';

  @override
  String get normalDescription =>
      'Προσδίδει μια εικόνα που καλύπτει 1,5 φορές την ορατή περιοχή, παρέχοντας ομαλότερες μεταβάσεις κατά την κύλιση.';

  @override
  String get high => 'Υψηλή';

  @override
  String get highDescription =>
      'Μεγιστοποιεί την ποιότητα με κόστος την απόδοση. Μπαίνει μια εικόνα που καλύπτει 2 φορές την ορατή περιοχή, εξασφαλίζοντας απρόσκοπτη απόδοση ακόμη και κατά τη διάρκεια της ταχείας κύλισης ή μεγέθυνσης.';

  @override
  String get renderResolution => 'Ανάλυση απόδοσης';

  @override
  String get translate => 'Μετάφραση';

  @override
  String get unencrypted => 'Μη Κρυπτογραφημένο';

  @override
  String get encrypted => 'Κρυπτογραφημένο';

  @override
  String get encryptDocumentMessage =>
      'Κάντε κλικ για κρυπτογράφηση του εγγράφου';

  @override
  String get unencryptDocumentMessage =>
      'Κάντε κλικ για μη κρυπτογράφηση του εγγράφου';

  @override
  String get unencrypt => 'Μη Κρυπτογράφηση';

  @override
  String get encrypt => 'Κρυπτογράφηση';

  @override
  String get encryptWarning =>
      'Αυτό θα κρυπτογραφήσει το έγγραφο. Θα πρέπει να θυμάστε τον κωδικό πρόσβασης για να τον αποκρυπτογραφήσετε.';

  @override
  String get unencryptWarning =>
      'Αυτό θα αποκρυπτογραφήσει το έγγραφο. Ο κωδικός πρόσβασης θα αφαιρεθεί και όλοι με πρόσβαση θα είναι σε θέση να το ανοίξουν.';

  @override
  String get confirmPassword => 'Επιβεβαίωση κωδικού πρόσβασης';

  @override
  String get passwordMismatch => 'Οι κωδικοί πρόσβασης δεν ταιριάζουν';

  @override
  String get action => 'Ενέργεια';

  @override
  String get svgText => 'Κείμενο SVG';

  @override
  String get offset => 'Μετατόπιση';

  @override
  String get positionDependent => 'Εξάρτηση από τη θέση';

  @override
  String get flipHorizontal => 'Οριζόντια αναστροφή';

  @override
  String get flipVertical => 'Κάθετη αναστροφή';

  @override
  String get grayscale => 'Grayscale';

  @override
  String get moveOnGesture => 'Μετακίνηση στη χειρονομία';

  @override
  String get exportAllFiles => 'Εξαγωγή όλων των αρχείων';

  @override
  String get restoreSettingsFromFile => 'Επαναφορά ρυθμίσεων από αρχείο';

  @override
  String get exportSettingsToFile => 'Εξαγωγή ρυθμίσεων σε αρχείο';

  @override
  String get barcode => 'Barcode';

  @override
  String get barcodeType => 'Τύπος γραμμωτού κώδικα';

  @override
  String get qrCode => 'QR Code';

  @override
  String get dataMatrix => 'Πίνακας Δεδομένων';

  @override
  String get code128 => 'Κωδικός 128';

  @override
  String defaultUserName(int index) {
    return 'User $index';
  }

  @override
  String get moveLeft => 'Μετακίνηση αριστερά';

  @override
  String get moveRight => 'Μετακίνηση δεξιά';

  @override
  String get bundledPacks => 'Συνδυασμένα πακέτα';

  @override
  String get component => 'Συστατικό';

  @override
  String get selectComponent => 'Επιλογή στοιχείου';

  @override
  String get bundlePackInDocument => 'Πακέτο πακέτου σε έγγραφο';

  @override
  String get bundledPacksDescription =>
      'Τα ομαδοποιημένα πακέτα περιλαμβάνονται στο έγγραφο και χρησιμοποιούνται μόνο για να μοιραστούν με το έγγραφο. Τα περιουσιακά στοιχεία μπορούν να χρησιμοποιηθούν στο έγγραφο μόνο αν είναι εγκατεστημένο το πακέτο. Τα πακέτα μπορούν να εγκατασταθούν κάνοντας κλικ πάνω τους.';

  @override
  String get fillAlpha => 'Γέμισμα άλφα';

  @override
  String get packagedFile => 'Πακεταρισμένο αρχείο';

  @override
  String get rawFile => 'Αρχείο Raw';

  @override
  String get webSocketDescription =>
      'Η συσκευή σας φιλοξενεί το διακομιστή, έτσι ώστε οι συνεργάτες να μπορούν να συμμετέχουν στο ίδιο δίκτυο ή οπουδήποτε αν προωθείτε τη θύρα στον δρομολογητή σας.';

  @override
  String get swampDescription =>
      'Τα μηνύματά σας δρομολογούνται μέσω ενός ασφαλούς διακομιστή ρελέ με κρυπτογράφηση από άκρο σε άκρο. Απαιτείται μια διεύθυνση διακομιστή swamp για τη δημιουργία μιας συνεδρίας.';

  @override
  String get createRawNote => 'Δημιουργία ακατέργαστης σημείωσης';

  @override
  String get polygon => 'Πολύγωνο';

  @override
  String get finishShape => 'Ολοκλήρωση σχήματος';

  @override
  String get submit => 'Υποβολή';

  @override
  String get math => 'Μαθηματικά';

  @override
  String get ignorePressure => 'Παράβλεψη πίεσης';

  @override
  String get ignoreFirstPressureDescription =>
      'Σε ορισμένες συσκευές, η πρώτη τιμή πίεσης δεν είναι ακριβής. Αυτή η ρύθμιση θα αγνοήσει την πρώτη τιμή πίεσης και θα χρησιμοποιήσει την πίεση του δεύτερου γεγονότος.';

  @override
  String get temporary => 'Προσωρινή';

  @override
  String get simpleToolbarVisibility => 'Απλή ορατότητα γραμμής εργαλείων';

  @override
  String get autosaveDelay => 'Καθυστέρηση αυτόματης αποθήκευσης';

  @override
  String get saved => 'Αποθηκεύτηκε';

  @override
  String get saving => 'Αποθηκεύεται...';

  @override
  String get readOnly => 'Μόνο για ανάγνωση';

  @override
  String get saveDelayed => 'Η αποθήκευση καθυστέρησε';

  @override
  String get unsaved => 'Μη Αποθηκευμένα';

  @override
  String get pdfEmptyDescription =>
      'Προς το παρόν δεν υπάρχουν περιοχές για εξαγωγή. Παρακαλώ επιλέξτε τουλάχιστον μία περιοχή χρησιμοποιώντας το κουμπί συν στην επάνω δεξιά γωνία ή προσθέστε όλες τις περιοχές από την τρέχουσα σελίδα ή από ολόκληρο το κείμενο παρακάτω.';

  @override
  String get densityMaximize => 'Maximize';
}
