// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Vietnamese (`vi`).
class AppLocalizationsVi extends AppLocalizations {
  AppLocalizationsVi([String locale = 'vi']) : super(locale);

  @override
  String get open => 'Mở';

  @override
  String get settings => 'Cài đặt';

  @override
  String get personalization => 'Cá nhân hóa';

  @override
  String get theme => 'Giao diện';

  @override
  String get darkTheme => 'Giao diện tối';

  @override
  String get lightTheme => 'Giao diện sáng';

  @override
  String get systemTheme => 'Dùng giao diện mặc định của máy';

  @override
  String get view => 'Hiển thị';

  @override
  String get edit => 'Chỉnh sửa';

  @override
  String get export => 'Xuất dữ liệu';

  @override
  String get save => 'Lưu';

  @override
  String get zoom => 'Thu phóng';

  @override
  String get zoomIn => 'Phóng to';

  @override
  String get zoomOut => 'Thu nhỏ';

  @override
  String get resetZoom => 'Đặt lại';

  @override
  String get strokeWidth => 'Độ dày nét';

  @override
  String get includeEraser => 'Bao gồm công cụ tẩy?';

  @override
  String get thinning => 'Làm mảnh';

  @override
  String get pen => 'Bút vẽ';

  @override
  String get invertedPen => 'Bút đảo ngược';

  @override
  String get eraser => 'Tẩy';

  @override
  String get pathEraser => 'Bút xóa đường';

  @override
  String get label => 'Nhãn';

  @override
  String get delete => 'Xóa';

  @override
  String get areYouSure => 'Bạn chắc chứ?';

  @override
  String get reallyDelete => 'Bạn có thực sự muốn xoá mục này?';

  @override
  String get no => 'Không';

  @override
  String get yes => 'Có';

  @override
  String get undo => 'Hoàn tác';

  @override
  String get redo => 'Làm lại';

  @override
  String get general => 'Chung';

  @override
  String get copyTitle => 'Đã sao chép vào bộ nhớ tạm';

  @override
  String get loading => 'Đang tải...';

  @override
  String get enterText => 'Nhập văn bản';

  @override
  String get size => 'Kích thước';

  @override
  String get width => 'Chiều rộng';

  @override
  String get height => 'Chiều cao';

  @override
  String get count => 'Số lượng';

  @override
  String get space => 'Phím cách';

  @override
  String get background => 'Nền';

  @override
  String get box => 'Hộp';

  @override
  String get locale => 'Ngôn ngữ';

  @override
  String get systemLocale => 'Ngôn ngữ hệ thống';

  @override
  String get information => 'Thông tin';

  @override
  String get license => 'Giấy phép';

  @override
  String get imprint => 'Thông tin pháp lý';

  @override
  String get privacypolicy => 'Chính sách bảo mật';

  @override
  String get sourceCode => 'Mã nguồn';

  @override
  String get documentation => 'Tài liệu';

  @override
  String get changelog => 'Nhật ký thay đổi';

  @override
  String get source => 'Nguồn';

  @override
  String get existOverride => 'Phần tử này đã tồn tại. Ghi đè?';

  @override
  String get description => 'Mô tả';

  @override
  String get fill => 'Tô';

  @override
  String get defaultPalette => 'Bảng màu mặc định';

  @override
  String get highlighter => 'Bút đánh dấu';

  @override
  String get add => 'Thêm';

  @override
  String get remove => 'Loại bỏ';

  @override
  String get removeConfirm => 'Bạn có thực sự muốn loại bỏ không?';

  @override
  String get resetPalette => 'Đặt lại bảng màu';

  @override
  String get custom => 'Tùy chỉnh';

  @override
  String get decoration => 'Trang trí';

  @override
  String get underline => 'Gạch chân';

  @override
  String get overline => 'Gạch đầu';

  @override
  String get strikethrough => 'Gạch ngang';

  @override
  String get thickness => 'Độ dày';

  @override
  String get style => 'Kiểu';

  @override
  String get solid => 'Khối';

  @override
  String get double => 'Đường kẻ đôi';

  @override
  String get dotted => 'Chấm chấm';

  @override
  String get dashed => 'Cắt khúc';

  @override
  String get wavy => 'Dợn sóng';

  @override
  String get fontWeight => 'Kích cỡ phông chữ';

  @override
  String get normal => 'Thường';

  @override
  String get bold => 'In đậm';

  @override
  String get italic => 'In nghiêng';

  @override
  String get clipboard => 'Bảng nhớ tạm';

  @override
  String get file => 'Tệp tin';

  @override
  String get data => 'Dữ liệu';

  @override
  String get share => 'Chia sẻ';

  @override
  String get spacing => 'Khoảng cách';

  @override
  String get image => 'Hình ảnh';

  @override
  String get enterUrl => 'Nhập URL';

  @override
  String get scale => 'Tỷ lệ';

  @override
  String get help => 'Trợ giúp';

  @override
  String get reallyReset => 'Bạn có thực sự muốn đặt lại không?';

  @override
  String get whatToDo => 'Bạn muốn làm gì?';

  @override
  String get ignore => 'Bỏ qua';

  @override
  String get backup => 'Sao lưu';

  @override
  String createdInNewerVersion(String fileName, int fileVersion) {
    return 'Tệp tin $fileName đã được tạo với phiên bản mới hơn ($fileVersion). Nên làm gì với tệp tin này?';
  }

  @override
  String get waypoints => 'Điểm dừng';

  @override
  String get origin => 'Gốc';

  @override
  String get import => 'Nhập';

  @override
  String get newContent => 'Mới';

  @override
  String get selectElement => 'Chọn phần tử';

  @override
  String get ctrlKey => 'Ctrl';

  @override
  String get shiftKey => 'Shift';

  @override
  String get altKey => 'Alt';

  @override
  String get copyVersion => 'Sao chép phiên bản';

  @override
  String get input => 'Đầu vào';

  @override
  String get behaviors => 'Hành vi';

  @override
  String get dataDirectory => 'Thư mục dữ liệu';

  @override
  String get defaultPath => 'Đường dẫn mặc định';

  @override
  String get dateFormat => 'Định dạng ngày tháng';

  @override
  String updatedAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'Đã được cập nhật lúc: $dateTimeString';
  }

  @override
  String createdAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'Đã được tạo lúc: $dateTimeString';
  }

  @override
  String get rename => 'Đổi tên';

  @override
  String get duplicate => 'Tạo bản sao';

  @override
  String get hand => 'Tay';

  @override
  String get folder => 'Thư mục';

  @override
  String get move => 'Di chuyển';

  @override
  String get copy => 'Sao chép';

  @override
  String get back => 'Quay lại';

  @override
  String get zoomDependent => 'Phụ thuộc thu phóng';

  @override
  String get shapeDetection => 'Phát hiện hình dạng';

  @override
  String get delay => 'Độ trễ';

  @override
  String get defaultLayer => 'Lớp mặc định';

  @override
  String get layer => 'Lớp';

  @override
  String get layers => 'Các lớp';

  @override
  String get notSet => 'Chưa đặt';

  @override
  String get enterLayer => 'Nhập tên lớp';

  @override
  String get selectElements => 'Chọn các phần tử';

  @override
  String get deleteElements => 'Xóa các phần tử';

  @override
  String get deleteElementsConfirm =>
      'Bạn có thực sự muốn xóa các phần tử đã chọn không?';

  @override
  String get selectCustomCollection => 'Chọn bộ sưu tập tùy chỉnh';

  @override
  String get svg => 'SVG';

  @override
  String get sensitivity => 'Độ nhạy';

  @override
  String get sensitivityHint => 'Giá trị càng cao, đầu vào càng nhạy';

  @override
  String get horizontal => 'Ngang';

  @override
  String get vertical => 'Dọc';

  @override
  String get plain => 'Trơn';

  @override
  String get light => 'Sáng';

  @override
  String get ruled => 'Có dòng kẻ';

  @override
  String get quad => 'Lưới ô vuông';

  @override
  String get music => 'Âm nhạc';

  @override
  String get dark => 'Tối';

  @override
  String get plainDark => 'Trơn tối';

  @override
  String get ruledDark => 'Dòng tối';

  @override
  String get quadDark => 'Lưới tối';

  @override
  String get musicDark => 'Âm nhạc tối';

  @override
  String get templates => 'Mẫu';

  @override
  String get untitled => 'Không tên';

  @override
  String get createTemplate => 'Tạo mẫu';

  @override
  String get createTemplateContent =>
      'Bạn có thực sự muốn tạo mẫu từ tài liệu này không? Tài liệu gốc sẽ bị xóa.';

  @override
  String get replace => 'Thay thế';

  @override
  String get reallyReplace =>
      'Bạn có thực sự muốn thay thế mẫu không? Hành động này không thể hoàn tác!';

  @override
  String get defaultTemplate => 'Mẫu mặc định';

  @override
  String get insert => 'Chèn';

  @override
  String get document => 'Tài liệu';

  @override
  String get camera => 'Camera';

  @override
  String get printout => 'Bản in';

  @override
  String get selectCamera => 'Chọn camera';

  @override
  String get changeDocumentPath => 'Thay đổi đường dẫn tài liệu';

  @override
  String get deleteWholeStroke => 'Xóa toàn bộ nét vẽ';

  @override
  String get alpha => 'Độ trong suốt';

  @override
  String get area => 'Khu vực';

  @override
  String get selectArea => 'Chọn khu vực';

  @override
  String get aspectRatio => 'Tỷ lệ khung hình';

  @override
  String get presets => 'Cài đặt trước';

  @override
  String get pagePortrait => 'Khổ dọc';

  @override
  String get pageLandscape => 'Khổ ngang';

  @override
  String get square => 'Vuông';

  @override
  String get areas => 'Các khu vực';

  @override
  String get enterArea => 'Nhập khu vực';

  @override
  String get exitArea => 'Thoát khu vực';

  @override
  String get currentArea => 'Khu vực hiện tại';

  @override
  String get design => 'Thiết kế';

  @override
  String get text => 'Văn bản';

  @override
  String welcome(String codeName) {
    return 'Chào, đây là Linwood Butterfly $codeName';
  }

  @override
  String get welcomeContent => 'Một không gian vẽ tự do và mã nguồn mở!';

  @override
  String updated(String version) {
    return 'Ứng dụng đã được cập nhật lên phiên bản $version';
  }

  @override
  String get releaseNotes => 'Ghi chú phát hành';

  @override
  String get constraints => 'Ràng buộc';

  @override
  String get scaled => 'Đã thu phóng';

  @override
  String get fixed => 'Cố định';

  @override
  String get dynamicContent => 'Nội dung động';

  @override
  String get none => 'Không có';

  @override
  String get includeArea => 'Bao gồm khu vực';

  @override
  String get verticalAlignment => 'Căn dọc';

  @override
  String get horizontalAlignment => 'Căn ngang';

  @override
  String get top => 'Trên cùng';

  @override
  String get center => 'Giữa';

  @override
  String get bottom => 'Dưới cùng';

  @override
  String get left => 'Trái';

  @override
  String get right => 'Phải';

  @override
  String get justify => 'Căn đều';

  @override
  String get constraint => 'Ràng buộc';

  @override
  String get length => 'Chiều dài';

  @override
  String get exportSvg => 'Xuất SVG';

  @override
  String get pdf => 'PDF';

  @override
  String get selectPages => 'Chọn trang';

  @override
  String get recentFiles => 'Tệp tin gần đây';

  @override
  String get start => 'Bắt đầu';

  @override
  String get noRecentFiles => 'Không có tệp tin gần đây';

  @override
  String countPages(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count trang',
      one: '1 trang',
      zero: 'Không có trang',
    );
    return '$_temp0';
  }

  @override
  String pageIndex(int index) {
    return 'Trang $index';
  }

  @override
  String get exit => 'Thoát';

  @override
  String get noElements => 'Không có phần tử';

  @override
  String get invertSelection => 'Đảo ngược lựa chọn';

  @override
  String get errorWhileImporting => 'Lỗi khi nhập';

  @override
  String get errorWhileImportingContent => 'Đã xảy ra lỗi khi nhập tệp tin';

  @override
  String get showDetails => 'Hiện chi tiết';

  @override
  String get hideDetails => 'Ẩn chi tiết';

  @override
  String get error => 'Lỗi';

  @override
  String get stackTrace => 'Dấu vết ngăn xếp';

  @override
  String get laser => 'Laser';

  @override
  String get duration => 'Thời lượng';

  @override
  String get quality => 'Chất lượng';

  @override
  String get exportPdf => 'Xuất PDF';

  @override
  String get local => 'Cục bộ';

  @override
  String get addConnection => 'Thêm kết nối';

  @override
  String get connections => 'Kết nối';

  @override
  String get noConnections => 'Không có kết nối';

  @override
  String get url => 'URL';

  @override
  String get connect => 'Kết nối';

  @override
  String get username => 'Tên người dùng';

  @override
  String get password => 'Mật khẩu';

  @override
  String get webNotSupported => 'Trình duyệt không hỗ trợ';

  @override
  String get advanced => 'Nâng cao';

  @override
  String get directory => 'Thư mục';

  @override
  String get documentsDirectory => 'Thư mục tài liệu';

  @override
  String get templatesDirectory => 'Thư mục mẫu';

  @override
  String get errorWhileCreatingConnection => 'Lỗi khi tạo kết nối';

  @override
  String get cannotConnect => 'Không thể kết nối';

  @override
  String get urlNotValid => 'URL không hợp lệ';

  @override
  String get icon => 'Biểu tượng';

  @override
  String get update => 'Cập nhật';

  @override
  String get updateAvailable => 'Có bản cập nhật';

  @override
  String get stable => 'Ổn định';

  @override
  String get nightly => 'Phiên bản thử nghiệm';

  @override
  String get checkForUpdates => 'Kiểm tra cập nhật';

  @override
  String get checkForUpdatesWarning =>
      'Việc kiểm tra cập nhật sẽ kết nối với trang web Butterfly để lấy thông tin.';

  @override
  String get usingLatestStable => 'Bạn đang dùng phiên bản ổn định mới nhất';

  @override
  String get usingLatestNightly => 'Bạn đang dùng phiên bản nightly mới nhất';

  @override
  String get currentVersion => 'Phiên bản hiện tại';

  @override
  String get updateNow => 'Cập nhật ngay';

  @override
  String get shape => 'Hình dạng';

  @override
  String get circle => 'Hình tròn';

  @override
  String get rectangle => 'Hình chữ nhật';

  @override
  String get triangle => 'Hình tam giác';

  @override
  String get line => 'Đường thẳng';

  @override
  String get cornerRadius => 'Bán kính góc';

  @override
  String get topLeft => 'Trên trái';

  @override
  String get topRight => 'Trên phải';

  @override
  String get bottomLeft => 'Dưới trái';

  @override
  String get bottomRight => 'Dưới phải';

  @override
  String get caches => 'Bộ nhớ đệm';

  @override
  String get manage => 'Quản lý';

  @override
  String get clearCaches => 'Xóa bộ nhớ đệm';

  @override
  String get createCache => 'Tạo bộ nhớ đệm';

  @override
  String get thirdPartyLicenses => 'Giấy phép bên thứ ba';

  @override
  String get syncing => 'Đang đồng bộ...';

  @override
  String get synced => 'Đã đồng bộ';

  @override
  String get notSynced => 'Chưa đồng bộ';

  @override
  String get conflict => 'Xung đột';

  @override
  String get keepLocal => 'Giữ bản cục bộ';

  @override
  String get keepConnection => 'Giữ bản kết nối';

  @override
  String get keepBoth => 'Giữ cả hai';

  @override
  String get forAll => 'Cho tất cả';

  @override
  String fileConflict(String file, String connection) {
    return '$file trong $connection bị xung đột';
  }

  @override
  String get offline => 'Ngoại tuyến';

  @override
  String get localLatest => 'Bản cục bộ mới nhất';

  @override
  String get connectionLatest => 'Bản kết nối mới nhất';

  @override
  String get path => 'Đường dẫn';

  @override
  String get folderSynced => 'Thư mục đã đồng bộ';

  @override
  String get syncRootDirectory => 'Thư mục gốc đồng bộ';

  @override
  String get penOnlyInput => 'Chỉ nhận đầu vào bằng bút';

  @override
  String get inputGestures => 'Cử chỉ đầu vào';

  @override
  String get nativeTitleBar => 'Thanh tiêu đề gốc';

  @override
  String get syncMode => 'Chế độ đồng bộ';

  @override
  String get connection => 'Kết nối';

  @override
  String get always => 'Luôn luôn';

  @override
  String get noMobile => 'Không dùng dữ liệu di động';

  @override
  String get manual => 'Thủ công';

  @override
  String get search => 'Tìm kiếm';

  @override
  String get properties => 'Thuộc tính';

  @override
  String get pin => 'Ghim';

  @override
  String get unpin => 'Bỏ ghim';

  @override
  String get element => 'Phần tử';

  @override
  String get painter => 'Họa sĩ';

  @override
  String get position => 'Vị trí';

  @override
  String get note => 'Ghi chú';

  @override
  String get packs => 'Gói';

  @override
  String get pack => 'Gói';

  @override
  String get more => 'Thêm';

  @override
  String get askForName => 'Yêu cầu tên';

  @override
  String areaIndex(int index) {
    return 'Khu vực $index';
  }

  @override
  String get startInFullScreen => 'Khởi chạy toàn màn hình';

  @override
  String get inputs => 'Đầu vào';

  @override
  String get mouse => 'Chuột';

  @override
  String get touch => 'Cảm ứng';

  @override
  String get keyboard => 'Bàn phím';

  @override
  String get shortcuts => 'Phím tắt';

  @override
  String get middle => 'Giữa';

  @override
  String get first => 'Đầu tiên';

  @override
  String get second => 'Thứ hai';

  @override
  String get activeTool => 'Công cụ đang hoạt động';

  @override
  String get activeToolDescription =>
      'Sử dụng công cụ đang chọn trên thanh công cụ';

  @override
  String get handTool => 'Công cụ Tay';

  @override
  String get handToolDescription => 'Kéo để di chuyển trên canvas';

  @override
  String get toolOnToolbar => 'Công cụ vị trí';

  @override
  String get toolOnToolbarDescription =>
      'Sử dụng công cụ ở vị trí chỉ định trên thanh công cụ, tính từ trái sang';

  @override
  String toolOnToolbarShort(int display_position) {
    return 'Vị trí thanh công cụ: $display_position';
  }

  @override
  String get tools => 'Công cụ';

  @override
  String get showGrid => 'Hiện lưới';

  @override
  String get grid => 'Lưới';

  @override
  String get ruler => 'Thước kẻ';

  @override
  String get angle => 'Góc';

  @override
  String get report => 'Báo cáo';

  @override
  String get newFolder => 'Thư mục mới';

  @override
  String get createPack => 'Tạo gói';

  @override
  String get editPack => 'Chỉnh sửa gói';

  @override
  String get packsDirectory => 'Thư mục gói';

  @override
  String get stamp => 'Con dấu';

  @override
  String get addToPack => 'Thêm vào gói';

  @override
  String get sureImportPack => 'Bạn có chắc muốn nhập gói không?';

  @override
  String byAuthor(String author) {
    return 'bởi $author';
  }

  @override
  String get author => 'Tác giả';

  @override
  String get addAsset => 'Thêm tài nguyên';

  @override
  String get editAsset => 'Chỉnh sửa tài nguyên';

  @override
  String get scope => 'Phạm vi';

  @override
  String get noPacks => 'Hiện không có gói nào';

  @override
  String get components => 'Thành phần';

  @override
  String get waypoint => 'Điểm dừng';

  @override
  String get actions => 'Hành động';

  @override
  String get painters => 'Họa sĩ';

  @override
  String get breakingChangesTitle => 'Thay đổi quan trọng';

  @override
  String breakingChangesMessage(int version, int newVersion) {
    return 'Có những thay đổi quan trọng trong phiên bản này. Vui lòng đọc nhật ký thay đổi trước khi cập nhật. Phiên bản tệp hiện tại là $version, phiên bản mới là $newVersion.';
  }

  @override
  String get styles => 'Kiểu dáng';

  @override
  String get paragraph => 'Đoạn văn';

  @override
  String get fontFamily => 'Phông chữ';

  @override
  String get smoothing => 'Làm mượt';

  @override
  String get streamline => 'Làm thẳng';

  @override
  String get presentation => 'Trình chiếu';

  @override
  String get selectAsset => 'Chọn tài nguyên';

  @override
  String get clearStyle => 'Xóa kiểu';

  @override
  String get unknownImportType => 'Loại nhập không xác định';

  @override
  String get sureImportTemplate => 'Bạn có chắc muốn nhập mẫu không?';

  @override
  String get frame => 'Khung';

  @override
  String get play => 'Phát';

  @override
  String get video => 'Video';

  @override
  String get fps => 'Khung/giây';

  @override
  String get breakpoint => 'Điểm dừng';

  @override
  String get presentationControls => 'Điều khiển trình chiếu';

  @override
  String get nextSlide => 'Trang tiếp theo';

  @override
  String get nextSlideDescription =>
      'Vuốt phải hoặc nhấn phím mũi tên phải để đến trang tiếp theo';

  @override
  String get previousSlide => 'Trang trước';

  @override
  String get previousSlideDescription =>
      'Vuốt trái hoặc nhấn phím mũi tên trái để về trang trước';

  @override
  String get exitPresentation => 'Thoát trình chiếu';

  @override
  String get exitPresentationDescription =>
      'Nhấn phím Esc hoặc vuốt xuống để thoát trình chiếu';

  @override
  String get pausePresentation => 'Tạm dừng trình chiếu';

  @override
  String get pausePresentationDescription =>
      'Chạm vào màn hình hoặc nhấn phím cách để tạm dừng hoặc tiếp tục';

  @override
  String get keyframe => 'Khung then chốt';

  @override
  String get endOfPresentation => 'Bạn đã đến cuối trình chiếu';

  @override
  String get startOfPresentation => 'Bạn đã đến đầu trình chiếu';

  @override
  String get palettes => 'Bảng màu';

  @override
  String headline(int index) {
    return 'Tiêu đề $index';
  }

  @override
  String get code => 'Mã';

  @override
  String get quote => 'Trích dẫn';

  @override
  String get link => 'Liên kết';

  @override
  String get checkbox => 'Hộp kiểm';

  @override
  String get deleted => 'Đã xóa';

  @override
  String get emphasis => 'Nhấn mạnh';

  @override
  String get listBullet => 'Danh sách dấu đầu dòng';

  @override
  String get strong => 'Đậm';

  @override
  String get markdown => 'Markdown';

  @override
  String get home => 'Trang chủ';

  @override
  String get files => 'Tệp tin';

  @override
  String get sortBy => 'Sắp xếp theo';

  @override
  String get location => 'Vị trí';

  @override
  String get whatsNew => 'Có gì mới?';

  @override
  String get unstar => 'Bỏ gắn sao';

  @override
  String get star => 'Gắn sao';

  @override
  String get goUp => 'Lên trên';

  @override
  String get created => 'Đã tạo';

  @override
  String get modified => 'Đã sửa';

  @override
  String get quickstart => 'Bắt đầu nhanh';

  @override
  String get noTemplates => 'Hiện không có mẫu nào';

  @override
  String get importCorePack => 'Nhập gói cốt lõi';

  @override
  String get importCorePackDescription =>
      'Nhập gói cốt lõi chứa tất cả tài nguyên cơ bản để bắt đầu. Thao tác này sẽ ghi đè gói cốt lõi hiện tại.';

  @override
  String get never => 'Không bao giờ';

  @override
  String get onlyOnUpdates => 'Chỉ khi cập nhật';

  @override
  String get visibility => 'Hiển thị';

  @override
  String get captureThumbnail => 'Chụp hình thu nhỏ';

  @override
  String get capturedThumbnail => 'Đã chụp hình thu nhỏ thành công';

  @override
  String get chooseLabelMode => 'Chọn chế độ nhãn';

  @override
  String get foreground => 'Tiền cảnh';

  @override
  String get version => 'Phiên bản';

  @override
  String get repository => 'Kho lưu trữ';

  @override
  String get pages => 'Trang';

  @override
  String get navigator => 'Trình điều hướng';

  @override
  String get arrange => 'Sắp xếp';

  @override
  String get bringToFront => 'Đưa lên trên';

  @override
  String get sendToBack => 'Đưa xuống dưới';

  @override
  String get bringForward => 'Đưa lên trước';

  @override
  String get sendBackward => 'Đưa xuống sau';

  @override
  String get rotation => 'Xoay';

  @override
  String get onlyAvailableLargerScreen => 'Chỉ khả dụng trên màn hình lớn hơn';

  @override
  String get toolbarPosition => 'Vị trí thanh công cụ';

  @override
  String get rotate => 'Xoay';

  @override
  String get spacer => 'Khoảng trống';

  @override
  String get navigationRail => 'Thanh điều hướng';

  @override
  String get cut => 'Cắt';

  @override
  String get insertBefore => 'Chèn trước';

  @override
  String get insertAfter => 'Chèn sau';

  @override
  String get insertFirst => 'Chèn đầu tiên';

  @override
  String get insertLast => 'Chèn cuối cùng';

  @override
  String get paste => 'Dán';

  @override
  String get ascending => 'Tăng dần';

  @override
  String get descending => 'Giảm dần';

  @override
  String get imageScale => 'Tỷ lệ hình ảnh';

  @override
  String get select => 'Chọn';

  @override
  String get tool => 'Công cụ';

  @override
  String get texture => 'Kết cấu';

  @override
  String get platformTheme => 'Giao diện nền tảng';

  @override
  String get desktop => 'Máy tính';

  @override
  String get mobile => 'Di động';

  @override
  String get pdfQuality => 'Chất lượng PDF';

  @override
  String get surface => 'Bề mặt';

  @override
  String get pattern => 'Mẫu';

  @override
  String get sureClose => 'Bạn có chắc muốn đóng tài liệu không?';

  @override
  String get thereAreUnsavedChanges => 'Có một số thay đổi chưa được lưu';

  @override
  String get page => 'Trang';

  @override
  String get iceServers => 'Máy chủ ICE';

  @override
  String get collaboration => 'Cộng tác';

  @override
  String get webRtc => 'Web RTC';

  @override
  String get webSocket => 'Web Socket';

  @override
  String get iceServer => 'Máy chủ ICE';

  @override
  String get port => 'Cổng';

  @override
  String get type => 'Loại';

  @override
  String get side => 'Bên';

  @override
  String get client => 'Khách hàng';

  @override
  String get server => 'Máy chủ';

  @override
  String get switchView => 'Chuyển chế độ xem';

  @override
  String get lasso => 'Thòng lọng';

  @override
  String get hideUI => 'Ẩn giao diện';

  @override
  String get density => 'Mật độ';

  @override
  String get compact => 'Gọn';

  @override
  String get comfortable => 'Thoải mái';

  @override
  String get standard => 'Tiêu chuẩn';

  @override
  String get lock => 'Khóa';

  @override
  String get addElement => 'Thêm phần tử';

  @override
  String get notDefaultConnection => 'Không phải kết nối mặc định';

  @override
  String get defaultConnection => 'Kết nối mặc định';

  @override
  String get hide => 'Ẩn';

  @override
  String get show => 'Hiện';

  @override
  String get pause => 'Tạm dừng';

  @override
  String get stop => 'Dừng';

  @override
  String get refresh => 'Làm mới';

  @override
  String get print => 'In';

  @override
  String get dav => 'DAV';

  @override
  String get eyeDropper => 'Công cụ lấy màu';

  @override
  String get users => 'Người dùng';

  @override
  String get experiments => 'Thử nghiệm';

  @override
  String get experimentsWarning =>
      'Các tính năng này đang thử nghiệm và có thể thay đổi, hỏng hoặc biến mất bất cứ lúc nào. Việc kích hoạt có thể gây mất ổn định hoặc mất dữ liệu. Hãy cẩn thận. Vui lòng báo lỗi nếu có.';

  @override
  String get address => 'Địa chỉ';

  @override
  String get spreadToPages => 'Trải ra các trang';

  @override
  String get rootDirectorySpecifiedDescription =>
      'Thư mục gốc đã được chỉ định. Tất cả đường dẫn thư mục nâng cao sẽ dựa trên thư mục này. Giữ trống để vô hiệu hóa.';

  @override
  String get rootDirectoryNotSpecifiedDescription =>
      'Chưa chỉ định thư mục gốc. Cần có tên. Tất cả đường dẫn thư mục nâng cao sẽ là đường dẫn tuyệt đối. Giữ trống để vô hiệu hóa.';

  @override
  String get unsecureConnectionTitle => 'Kết nối không bảo mật';

  @override
  String unsecureConnectionMessage(String fingerprint) {
    return 'Kết nối không bảo mật. Điều này có thể rủi ro bảo mật. Vui lòng chỉ tiếp tục nếu bạn tin tưởng kết nối. Dấu vân tay SHA1 là $fingerprint.';
  }

  @override
  String get continueAnyway => 'Tiếp tục';

  @override
  String get zoomControl => 'Điều khiển thu phóng';

  @override
  String get highContrast => 'Độ tương phản cao';

  @override
  String get shouldANumber => 'Giá trị này phải là số hợp lệ';

  @override
  String get createAreas => 'Tạo khu vực';

  @override
  String get autosave => 'Tự động lưu';

  @override
  String get invert => 'Đảo ngược';

  @override
  String get operations => 'Các thao tác';

  @override
  String get medium => 'Vừa';

  @override
  String get large => 'Lớn';

  @override
  String get toolbarSize => 'Kích thước thanh công cụ';

  @override
  String get addAll => 'Thêm tất cả';

  @override
  String get onlyCurrentPage => 'Chỉ trang hiện tại';

  @override
  String get smoothNavigation => 'Điều hướng mượt';

  @override
  String get exact => 'Chính xác';

  @override
  String get inline => 'Nội tuyến';

  @override
  String get toolbarRows => 'Số hàng thanh công cụ';

  @override
  String get pointerTest => 'Kiểm tra con trỏ';

  @override
  String get pressure => 'Áp lực';

  @override
  String get small => 'Nhỏ';

  @override
  String get tiny => 'Rất nhỏ';

  @override
  String get selectAll => 'Chọn tất cả';

  @override
  String get overrideTools => 'Ghi đè công cụ';

  @override
  String get hideCursorWhileDrawing => 'Ẩn con trỏ khi vẽ';

  @override
  String get installed => 'Đã cài';

  @override
  String get install => 'Cài đặt';

  @override
  String get deselect => 'Bỏ chọn';

  @override
  String get changeCollection => 'Đổi bộ sưu tập';

  @override
  String get collections => 'Các bộ sưu tập';

  @override
  String get fullSelection => 'Chọn toàn bộ';

  @override
  String get fullSelectionDescription =>
      'Yêu cầu phần tử nằm hoàn toàn trong hộp chọn để chọn.';

  @override
  String get collection => 'Bộ sưu tập';

  @override
  String get defaultCollection => 'Bộ sưu tập mặc định';

  @override
  String get scroll => 'Cuộn';

  @override
  String get onStartup => 'Khi khởi động';

  @override
  String get homeScreen => 'Màn hình chính';

  @override
  String get lastNote => 'Ghi chú cuối';

  @override
  String get newNote => 'Ghi chú mới';

  @override
  String get convertToLayer => 'Chuyển thành lớp';

  @override
  String get merge => 'Gộp';

  @override
  String get up => 'Lên';

  @override
  String get down => 'Xuống';

  @override
  String get other => 'Khác';

  @override
  String countElements(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count phần tử',
      one: '1 phần tử',
      zero: 'Không có phần tử',
    );
    return '$_temp0';
  }

  @override
  String get colorToolbar => 'Thanh công cụ màu';

  @override
  String get yesButShowButtons => 'Có, nhưng hiển thị nút';

  @override
  String get optionsPanelPosition => 'Vị trí bảng tùy chọn';

  @override
  String get hideDuration => 'Thời gian ẩn';

  @override
  String get animation => 'Hoạt ảnh';

  @override
  String get performance => 'Hiệu năng';

  @override
  String get performanceDescription =>
      'Tối ưu cho tốc độ và bộ nhớ. Chỉ phần hiển thị được nướng thành hình ảnh.';

  @override
  String get normalDescription =>
      'Cân bằng chất lượng và hiệu năng. Nướng hình ảnh phủ 1.5 lần vùng hiển thị, mượt hơn khi cuộn.';

  @override
  String get high => 'Cao';

  @override
  String get highDescription =>
      'Maximizes quality at the cost of performance. Bakes an image covering 2 times the visible area, ensuring seamless rendering even during rapid scrolling or zooming.';

  @override
  String get renderResolution => 'Độ phân giải render';

  @override
  String get translate => 'Dịch';

  @override
  String get unencrypted => 'Chưa mã hóa';

  @override
  String get encrypted => 'Đã mã hóa';

  @override
  String get encryptDocumentMessage => 'Nhấp để mã hóa tài liệu';

  @override
  String get unencryptDocumentMessage => 'Nhấp để giải mã tài liệu';

  @override
  String get unencrypt => 'Giải mã';

  @override
  String get encrypt => 'Mã hóa';

  @override
  String get encryptWarning =>
      'Thao tác này sẽ mã hóa tài liệu. Bạn cần nhớ mật khẩu để giải mã.';

  @override
  String get unencryptWarning =>
      'Thao tác này sẽ giải mã tài liệu. Mật khẩu sẽ bị xóa và ai cũng có thể mở.';

  @override
  String get confirmPassword => 'Xác nhận mật khẩu';

  @override
  String get passwordMismatch => 'Mật khẩu không khớp';

  @override
  String get action => 'Thao tác';

  @override
  String get svgText => 'Văn bản SVG';

  @override
  String get offset => 'Độ lệch';

  @override
  String get positionDependent => 'Phụ thuộc vị trí';

  @override
  String get flipHorizontal => 'Lật ngang';

  @override
  String get flipVertical => 'Lật dọc';

  @override
  String get grayscale => 'Thang xám';

  @override
  String get moveOnGesture => 'Di chuyển khi cử chỉ';

  @override
  String get exportAllFiles => 'Xuất tất cả tệp tin';

  @override
  String get restoreSettingsFromFile => 'Khôi phục cài đặt từ tệp tin';

  @override
  String get exportSettingsToFile => 'Xuất cài đặt ra tệp tin';

  @override
  String get barcode => 'Mã vạch';

  @override
  String get barcodeType => 'Loại mã vạch';

  @override
  String get qrCode => 'Mã QR';

  @override
  String get dataMatrix => 'Data Matrix';

  @override
  String get code128 => 'Code 128';

  @override
  String defaultUserName(int index) {
    return 'Người dùng $index';
  }

  @override
  String get moveLeft => 'Di chuyển sang trái';

  @override
  String get moveRight => 'Di chuyển sang phải';

  @override
  String get bundledPacks => 'Gói đi kèm';

  @override
  String get component => 'Component';

  @override
  String get selectComponent => 'Chọn thành phần';

  @override
  String get bundlePackInDocument => 'Đóng gói vào tài liệu';

  @override
  String get bundledPacksDescription =>
      'Các gói đi kèm được bao gồm trong tài liệu và chỉ dùng khi chia sẻ cùng tài liệu. Tài nguyên chỉ dùng khi gói được cài. Nhấp để cài gói.';

  @override
  String get fillAlpha => 'Độ trong suốt lớp tô';

  @override
  String get packagedFile => 'Tệp đóng gói';

  @override
  String get rawFile => 'Tệp gốc';

  @override
  String get webSocketDescription =>
      'Thiết bị của bạn đóng vai trò máy chủ, vì vậy cộng tác viên chỉ có thể tham gia trong cùng mạng hoặc khi bạn mở cổng.';

  @override
  String get swampDescription =>
      'Tin nhắn của bạn được định tuyến qua máy chủ trung gian mã hóa đầu cuối. Cần địa chỉ máy chủ swamp để tạo phiên.';

  @override
  String get createRawNote => 'Tạo ghi chú gốc';

  @override
  String get polygon => 'Đa giác';

  @override
  String get finishShape => 'Hoàn thành hình';

  @override
  String get submit => 'Gửi';

  @override
  String get math => 'Math';

  @override
  String get ignorePressure => 'Ignore pressure';

  @override
  String get ignoreFirstPressureDescription =>
      'On some devices, the first pressure value is not accurate. This setting will ignore the first pressure value and use the pressure of the second event instead.';

  @override
  String get temporary => 'Temporary';

  @override
  String get simpleToolbarVisibility => 'Simple toolbar visibility';

  @override
  String get autosaveDelay => 'Autosave delay';

  @override
  String get saved => 'Saved';

  @override
  String get saving => 'Saving...';

  @override
  String get readOnly => 'Read only';

  @override
  String get saveDelayed => 'Save delayed';

  @override
  String get unsaved => 'Unsaved';

  @override
  String get pdfEmptyDescription =>
      'There are currently no areas to export. Please select at least one area using the plus button in the top right corner or add all areas from the current page or from the whole document below.';
}
