// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Thai (`th`).
class AppLocalizationsTh extends AppLocalizations {
  AppLocalizationsTh([String locale = 'th']) : super(locale);

  @override
  String get open => 'เปิด';

  @override
  String get settings => 'การตั้งค่า';

  @override
  String get personalization => 'ปรับแต่ง';

  @override
  String get theme => 'ธีม';

  @override
  String get darkTheme => 'ธีมสีเข้ม';

  @override
  String get lightTheme => 'ธีมสีอ่อน';

  @override
  String get systemTheme => 'ใช้ธีมระบบเริ่มต้น';

  @override
  String get view => 'ดู';

  @override
  String get edit => 'แก้ไข';

  @override
  String get export => 'ส่งออก';

  @override
  String get save => 'บันทึก';

  @override
  String get zoom => 'ซูม';

  @override
  String get zoomIn => 'ซูมเข้า';

  @override
  String get zoomOut => 'ซูมออก';

  @override
  String get resetZoom => 'รีเซ็ตการซูม';

  @override
  String get strokeWidth => 'ความกว้างของเส้น';

  @override
  String get includeEraser => 'รวมยางลบด้วยหรือไม่?';

  @override
  String get thinning => 'การลดความหนา';

  @override
  String get pen => 'ปากกา';

  @override
  String get invertedPen => 'ปากกากลับสี';

  @override
  String get eraser => 'ยางลบ';

  @override
  String get pathEraser => 'ยางลบเส้นทาง';

  @override
  String get label => 'ป้าย';

  @override
  String get delete => 'ลบ';

  @override
  String get areYouSure => 'คุณแน่ใจหรือไม่?';

  @override
  String get reallyDelete => 'คุณต้องการลบรายการนี้จริงๆ หรือไม่?';

  @override
  String get no => 'ไม่';

  @override
  String get yes => 'ใช่';

  @override
  String get undo => 'เลิกทำ';

  @override
  String get redo => 'ทำซ้ำ';

  @override
  String get general => 'ทั่วไป';

  @override
  String get copyTitle => 'คัดลอกไปยังคลิปบอร์ดแล้ว';

  @override
  String get loading => 'กำลังโหลด...';

  @override
  String get enterText => 'ป้อนข้อความ';

  @override
  String get size => 'ขนาด';

  @override
  String get width => 'ความกว้าง';

  @override
  String get height => 'ความสูง';

  @override
  String get count => 'จำนวน';

  @override
  String get space => 'ระยะห่าง';

  @override
  String get background => 'พื้นหลัง';

  @override
  String get box => 'กล่อง';

  @override
  String get locale => 'ภาษาท้องถิ่น';

  @override
  String get systemLocale => 'ภาษาท้องถิ่นของระบบ';

  @override
  String get information => 'ข้อมูล';

  @override
  String get license => 'ใบอนุญาต';

  @override
  String get imprint => 'ข้อมูลผู้จัดทำ';

  @override
  String get privacypolicy => 'นโยบายความเป็นส่วนตัว';

  @override
  String get sourceCode => 'ซอร์สโค้ด';

  @override
  String get documentation => 'เอกสาร';

  @override
  String get changelog => 'บันทึกการเปลี่ยนแปลง';

  @override
  String get source => 'ที่มา';

  @override
  String get existOverride => 'องค์ประกอบนี้มีอยู่แล้ว ต้องเขียนทับหรือไม่?';

  @override
  String get description => 'คำอธิบาย';

  @override
  String get fill => 'เติม';

  @override
  String get defaultPalette => 'พาเลตเริ่มต้น';

  @override
  String get highlighter => 'ปากกาเน้นข้อความ';

  @override
  String get add => 'เพิ่ม';

  @override
  String get remove => 'นำออก';

  @override
  String get removeConfirm => 'คุณต้องการนำสิ่งนี้ออกจริงๆ หรือไม่?';

  @override
  String get resetPalette => 'รีเซ็ตพาเลต';

  @override
  String get custom => 'กำหนดเอง';

  @override
  String get decoration => 'การตกแต่ง';

  @override
  String get underline => 'ขีดเส้นใต้';

  @override
  String get overline => 'ขีดเส้นบน';

  @override
  String get strikethrough => 'ขีดฆ่า';

  @override
  String get thickness => 'ความหนา';

  @override
  String get style => 'สไตล์';

  @override
  String get solid => 'ทึบ';

  @override
  String get double => 'คู่';

  @override
  String get dotted => 'ลายจุด';

  @override
  String get dashed => 'ลายขีด';

  @override
  String get wavy => 'ลายคลื่น';

  @override
  String get fontWeight => 'ความหนาของฟอนต์';

  @override
  String get normal => 'ปกติ';

  @override
  String get bold => 'ตัวหนา';

  @override
  String get italic => 'ตัวเอียง';

  @override
  String get clipboard => 'คลิปบอร์ด';

  @override
  String get file => 'ไฟล์';

  @override
  String get data => 'ข้อมูล';

  @override
  String get share => 'แชร์';

  @override
  String get spacing => 'ระยะห่าง';

  @override
  String get image => 'รูปภาพ';

  @override
  String get enterUrl => 'ป้อน URL';

  @override
  String get scale => 'สเกล';

  @override
  String get help => 'ช่วยเหลือ';

  @override
  String get reallyReset => 'คุณต้องการรีเซ็ตสิ่งนี้จริงๆ หรือไม่?';

  @override
  String get whatToDo => 'คุณต้องการทำอะไร?';

  @override
  String get ignore => 'ละเว้น';

  @override
  String get backup => 'สำรองข้อมูล';

  @override
  String createdInNewerVersion(String fileName, int fileVersion) {
    return 'ไฟล์ $fileName ถูกสร้างในเวอร์ชันที่ใหม่กว่า ($fileVersion) ควรจัดการไฟล์นี้อย่างไร?';
  }

  @override
  String get waypoints => 'จุดทางผ่าน';

  @override
  String get origin => 'จุดเริ่มต้น';

  @override
  String get import => 'นำเข้า';

  @override
  String get newContent => 'ใหม่';

  @override
  String get selectElement => 'เลือกองค์ประกอบ';

  @override
  String get ctrlKey => 'Ctrl';

  @override
  String get shiftKey => 'Shift';

  @override
  String get altKey => 'Alt';

  @override
  String get copyVersion => 'คัดลอกเวอร์ชัน';

  @override
  String get input => 'อินพุต';

  @override
  String get behaviors => 'พฤติกรรม';

  @override
  String get dataDirectory => 'ไดเรกทอรีข้อมูล';

  @override
  String get defaultPath => 'เส้นทางเริ่มต้น';

  @override
  String get dateFormat => 'รูปแบบวันที่';

  @override
  String updatedAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'อัปเดตเมื่อ: $dateTimeString';
  }

  @override
  String createdAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'สร้างเมื่อ: $dateTimeString';
  }

  @override
  String get rename => 'เปลี่ยนชื่อ';

  @override
  String get duplicate => 'ทำซ้ำ';

  @override
  String get hand => 'มือ';

  @override
  String get folder => 'โฟลเดอร์';

  @override
  String get move => 'ย้าย';

  @override
  String get copy => 'คัดลอก';

  @override
  String get back => 'ย้อนกลับ';

  @override
  String get zoomDependent => 'ขึ้นอยู่กับการซูม';

  @override
  String get shapeDetection => 'ตรวจจับรูปทรง';

  @override
  String get delay => 'หน่วงเวลา';

  @override
  String get defaultLayer => 'เลเยอร์เริ่มต้น';

  @override
  String get layer => 'เลเยอร์';

  @override
  String get layers => 'เลเยอร์';

  @override
  String get notSet => 'ไม่ได้ตั้งค่า';

  @override
  String get enterLayer => 'ป้อนชื่อเลเยอร์';

  @override
  String get selectElements => 'เลือกองค์ประกอบ';

  @override
  String get deleteElements => 'ลบองค์ประกอบ';

  @override
  String get deleteElementsConfirm =>
      'คุณต้องการลบองค์ประกอบที่เลือกจริงๆ หรือไม่?';

  @override
  String get selectCustomCollection => 'เลือกคอลเล็กชันที่กำหนดเอง';

  @override
  String get svg => 'SVG';

  @override
  String get sensitivity => 'ความไว';

  @override
  String get sensitivityHint => 'ค่ายิ่งสูง อินพุตจะยิ่งไว';

  @override
  String get horizontal => 'แนวนอน';

  @override
  String get vertical => 'แนวตั้ง';

  @override
  String get plain => 'ไม่มีเส้น';

  @override
  String get light => 'เส้นจาง';

  @override
  String get ruled => 'มีเส้น';

  @override
  String get quad => 'ตาราง';

  @override
  String get music => 'โน้ตเพลง';

  @override
  String get dark => 'มืด';

  @override
  String get plainDark => 'ไม่มีเส้น (มืด)';

  @override
  String get ruledDark => 'มีเส้น (มืด)';

  @override
  String get quadDark => 'ตาราง (มืด)';

  @override
  String get musicDark => 'โน้ตเพลง (มืด)';

  @override
  String get templates => 'แม่แบบ';

  @override
  String get untitled => 'ไม่มีชื่อ';

  @override
  String get createTemplate => 'สร้างแม่แบบ';

  @override
  String get createTemplateContent =>
      'คุณต้องการสร้างแม่แบบจากเอกสารนี้จริงๆ หรือไม่ เอกสารต้นฉบับจะถูกลบ';

  @override
  String get replace => 'แทนที่';

  @override
  String get reallyReplace =>
      'คุณต้องการแทนที่แม่แบบจริงๆ หรือไม่ การกระทำนี้ไม่สามารถย้อนกลับได้!';

  @override
  String get defaultTemplate => 'แม่แบบเริ่มต้น';

  @override
  String get insert => 'แทรก';

  @override
  String get document => 'เอกสาร';

  @override
  String get camera => 'กล้อง';

  @override
  String get printout => 'สำเนาที่ปริ้นต์ออก';

  @override
  String get selectCamera => 'เลือกกล้อง';

  @override
  String get changeDocumentPath => 'เปลี่ยนเส้นทางเอกสาร';

  @override
  String get deleteWholeStroke => 'ลบเส้นทั้งหมด';

  @override
  String get alpha => 'แอลฟา';

  @override
  String get area => 'พื้นที่';

  @override
  String get selectArea => 'เลือกพื้นที่';

  @override
  String get aspectRatio => 'อัตราส่วน';

  @override
  String get presets => 'ค่าที่ตั้งล่วงหน้า';

  @override
  String get pagePortrait => 'หน้าตั้ง';

  @override
  String get pageLandscape => 'หน้ากว้าง';

  @override
  String get square => 'จัตุรัส';

  @override
  String get areas => 'พื้นที่';

  @override
  String get enterArea => 'ป้อนพื้นที่';

  @override
  String get exitArea => 'ออกจากพื้นที่';

  @override
  String get currentArea => 'พื้นที่ปัจจุบัน';

  @override
  String get design => 'ออกแบบ';

  @override
  String get text => 'ข้อความ';

  @override
  String welcome(String codeName) {
    return 'สวัสดี นี่คือ Linwood Butterfly $codeName';
  }

  @override
  String get welcomeContent => 'พื้นที่วาดภาพแบบโอเพนซอร์สและใช้ฟรี!';

  @override
  String updated(String version) {
    return 'แอปอัปเดตเป็นเวอร์ชัน $version';
  }

  @override
  String get releaseNotes => 'หมายเหตุการอัปเดต';

  @override
  String get constraints => 'ข้อจำกัด';

  @override
  String get scaled => 'ปรับสเกล';

  @override
  String get fixed => 'คงที่';

  @override
  String get dynamicContent => 'ไดนามิก';

  @override
  String get none => 'ไม่มี';

  @override
  String get includeArea => 'รวมพื้นที่';

  @override
  String get verticalAlignment => 'การจัดแนวแนวตั้ง';

  @override
  String get horizontalAlignment => 'การจัดแนวแนวนอน';

  @override
  String get top => 'บน';

  @override
  String get center => 'กึ่งกลาง';

  @override
  String get bottom => 'ล่าง';

  @override
  String get left => 'ซ้าย';

  @override
  String get right => 'ขวา';

  @override
  String get justify => 'จัดชิด';

  @override
  String get constraint => 'ข้อจำกัด';

  @override
  String get length => 'ความยาว';

  @override
  String get exportSvg => 'ส่งออก SVG';

  @override
  String get pdf => 'PDF';

  @override
  String get selectPages => 'เลือกหน้า';

  @override
  String get recentFiles => 'ไฟล์ล่าสุด';

  @override
  String get start => 'เริ่ม';

  @override
  String get noRecentFiles => 'ไม่มีไฟล์ล่าสุด';

  @override
  String countPages(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count หน้า',
      one: '1 หน้า',
      zero: 'ไม่มีหน้า',
    );
    return '$_temp0';
  }

  @override
  String pageIndex(int index) {
    return 'หน้า $index';
  }

  @override
  String get exit => 'ออก';

  @override
  String get noElements => 'ไม่มีองค์ประกอบ';

  @override
  String get invertSelection => 'กลับการเลือก';

  @override
  String get errorWhileImporting => 'เกิดข้อผิดพลาดขณะนำเข้า';

  @override
  String get errorWhileImportingContent => 'เกิดข้อผิดพลาดขณะนำเข้าไฟล์';

  @override
  String get showDetails => 'แสดงรายละเอียด';

  @override
  String get hideDetails => 'ซ่อนรายละเอียด';

  @override
  String get error => 'ข้อผิดพลาด';

  @override
  String get stackTrace => 'สแต็กเทรซ';

  @override
  String get laser => 'เลเซอร์';

  @override
  String get duration => 'ระยะเวลา';

  @override
  String get quality => 'คุณภาพ';

  @override
  String get exportPdf => 'ส่งออก PDF';

  @override
  String get local => 'ในเครื่อง';

  @override
  String get addConnection => 'เพิ่มการเชื่อมต่อ';

  @override
  String get connections => 'การเชื่อมต่อ';

  @override
  String get noConnections => 'ไม่มีการเชื่อมต่อ';

  @override
  String get url => 'URL';

  @override
  String get connect => 'เชื่อมต่อ';

  @override
  String get username => 'ชื่อผู้ใช้';

  @override
  String get password => 'รหัสผ่าน';

  @override
  String get webNotSupported => 'ไม่รองรับเว็บ';

  @override
  String get advanced => 'ขั้นสูง';

  @override
  String get directory => 'ไดเรกทอรี';

  @override
  String get documentsDirectory => 'ไดเรกทอรีเอกสาร';

  @override
  String get templatesDirectory => 'ไดเรกทอรีแม่แบบ';

  @override
  String get errorWhileCreatingConnection =>
      'เกิดข้อผิดพลาดขณะสร้างการเชื่อมต่อ';

  @override
  String get cannotConnect => 'ไม่สามารถเชื่อมต่อ';

  @override
  String get urlNotValid => 'URL ไม่ถูกต้อง';

  @override
  String get icon => 'ไอคอน';

  @override
  String get update => 'อัปเดต';

  @override
  String get updateAvailable => 'มีการอัปเดต';

  @override
  String get stable => 'เสถียร';

  @override
  String get nightly => 'รุ่นรายคืน';

  @override
  String get checkForUpdates => 'ตรวจสอบการอัปเดต';

  @override
  String get checkForUpdatesWarning =>
      'การตรวจสอบการอัปเดตจะเชื่อมต่อกับเว็บไซต์ Butterfly เพื่อดึงข้อมูล';

  @override
  String get usingLatestStable => 'คุณกำลังใช้เวอร์ชันเสถียรล่าสุด';

  @override
  String get usingLatestNightly => 'คุณกำลังใช้รุ่นรายคืนล่าสุด';

  @override
  String get currentVersion => 'เวอร์ชันปัจจุบัน';

  @override
  String get updateNow => 'อัปเดตตอนนี้';

  @override
  String get shape => 'รูปร่าง';

  @override
  String get circle => 'วงกลม';

  @override
  String get rectangle => 'สี่เหลี่ยมผืนผ้า';

  @override
  String get triangle => 'สามเหลี่ยม';

  @override
  String get line => 'เส้น';

  @override
  String get cornerRadius => 'รัศมีมุม';

  @override
  String get topLeft => 'บนซ้าย';

  @override
  String get topRight => 'บนขวา';

  @override
  String get bottomLeft => 'ล่างซ้าย';

  @override
  String get bottomRight => 'ล่างขวา';

  @override
  String get caches => 'แคช';

  @override
  String get manage => 'จัดการ';

  @override
  String get clearCaches => 'ล้างแคช';

  @override
  String get createCache => 'สร้างแคช';

  @override
  String get thirdPartyLicenses => 'ใบอนุญาตจากบุคคลที่สาม';

  @override
  String get syncing => 'กำลังซิงค์...';

  @override
  String get synced => 'ซิงค์แล้ว';

  @override
  String get notSynced => 'ยังไม่ได้ซิงค์';

  @override
  String get conflict => 'ความขัดแย้ง';

  @override
  String get keepLocal => 'เก็บในเครื่อง';

  @override
  String get keepConnection => 'เก็บจากการเชื่อมต่อ';

  @override
  String get keepBoth => 'เก็บทั้งสอง';

  @override
  String get forAll => 'สำหรับทั้งหมด';

  @override
  String fileConflict(String file, String connection) {
    return '$file ใน $connection มีความขัดแย้ง';
  }

  @override
  String get offline => 'ออฟไลน์';

  @override
  String get localLatest => 'ล่าสุดในเครื่อง';

  @override
  String get connectionLatest => 'ล่าสุดจากการเชื่อมต่อ';

  @override
  String get path => 'เส้นทาง';

  @override
  String get folderSynced => 'ซิงค์โฟลเดอร์แล้ว';

  @override
  String get syncRootDirectory => 'ไดเรกทอรีหลักสำหรับซิงค์';

  @override
  String get penOnlyInput => 'อินพุตเฉพาะปากกา';

  @override
  String get inputGestures => 'การทำท่าทางอินพุต';

  @override
  String get nativeTitleBar => 'แถบหัวเรื่องเริ่มต้น';

  @override
  String get syncMode => 'โหมดซิงค์';

  @override
  String get connection => 'การเชื่อมต่อ';

  @override
  String get always => 'เสมอ';

  @override
  String get noMobile => 'ไม่ใช้งานบนมือถือ';

  @override
  String get manual => 'ด้วยตนเอง';

  @override
  String get search => 'ค้นหา';

  @override
  String get properties => 'คุณสมบัติ';

  @override
  String get pin => 'ปักหมุด';

  @override
  String get unpin => 'ยกเลิกปักหมุด';

  @override
  String get element => 'องค์ประกอบ';

  @override
  String get painter => 'นักวาด';

  @override
  String get position => 'ตำแหน่ง';

  @override
  String get note => 'บันทึก';

  @override
  String get packs => 'แพ็ก';

  @override
  String get pack => 'แพ็ก';

  @override
  String get more => 'เพิ่มเติม';

  @override
  String get askForName => 'ถามชื่อ';

  @override
  String areaIndex(int index) {
    return 'พื้นที่ $index';
  }

  @override
  String get startInFullScreen => 'เริ่มในโหมดเต็มจอ';

  @override
  String get inputs => 'อินพุต';

  @override
  String get mouse => 'เมาส์';

  @override
  String get touch => 'สัมผัส';

  @override
  String get keyboard => 'คีย์บอร์ด';

  @override
  String get shortcuts => 'คีย์ลัด';

  @override
  String get middle => 'กลาง';

  @override
  String get first => 'แรก';

  @override
  String get second => 'ที่สอง';

  @override
  String get activeTool => 'เครื่องมือที่ใช้งาน';

  @override
  String get activeToolDescription => 'ใช้เครื่องมือที่เลือกบนแถบเครื่องมือ';

  @override
  String get handTool => 'เครื่องมือมือ';

  @override
  String get handToolDescription => 'ลากเพื่อเลื่อนผืนผ้าใบ';

  @override
  String get toolOnToolbar => 'เครื่องมือเฉพาะบนแถบเครื่องมือ';

  @override
  String get toolOnToolbarDescription =>
      'ใช้เครื่องมือที่ตำแหน่งระบุบนแถบเครื่องมือ นับจากซ้าย';

  @override
  String toolOnToolbarShort(int display_position) {
    return 'ตำแหน่งแถบเครื่องมือ: $display_position';
  }

  @override
  String get tools => 'เครื่องมือ';

  @override
  String get showGrid => 'แสดงตาราง';

  @override
  String get grid => 'ตาราง';

  @override
  String get ruler => 'ไม้บรรทัด';

  @override
  String get angle => 'มุม';

  @override
  String get report => 'รายงาน';

  @override
  String get newFolder => 'โฟลเดอร์ใหม่';

  @override
  String get createPack => 'สร้างแพ็ก';

  @override
  String get editPack => 'แก้ไขแพ็ก';

  @override
  String get packsDirectory => 'ไดเรกทอรีแพ็ก';

  @override
  String get stamp => 'ตรา';

  @override
  String get addToPack => 'เพิ่มไปยังแพ็ก';

  @override
  String get sureImportPack => 'คุณแน่ใจว่าต้องการนำเข้าแพ็กหรือไม่?';

  @override
  String byAuthor(String author) {
    return 'โดย $author';
  }

  @override
  String get author => 'ผู้เขียน';

  @override
  String get addAsset => 'เพิ่มแอสเซ็ต';

  @override
  String get editAsset => 'แก้ไขแอสเซ็ต';

  @override
  String get scope => 'ขอบเขต';

  @override
  String get noPacks => 'ขณะนี้ไม่มีแพ็กที่ใช้งานได้';

  @override
  String get components => 'คอมโพเนนต์';

  @override
  String get waypoint => 'จุดทางผ่าน';

  @override
  String get actions => 'การกระทำ';

  @override
  String get painters => 'นักวาด';

  @override
  String get breakingChangesTitle => 'การเปลี่ยนแปลงที่ไม่เข้ากัน';

  @override
  String breakingChangesMessage(int version, int newVersion) {
    return 'มีการเปลี่ยนแปลงที่ไม่เข้ากันในเวอร์ชันนี้ โปรดอ่านบันทึกการเปลี่ยนแปลงก่อนอัปเดต เวอร์ชันไฟล์ปัจจุบันคือ $version และเวอร์ชันใหม่คือ $newVersion';
  }

  @override
  String get styles => 'สไตล์';

  @override
  String get paragraph => 'ย่อหน้า';

  @override
  String get fontFamily => 'ฟอนต์';

  @override
  String get smoothing => 'ความเรียบ';

  @override
  String get streamline => 'เส้นเรียว';

  @override
  String get presentation => 'การนำเสนอ';

  @override
  String get selectAsset => 'เลือกแอสเซ็ต';

  @override
  String get clearStyle => 'ล้างสไตล์';

  @override
  String get unknownImportType => 'ประเภทการนำเข้าไม่รู้จัก';

  @override
  String get sureImportTemplate => 'คุณแน่ใจว่าต้องการนำเข้าแม่แบบหรือไม่?';

  @override
  String get frame => 'กรอบ';

  @override
  String get play => 'เล่น';

  @override
  String get video => 'วิดีโอ';

  @override
  String get fps => 'FPS';

  @override
  String get breakpoint => 'เบรกพอยต์';

  @override
  String get presentationControls => 'การควบคุมการนำเสนอ';

  @override
  String get nextSlide => 'สไลด์ถัดไป';

  @override
  String get nextSlideDescription =>
      'ปัดไปทางขวาหรือกดปุ่มลูกศรขวาเพื่อไปยังสไลด์ถัดไป';

  @override
  String get previousSlide => 'สไลด์ก่อนหน้า';

  @override
  String get previousSlideDescription =>
      'ปัดไปทางซ้ายหรือลูกศรซ้ายเพื่อกลับไปยังสไลด์ก่อนหน้า';

  @override
  String get exitPresentation => 'ออกจากการนำเสนอ';

  @override
  String get exitPresentationDescription =>
      'กดปุ่ม Escape หรือปัดลงเพื่อออกจากการนำเสนอ';

  @override
  String get pausePresentation => 'หยุดชั่วคราวการนำเสนอ';

  @override
  String get pausePresentationDescription =>
      'แตะที่หน้าจอหรือกด Space เพื่อหยุดหรือดำเนินการนำเสนอต่อ';

  @override
  String get keyframe => 'คีย์เฟรม';

  @override
  String get endOfPresentation => 'คุณได้ไปถึงจุดสิ้นสุดของการนำเสนอ';

  @override
  String get startOfPresentation => 'คุณได้ไปถึงจุดเริ่มต้นของการนำเสนอ';

  @override
  String get palettes => 'พาเลต';

  @override
  String headline(int index) {
    return 'หัวข้อ $index';
  }

  @override
  String get code => 'โค้ด';

  @override
  String get quote => 'อ้างอิง';

  @override
  String get link => 'ลิงก์';

  @override
  String get checkbox => 'ช่องเลือก';

  @override
  String get deleted => 'ถูกลบ';

  @override
  String get emphasis => 'เน้น';

  @override
  String get listBullet => 'รายการหัวข้อย่อย';

  @override
  String get strong => 'ตัวหนา';

  @override
  String get markdown => 'มาร์กดาวน์';

  @override
  String get home => 'หน้าหลัก';

  @override
  String get files => 'ไฟล์';

  @override
  String get sortBy => 'จัดเรียงตาม';

  @override
  String get location => 'ตำแหน่ง';

  @override
  String get whatsNew => 'มีอะไรใหม่?';

  @override
  String get unstar => 'ยกเลิกติดดาว';

  @override
  String get star => 'ติดดาว';

  @override
  String get goUp => 'เลื่อนขึ้น';

  @override
  String get created => 'สร้างเมื่อ';

  @override
  String get modified => 'แก้ไขเมื่อ';

  @override
  String get quickstart => 'เริ่มต้นด่วน';

  @override
  String get noTemplates => 'ขณะนี้ไม่มีแม่แบบใดๆ';

  @override
  String get importCorePack => 'นำเข้าแพ็กหลัก';

  @override
  String get importCorePackDescription =>
      'นำเข้าแพ็กหลักที่มีแอสเซ็ตพื้นฐานทั้งหมดเพื่อเริ่มต้น การดำเนินการนี้จะเขียนทับแพ็กหลักปัจจุบัน';

  @override
  String get never => 'ไม่เคย';

  @override
  String get onlyOnUpdates => 'เฉพาะเมื่ออัปเดต';

  @override
  String get visibility => 'การมองเห็น';

  @override
  String get captureThumbnail => 'จับภาพย่อ';

  @override
  String get capturedThumbnail => 'จับภาพย่อสำเร็จ';

  @override
  String get chooseLabelMode => 'เลือกโหมดป้าย';

  @override
  String get foreground => 'พื้นหน้า';

  @override
  String get version => 'เวอร์ชัน';

  @override
  String get repository => 'ที่เก็บ';

  @override
  String get pages => 'หน้า';

  @override
  String get navigator => 'ตัวนำทาง';

  @override
  String get arrange => 'จัดเรียง';

  @override
  String get bringToFront => 'นำไปข้างหน้า';

  @override
  String get sendToBack => 'ส่งไปข้างหลัง';

  @override
  String get bringForward => 'นำขึ้นข้างหน้า';

  @override
  String get sendBackward => 'ส่งถอยหลัง';

  @override
  String get rotation => 'การหมุน';

  @override
  String get onlyAvailableLargerScreen => 'ใช้ได้เฉพาะบนหน้าจอขนาดใหญ่';

  @override
  String get toolbarPosition => 'ตำแหน่งแถบเครื่องมือ';

  @override
  String get rotate => 'หมุน';

  @override
  String get spacer => 'ตัวเว้นวรรค';

  @override
  String get navigationRail => 'รางนำทาง';

  @override
  String get cut => 'ตัด';

  @override
  String get insertBefore => 'แทรกก่อน';

  @override
  String get insertAfter => 'แทรกหลัง';

  @override
  String get insertFirst => 'แทรกแรก';

  @override
  String get insertLast => 'แทรกสุดท้าย';

  @override
  String get paste => 'วาง';

  @override
  String get ascending => 'เรียงจากน้อยไปมาก';

  @override
  String get descending => 'เรียงจากมากไปน้อย';

  @override
  String get imageScale => 'สเกลรูปภาพ';

  @override
  String get select => 'เลือก';

  @override
  String get tool => 'เครื่องมือ';

  @override
  String get texture => 'พื้นผิว';

  @override
  String get platformTheme => 'ธีมแพลตฟอร์ม';

  @override
  String get desktop => 'เดสก์ท็อป';

  @override
  String get mobile => 'มือถือ';

  @override
  String get pdfQuality => 'คุณภาพ PDF';

  @override
  String get surface => 'พื้นผิว';

  @override
  String get pattern => 'รูปแบบ';

  @override
  String get sureClose => 'คุณแน่ใจว่าต้องการปิดเอกสารหรือไม่?';

  @override
  String get thereAreUnsavedChanges => 'มีการเปลี่ยนแปลงที่ยังไม่ได้บันทึก';

  @override
  String get page => 'หน้า';

  @override
  String get iceServers => 'เซิร์ฟเวอร์ ICE';

  @override
  String get collaboration => 'ความร่วมมือ';

  @override
  String get webRtc => 'Web RTC';

  @override
  String get webSocket => 'Web Socket';

  @override
  String get iceServer => 'เซิร์ฟเวอร์ ICE';

  @override
  String get port => 'พอร์ต';

  @override
  String get type => 'ประเภท';

  @override
  String get side => 'ด้าน';

  @override
  String get client => 'ไคลเอนต์';

  @override
  String get server => 'เซิร์ฟเวอร์';

  @override
  String get switchView => 'สลับมุมมอง';

  @override
  String get lasso => 'ลาสโซ';

  @override
  String get hideUI => 'ซ่อน UI';

  @override
  String get density => 'ความหนาแน่น';

  @override
  String get compact => 'กะทัดรัด';

  @override
  String get comfortable => 'สบายตา';

  @override
  String get standard => 'มาตรฐาน';

  @override
  String get lock => 'ล็อก';

  @override
  String get addElement => 'เพิ่มองค์ประกอบ';

  @override
  String get notDefaultConnection => 'ไม่ใช่การเชื่อมต่อเริ่มต้น';

  @override
  String get defaultConnection => 'การเชื่อมต่อเริ่มต้น';

  @override
  String get hide => 'ซ่อน';

  @override
  String get show => 'แสดง';

  @override
  String get pause => 'หยุดชั่วคราว';

  @override
  String get stop => 'หยุด';

  @override
  String get refresh => 'รีเฟรช';

  @override
  String get print => 'พิมพ์';

  @override
  String get dav => 'DAV';

  @override
  String get eyeDropper => 'หยดสี';

  @override
  String get users => 'ผู้ใช้';

  @override
  String get experiments => 'ทดลอง';

  @override
  String get experimentsWarning =>
      'คุณสมบัติเหล่านี้เป็นการทดลองและอาจเปลี่ยนแปลงเสียหายหายไปได้ตลอดเวลา การเปิดใช้งานอาจทำให้เกิดความไม่เสถียรหรือสูญหายของข้อมูล โปรดระมัดระวัง และแจ้งบั๊กที่พบ';

  @override
  String get address => 'ที่อยู่';

  @override
  String get spreadToPages => 'กระจายไปยังหลายหน้า';

  @override
  String get rootDirectorySpecifiedDescription =>
      'ได้กำหนดไดเรกทอรีหลักแล้ว เส้นทางไดเรกทอรีขั้นสูงทั้งหมดจะสัมพันธ์กับไดเรกทอรีนี้ หากต้องการปิดประเภทไดเรกทอรีนี้ ให้ปล่อยว่างไว้';

  @override
  String get rootDirectoryNotSpecifiedDescription =>
      'ยังไม่ได้กำหนดไดเรกทอรีหลัก จึงต้องกำหนดชื่อ เส้นทางไดเรกทอรีขั้นสูงทั้งหมดจะเป็นเส้นทางสมบูรณ์ หากต้องการปิดประเภทไดเรกทอรีนี้ ให้ปล่อยว่างไว้';

  @override
  String get unsecureConnectionTitle => 'การเชื่อมต่อไม่ปลอดภัย';

  @override
  String unsecureConnectionMessage(String fingerprint) {
    return 'การเชื่อมต่อไม่ปลอดภัย ซึ่งอาจเป็นความเสี่ยงด้านความปลอดภัย โปรดดำเนินการต่อก็ต่อเมื่อคุณไว้วางใจการเชื่อมต่อ รหัสลายนิ้วมือ sha1 คือ $fingerprint';
  }

  @override
  String get continueAnyway => 'ดำเนินการต่ออย่างไรก็ตาม';

  @override
  String get zoomControl => 'ตัวควบคุมการซูม';

  @override
  String get highContrast => 'คอนทราสต์สูง';

  @override
  String get shouldANumber => 'ค่านี้ควรเป็นตัวเลขที่ถูกต้อง';

  @override
  String get createAreas => 'สร้างพื้นที่';

  @override
  String get autosave => 'บันทึกอัตโนมัติ';

  @override
  String get invert => 'กลับ';

  @override
  String get operations => 'การดำเนินการ';

  @override
  String get medium => 'ปานกลาง';

  @override
  String get large => 'ใหญ่';

  @override
  String get toolbarSize => 'ขนาดแถบเครื่องมือ';

  @override
  String get addAll => 'เพิ่มทั้งหมด';

  @override
  String get onlyCurrentPage => 'เฉพาะหน้าปัจจุบัน';

  @override
  String get smoothNavigation => 'การนำทางเรียบ';

  @override
  String get exact => 'แม่นยำ';

  @override
  String get inline => 'อินไลน์';

  @override
  String get toolbarRows => 'แถวของแถบเครื่องมือ';

  @override
  String get pointerTest => 'ทดสอบตัวชี้';

  @override
  String get pressure => 'ความดัน';

  @override
  String get small => 'เล็ก';

  @override
  String get tiny => 'จิ๋ว';

  @override
  String get selectAll => 'เลือกทั้งหมด';

  @override
  String get overrideTools => 'แทนที่เครื่องมือ';

  @override
  String get hideCursorWhileDrawing => 'ซ่อนเคอร์เซอร์ขณะวาด';

  @override
  String get installed => 'ติดตั้งแล้ว';

  @override
  String get install => 'ติดตั้ง';

  @override
  String get deselect => 'ยกเลิกเลือก';

  @override
  String get changeCollection => 'เปลี่ยนคอลเล็กชัน';

  @override
  String get collections => 'คอลเล็กชัน';

  @override
  String get fullSelection => 'เลือกทั้งหมด';

  @override
  String get fullSelectionDescription =>
      'ต้องให้องค์ประกอบอยู่ภายในกล่องเลือกอย่างเต็มที่จึงจะถูกเลือก';

  @override
  String get collection => 'คอลเล็กชัน';

  @override
  String get defaultCollection => 'คอลเล็กชันเริ่มต้น';

  @override
  String get scroll => 'เลื่อน';

  @override
  String get onStartup => 'เมื่อเริ่มต้น';

  @override
  String get homeScreen => 'หน้าจอหลัก';

  @override
  String get lastNote => 'บันทึกล่าสุด';

  @override
  String get newNote => 'บันทึกใหม่';

  @override
  String get convertToLayer => 'แปลงเป็นเลเยอร์';

  @override
  String get merge => 'รวม';

  @override
  String get up => 'ขึ้น';

  @override
  String get down => 'ลง';

  @override
  String get other => 'อื่นๆ';

  @override
  String countElements(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count องค์ประกอบ',
      one: '1 องค์ประกอบ',
      zero: 'ไม่มีองค์ประกอบ',
    );
    return '$_temp0';
  }

  @override
  String get colorToolbar => 'แถบเครื่องมือสี';

  @override
  String get yesButShowButtons => 'ใช่ แต่แสดงปุ่ม';

  @override
  String get optionsPanelPosition => 'ตำแหน่งแผงตัวเลือก';

  @override
  String get hideDuration => 'ซ่อนระยะเวลา';

  @override
  String get animation => 'แอนิเมชัน';

  @override
  String get performance => 'ประสิทธิภาพ';

  @override
  String get performanceDescription =>
      'ปรับแต่งเพื่อความเร็วและการใช้งานหน่วยความจำ ส่วนที่มองเห็นได้ของบันทึกเท่านั้นที่จะถูกแปลงเป็นภาพ';

  @override
  String get normalDescription =>
      'สร้างสมดุลระหว่างคุณภาพและประสิทธิภาพ โดยแปลงเป็นภาพครอบคลุมพื้นที่ที่มองเห็นได้ 1.5 เท่า ช่วยให้การเลื่อนมีความเรียบเนียนมากขึ้น';

  @override
  String get high => 'สูง';

  @override
  String get highDescription =>
      'Maximizes quality at the cost of performance. Bakes an image covering 2 times the visible area, ensuring seamless rendering even during rapid scrolling or zooming.';

  @override
  String get renderResolution => 'ความละเอียดการเรนเดอร์';

  @override
  String get translate => 'แปล';

  @override
  String get unencrypted => 'ไม่ได้เข้ารหัส';

  @override
  String get encrypted => 'เข้ารหัส';

  @override
  String get encryptDocumentMessage => 'คลิกเพื่อเข้ารหัสเอกสาร';

  @override
  String get unencryptDocumentMessage => 'คลิกเพื่อถอดรหัสเอกสาร';

  @override
  String get unencrypt => 'ถอดรหัส';

  @override
  String get encrypt => 'เข้ารหัส';

  @override
  String get encryptWarning =>
      'สิ่งนี้จะเข้ารหัสเอกสาร คุณจะต้องจำรหัสผ่านเพื่อถอดรหัส';

  @override
  String get unencryptWarning =>
      'สิ่งนี้จะถอดรหัสเอกสาร รหัสผ่านจะถูกลบและทุกคนที่เข้าถึงจะสามารถเปิดได้';

  @override
  String get confirmPassword => 'ยืนยันรหัสผ่าน';

  @override
  String get passwordMismatch => 'รหัสผ่านไม่ตรงกัน';

  @override
  String get action => 'การกระทำ';

  @override
  String get svgText => 'ข้อความ SVG';

  @override
  String get offset => 'ระยะห่าง';

  @override
  String get positionDependent => 'ขึ้นกับตำแหน่ง';

  @override
  String get flipHorizontal => 'พลิกแนวนอน';

  @override
  String get flipVertical => 'พลิกแนวตั้ง';

  @override
  String get grayscale => 'ขาวดำ';

  @override
  String get moveOnGesture => 'เลื่อนด้วยท่าทาง';

  @override
  String get exportAllFiles => 'ส่งออกทุกไฟล์';

  @override
  String get restoreSettingsFromFile => 'กู้คืนการตั้งค่าจากไฟล์';

  @override
  String get exportSettingsToFile => 'ส่งออกการตั้งค่าเป็นไฟล์';

  @override
  String get barcode => 'บาร์โค้ด';

  @override
  String get barcodeType => 'ประเภทบาร์โค้ด';

  @override
  String get qrCode => 'คิวอาร์โค้ด';

  @override
  String get dataMatrix => 'Data Matrix';

  @override
  String get code128 => 'Code 128';

  @override
  String defaultUserName(int index) {
    return 'ผู้ใช้ $index';
  }

  @override
  String get moveLeft => 'เลื่อนไปซ้าย';

  @override
  String get moveRight => 'เลื่อนไปขวา';

  @override
  String get bundledPacks => 'แพ็กที่รวมมา';

  @override
  String get component => 'Component';

  @override
  String get selectComponent => 'เลือกคอมโพเนนต์';

  @override
  String get bundlePackInDocument => 'ฝังแพ็กในเอกสาร';

  @override
  String get bundledPacksDescription =>
      'แพ็กที่รวมไว้จะถูกฝังในเอกสารและใช้เพื่อแชร์ไปพร้อมกับเอกสารเท่านั้น แอสเซ็ตจะใช้ได้ในเอกสารก็ต่อเมื่อแพ็กถูกติดตั้ง สามารถติดตั้งแพ็กได้โดยคลิกที่แพ็ก';

  @override
  String get fillAlpha => 'แอลฟาการเติม';

  @override
  String get packagedFile => 'ไฟล์ที่แพ็กมา';

  @override
  String get rawFile => 'ไฟล์ดิบ';

  @override
  String get webSocketDescription =>
      'อุปกรณ์ของคุณเป็นโฮสต์เซิร์ฟเวอร์ จึงให้ผู้ร่วมงานเข้าร่วมได้เฉพาะในเครือข่ายเดียวกัน หรือต้องเปิดพอร์ตบนเราเตอร์เพื่อเข้าจากที่อื่น';

  @override
  String get swampDescription =>
      'ข้อความของคุณจะถูกส่งผ่านเซิร์ฟเวอร์รีเลย์ที่ปลอดภัยและเข้ารหัสตั้งแต่ต้นทางถึงปลายทาง ต้องระบุที่อยู่เซิร์ฟเวอร์ swamp เพื่อสร้างเซสชัน';

  @override
  String get createRawNote => 'สร้างบันทึกดิบ';

  @override
  String get polygon => 'รูปหลายเหลี่ยม';

  @override
  String get finishShape => 'เสร็จสิ้นรูปทรง';

  @override
  String get submit => 'ส่ง';

  @override
  String get math => 'Math';

  @override
  String get ignorePressure => 'Ignore pressure';

  @override
  String get ignoreFirstPressureDescription =>
      'On some devices, the first pressure value is not accurate. This setting will ignore the first pressure value and use the pressure of the second event instead.';

  @override
  String get temporary => 'Temporary';

  @override
  String get simpleToolbarVisibility => 'Simple toolbar visibility';

  @override
  String get autosaveDelay => 'Autosave delay';

  @override
  String get saved => 'Saved';

  @override
  String get saving => 'Saving...';

  @override
  String get readOnly => 'Read only';

  @override
  String get saveDelayed => 'Save delayed';

  @override
  String get unsaved => 'Unsaved';

  @override
  String get pdfEmptyDescription =>
      'There are currently no areas to export. Please select at least one area using the plus button in the top right corner or add all areas from the current page or from the whole document below.';
}
