// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Russian (`ru`).
class AppLocalizationsRu extends AppLocalizations {
  AppLocalizationsRu([String locale = 'ru']) : super(locale);

  @override
  String get open => 'Открыть';

  @override
  String get settings => 'Настройки';

  @override
  String get personalization => 'Персонализация';

  @override
  String get theme => 'Тема';

  @override
  String get darkTheme => 'Темная тема';

  @override
  String get lightTheme => 'Светлая тема';

  @override
  String get systemTheme => 'Использовать системную тему по умолчанию';

  @override
  String get view => 'Вид';

  @override
  String get edit => 'Редактировать';

  @override
  String get export => 'Экспорт';

  @override
  String get save => 'Сохранить';

  @override
  String get zoom => 'Масштаб';

  @override
  String get zoomIn => 'Увеличить';

  @override
  String get zoomOut => 'Уменьшить';

  @override
  String get resetZoom => 'Сбросить';

  @override
  String get strokeWidth => 'Толщина линии';

  @override
  String get includeEraser => 'Включить ластик?';

  @override
  String get thinning => 'Утончение';

  @override
  String get pen => 'Перо';

  @override
  String get invertedPen => 'Инверсия ручки';

  @override
  String get eraser => 'Ластик';

  @override
  String get pathEraser => 'Контурный ластик';

  @override
  String get label => 'Подпись';

  @override
  String get delete => 'Удалить';

  @override
  String get areYouSure => 'Вы уверены?';

  @override
  String get reallyDelete => 'Вы действительно хотите удалить этот элемент?';

  @override
  String get no => 'Нет';

  @override
  String get yes => 'Да';

  @override
  String get undo => 'Отменить';

  @override
  String get redo => 'Повторить';

  @override
  String get general => 'Общие';

  @override
  String get copyTitle => 'Скопировано в буфер обмена';

  @override
  String get loading => 'Загрузка...';

  @override
  String get enterText => 'Введите текст';

  @override
  String get size => 'Размер';

  @override
  String get width => 'Ширина';

  @override
  String get height => 'Высота';

  @override
  String get count => 'Счетчик';

  @override
  String get space => 'Пространство';

  @override
  String get background => 'Фон';

  @override
  String get box => 'Блок';

  @override
  String get locale => 'Язык';

  @override
  String get systemLocale => 'Системный язык';

  @override
  String get information => 'Информация';

  @override
  String get license => 'Лицензия';

  @override
  String get imprint => 'О компании';

  @override
  String get privacypolicy => 'Политика конфиденциальности';

  @override
  String get sourceCode => 'Исходный код';

  @override
  String get documentation => 'Документация';

  @override
  String get changelog => 'Список изменений';

  @override
  String get source => 'Исходный код';

  @override
  String get existOverride => 'Этот элемент уже существует. Перезаписать?';

  @override
  String get description => 'Описание';

  @override
  String get fill => 'Заполнить';

  @override
  String get defaultPalette => 'Стандартная палитра';

  @override
  String get highlighter => 'Выделение';

  @override
  String get add => 'Добавить';

  @override
  String get remove => 'Удалить';

  @override
  String get removeConfirm => 'Вы действительно хотите удалить это?';

  @override
  String get resetPalette => 'Сбросить палитру';

  @override
  String get custom => 'Пользовательский';

  @override
  String get decoration => 'Оформление';

  @override
  String get underline => 'Подчёркивание';

  @override
  String get overline => 'Надчеркивание';

  @override
  String get strikethrough => 'Зачёркнутый';

  @override
  String get thickness => 'Толщина';

  @override
  String get style => 'Стиль';

  @override
  String get solid => 'Сплошной';

  @override
  String get double => 'Двойной';

  @override
  String get dotted => 'Точечный';

  @override
  String get dashed => 'Пунктирный';

  @override
  String get wavy => 'Волнистый';

  @override
  String get fontWeight => 'Насыщенность шрифта';

  @override
  String get normal => 'Обычный';

  @override
  String get bold => 'Жирный';

  @override
  String get italic => 'Курсив';

  @override
  String get clipboard => 'Буфер обмена';

  @override
  String get file => 'Файл';

  @override
  String get data => 'Данные';

  @override
  String get share => 'Поделиться';

  @override
  String get spacing => 'Интервал';

  @override
  String get image => 'Изображение';

  @override
  String get enterUrl => 'Введите URL';

  @override
  String get scale => 'Масштаб';

  @override
  String get help => 'Справка';

  @override
  String get reallyReset => 'Вы действительно хотите сбросить его?';

  @override
  String get whatToDo => 'Что вы хотите сделать?';

  @override
  String get ignore => 'Пропустить';

  @override
  String get backup => 'Резервное копирование';

  @override
  String createdInNewerVersion(String fileName, int fileVersion) {
    return 'Файл $fileName был создан в более новой версии ($fileVersion). Что нужно сделать с этим файлом?';
  }

  @override
  String get waypoints => 'Путевые точки';

  @override
  String get origin => 'Источник';

  @override
  String get import => 'Импорт';

  @override
  String get newContent => 'Новый';

  @override
  String get selectElement => 'Выберите элемент';

  @override
  String get ctrlKey => 'Ctrl';

  @override
  String get shiftKey => 'Shift';

  @override
  String get altKey => 'Alt';

  @override
  String get copyVersion => 'Скопировать версию';

  @override
  String get input => 'Input';

  @override
  String get behaviors => 'Поведение';

  @override
  String get dataDirectory => 'Каталог данных';

  @override
  String get defaultPath => 'Путь по умолчанию';

  @override
  String get dateFormat => 'Формат даты';

  @override
  String updatedAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'Обновлено: $dateTimeString';
  }

  @override
  String createdAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'Создано: $dateTimeString';
  }

  @override
  String get rename => 'Переименовать';

  @override
  String get duplicate => 'Дублировать';

  @override
  String get hand => 'Рука';

  @override
  String get folder => 'Папка';

  @override
  String get move => 'Переместить';

  @override
  String get copy => 'Копировать';

  @override
  String get back => 'Назад';

  @override
  String get zoomDependent => 'Зависимость от масштаба';

  @override
  String get shapeDetection => 'Обнаружение фигур';

  @override
  String get delay => 'Задержка';

  @override
  String get defaultLayer => 'Слой по умолчанию';

  @override
  String get layer => 'Слой';

  @override
  String get layers => 'Слои';

  @override
  String get notSet => 'Не задано';

  @override
  String get enterLayer => 'Введите имя слоя';

  @override
  String get selectElements => 'Выберите элементы';

  @override
  String get deleteElements => 'Удалить элементы';

  @override
  String get deleteElementsConfirm =>
      'Вы действительно хотите удалить выбранные элементы?';

  @override
  String get selectCustomCollection => 'Выберите свою коллекцию';

  @override
  String get svg => 'SVG';

  @override
  String get sensitivity => 'Чувствительность';

  @override
  String get sensitivityHint => 'Чем больше значение, тем чувствительнее ввод';

  @override
  String get horizontal => 'Горизонтально';

  @override
  String get vertical => 'Вертикально';

  @override
  String get plain => 'Обычный';

  @override
  String get light => 'Светлая';

  @override
  String get ruled => 'В линейку';

  @override
  String get quad => 'В клетку';

  @override
  String get music => 'Нотный стан';

  @override
  String get dark => 'Тёмная';

  @override
  String get plainDark => 'Тёмная';

  @override
  String get ruledDark => 'В линейку тёмный';

  @override
  String get quadDark => 'В клетку тёмный';

  @override
  String get musicDark => 'Нотный стан тёмный';

  @override
  String get templates => 'Шаблоны';

  @override
  String get untitled => 'Без названия';

  @override
  String get createTemplate => 'Создать шаблон';

  @override
  String get createTemplateContent =>
      'Вы действительно хотите создать шаблон из этого документа? Оригинальный документ будет удален.';

  @override
  String get replace => 'Заменить';

  @override
  String get reallyReplace =>
      'Вы действительно хотите заменить шаблон? Это действие нельзя отменить!';

  @override
  String get defaultTemplate => 'Шаблон по умолчанию';

  @override
  String get insert => 'Вставить';

  @override
  String get document => 'Документ';

  @override
  String get camera => 'Снимок';

  @override
  String get printout => 'Печать';

  @override
  String get selectCamera => 'Выбор камеры';

  @override
  String get changeDocumentPath => 'Изменить путь к документу';

  @override
  String get deleteWholeStroke => 'Удалить весь контур';

  @override
  String get alpha => 'Прозрачность';

  @override
  String get area => 'Область';

  @override
  String get selectArea => 'Выберите область';

  @override
  String get aspectRatio => 'Соотношение сторон';

  @override
  String get presets => 'Пресеты';

  @override
  String get pagePortrait => 'Портрет';

  @override
  String get pageLandscape => 'Пейзаж';

  @override
  String get square => 'Квадрат';

  @override
  String get areas => 'Области';

  @override
  String get enterArea => 'Войти в область';

  @override
  String get exitArea => 'Выйти из области';

  @override
  String get currentArea => 'Текущая область';

  @override
  String get design => 'Дизайн';

  @override
  String get text => 'Текст';

  @override
  String welcome(String codeName) {
    return 'Эй, это Linwood Butterfly $codeName';
  }

  @override
  String get welcomeContent =>
      'Свободное место для рисования с открытым исходным кодом!';

  @override
  String updated(String version) {
    return 'Приложение обновлено до версии $version';
  }

  @override
  String get releaseNotes => 'Заметки о выпуске';

  @override
  String get constraints => 'Ограничения';

  @override
  String get scaled => 'Масштаб';

  @override
  String get fixed => 'Исправлено';

  @override
  String get dynamicContent => 'Динамический';

  @override
  String get none => 'Нет';

  @override
  String get includeArea => 'Включение области';

  @override
  String get verticalAlignment => 'Вертикальное выравнивание';

  @override
  String get horizontalAlignment => 'Горизонтальное выравнивание';

  @override
  String get top => 'Сверху';

  @override
  String get center => 'По центру';

  @override
  String get bottom => 'Внизу';

  @override
  String get left => 'Слева';

  @override
  String get right => 'Справа';

  @override
  String get justify => 'По ширине';

  @override
  String get constraint => 'Ограничение';

  @override
  String get length => 'Длина';

  @override
  String get exportSvg => 'Экспорт SVG';

  @override
  String get pdf => 'PDF';

  @override
  String get selectPages => 'Выберите страницы';

  @override
  String get recentFiles => 'Последние файлы';

  @override
  String get start => 'Начальный экран';

  @override
  String get noRecentFiles => 'Нет недавних файлов';

  @override
  String countPages(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count страницы',
      one: '1 страница',
      zero: 'Нет страниц',
    );
    return '$_temp0';
  }

  @override
  String pageIndex(int index) {
    return 'Страница $index';
  }

  @override
  String get exit => 'Выход';

  @override
  String get noElements => 'Нет элементов';

  @override
  String get invertSelection => 'Обратить выделение';

  @override
  String get errorWhileImporting => 'Ошибка при импорте';

  @override
  String get errorWhileImportingContent => 'Произошла ошибка при импорте файла';

  @override
  String get showDetails => 'Показать подробности';

  @override
  String get hideDetails => 'Скрыть детали';

  @override
  String get error => 'Ошибка';

  @override
  String get stackTrace => 'Трассировка стека';

  @override
  String get laser => 'Лазер';

  @override
  String get duration => 'Время видимости';

  @override
  String get quality => 'Качество';

  @override
  String get exportPdf => 'Экспорт в PDF';

  @override
  String get local => 'Локальный';

  @override
  String get addConnection => 'Добавить подключение';

  @override
  String get connections => 'Подключения';

  @override
  String get noConnections => 'Нет подключений';

  @override
  String get url => 'URL';

  @override
  String get connect => 'Подключиться';

  @override
  String get username => 'Имя пользователя';

  @override
  String get password => 'Пароль';

  @override
  String get webNotSupported => 'Сеть не поддерживается';

  @override
  String get advanced => 'Расширенные';

  @override
  String get directory => 'Каталог';

  @override
  String get documentsDirectory => 'Каталог документов';

  @override
  String get templatesDirectory => 'Каталог шаблонов';

  @override
  String get errorWhileCreatingConnection => 'Ошибка при создании соединения';

  @override
  String get cannotConnect => 'Не удается подключиться';

  @override
  String get urlNotValid => 'Неправильный URL';

  @override
  String get icon => 'Иконка';

  @override
  String get update => 'Обновление';

  @override
  String get updateAvailable => 'Доступно обновление';

  @override
  String get stable => 'Стабильная';

  @override
  String get nightly => 'Ночной';

  @override
  String get checkForUpdates => 'Проверить обновления';

  @override
  String get checkForUpdatesWarning =>
      'Проверка обновлений будет проходить через веб-сайт Butterfly для получения информации.';

  @override
  String get usingLatestStable => 'Вы используете последнюю стабильную версию';

  @override
  String get usingLatestNightly => 'Вы используете последнюю ночную версию';

  @override
  String get currentVersion => 'Текущая версия';

  @override
  String get updateNow => 'Обновить сейчас';

  @override
  String get shape => 'Фигура';

  @override
  String get circle => 'Круг';

  @override
  String get rectangle => 'Прямоугольник';

  @override
  String get triangle => 'Треугольник';

  @override
  String get line => 'Линия';

  @override
  String get cornerRadius => 'Радиус скругления';

  @override
  String get topLeft => 'Сверху слева';

  @override
  String get topRight => 'Сверху справа';

  @override
  String get bottomLeft => 'Снизу слева';

  @override
  String get bottomRight => 'Снизу справа';

  @override
  String get caches => 'Кеш';

  @override
  String get manage => 'Управлять';

  @override
  String get clearCaches => 'Очистить кэш';

  @override
  String get createCache => 'Создать кэш';

  @override
  String get thirdPartyLicenses => 'Лицензии третьих лиц';

  @override
  String get syncing => 'Синхронизация...';

  @override
  String get synced => 'Синхронизировано';

  @override
  String get notSynced => 'Не синхронизировано';

  @override
  String get conflict => 'Конфликт';

  @override
  String get keepLocal => 'Сохранить локально';

  @override
  String get keepConnection => 'Сохранять соединение';

  @override
  String get keepBoth => 'Оставить оба';

  @override
  String get forAll => 'Для всех';

  @override
  String fileConflict(String file, String connection) {
    return '$file в $connection имеет конфликт';
  }

  @override
  String get offline => 'Не в сети';

  @override
  String get localLatest => 'Локальный последний';

  @override
  String get connectionLatest => 'Последнее подключение';

  @override
  String get path => 'Путь';

  @override
  String get folderSynced => 'Папка синхронизирована';

  @override
  String get syncRootDirectory => 'Корневой каталог синхронизации';

  @override
  String get penOnlyInput => 'Только ввод ручки';

  @override
  String get inputGestures => 'Жесты ввода';

  @override
  String get nativeTitleBar => 'Родной заголовок';

  @override
  String get syncMode => 'Режим синхронизации';

  @override
  String get connection => 'Подключение';

  @override
  String get always => 'Всегда';

  @override
  String get noMobile => 'Нет мобильных устройств';

  @override
  String get manual => 'Ручной';

  @override
  String get search => 'Искать';

  @override
  String get properties => 'Свойства';

  @override
  String get pin => 'Закрепить';

  @override
  String get unpin => 'Открепить';

  @override
  String get element => 'Элемент';

  @override
  String get painter => 'Художник';

  @override
  String get position => 'Позиция';

  @override
  String get note => 'Примечание';

  @override
  String get packs => 'Наборы';

  @override
  String get pack => 'Набор';

  @override
  String get more => 'Ещё';

  @override
  String get askForName => 'Запрашивать имя';

  @override
  String areaIndex(int index) {
    return 'Область $index';
  }

  @override
  String get startInFullScreen => 'Запуск в полноэкранном режиме';

  @override
  String get inputs => 'Управление';

  @override
  String get mouse => 'Мышь';

  @override
  String get touch => 'Прикосновение';

  @override
  String get keyboard => 'Клавиатура';

  @override
  String get shortcuts => 'Ярлыки';

  @override
  String get middle => 'Средний';

  @override
  String get first => 'Первое';

  @override
  String get second => 'Секунда';

  @override
  String get activeTool => 'Активный инструмент';

  @override
  String get activeToolDescription =>
      'Использовать выбранный инструмент на панели инструментов';

  @override
  String get handTool => 'Ручной инструмент';

  @override
  String get handToolDescription => 'Перетащите по холсту';

  @override
  String get toolOnToolbar => 'Специфичный инструмент на панели инструментов';

  @override
  String get toolOnToolbarDescription =>
      'Использовать инструмент в указанной позиции на панели инструментов, начиная с левой стороны';

  @override
  String toolOnToolbarShort(int display_position) {
    return 'Положение панели инструментов: $display_position';
  }

  @override
  String get tools => 'Инструменты';

  @override
  String get showGrid => 'Показать сетку';

  @override
  String get grid => 'Сетка';

  @override
  String get ruler => 'Линейка';

  @override
  String get angle => 'Угол';

  @override
  String get report => 'Отчет';

  @override
  String get newFolder => 'Новая папка';

  @override
  String get createPack => 'Создать набор';

  @override
  String get editPack => 'Изменить набор';

  @override
  String get packsDirectory => 'Каталог наборов';

  @override
  String get stamp => 'Штамп';

  @override
  String get addToPack => 'Добавить в набор';

  @override
  String get sureImportPack => 'Вы уверены, что хотите импортировать набор?';

  @override
  String byAuthor(String author) {
    return 'от $author';
  }

  @override
  String get author => 'Автор';

  @override
  String get addAsset => 'Добавить актив';

  @override
  String get editAsset => 'Редактировать актив';

  @override
  String get scope => 'Сфера охвата';

  @override
  String get noPacks => 'На данный момент наборов нет';

  @override
  String get components => 'Компоненты';

  @override
  String get waypoint => 'Путевая точка';

  @override
  String get actions => 'Действия';

  @override
  String get painters => 'Художники';

  @override
  String get breakingChangesTitle => 'Важные изменения';

  @override
  String breakingChangesMessage(int version, int newVersion) {
    return 'В этой версии есть важные изменения. Пожалуйста, ознакомьтесь со списком изменений перед обновлением. Текущая версия файла - $version, новая версия - $newVersion.';
  }

  @override
  String get styles => 'Styles';

  @override
  String get paragraph => 'Пункт 2';

  @override
  String get fontFamily => 'Семейство шрифтов';

  @override
  String get smoothing => 'Сглаживание';

  @override
  String get streamline => 'Трансляция';

  @override
  String get presentation => 'Представление';

  @override
  String get selectAsset => 'Выберите актив';

  @override
  String get clearStyle => 'Очистить стиль';

  @override
  String get unknownImportType => 'Неизвестный тип импорта';

  @override
  String get sureImportTemplate =>
      'Вы уверены, что хотите импортировать шаблон?';

  @override
  String get frame => 'Frame';

  @override
  String get play => 'Играть';

  @override
  String get video => 'Видео';

  @override
  String get fps => 'FPS';

  @override
  String get breakpoint => 'Точка останова';

  @override
  String get presentationControls => 'Управление представлением';

  @override
  String get nextSlide => 'Следующий слайд';

  @override
  String get nextSlideDescription =>
      'Проведите вправо или нажмите клавишу со стрелкой вправо для перехода к следующему слайду';

  @override
  String get previousSlide => 'Предыдущий слайд';

  @override
  String get previousSlideDescription =>
      'Смахните влево или нажмите клавишу со стрелкой влево, чтобы перейти к предыдущему слайду';

  @override
  String get exitPresentation => 'Выйти из презентации';

  @override
  String get exitPresentationDescription =>
      'Нажмите кнопку экрана, чтобы выйти из презентации';

  @override
  String get pausePresentation => 'Приостановить презентацию';

  @override
  String get pausePresentationDescription =>
      'Нажмите на экран или нажмите пробел, чтобы приостановить или возобновить презентацию';

  @override
  String get keyframe => 'Keyframe';

  @override
  String get endOfPresentation => 'Вы завершили презентацию';

  @override
  String get startOfPresentation => 'Вы достигли начала презентации';

  @override
  String get palettes => 'Palettes';

  @override
  String headline(int index) {
    return 'Заголовок $index';
  }

  @override
  String get code => 'Код';

  @override
  String get quote => 'Цитата';

  @override
  String get link => 'Ссылка';

  @override
  String get checkbox => 'Флажок';

  @override
  String get deleted => 'Удалено';

  @override
  String get emphasis => 'Акцент';

  @override
  String get listBullet => 'Список пули';

  @override
  String get strong => 'Крепкий';

  @override
  String get markdown => 'Markdown';

  @override
  String get home => 'Домашний';

  @override
  String get files => 'Файлы';

  @override
  String get sortBy => 'Сортировать по';

  @override
  String get location => 'Местоположение';

  @override
  String get whatsNew => 'Что нового?';

  @override
  String get unstar => 'Убрать из Избранного';

  @override
  String get star => 'Звезда';

  @override
  String get goUp => 'Вверх';

  @override
  String get created => 'Создано';

  @override
  String get modified => 'Изменено';

  @override
  String get quickstart => 'Быстрый старт';

  @override
  String get noTemplates => 'В настоящее время шаблонов нет';

  @override
  String get importCorePack => 'Импортировать пакет ядра';

  @override
  String get importCorePackDescription =>
      'Импортируйте пакет ядра, содержащий все основные медиафайлы для начала. Это переопределит текущий пакет ядра.';

  @override
  String get never => 'Никогда';

  @override
  String get onlyOnUpdates => 'Только при обновлении';

  @override
  String get visibility => 'Видимость';

  @override
  String get captureThumbnail => 'Захват эскиза';

  @override
  String get capturedThumbnail => 'Успешно записанные миниатюры';

  @override
  String get chooseLabelMode => 'Выберите режим метки';

  @override
  String get foreground => 'Передний план';

  @override
  String get version => 'Версии';

  @override
  String get repository => 'Репозиторий';

  @override
  String get pages => 'Страницы';

  @override
  String get navigator => 'Navigator';

  @override
  String get arrange => 'Организовать';

  @override
  String get bringToFront => 'Вывести на передний план';

  @override
  String get sendToBack => 'Отправить на задний план';

  @override
  String get bringForward => 'Перенос вперед';

  @override
  String get sendBackward => 'Отправить назад';

  @override
  String get rotation => 'Поворот';

  @override
  String get onlyAvailableLargerScreen => 'Доступно только на больших экранах';

  @override
  String get toolbarPosition => 'Положение панели инструментов';

  @override
  String get rotate => 'Повернуть';

  @override
  String get spacer => 'Пробел';

  @override
  String get navigationRail => 'Навигационные рельсы';

  @override
  String get cut => 'Вырезать';

  @override
  String get insertBefore => 'Вставить снизу';

  @override
  String get insertAfter => 'Вставить после';

  @override
  String get insertFirst => 'Вставить первый';

  @override
  String get insertLast => 'Insert last';

  @override
  String get paste => 'Вставить';

  @override
  String get ascending => 'По возрастанию';

  @override
  String get descending => 'По убыванию';

  @override
  String get imageScale => 'Масштаб изображения';

  @override
  String get select => 'Выбрать';

  @override
  String get tool => 'Инструмент';

  @override
  String get texture => 'Текстура';

  @override
  String get platformTheme => 'Тема платформы';

  @override
  String get desktop => 'Рабочий стол';

  @override
  String get mobile => 'Мобильный';

  @override
  String get pdfQuality => 'Качество PDF';

  @override
  String get surface => 'Поверхность';

  @override
  String get pattern => 'Шаблон';

  @override
  String get sureClose => 'Вы уверены, что хотите закрыть документ?';

  @override
  String get thereAreUnsavedChanges => 'Имеются несохраненные изменения';

  @override
  String get page => 'Страница';

  @override
  String get iceServers => 'ICE серверы';

  @override
  String get collaboration => 'Сотрудничество';

  @override
  String get webRtc => 'Web RTC';

  @override
  String get webSocket => 'Веб-сокет';

  @override
  String get iceServer => 'ICE сервер';

  @override
  String get port => 'Порт';

  @override
  String get type => 'Тип';

  @override
  String get side => 'Грань';

  @override
  String get client => 'Клиент';

  @override
  String get server => 'Сервер';

  @override
  String get switchView => 'Переключить вид';

  @override
  String get lasso => 'Lasso';

  @override
  String get hideUI => 'Скрыть UI';

  @override
  String get density => 'Плотность';

  @override
  String get compact => 'Компактный';

  @override
  String get comfortable => 'Удобный';

  @override
  String get standard => 'Стандартный';

  @override
  String get lock => 'Заблокировать';

  @override
  String get addElement => 'Добавить элемент';

  @override
  String get notDefaultConnection => 'Соединение не по умолчанию';

  @override
  String get defaultConnection => 'Соединение по умолчанию';

  @override
  String get hide => 'Скрыть';

  @override
  String get show => 'Показать';

  @override
  String get pause => 'Пауза';

  @override
  String get stop => 'Остановить';

  @override
  String get refresh => 'Обновить';

  @override
  String get print => 'Печать';

  @override
  String get dav => 'DAV';

  @override
  String get eyeDropper => 'Крушитель глаз';

  @override
  String get users => 'Пользователи';

  @override
  String get experiments => 'Эксперимент';

  @override
  String get experimentsWarning =>
      'Эти функции являются экспериментальными и могут изменить, прервать или исчезнуть в любое время. Включение их может привести к нестабильности или потере данных. Будьте осторожны. Пожалуйста, сообщите о любых ошибках.';

  @override
  String get address => 'Адрес';

  @override
  String get spreadToPages => 'Распространять на страницы';

  @override
  String get rootDirectorySpecifiedDescription =>
      'Указан корневой каталог. Все дополнительные пути будут относительно этой директории. Оставьте пустым, чтобы отключить этот тип каталога.';

  @override
  String get rootDirectoryNotSpecifiedDescription =>
      'Корневой каталог не указан. Имя обязательно. Все расширенные пути будут абсолютными. Оставьте пустым, чтобы отключить этот тип директории.';

  @override
  String get unsecureConnectionTitle => 'Небезопасное соединение';

  @override
  String unsecureConnectionMessage(String fingerprint) {
    return 'Соединение не безопасно. Это может быть опасным для безопасности. Пожалуйста, продолжайте только если вы доверяете соединению. Отпечаток sha1 является $fingerprint.';
  }

  @override
  String get continueAnyway => 'Все равно продолжить';

  @override
  String get zoomControl => 'Управление масштабом';

  @override
  String get highContrast => 'Высокий контраст';

  @override
  String get shouldANumber => 'Это значение должно быть действительным числом';

  @override
  String get createAreas => 'Создать области';

  @override
  String get autosave => 'Autosave';

  @override
  String get invert => 'Invert';

  @override
  String get operations => 'Операции';

  @override
  String get medium => 'Средний';

  @override
  String get large => 'Большой';

  @override
  String get toolbarSize => 'Размер панели инструментов';

  @override
  String get addAll => 'Добавить все';

  @override
  String get onlyCurrentPage => 'Только текущая страница';

  @override
  String get smoothNavigation => 'Гладкая навигация';

  @override
  String get exact => 'Точно';

  @override
  String get inline => 'Встроенный';

  @override
  String get toolbarRows => 'Строки панели';

  @override
  String get pointerTest => 'Тест указателя';

  @override
  String get pressure => 'Давление';

  @override
  String get small => 'Маленький';

  @override
  String get tiny => 'Маленький';

  @override
  String get selectAll => 'Выбрать все';

  @override
  String get overrideTools => 'Переопределить инструменты';

  @override
  String get hideCursorWhileDrawing => 'Скрыть курсор во время рисования';

  @override
  String get installed => 'Установлено';

  @override
  String get install => 'Установить';

  @override
  String get deselect => 'Отменить выбор';

  @override
  String get changeCollection => 'Изменить коллекцию';

  @override
  String get collections => 'Коллекции';

  @override
  String get fullSelection => 'Полная выборка';

  @override
  String get fullSelectionDescription =>
      'Для выбора требуется, чтобы элементы были полностью внутри окна выбора.';

  @override
  String get collection => 'Коллекция';

  @override
  String get defaultCollection => 'Коллекция по умолчанию';

  @override
  String get scroll => 'Прокрутка';

  @override
  String get onStartup => 'При запуске';

  @override
  String get homeScreen => 'Домашний экран';

  @override
  String get lastNote => 'Последняя заметка';

  @override
  String get newNote => 'Новая заметка';

  @override
  String get convertToLayer => 'Преобразовать в слой';

  @override
  String get merge => 'Объединить';

  @override
  String get up => 'Вверх';

  @override
  String get down => 'Вниз';

  @override
  String get other => 'Прочие вопросы';

  @override
  String countElements(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count элементов',
      one: '1 элемент',
      zero: 'Нет элементов',
    );
    return '$_temp0';
  }

  @override
  String get colorToolbar => 'Инструменты цвета';

  @override
  String get yesButShowButtons => 'Да, но показать кнопки';

  @override
  String get optionsPanelPosition => 'Опции позиции панели';

  @override
  String get hideDuration => 'Скрыть длительность';

  @override
  String get animation => 'Анимация';

  @override
  String get performance => 'Производительность';

  @override
  String get performanceDescription =>
      'Оптимизировано для скорости и использования памяти. В изображение помещается только видимая часть заметки.';

  @override
  String get normalDescription =>
      'Баланс качества и производительности. Прибавляет изображение, покрывающее видимую область в полтора раза, обеспечивая более плавные переходы при прокрутке.';

  @override
  String get high => 'Высокий';

  @override
  String get highDescription =>
      'Увеличивает качество за счет повышения производительности. Делает изображение, покрывающее в два раза видимую область, обеспечивая бесшовное рендеринг даже при быстрой прокрутке или масштабировании.';

  @override
  String get renderResolution => 'Отрисовка разрешения';

  @override
  String get translate => 'Перевести';

  @override
  String get unencrypted => 'Незашифрованный';

  @override
  String get encrypted => 'Зашифровано';

  @override
  String get encryptDocumentMessage => 'Нажмите, чтобы зашифровать документ';

  @override
  String get unencryptDocumentMessage =>
      'Нажмите, чтобы отменить шифрование документа';

  @override
  String get unencrypt => 'Нешифрование';

  @override
  String get encrypt => 'Шифрование';

  @override
  String get encryptWarning =>
      'Это зашифрует документ. Вам нужно запомнить пароль, чтобы расшифровать его.';

  @override
  String get unencryptWarning =>
      'Это отменит шифрование документа. Пароль будет удален и все участники с доступом смогут его открыть.';

  @override
  String get confirmPassword => 'Подтвердите пароль';

  @override
  String get passwordMismatch => 'Пароли не совпадают';

  @override
  String get action => 'Действие';

  @override
  String get svgText => 'SVG текст';

  @override
  String get offset => 'Смещение';

  @override
  String get positionDependent => 'Зависит от позиции';

  @override
  String get flipHorizontal => 'Отразить по горизонтали';

  @override
  String get flipVertical => 'Отразить вертикально';

  @override
  String get grayscale => 'Grayscale';

  @override
  String get moveOnGesture => 'Переместить жест';

  @override
  String get exportAllFiles => 'Экспортировать все файлы';

  @override
  String get restoreSettingsFromFile => 'Восстановить настройки из файла';

  @override
  String get exportSettingsToFile => 'Экспорт настроек в файл';

  @override
  String get barcode => 'Barcode';

  @override
  String get barcodeType => 'Тип штрих-кода';

  @override
  String get qrCode => 'QR Code';

  @override
  String get dataMatrix => 'Матрица данных';

  @override
  String get code128 => 'Код 128';

  @override
  String defaultUserName(int index) {
    return 'Пользователь $index';
  }

  @override
  String get moveLeft => 'Влево';

  @override
  String get moveRight => 'Двигаться вправо';

  @override
  String get bundledPacks => 'Пакеты';

  @override
  String get component => 'Компонент';

  @override
  String get selectComponent => 'Выберите компонент';

  @override
  String get bundlePackInDocument => 'Включить пакет в документ';

  @override
  String get bundledPacksDescription =>
      'Пакеты включены в документ и используются только для обмена с документом. Активы могут использоваться только в документе, если пакет установлен. Пакеты могут быть установлены щелчком по ним.';

  @override
  String get fillAlpha => 'Заполнить альфа';

  @override
  String get packagedFile => 'Упакованный файл';

  @override
  String get rawFile => 'Файл сырых данных';

  @override
  String get webSocketDescription =>
      'Ваше устройство содержит сервер, поэтому соавторы могут подключаться только по той же сети или откуда угодно, если вы перенаправляете порт на маршрутизатор.';

  @override
  String get swampDescription =>
      'Ваши сообщения направляются через безопасный сервер ретрансляции с сквозным шифрованием. Для создания сеанса требуется адрес сервера swamp.';

  @override
  String get createRawNote => 'Создать заметку';

  @override
  String get polygon => 'Полигон';

  @override
  String get finishShape => 'Закончить форму';

  @override
  String get submit => 'Отправить';

  @override
  String get math => 'Математика';

  @override
  String get ignorePressure => 'Игнорировать давление';

  @override
  String get ignoreFirstPressureDescription =>
      'На некоторых устройствах первое значение давления неточно. Эта настройка будет игнорировать первое значение давления и вместо этого использовать давление второго события.';

  @override
  String get temporary => 'Временно';

  @override
  String get simpleToolbarVisibility => 'Простая видимость панели инструментов';

  @override
  String get autosaveDelay => 'Задержка автосохранения';

  @override
  String get saved => 'Сохранено';

  @override
  String get saving => 'Сохранение...';

  @override
  String get readOnly => 'Только для чтения';

  @override
  String get saveDelayed => 'Сохранить с задержкой';

  @override
  String get unsaved => 'Не сохранено';

  @override
  String get pdfEmptyDescription =>
      'В настоящее время нет областей для экспорта. Пожалуйста, выберите по крайней мере одну область, используя кнопку \"плюс\" в верхнем правом углу или добавьте все области с текущей страницы или из всего документа ниже.';
}
