// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Hungarian (`hu`).
class AppLocalizationsHu extends AppLocalizations {
  AppLocalizationsHu([String locale = 'hu']) : super(locale);

  @override
  String get open => 'Megnyit';

  @override
  String get settings => 'Beállítások';

  @override
  String get personalization => 'Személyre szabás';

  @override
  String get theme => 'Kinézet';

  @override
  String get darkTheme => 'Sötét téma';

  @override
  String get lightTheme => 'Világos téma';

  @override
  String get systemTheme => 'Rendszer téma';

  @override
  String get view => 'Megtekintés';

  @override
  String get edit => 'Szerkesztés';

  @override
  String get export => 'Exportálás';

  @override
  String get save => 'Mentés';

  @override
  String get zoom => 'Nagyítás';

  @override
  String get zoomIn => 'Nagyítás';

  @override
  String get zoomOut => 'Kicsinyítés';

  @override
  String get resetZoom => 'Eredeti nagyítás visszaállítása';

  @override
  String get strokeWidth => 'Vastagság';

  @override
  String get includeEraser => 'Radír?';

  @override
  String get thinning => 'Vékonyítás';

  @override
  String get pen => 'Toll';

  @override
  String get invertedPen => 'Invertált toll';

  @override
  String get eraser => 'Radír';

  @override
  String get pathEraser => 'Vonaltörlő';

  @override
  String get label => 'Címke';

  @override
  String get delete => 'Törlés';

  @override
  String get areYouSure => 'Biztos vagy benne?';

  @override
  String get reallyDelete => 'Valóban törölni akarod ezt a tételt?';

  @override
  String get no => 'Nem';

  @override
  String get yes => 'Igen';

  @override
  String get undo => 'Mégse';

  @override
  String get redo => 'Újra';

  @override
  String get general => 'Általános';

  @override
  String get copyTitle => 'Vágólapra másolva';

  @override
  String get loading => 'Betöltés...';

  @override
  String get enterText => 'Adja meg a szöveget';

  @override
  String get size => 'Méret';

  @override
  String get width => 'Szélesség';

  @override
  String get height => 'Magasság';

  @override
  String get count => 'Mennyiség';

  @override
  String get space => 'Szóköz';

  @override
  String get background => 'Háttér';

  @override
  String get box => 'Doboz';

  @override
  String get locale => 'A készüléken';

  @override
  String get systemLocale => 'Helyi rendszer';

  @override
  String get information => 'Információ';

  @override
  String get license => 'Licensz';

  @override
  String get imprint => 'Impresszum';

  @override
  String get privacypolicy => 'Adatvédelmi nyilatkozat';

  @override
  String get sourceCode => 'Forráskód';

  @override
  String get documentation => 'Dokumentáció';

  @override
  String get changelog => 'Változások listája';

  @override
  String get source => 'Forráskód';

  @override
  String get existOverride => 'Ez az elem már létezik. Felülírja?';

  @override
  String get description => 'Leírás';

  @override
  String get fill => 'Kitöltés';

  @override
  String get defaultPalette => 'Alapértelmezett paletta';

  @override
  String get highlighter => 'Kiemelés';

  @override
  String get add => 'Hozzáadás';

  @override
  String get remove => 'Törlés';

  @override
  String get removeConfirm => 'Biztosan törölni szeretné?';

  @override
  String get resetPalette => 'Paletta visszaállítása';

  @override
  String get custom => 'Egyedi';

  @override
  String get decoration => 'Díszítés';

  @override
  String get underline => 'Aláhúzás';

  @override
  String get overline => 'Felülvonás';

  @override
  String get strikethrough => 'Áthúzás';

  @override
  String get thickness => 'Vastagság';

  @override
  String get style => 'Stílus';

  @override
  String get solid => 'Szilárd';

  @override
  String get double => 'Dupla';

  @override
  String get dotted => 'Pontozott';

  @override
  String get dashed => 'Szaggatott';

  @override
  String get wavy => 'Hullámos';

  @override
  String get fontWeight => 'Betűvastagság';

  @override
  String get normal => 'Normál';

  @override
  String get bold => 'Félkövér';

  @override
  String get italic => 'Dőlt';

  @override
  String get clipboard => 'Vágólap';

  @override
  String get file => 'Fájl';

  @override
  String get data => 'Adat';

  @override
  String get share => 'Megosztás';

  @override
  String get spacing => 'Tagolás';

  @override
  String get image => 'Kép';

  @override
  String get enterUrl => 'Adja meg a webcíмет';

  @override
  String get scale => 'Skálázás';

  @override
  String get help => 'Súgó';

  @override
  String get reallyReset => 'Biztosan vissza szeretné állítani?';

  @override
  String get whatToDo => 'Mit akar tenni?';

  @override
  String get ignore => 'Figyelmen kívül hagyás';

  @override
  String get backup => 'Biztonsági mentés';

  @override
  String createdInNewerVersion(String fileName, int fileVersion) {
    return 'A fájl $fileName egy újabb verzióban készült ($fileVersion). Mit akar csinálni a fájlal?';
  }

  @override
  String get waypoints => 'Útvonalpontok';

  @override
  String get origin => 'Származás';

  @override
  String get import => 'Importálás';

  @override
  String get newContent => 'Új';

  @override
  String get selectElement => 'Elemek kiválasztása';

  @override
  String get ctrlKey => 'Ctrl';

  @override
  String get shiftKey => 'Shift';

  @override
  String get altKey => 'Alt';

  @override
  String get copyVersion => 'Verzió másolása';

  @override
  String get input => 'Beviteli mód';

  @override
  String get behaviors => 'Viselkedés';

  @override
  String get dataDirectory => 'Adatmappa';

  @override
  String get defaultPath => 'Alapértelmezett útvonal';

  @override
  String get dateFormat => 'Időformátum';

  @override
  String updatedAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'Frissítve:$dateTimeString';
  }

  @override
  String createdAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'Létrehozva:$dateTimeString';
  }

  @override
  String get rename => 'Átnevezés';

  @override
  String get duplicate => 'Másolat';

  @override
  String get hand => 'Kéz';

  @override
  String get folder => 'Könyvtár';

  @override
  String get move => 'Áthelyezés';

  @override
  String get copy => 'Másolás';

  @override
  String get back => 'Vissza';

  @override
  String get zoomDependent => 'Függőleges nagyítás';

  @override
  String get shapeDetection => 'Forma felismerés';

  @override
  String get delay => 'Késleltetés';

  @override
  String get defaultLayer => 'Alapértelmezett réteg';

  @override
  String get layer => 'Réteg';

  @override
  String get layers => 'Rétegek';

  @override
  String get notSet => 'Nincs beállítva';

  @override
  String get enterLayer => 'Írd be az új réteg nevét';

  @override
  String get selectElements => 'Elemek kiválasztása';

  @override
  String get deleteElements => 'Elemek törlése';

  @override
  String get deleteElementsConfirm =>
      'Valóban törölni kívánja a kiválasztott elemeket?';

  @override
  String get selectCustomCollection => 'Egyedi kollekció kiválasztása';

  @override
  String get svg => 'SVG';

  @override
  String get sensitivity => 'Érzékenység';

  @override
  String get sensitivityHint =>
      'Minél nagyobb az érték, annál érzékenyebb a bemenet';

  @override
  String get horizontal => 'Vízszintes';

  @override
  String get vertical => 'Függőleges';

  @override
  String get plain => 'Sima';

  @override
  String get light => 'Világos';

  @override
  String get ruled => 'Szabályzott';

  @override
  String get quad => 'Négyzetrácsos';

  @override
  String get music => 'Zene';

  @override
  String get dark => 'Sötét';

  @override
  String get plainDark => 'Sötét';

  @override
  String get ruledDark => 'Szabályzott sötét';

  @override
  String get quadDark => 'Négyzetrácsos sötét';

  @override
  String get musicDark => 'Zene sötét';

  @override
  String get templates => 'Sablonok';

  @override
  String get untitled => 'Névtelen';

  @override
  String get createTemplate => 'Sablon létrehozása';

  @override
  String get createTemplateContent =>
      'Tényleg szeretne sablont létrehozni ebből a dokumentumból? Az eredeti dokumentum törölve lesz.';

  @override
  String get replace => 'Kicserélés';

  @override
  String get reallyReplace =>
      'Tényleg ki akarja cserélni a sablont? ez a művelet visszavonhatatlan!';

  @override
  String get defaultTemplate => 'Alapértelmezett sablon';

  @override
  String get insert => 'Beillesztés';

  @override
  String get document => 'Dokumentum';

  @override
  String get camera => 'Kamera';

  @override
  String get printout => 'Nyomtatott dokumentum';

  @override
  String get selectCamera => 'Kamera kiválasztása';

  @override
  String get changeDocumentPath => 'Dokumentum útvonal megváltoztatása';

  @override
  String get deleteWholeStroke => 'Teljes vonás törlése';

  @override
  String get alpha => 'Áttetszőség';

  @override
  String get area => 'Terület';

  @override
  String get selectArea => 'Terület kiválasztása';

  @override
  String get aspectRatio => 'Oldalarány';

  @override
  String get presets => 'Előbeállítások';

  @override
  String get pagePortrait => 'Álló oldal';

  @override
  String get pageLandscape => 'Fekvő oldal';

  @override
  String get square => 'Négyzet';

  @override
  String get areas => 'Területek';

  @override
  String get enterArea => 'Írd be a terület nevét';

  @override
  String get exitArea => 'Kilépés a területből';

  @override
  String get currentArea => 'Aktuális terület';

  @override
  String get design => 'Tervezés';

  @override
  String get text => 'Szöveg';

  @override
  String welcome(String codeName) {
    return 'Szia, Linwood Butterfly $codeName vagyok';
  }

  @override
  String get welcomeContent => 'Ingyenes és nyílt forráskódú rajzolófelület!';

  @override
  String updated(String version) {
    return 'Az alkalmazás $version verzióra frissült';
  }

  @override
  String get releaseNotes => 'Kiadási megjegyzések';

  @override
  String get constraints => 'Korlátozások';

  @override
  String get scaled => 'Méretezett';

  @override
  String get fixed => 'Rögzített';

  @override
  String get dynamicContent => 'Dinamikus';

  @override
  String get none => 'Nincs';

  @override
  String get includeArea => 'Terület bevonása';

  @override
  String get verticalAlignment => 'Függőleges igazítás';

  @override
  String get horizontalAlignment => 'Vízszintes igazítás';

  @override
  String get top => 'Fent';

  @override
  String get center => 'Közép';

  @override
  String get bottom => 'Alsó';

  @override
  String get left => 'Bal';

  @override
  String get right => 'Jobb';

  @override
  String get justify => 'Sorkizárt';

  @override
  String get constraint => 'Korlátozás';

  @override
  String get length => 'Hosszúság';

  @override
  String get exportSvg => 'Exportálás SVG-be';

  @override
  String get pdf => 'PDF';

  @override
  String get selectPages => 'Válasszon ki oldalakat';

  @override
  String get recentFiles => 'Legutóbbi fájlok';

  @override
  String get start => 'Indítás';

  @override
  String get noRecentFiles => 'Nincsenek legutóbbi fájlok';

  @override
  String countPages(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count oldal',
      one: '1 oldal',
      zero: 'Nincs oldal',
    );
    return '$_temp0';
  }

  @override
  String pageIndex(int index) {
    return 'Oldal $index';
  }

  @override
  String get exit => 'Kilépés';

  @override
  String get noElements => 'Nincsenek elemek';

  @override
  String get invertSelection => 'Kijelölés megfordítása';

  @override
  String get errorWhileImporting => 'Hiba az importálás során';

  @override
  String get errorWhileImportingContent =>
      'Hiba történt a fájl megnyitása közben';

  @override
  String get showDetails => 'Részletek megjelenítése';

  @override
  String get hideDetails => 'Részletek elrejtése';

  @override
  String get error => 'Hiba';

  @override
  String get stackTrace => 'Hívásverem';

  @override
  String get laser => 'Lézer';

  @override
  String get duration => 'Időtartam';

  @override
  String get quality => 'Minőség';

  @override
  String get exportPdf => 'PDF exportálása';

  @override
  String get local => 'Helyi';

  @override
  String get addConnection => 'Kapcsolat hozzáadása';

  @override
  String get connections => 'Kapcsolatok';

  @override
  String get noConnections => 'Nincsenek kapcsolatok';

  @override
  String get url => 'Webcím';

  @override
  String get connect => 'Csatlakozás';

  @override
  String get username => 'Felhasználónév';

  @override
  String get password => 'Jelszó';

  @override
  String get webNotSupported => 'A web nem támogatott';

  @override
  String get advanced => 'Speciális';

  @override
  String get directory => 'Könyvtár';

  @override
  String get documentsDirectory => 'Dokumentumok könyvtára';

  @override
  String get templatesDirectory => 'Sablonok könyvtára';

  @override
  String get errorWhileCreatingConnection =>
      'Hiba a kapcsolat létrehozása során';

  @override
  String get cannotConnect => 'Nem tud csatlakozni';

  @override
  String get urlNotValid => 'Az URL nem érvényes';

  @override
  String get icon => 'Ikon';

  @override
  String get update => 'Frissítés';

  @override
  String get updateAvailable => 'Frissítés elérhető';

  @override
  String get stable => 'Stabil';

  @override
  String get nightly => 'Éjszakai';

  @override
  String get checkForUpdates => 'Frissítések keresése';

  @override
  String get checkForUpdatesWarning =>
      'A frissítések keresése csatlakozik a Butterfly weboldalhoz az információk lekéréséhez.';

  @override
  String get usingLatestStable => 'A legújabb stabil verziót használja';

  @override
  String get usingLatestNightly => 'A legújabb éjszakai verziót használja';

  @override
  String get currentVersion => 'Jelenlegi verzió';

  @override
  String get updateNow => 'Frissítés most';

  @override
  String get shape => 'Forma';

  @override
  String get circle => 'Kör';

  @override
  String get rectangle => 'Téglalap';

  @override
  String get triangle => 'Háromszög';

  @override
  String get line => 'Vonal';

  @override
  String get cornerRadius => 'Sarok sugara';

  @override
  String get topLeft => 'Bal felső';

  @override
  String get topRight => 'Jobb felső';

  @override
  String get bottomLeft => 'Bal alsó';

  @override
  String get bottomRight => 'Jobb alsó';

  @override
  String get caches => 'Gyorsítótárak';

  @override
  String get manage => 'Kezelés';

  @override
  String get clearCaches => 'Gyorsítótárak törlése';

  @override
  String get createCache => 'Gyorsítótár létrehozása';

  @override
  String get thirdPartyLicenses => 'Harmadik fél licenszei';

  @override
  String get syncing => 'Szinkronizálás...';

  @override
  String get synced => 'Szinkronizálva';

  @override
  String get notSynced => 'Nincs szinkronizálva';

  @override
  String get conflict => 'Konfliktus';

  @override
  String get keepLocal => 'Helyi megtartása';

  @override
  String get keepConnection => 'Kapcsolat megtartása';

  @override
  String get keepBoth => 'Mindkettő megtartása';

  @override
  String get forAll => 'Mindegyikre';

  @override
  String fileConflict(String file, String connection) {
    return '$file és $connection között konfliktus van';
  }

  @override
  String get offline => 'Offline';

  @override
  String get localLatest => 'Legfrissebb helyi verzió';

  @override
  String get connectionLatest => 'Legfrissebb kapcsolati verzió';

  @override
  String get path => 'Útvonal';

  @override
  String get folderSynced => 'Könyvtár szinkronizálva';

  @override
  String get syncRootDirectory => 'Szinkron gyökérkönyvtár';

  @override
  String get penOnlyInput => 'Tollal történő bevitel';

  @override
  String get inputGestures => 'Beviteli gesztusok';

  @override
  String get nativeTitleBar => 'Natív címsor';

  @override
  String get syncMode => 'Szinkronizációs mód';

  @override
  String get connection => 'Kapcsolat';

  @override
  String get always => 'Mindig';

  @override
  String get noMobile => 'Mobilhálózat letiltva';

  @override
  String get manual => 'Kézi';

  @override
  String get search => 'Keresés';

  @override
  String get properties => 'Tulajdonságok';

  @override
  String get pin => 'Rögzítés';

  @override
  String get unpin => 'Rögzítés megszüntetése';

  @override
  String get element => 'Elem';

  @override
  String get painter => 'Festő';

  @override
  String get position => 'Pozíció';

  @override
  String get note => 'Megjegyzés';

  @override
  String get packs => 'Csomagok';

  @override
  String get pack => 'Csomag';

  @override
  String get more => 'Több';

  @override
  String get askForName => 'Név bekérése';

  @override
  String areaIndex(int index) {
    return 'Terület $index';
  }

  @override
  String get startInFullScreen => 'Teljes képernyős indítás';

  @override
  String get inputs => 'Bemenetek';

  @override
  String get mouse => 'Egér';

  @override
  String get touch => 'Érintés';

  @override
  String get keyboard => 'Billentyűzet';

  @override
  String get shortcuts => 'Billentyűparancsok';

  @override
  String get middle => 'Középső';

  @override
  String get first => 'Első';

  @override
  String get second => 'Második';

  @override
  String get activeTool => 'Aktív eszköz';

  @override
  String get activeToolDescription =>
      'Használja a kiválasztott eszközt az eszköztáron';

  @override
  String get handTool => 'Kéz eszköz';

  @override
  String get handToolDescription => 'Húzással mozgassa a vásznat';

  @override
  String get toolOnToolbar => 'Konkrét eszköz az eszköztáron';

  @override
  String get toolOnToolbarDescription =>
      'Használja az eszközt az eszköztáron a megadott pozícióban, balról számítva';

  @override
  String toolOnToolbarShort(int display_position) {
    return 'Eszköztár pozíció: $display_position';
  }

  @override
  String get tools => 'Eszközök';

  @override
  String get showGrid => 'Rács megjelenítése';

  @override
  String get grid => 'Rács';

  @override
  String get ruler => 'Vonalzó';

  @override
  String get angle => 'Szög';

  @override
  String get report => 'Jelentés';

  @override
  String get newFolder => 'Új könyvtár';

  @override
  String get createPack => 'Csomag létrehozása';

  @override
  String get editPack => 'Csomag szerkesztése';

  @override
  String get packsDirectory => 'Csomagok könyvtára';

  @override
  String get stamp => 'Bélyegző';

  @override
  String get addToPack => 'Hozzáadás a csomaghoz';

  @override
  String get sureImportPack => 'Biztosan importálni szeretné a csomagot?';

  @override
  String byAuthor(String author) {
    return '$author által';
  }

  @override
  String get author => 'Szerző';

  @override
  String get addAsset => 'Erőforrás hozzáadása';

  @override
  String get editAsset => 'Erőforrás szerkesztése';

  @override
  String get scope => 'Hatókör';

  @override
  String get noPacks => 'Jelenleg nincsenek elérhető csomagok';

  @override
  String get components => 'Komponensek';

  @override
  String get waypoint => 'Útvonalpont';

  @override
  String get actions => 'Műveletek';

  @override
  String get painters => 'Festők';

  @override
  String get breakingChangesTitle => 'Visszafelé nem kompatibilis változások';

  @override
  String breakingChangesMessage(int version, int newVersion) {
    return 'Ebben a verzióban vannak visszafelé nem kompatibilis változások. Kérjük, olvassa el a változáslistát a frissítés előtt. A jelenlegi fájlverzió: $version, az új verzió: $newVersion.';
  }

  @override
  String get styles => 'Stílusok';

  @override
  String get paragraph => 'Bekezdés';

  @override
  String get fontFamily => 'Betűcsalád';

  @override
  String get smoothing => 'Simítás';

  @override
  String get streamline => 'Letisztítás';

  @override
  String get presentation => 'Prezentáció';

  @override
  String get selectAsset => 'Erőforrás kiválasztása';

  @override
  String get clearStyle => 'Stílus törlése';

  @override
  String get unknownImportType => 'Ismeretlen import típus';

  @override
  String get sureImportTemplate => 'Biztosan importálni szeretné a sablont?';

  @override
  String get frame => 'Keret';

  @override
  String get play => 'Lejátszás';

  @override
  String get video => 'Videó';

  @override
  String get fps => 'FPS';

  @override
  String get breakpoint => 'Töréspont';

  @override
  String get presentationControls => 'Prezentációvezérlők';

  @override
  String get nextSlide => 'Következő dia';

  @override
  String get nextSlideDescription =>
      'Lapozzon jobbra vagy nyomja meg a jobb nyíl billentyűt a következő diára lépéshez';

  @override
  String get previousSlide => 'Előző dia';

  @override
  String get previousSlideDescription =>
      'Lapozzon balra vagy nyomja meg a bal nyíl billentyűt az előző diára lépéshez';

  @override
  String get exitPresentation => 'Kilépés a prezentációból';

  @override
  String get exitPresentationDescription =>
      'Nyomja meg az Esc billentyűt vagy lapozzon lefelé a prezentációból való kilépéshez';

  @override
  String get pausePresentation => 'Prezentáció szüneteltetése';

  @override
  String get pausePresentationDescription =>
      'Érintse meg a képernyőt vagy nyomja meg a szóköz billentyűt a prezentáció szüneteltetéséhez vagy folytatásához';

  @override
  String get keyframe => 'Kulcskocka';

  @override
  String get endOfPresentation => 'Elérte a prezentáció végét';

  @override
  String get startOfPresentation => 'Elérte a prezentáció elejét';

  @override
  String get palettes => 'Paletták';

  @override
  String headline(int index) {
    return 'Főcím $index';
  }

  @override
  String get code => 'Kód';

  @override
  String get quote => 'Idézet';

  @override
  String get link => 'Hivatkozás';

  @override
  String get checkbox => 'Jelölőnégyzet';

  @override
  String get deleted => 'Törölve';

  @override
  String get emphasis => 'Kiemelés';

  @override
  String get listBullet => 'Felsorolásjel';

  @override
  String get strong => 'Félkövér';

  @override
  String get markdown => 'Markdown';

  @override
  String get home => 'Kezdőlap';

  @override
  String get files => 'Fájlok';

  @override
  String get sortBy => 'Rendezés';

  @override
  String get location => 'Hely';

  @override
  String get whatsNew => 'Mi újdonság?';

  @override
  String get unstar => 'Csillag eltávolítása';

  @override
  String get star => 'Csillag hozzáadása';

  @override
  String get goUp => 'Fel';

  @override
  String get created => 'Létrehozva';

  @override
  String get modified => 'Módosítva';

  @override
  String get quickstart => 'Gyors kezdés';

  @override
  String get noTemplates => 'Jelenleg nincsenek elérhető sablonok';

  @override
  String get importCorePack => 'Alapcsomag importálása';

  @override
  String get importCorePackDescription =>
      'Importálja az alapcsomagot, amely az összes alapvető erőforrást tartalmazza a kezdéshez. Ez felülírja a jelenlegi alapcsomagot.';

  @override
  String get never => 'Soha';

  @override
  String get onlyOnUpdates => 'Csak frissítéseknél';

  @override
  String get visibility => 'Láthatóság';

  @override
  String get captureThumbnail => 'Bélyegkép készítése';

  @override
  String get capturedThumbnail => 'Bélyegkép sikeresen rögzítve';

  @override
  String get chooseLabelMode => 'Címkemód választása';

  @override
  String get foreground => 'Előtér';

  @override
  String get version => 'Verzió';

  @override
  String get repository => 'Tároló';

  @override
  String get pages => 'Oldalak';

  @override
  String get navigator => 'Navigátor';

  @override
  String get arrange => 'Elrendezés';

  @override
  String get bringToFront => 'Előtérbe hozás';

  @override
  String get sendToBack => 'Háttérbe küldés';

  @override
  String get bringForward => 'Előrébb hozás';

  @override
  String get sendBackward => 'Hátrébb hozás';

  @override
  String get rotation => 'Elforgatás';

  @override
  String get onlyAvailableLargerScreen => 'Csak nagyobb képernyőkön érhető el';

  @override
  String get toolbarPosition => 'Eszköztár pozíció';

  @override
  String get rotate => 'Elforgatás';

  @override
  String get spacer => 'Helykitöltő';

  @override
  String get navigationRail => 'Navigációs sáv';

  @override
  String get cut => 'Kivágás';

  @override
  String get insertBefore => 'Beszúrás elé';

  @override
  String get insertAfter => 'Beszúrás után';

  @override
  String get insertFirst => 'Beszúrás elejére';

  @override
  String get insertLast => 'Beszúrás végére';

  @override
  String get paste => 'Beillesztés';

  @override
  String get ascending => 'Növekvő';

  @override
  String get descending => 'Csökkenő';

  @override
  String get imageScale => 'Kép méretezése';

  @override
  String get select => 'Kiválasztás';

  @override
  String get tool => 'Eszköz';

  @override
  String get texture => 'Textúra';

  @override
  String get platformTheme => 'Platform téma';

  @override
  String get desktop => 'Asztali';

  @override
  String get mobile => 'Mobil';

  @override
  String get pdfQuality => 'PDF minőség';

  @override
  String get surface => 'Felület';

  @override
  String get pattern => 'Minta';

  @override
  String get sureClose => 'Biztosan be szeretné zárni a dokumentumot?';

  @override
  String get thereAreUnsavedChanges => 'Mentetlen módosítások vannak';

  @override
  String get page => 'Oldal';

  @override
  String get iceServers => 'ICE szerverek';

  @override
  String get collaboration => 'Együttműködés';

  @override
  String get webRtc => 'WebRTC';

  @override
  String get webSocket => 'WebSocket';

  @override
  String get iceServer => 'ICE szerver';

  @override
  String get port => 'Port';

  @override
  String get type => 'Típus';

  @override
  String get side => 'Oldal';

  @override
  String get client => 'Kliens';

  @override
  String get server => 'Szerver';

  @override
  String get switchView => 'Nézet váltása';

  @override
  String get lasso => 'Lasszó';

  @override
  String get hideUI => 'Felület elrejtése';

  @override
  String get density => 'Sűrűség';

  @override
  String get compact => 'Tömör';

  @override
  String get comfortable => 'Kényelmes';

  @override
  String get standard => 'Normál';

  @override
  String get lock => 'Zárolás';

  @override
  String get addElement => 'Elem hozzáadása';

  @override
  String get notDefaultConnection => 'Nem alapértelmezett kapcsolat';

  @override
  String get defaultConnection => 'Alapértelmezett kapcsolat';

  @override
  String get hide => 'Elrejtés';

  @override
  String get show => 'Megjelenítés';

  @override
  String get pause => 'Szüneteltetés';

  @override
  String get stop => 'Megállítás';

  @override
  String get refresh => 'Frissítés';

  @override
  String get print => 'Nyomtatás';

  @override
  String get dav => 'DAV';

  @override
  String get eyeDropper => 'Színpipetta';

  @override
  String get users => 'Felhasználók';

  @override
  String get experiments => 'Kísérletek';

  @override
  String get experimentsWarning =>
      'Ezek a funkciók kísérleti jellegűek és bármikor megváltozhatnak, működésképtelenné válhatnak vagy eltűnhetnek. Bekapcsolásuk instabilitást vagy adatvesztést okozhat. Elővigyázatossággal járjon el. Kérjük, jelentsen minden hibát.';

  @override
  String get address => 'Cím';

  @override
  String get spreadToPages => 'Oldalakra terítés';

  @override
  String get rootDirectorySpecifiedDescription =>
      'A gyökérkönyvtár meg van adva. Az összes speciális könyvtárútvonal ehhez a könyvtárhoz lesz relatív. Hagyja üresen a könyvtártípus letiltásához.';

  @override
  String get rootDirectoryNotSpecifiedDescription =>
      'A gyökérkönyvtár nincs megadva. Név megadása szükséges. Minden speciális könyvtárútvonal abszolút lesz. Hagyja üresen a könyvtártípus letiltásához.';

  @override
  String get unsecureConnectionTitle => 'Nem biztonságos kapcsolat';

  @override
  String unsecureConnectionMessage(String fingerprint) {
    return 'A kapcsolat nem biztonságos. Ez biztonsági kockázatot jelenthet. Csak abban az esetben folytassa, ha megbízik a kapcsolatban. A SHA1 ujjlenyomat: $fingerprint.';
  }

  @override
  String get continueAnyway => 'Mindenképpen folytat';

  @override
  String get zoomControl => 'Nagyítás vezérlése';

  @override
  String get highContrast => 'Magas kontraszt';

  @override
  String get shouldANumber => 'Ennek az értéknek érvényes számnak kell lennie';

  @override
  String get createAreas => 'Területek létrehozása';

  @override
  String get autosave => 'Automatikus mentés';

  @override
  String get invert => 'Invertálás';

  @override
  String get operations => 'Műveletek';

  @override
  String get medium => 'Közepes';

  @override
  String get large => 'Nagy';

  @override
  String get toolbarSize => 'Eszköztár méret';

  @override
  String get addAll => 'Összes hozzáadása';

  @override
  String get onlyCurrentPage => 'Csak aktuális oldal';

  @override
  String get smoothNavigation => 'Sima navigáció';

  @override
  String get exact => 'Pontos';

  @override
  String get inline => 'Beágyazott';

  @override
  String get toolbarRows => 'Eszköztár sorok';

  @override
  String get pointerTest => 'Mutató teszt';

  @override
  String get pressure => 'Nyomás';

  @override
  String get small => 'Kicsi';

  @override
  String get tiny => 'Apró';

  @override
  String get selectAll => 'Mindet kijelöl';

  @override
  String get overrideTools => 'Eszközök felülírása';

  @override
  String get hideCursorWhileDrawing => 'Rajzolás közben a kurzor elrejtése';

  @override
  String get installed => 'Telepítve';

  @override
  String get install => 'Telepítés';

  @override
  String get deselect => 'Kijelölés törlése';

  @override
  String get changeCollection => 'Gyűjtemény módosítása';

  @override
  String get collections => 'Gyűjtemények';

  @override
  String get fullSelection => 'Teljes kijelölés';

  @override
  String get fullSelectionDescription =>
      'A kijelöléshez az elemeknek teljesen a kijelölődobozon belül kell lenniük.';

  @override
  String get collection => 'Gyűjtemény';

  @override
  String get defaultCollection => 'Alapértelmezett gyűjtemény';

  @override
  String get scroll => 'Görgetés';

  @override
  String get onStartup => 'Indításkor';

  @override
  String get homeScreen => 'Kezdőképernyő';

  @override
  String get lastNote => 'Utolsó jegyzet';

  @override
  String get newNote => 'Új jegyzet';

  @override
  String get convertToLayer => 'Átalakítás réteggé';

  @override
  String get merge => 'Egyesítés';

  @override
  String get up => 'Fel';

  @override
  String get down => 'Le';

  @override
  String get other => 'Egyéb';

  @override
  String countElements(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count elem',
      one: '1 elem',
      zero: 'Nincsenek elemek',
    );
    return '$_temp0';
  }

  @override
  String get colorToolbar => 'Színes eszköztár';

  @override
  String get yesButShowButtons => 'Igen, de gombok megjelenítése';

  @override
  String get optionsPanelPosition => 'Opciópanel pozíciója';

  @override
  String get hideDuration => 'Elrejtés időtartama';

  @override
  String get animation => 'Animáció';

  @override
  String get performance => 'Teljesítmény';

  @override
  String get performanceDescription =>
      'Sebességre és memóriahasználatra optimalizált. A képbe csak a látható rész kerül beégetésre.';

  @override
  String get normalDescription =>
      'Minőség és teljesítmény kiegyensúlyozása: a kép a látható terület másfélszeresét tartalmazza, gördítés során simább átmenetet biztosítva.';

  @override
  String get high => 'Magas';

  @override
  String get highDescription =>
      'Maximizes quality at the cost of performance. Bakes an image covering 2 times the visible area, ensuring seamless rendering even during rapid scrolling or zooming.';

  @override
  String get renderResolution => 'Renderelési felbontás';

  @override
  String get translate => 'Fordítás';

  @override
  String get unencrypted => 'Nem titkosított';

  @override
  String get encrypted => 'Titkosított';

  @override
  String get encryptDocumentMessage =>
      'A dokumentum titkosításához kattintson ide';

  @override
  String get unencryptDocumentMessage =>
      'A dokumentum titkosításának feloldásához kattintson ide';

  @override
  String get unencrypt => 'Titkosítás feloldása';

  @override
  String get encrypt => 'Titkosítás';

  @override
  String get encryptWarning =>
      'Ez titkosítja a dokumentumot. A jelszót meg kell jegyeznie a visszafejtéshez.';

  @override
  String get unencryptWarning =>
      'Ez feloldja a dokumentum titkosítását. A jelszó eltávolításra kerül, és bárki, akinek hozzáférése van, meg tudja nyitni.';

  @override
  String get confirmPassword => 'Jelszó megerősítése';

  @override
  String get passwordMismatch => 'A jelszavak nem egyeznek';

  @override
  String get action => 'Művelet';

  @override
  String get svgText => 'SVG szöveg';

  @override
  String get offset => 'Eltolás';

  @override
  String get positionDependent => 'Pozíciófüggő';

  @override
  String get flipHorizontal => 'Vízszintes tükrözés';

  @override
  String get flipVertical => 'Függőleges tükrözés';

  @override
  String get grayscale => 'Szürkeárnyalatos';

  @override
  String get moveOnGesture => 'Mozgatás gesztussal';

  @override
  String get exportAllFiles => 'Minden fájl exportálása';

  @override
  String get restoreSettingsFromFile => 'Beállítások visszaállítása fájlból';

  @override
  String get exportSettingsToFile => 'Beállítások exportálása fájlba';

  @override
  String get barcode => 'Vonalkód';

  @override
  String get barcodeType => 'Vonalkód típusa';

  @override
  String get qrCode => 'QR-kód';

  @override
  String get dataMatrix => 'Adatmátrix';

  @override
  String get code128 => 'Code 128';

  @override
  String defaultUserName(int index) {
    return 'Felhasználó $index';
  }

  @override
  String get moveLeft => 'Mozgatás balra';

  @override
  String get moveRight => 'Mozgatás jobbra';

  @override
  String get bundledPacks => 'Beépített csomagok';

  @override
  String get component => 'Component';

  @override
  String get selectComponent => 'Komponens kiválasztása';

  @override
  String get bundlePackInDocument => 'Csomag beágyazása dokumentumba';

  @override
  String get bundledPacksDescription =>
      'A beépített csomagok a dokumentumba vannak ágyazva, és csak a dokumentummal együtt oszthatók meg. Az erőforrások csak akkor használhatók a dokumentumban, ha a csomag telepítve van. A csomagok telepítéséhez kattintson rájuk.';

  @override
  String get fillAlpha => 'Kitöltés átlátszósága';

  @override
  String get packagedFile => 'Csomagolt fájl';

  @override
  String get rawFile => 'Nyers fájl';

  @override
  String get webSocketDescription =>
      'Az eszköz tárhelyszolgáltatóként működik, így a kollaborátorok csak ugyanazon a hálózaton csatlakozhatnak, vagy bárhonnan, ha a hálózati útválasztón engedélyezi a port továbbítását.';

  @override
  String get swampDescription =>
      'Az üzeneteket egy biztonságos relé szerver továbbítja, mely végpontok közötti titkosítást biztosít. A munkamenet létrehozásához Swamp szerver címre van szükség.';

  @override
  String get createRawNote => 'Nyers jegyzet létrehozása';

  @override
  String get polygon => 'Sokszög';

  @override
  String get finishShape => 'Alakzat befejezése';

  @override
  String get submit => 'Küldés';

  @override
  String get math => 'Math';

  @override
  String get ignorePressure => 'Ignore pressure';

  @override
  String get ignoreFirstPressureDescription =>
      'On some devices, the first pressure value is not accurate. This setting will ignore the first pressure value and use the pressure of the second event instead.';

  @override
  String get temporary => 'Temporary';

  @override
  String get simpleToolbarVisibility => 'Simple toolbar visibility';

  @override
  String get autosaveDelay => 'Autosave delay';

  @override
  String get saved => 'Saved';

  @override
  String get saving => 'Saving...';

  @override
  String get readOnly => 'Read only';

  @override
  String get saveDelayed => 'Save delayed';

  @override
  String get unsaved => 'Unsaved';

  @override
  String get pdfEmptyDescription =>
      'There are currently no areas to export. Please select at least one area using the plus button in the top right corner or add all areas from the current page or from the whole document below.';
}
