// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Hebrew (`he`).
class AppLocalizationsHe extends AppLocalizations {
  AppLocalizationsHe([String locale = 'he']) : super(locale);

  @override
  String get open => 'פתח';

  @override
  String get settings => 'הגדרות';

  @override
  String get personalization => 'התאמה אישית';

  @override
  String get theme => 'ערכת נושא';

  @override
  String get darkTheme => 'ערכת נושא כהה';

  @override
  String get lightTheme => 'ערכת נושא בהירה';

  @override
  String get systemTheme => 'השתמש בערכת הנושא של המערכת';

  @override
  String get view => 'תצוגה';

  @override
  String get edit => 'עריכה';

  @override
  String get export => 'ייצוא';

  @override
  String get save => 'שמירה';

  @override
  String get zoom => 'זום';

  @override
  String get zoomIn => 'הגדלה';

  @override
  String get zoomOut => 'הקטנה';

  @override
  String get resetZoom => 'איפוס זום';

  @override
  String get strokeWidth => 'עובי קו';

  @override
  String get includeEraser => 'לכלול מחק?';

  @override
  String get thinning => 'הידקקות';

  @override
  String get pen => 'עט';

  @override
  String get invertedPen => 'עט הפוך';

  @override
  String get eraser => 'מחק';

  @override
  String get pathEraser => 'מחק נתיבים';

  @override
  String get label => 'תווית';

  @override
  String get delete => 'מחיקה';

  @override
  String get areYouSure => 'האם אתה בטוח?';

  @override
  String get reallyDelete => 'האם אתה בטוח שברצונך למחוק פריט זה?';

  @override
  String get no => 'לא';

  @override
  String get yes => 'כן';

  @override
  String get undo => 'ביטול';

  @override
  String get redo => 'ביצוע חוזר';

  @override
  String get general => 'כללי';

  @override
  String get copyTitle => 'הועתק ללוח';

  @override
  String get loading => 'טוען...';

  @override
  String get enterText => 'הזן את הטקסט';

  @override
  String get size => 'גודל';

  @override
  String get width => 'רוחב';

  @override
  String get height => 'גובה';

  @override
  String get count => 'כמות';

  @override
  String get space => 'רווח';

  @override
  String get background => 'רקע';

  @override
  String get box => 'תיבה';

  @override
  String get locale => 'שפה';

  @override
  String get systemLocale => 'שפת המערכת';

  @override
  String get information => 'מידע';

  @override
  String get license => 'רישיון';

  @override
  String get imprint => 'אודות';

  @override
  String get privacypolicy => 'מדיניות פרטיות';

  @override
  String get sourceCode => 'קוד מקור';

  @override
  String get documentation => 'תיעוד';

  @override
  String get changelog => 'יומן שינויים';

  @override
  String get source => 'מקור';

  @override
  String get existOverride => 'פריט זה כבר קיים. האם לדרוס?';

  @override
  String get description => 'תיאור';

  @override
  String get fill => 'מילוי';

  @override
  String get defaultPalette => 'פלטת צבעים ברירת מחדל';

  @override
  String get highlighter => 'מרקר';

  @override
  String get add => 'הוספה';

  @override
  String get remove => 'הסרה';

  @override
  String get removeConfirm => 'האם אתה בטוח שברצונך להסיר זאת?';

  @override
  String get resetPalette => 'איפוס פלטת צבעים';

  @override
  String get custom => 'מותאם אישית';

  @override
  String get decoration => 'עיטור';

  @override
  String get underline => 'קו תחתון';

  @override
  String get overline => 'קו עליון';

  @override
  String get strikethrough => 'קו חוצה';

  @override
  String get thickness => 'עובי';

  @override
  String get style => 'סגנון';

  @override
  String get solid => 'אחיד';

  @override
  String get double => 'כפול';

  @override
  String get dotted => 'מנוקד';

  @override
  String get dashed => 'מקווקו';

  @override
  String get wavy => 'גלי';

  @override
  String get fontWeight => 'משקל גופן';

  @override
  String get normal => 'רגיל';

  @override
  String get bold => 'מודגש';

  @override
  String get italic => 'נטוי';

  @override
  String get clipboard => 'לוח';

  @override
  String get file => 'קובץ';

  @override
  String get data => 'נתונים';

  @override
  String get share => 'שיתוף';

  @override
  String get spacing => 'ריווח';

  @override
  String get image => 'תמונה';

  @override
  String get enterUrl => 'הזן את הכתובת';

  @override
  String get scale => 'קנה מידה';

  @override
  String get help => 'עזרה';

  @override
  String get reallyReset => 'האם אתה בטוח שברצונך לאפס זאת?';

  @override
  String get whatToDo => 'מה ברצונך לעשות?';

  @override
  String get ignore => 'התעלם';

  @override
  String get backup => 'גיבוי';

  @override
  String createdInNewerVersion(String fileName, int fileVersion) {
    return 'הקובץ $fileName נוצר בגרסה חדשה יותר ($fileVersion). מה לעשות עם קובץ זה?';
  }

  @override
  String get waypoints => 'נקודות ציון';

  @override
  String get origin => 'מקור';

  @override
  String get import => 'ייבוא';

  @override
  String get newContent => 'חדש';

  @override
  String get selectElement => 'בחר פריט';

  @override
  String get ctrlKey => 'Ctrl';

  @override
  String get shiftKey => 'Shift';

  @override
  String get altKey => 'Alt';

  @override
  String get copyVersion => 'העתק גרסה';

  @override
  String get input => 'קלט';

  @override
  String get behaviors => 'התנהגויות';

  @override
  String get dataDirectory => 'ספריית נתונים';

  @override
  String get defaultPath => 'נתיב ברירת מחדל';

  @override
  String get dateFormat => 'תבנית תאריך';

  @override
  String updatedAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'עודכן בתאריך: $dateTimeString';
  }

  @override
  String createdAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'נוצר בתאריך: $dateTimeString';
  }

  @override
  String get rename => 'שנה שם';

  @override
  String get duplicate => 'שכפל';

  @override
  String get hand => 'יד';

  @override
  String get folder => 'תיקייה';

  @override
  String get move => 'העבר';

  @override
  String get copy => 'העתק';

  @override
  String get back => 'חזור';

  @override
  String get zoomDependent => 'תלוי זום';

  @override
  String get shapeDetection => 'זיהוי צורות';

  @override
  String get delay => 'השהיה';

  @override
  String get defaultLayer => 'שכבת ברירת מחדל';

  @override
  String get layer => 'שכבה';

  @override
  String get layers => 'שכבות';

  @override
  String get notSet => 'לא הוגדר';

  @override
  String get enterLayer => 'הזן את שם השכבה';

  @override
  String get selectElements => 'בחר פריטים';

  @override
  String get deleteElements => 'מחק פריטים';

  @override
  String get deleteElementsConfirm =>
      'האם אתה בטוח שברצונך למחוק את הפריטים הנבחרים?';

  @override
  String get selectCustomCollection => 'בחר אוסף מותאם אישית';

  @override
  String get svg => 'SVG';

  @override
  String get sensitivity => 'רגישות';

  @override
  String get sensitivityHint => 'ככל שהערך גבוה יותר, כך הקלט רגיש יותר';

  @override
  String get horizontal => 'אופקי';

  @override
  String get vertical => 'אנכי';

  @override
  String get plain => 'חלק';

  @override
  String get light => 'בהיר';

  @override
  String get ruled => 'עם שורות';

  @override
  String get quad => 'משובץ';

  @override
  String get music => 'מוזיקה';

  @override
  String get dark => 'כהה';

  @override
  String get plainDark => 'כהה';

  @override
  String get ruledDark => 'עם שורות כהה';

  @override
  String get quadDark => 'משובץ כהה';

  @override
  String get musicDark => 'מוזיקה כהה';

  @override
  String get templates => 'תבניות';

  @override
  String get untitled => 'ללא כותרת';

  @override
  String get createTemplate => 'צור תבנית';

  @override
  String get createTemplateContent =>
      'האם ברצונך ליצור תבנית ממסמך זה? המסמך המקורי יימחק.';

  @override
  String get replace => 'החלף';

  @override
  String get reallyReplace =>
      'האם אתה בטוח שברצונך להחליף את התבנית? לא ניתן לבטל פעולה זו!';

  @override
  String get defaultTemplate => 'תבנית ברירת מחדל';

  @override
  String get insert => 'הוסף';

  @override
  String get document => 'מסמך';

  @override
  String get camera => 'מצלמה';

  @override
  String get printout => 'תדפיס';

  @override
  String get selectCamera => 'בחר מצלמה';

  @override
  String get changeDocumentPath => 'שנה נתיב מסמך';

  @override
  String get deleteWholeStroke => 'מחק קו שלם';

  @override
  String get alpha => 'אלפא';

  @override
  String get area => 'אזור';

  @override
  String get selectArea => 'בחר אזור';

  @override
  String get aspectRatio => 'יחס גובה-רוחב';

  @override
  String get presets => 'הגדרות קבועות מראש';

  @override
  String get pagePortrait => 'עמוד לאורך';

  @override
  String get pageLandscape => 'עמוד לרוחב';

  @override
  String get square => 'ריבוע';

  @override
  String get areas => 'אזורים';

  @override
  String get enterArea => 'הזן את האזור';

  @override
  String get exitArea => 'צא מהאזור';

  @override
  String get currentArea => 'אזור נוכחי';

  @override
  String get design => 'עיצוב';

  @override
  String get text => 'טקסט';

  @override
  String welcome(String codeName) {
    return 'היי, זה Linwood Butterfly $codeName';
  }

  @override
  String get welcomeContent => 'מרחב ציור חינמי ובקוד פתוח!';

  @override
  String updated(String version) {
    return 'האפליקציה עודכנה לגרסה $version';
  }

  @override
  String get releaseNotes => 'הערות גרסה';

  @override
  String get constraints => 'אילוצים';

  @override
  String get scaled => 'מותאם לגודל';

  @override
  String get fixed => 'קבוע';

  @override
  String get dynamicContent => 'דינמי';

  @override
  String get none => 'ללא';

  @override
  String get includeArea => 'כלול אזור';

  @override
  String get verticalAlignment => 'יישור אנכי';

  @override
  String get horizontalAlignment => 'יישור אופקי';

  @override
  String get top => 'למעלה';

  @override
  String get center => 'מרכז';

  @override
  String get bottom => 'למטה';

  @override
  String get left => 'שמאל';

  @override
  String get right => 'ימין';

  @override
  String get justify => 'יישור לשני הצדדים';

  @override
  String get constraint => 'אילוץ';

  @override
  String get length => 'אורך';

  @override
  String get exportSvg => 'ייצא SVG';

  @override
  String get pdf => 'PDF';

  @override
  String get selectPages => 'בחר עמודים';

  @override
  String get recentFiles => 'קבצים אחרונים';

  @override
  String get start => 'התחל';

  @override
  String get noRecentFiles => 'אין קבצים אחרונים';

  @override
  String countPages(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count עמודים',
      one: 'עמוד אחד',
      zero: 'אין עמודים',
    );
    return '$_temp0';
  }

  @override
  String pageIndex(int index) {
    return 'עמוד $index';
  }

  @override
  String get exit => 'יציאה';

  @override
  String get noElements => 'אין פריטים';

  @override
  String get invertSelection => 'הפוך בחירה';

  @override
  String get errorWhileImporting => 'שגיאה במהלך הייבוא';

  @override
  String get errorWhileImportingContent => 'אירעה שגיאה במהלך ייבוא הקובץ';

  @override
  String get showDetails => 'הצג פרטים';

  @override
  String get hideDetails => 'הסתר פרטים';

  @override
  String get error => 'שגיאה';

  @override
  String get stackTrace => 'עקבות מחסנית';

  @override
  String get laser => 'לייזר';

  @override
  String get duration => 'משך';

  @override
  String get quality => 'איכות';

  @override
  String get exportPdf => 'ייצא PDF';

  @override
  String get local => 'מקומי';

  @override
  String get addConnection => 'הוסף חיבור';

  @override
  String get connections => 'חיבורים';

  @override
  String get noConnections => 'אין חיבורים';

  @override
  String get url => 'כתובת אתר';

  @override
  String get connect => 'התחבר';

  @override
  String get username => 'שם משתמש';

  @override
  String get password => 'סיסמה';

  @override
  String get webNotSupported => 'אינטרנט אינו נתמך';

  @override
  String get advanced => 'מתקדם';

  @override
  String get directory => 'ספרייה';

  @override
  String get documentsDirectory => 'ספריית מסמכים';

  @override
  String get templatesDirectory => 'ספריית תבניות';

  @override
  String get errorWhileCreatingConnection => 'שגיאה ביצירת החיבור';

  @override
  String get cannotConnect => 'לא ניתן להתחבר';

  @override
  String get urlNotValid => 'כתובת האתר אינה תקינה';

  @override
  String get icon => 'סמל';

  @override
  String get update => 'עדכון';

  @override
  String get updateAvailable => 'עדכון זמין';

  @override
  String get stable => 'יציב';

  @override
  String get nightly => 'לילי';

  @override
  String get checkForUpdates => 'בדוק עדכונים';

  @override
  String get checkForUpdatesWarning =>
      'בדיקת עדכונים תתחבר לאתר Butterfly כדי לקבל את המידע.';

  @override
  String get usingLatestStable => 'אתה משתמש בגרסה היציבה האחרונה';

  @override
  String get usingLatestNightly => 'אתה משתמש בגרסה הלילית האחרונה';

  @override
  String get currentVersion => 'גרסה נוכחית';

  @override
  String get updateNow => 'עדכן כעת';

  @override
  String get shape => 'צורה';

  @override
  String get circle => 'עיגול';

  @override
  String get rectangle => 'מלבן';

  @override
  String get triangle => 'משולש';

  @override
  String get line => 'קו';

  @override
  String get cornerRadius => 'רדיוס פינה';

  @override
  String get topLeft => 'שמאל למעלה';

  @override
  String get topRight => 'ימין למעלה';

  @override
  String get bottomLeft => 'שמאל למטה';

  @override
  String get bottomRight => 'ימין למטה';

  @override
  String get caches => 'מטמונים';

  @override
  String get manage => 'נהל';

  @override
  String get clearCaches => 'נקה מטמונים';

  @override
  String get createCache => 'צור מטמון';

  @override
  String get thirdPartyLicenses => 'רישיונות צד שלישי';

  @override
  String get syncing => 'מסנכרן...';

  @override
  String get synced => 'סונכרן';

  @override
  String get notSynced => 'לא סונכרן';

  @override
  String get conflict => 'התנגשות';

  @override
  String get keepLocal => 'שמור מקומי';

  @override
  String get keepConnection => 'שמור חיבור';

  @override
  String get keepBoth => 'שמור את שניהם';

  @override
  String get forAll => 'עבור הכל';

  @override
  String fileConflict(String file, String connection) {
    return 'לקובץ $file בחיבור $connection יש התנגשות';
  }

  @override
  String get offline => 'לא מקוון';

  @override
  String get localLatest => 'מקומי אחרון';

  @override
  String get connectionLatest => 'חיבור אחרון';

  @override
  String get path => 'נתיב';

  @override
  String get folderSynced => 'התיקייה סונכרנה';

  @override
  String get syncRootDirectory => 'סנכרן ספריית שורש';

  @override
  String get penOnlyInput => 'קלט עט בלבד';

  @override
  String get inputGestures => 'מחוות קלט';

  @override
  String get nativeTitleBar => 'סרגל כותרת מקורי';

  @override
  String get syncMode => 'מצב סנכרון';

  @override
  String get connection => 'חיבור';

  @override
  String get always => 'תמיד';

  @override
  String get noMobile => 'לא בנייד';

  @override
  String get manual => 'ידני';

  @override
  String get search => 'חיפוש';

  @override
  String get properties => 'מאפיינים';

  @override
  String get pin => 'נעץ';

  @override
  String get unpin => 'הסר נעץ';

  @override
  String get element => 'פריט';

  @override
  String get painter => 'צייר';

  @override
  String get position => 'מיקום';

  @override
  String get note => 'פתק';

  @override
  String get packs => 'חבילות';

  @override
  String get pack => 'חבילה';

  @override
  String get more => 'עוד';

  @override
  String get askForName => 'בקש שם';

  @override
  String areaIndex(int index) {
    return 'אזור $index';
  }

  @override
  String get startInFullScreen => 'התחל במסך מלא';

  @override
  String get inputs => 'קלטים';

  @override
  String get mouse => 'עכבר';

  @override
  String get touch => 'מגע';

  @override
  String get keyboard => 'מקלדת';

  @override
  String get shortcuts => 'קיצורי דרך';

  @override
  String get middle => 'אמצעי';

  @override
  String get first => 'ראשון';

  @override
  String get second => 'שני';

  @override
  String get activeTool => 'כלי פעיל';

  @override
  String get activeToolDescription => 'השתמש בכלי הנבחר כעת בסרגל הכלים';

  @override
  String get handTool => 'כלי היד';

  @override
  String get handToolDescription => 'גרור כדי לנוע על פני משטח העבודה';

  @override
  String get toolOnToolbar => 'כלי ספציפי בסרגל הכלים';

  @override
  String get toolOnToolbarDescription =>
      'השתמש בכלי במיקום שצוין בסרגל הכלים, החל מצד שמאל';

  @override
  String toolOnToolbarShort(int display_position) {
    return 'מיקום בסרגל הכלים: $display_position';
  }

  @override
  String get tools => 'כלים';

  @override
  String get showGrid => 'הצג רשת';

  @override
  String get grid => 'רשת';

  @override
  String get ruler => 'סרגל';

  @override
  String get angle => 'זווית';

  @override
  String get report => 'דיווח';

  @override
  String get newFolder => 'תיקייה חדשה';

  @override
  String get createPack => 'צור חבילה';

  @override
  String get editPack => 'ערוך חבילה';

  @override
  String get packsDirectory => 'ספריית חבילות';

  @override
  String get stamp => 'חותמת';

  @override
  String get addToPack => 'הוסף לחבילה';

  @override
  String get sureImportPack => 'האם אתה בטוח שברצונך לייבא את החבילה?';

  @override
  String byAuthor(String author) {
    return 'מאת $author';
  }

  @override
  String get author => 'יוצר';

  @override
  String get addAsset => 'הוסף נכס';

  @override
  String get editAsset => 'ערוך נכס';

  @override
  String get scope => 'היקף';

  @override
  String get noPacks => 'אין כרגע חבילות זמינות';

  @override
  String get components => 'רכיבים';

  @override
  String get waypoint => 'נקודת ציון';

  @override
  String get actions => 'פעולות';

  @override
  String get painters => 'ציירים';

  @override
  String get breakingChangesTitle => 'שינויים שוברים';

  @override
  String breakingChangesMessage(int version, int newVersion) {
    return 'ישנם שינויים שוברים בגרסה זו. אנא קרא את יומן השינויים לפני העדכון. גרסת הקובץ הנוכחית היא $version, הגרסה החדשה היא $newVersion.';
  }

  @override
  String get styles => 'סגנונות';

  @override
  String get paragraph => 'פסקה';

  @override
  String get fontFamily => 'משפחת גופנים';

  @override
  String get smoothing => 'החלקה';

  @override
  String get streamline => 'ייעול';

  @override
  String get presentation => 'מצגת';

  @override
  String get selectAsset => 'בחר נכס';

  @override
  String get clearStyle => 'נקה סגנון';

  @override
  String get unknownImportType => 'סוג ייבוא לא ידוע';

  @override
  String get sureImportTemplate => 'האם אתה בטוח שברצונך לייבא את התבנית?';

  @override
  String get frame => 'מסגרת';

  @override
  String get play => 'נגן';

  @override
  String get video => 'וידאו';

  @override
  String get fps => 'FPS';

  @override
  String get breakpoint => 'נקודת עצירה';

  @override
  String get presentationControls => 'פקדי מצגת';

  @override
  String get nextSlide => 'שקופית הבאה';

  @override
  String get nextSlideDescription =>
      'החלק ימינה או לחץ על מקש חץ ימין כדי לעבור לשקופית הבאה';

  @override
  String get previousSlide => 'שקופית קודמת';

  @override
  String get previousSlideDescription =>
      'החלק שמאלה או לחץ על מקש חץ שמאל כדי לעבור לשקופית הקודמת';

  @override
  String get exitPresentation => 'יציאה מהמצגת';

  @override
  String get exitPresentationDescription =>
      'לחץ על מקש Esc או החלק למטה כדי לצאת מהמצגת';

  @override
  String get pausePresentation => 'השהה מצגת';

  @override
  String get pausePresentationDescription =>
      'הקש על המסך או לחץ על מקש הרווח כדי להשהות או להמשיך את המצגת';

  @override
  String get keyframe => 'פריים מפתח';

  @override
  String get endOfPresentation => 'הגעת לסוף המצגת';

  @override
  String get startOfPresentation => 'הגעת לתחילת המצגת';

  @override
  String get palettes => 'פלטות צבעים';

  @override
  String headline(int index) {
    return 'כותרת $index';
  }

  @override
  String get code => 'קוד';

  @override
  String get quote => 'ציטוט';

  @override
  String get link => 'קישור';

  @override
  String get checkbox => 'תיבת סימון';

  @override
  String get deleted => 'נמחק';

  @override
  String get emphasis => 'הדגשה';

  @override
  String get listBullet => 'תבליט רשימה';

  @override
  String get strong => 'חזק';

  @override
  String get markdown => 'Markdown';

  @override
  String get home => 'בית';

  @override
  String get files => 'קבצים';

  @override
  String get sortBy => 'מיין לפי';

  @override
  String get location => 'מיקום';

  @override
  String get whatsNew => 'מה חדש?';

  @override
  String get unstar => 'הסר כוכב';

  @override
  String get star => 'כוכב';

  @override
  String get goUp => 'עלה למעלה';

  @override
  String get created => 'נוצר';

  @override
  String get modified => 'שוּנה';

  @override
  String get quickstart => 'התחלה מהירה';

  @override
  String get noTemplates => 'אין כרגע תבניות זמינות';

  @override
  String get importCorePack => 'ייבא חבילת ליבה';

  @override
  String get importCorePackDescription =>
      'ייבא את חבילת הליבה המכילה את כל הנכסים הבסיסיים כדי להתחיל. פעולה זו תדרוס את חבילת הליבה הנוכחית.';

  @override
  String get never => 'אף פעם';

  @override
  String get onlyOnUpdates => 'רק בעדכונים';

  @override
  String get visibility => 'נראות';

  @override
  String get captureThumbnail => 'צלם תמונה ממוזערת';

  @override
  String get capturedThumbnail => 'התמונה הממוזערת צולמה בהצלחה';

  @override
  String get chooseLabelMode => 'בחר מצב תווית';

  @override
  String get foreground => 'חזית';

  @override
  String get version => 'גרסה';

  @override
  String get repository => 'מאגר';

  @override
  String get pages => 'עמודים';

  @override
  String get navigator => 'נווט';

  @override
  String get arrange => 'סדר';

  @override
  String get bringToFront => 'הבא לקדמה';

  @override
  String get sendToBack => 'העבר לרקע';

  @override
  String get bringForward => 'הבא קדימה';

  @override
  String get sendBackward => 'שלח אחורה';

  @override
  String get rotation => 'סיבוב';

  @override
  String get onlyAvailableLargerScreen => 'זמין רק במסכים גדולים יותר';

  @override
  String get toolbarPosition => 'מיקום סרגל כלים';

  @override
  String get rotate => 'סובב';

  @override
  String get spacer => 'מרווח';

  @override
  String get navigationRail => 'פס ניווט';

  @override
  String get cut => 'גזור';

  @override
  String get insertBefore => 'הוסף לפני';

  @override
  String get insertAfter => 'הוסף אחרי';

  @override
  String get insertFirst => 'הוסף ראשון';

  @override
  String get insertLast => 'הוסף אחרון';

  @override
  String get paste => 'הדבק';

  @override
  String get ascending => 'סדר עולה';

  @override
  String get descending => 'סדר יורד';

  @override
  String get imageScale => 'קנה מידה של תמונה';

  @override
  String get select => 'בחר';

  @override
  String get tool => 'כלי';

  @override
  String get texture => 'מרקם';

  @override
  String get platformTheme => 'ערכת נושא של הפלטפורמה';

  @override
  String get desktop => 'שולחן עבודה';

  @override
  String get mobile => 'נייד';

  @override
  String get pdfQuality => 'איכות PDF';

  @override
  String get surface => 'משטח';

  @override
  String get pattern => 'תבנית';

  @override
  String get sureClose => 'האם אתה בטוח שברצונך לסגור את המסמך?';

  @override
  String get thereAreUnsavedChanges => 'ישנם שינויים שלא נשמרו';

  @override
  String get page => 'עמוד';

  @override
  String get iceServers => 'שרתי ICE';

  @override
  String get collaboration => 'שיתוף פעולה';

  @override
  String get webRtc => 'Web RTC';

  @override
  String get webSocket => 'Web Socket';

  @override
  String get iceServer => 'שרת ICE';

  @override
  String get port => 'פורט';

  @override
  String get type => 'סוג';

  @override
  String get side => 'צד';

  @override
  String get client => 'לקוח';

  @override
  String get server => 'שרת';

  @override
  String get switchView => 'החלף תצוגה';

  @override
  String get lasso => 'לאסו';

  @override
  String get hideUI => 'הסתר ממשק משתמש';

  @override
  String get density => 'צפיפות';

  @override
  String get compact => 'קומפקטי';

  @override
  String get comfortable => 'נוח';

  @override
  String get standard => 'סטנדרטי';

  @override
  String get lock => 'נעל';

  @override
  String get addElement => 'הוסף פריט';

  @override
  String get notDefaultConnection => 'לא חיבור ברירת מחדל';

  @override
  String get defaultConnection => 'חיבור ברירת מחדל';

  @override
  String get hide => 'הסתר';

  @override
  String get show => 'הצג';

  @override
  String get pause => 'השהה';

  @override
  String get stop => 'עצור';

  @override
  String get refresh => 'רענן';

  @override
  String get print => 'הדפס';

  @override
  String get dav => 'DAV';

  @override
  String get eyeDropper => 'דוגם צבע';

  @override
  String get users => 'משתמשים';

  @override
  String get experiments => 'ניסויים';

  @override
  String get experimentsWarning =>
      'תכונות אלו הן ניסיוניות ועשויות להשתנות, להישבר או להיעלם בכל עת. הפעלתן עלולה לגרום לחוסר יציבות או לאובדן נתונים. יש לפעול בזהירות. אנא דווח על כל באג.';

  @override
  String get address => 'כתובת';

  @override
  String get spreadToPages => 'פרוס על פני עמודים';

  @override
  String get rootDirectorySpecifiedDescription =>
      'ספריית השורש צוינה. כל נתיבי הספריות המתקדמות יהיו יחסיים לספרייה זו. השאר ריק כדי להשבית סוג ספרייה זה.';

  @override
  String get rootDirectoryNotSpecifiedDescription =>
      'ספריית השורש לא צוינה. נדרש שם. כל נתיבי הספריות המתקדמות יהיו מוחלטים. השאר ריק כדי להשבית סוג ספרייה זה.';

  @override
  String get unsecureConnectionTitle => 'חיבור לא מאובטח';

  @override
  String unsecureConnectionMessage(String fingerprint) {
    return 'החיבור אינו מאובטח. הדבר עלול להוות סיכון אבטחתי. אנא המשך רק אם אתה בוטח בחיבור. טביעת האצבע sha1 היא $fingerprint.';
  }

  @override
  String get continueAnyway => 'המשך בכל זאת';

  @override
  String get zoomControl => 'בקרת זום';

  @override
  String get highContrast => 'ניגודיות גבוהה';

  @override
  String get shouldANumber => 'ערך זה חייב להיות מספר תקין';

  @override
  String get createAreas => 'צור אזורים';

  @override
  String get autosave => 'שמירה אוטומטית';

  @override
  String get invert => 'הפוך';

  @override
  String get operations => 'פעולות';

  @override
  String get medium => 'בינוני';

  @override
  String get large => 'גדול';

  @override
  String get toolbarSize => 'גודל סרגל כלים';

  @override
  String get addAll => 'הוסף הכל';

  @override
  String get onlyCurrentPage => 'רק העמוד הנוכחי';

  @override
  String get smoothNavigation => 'ניווט חלק';

  @override
  String get exact => 'מדויק';

  @override
  String get inline => 'בתוך השורה';

  @override
  String get toolbarRows => 'שורות בסרגל הכלים';

  @override
  String get pointerTest => 'בדיקת מצביע';

  @override
  String get pressure => 'לחץ';

  @override
  String get small => 'קטן';

  @override
  String get tiny => 'זעיר';

  @override
  String get selectAll => 'בחר הכל';

  @override
  String get overrideTools => 'דרוס כלים';

  @override
  String get hideCursorWhileDrawing => 'הסתר סמן בזמן ציור';

  @override
  String get installed => 'מותקן';

  @override
  String get install => 'התקן';

  @override
  String get deselect => 'בטל בחירה';

  @override
  String get changeCollection => 'שנה אוסף';

  @override
  String get collections => 'אוספים';

  @override
  String get fullSelection => 'בחירה מלאה';

  @override
  String get fullSelectionDescription =>
      'דורש שהפריטים יהיו במלואם בתוך תיבת הבחירה כדי להיבחר.';

  @override
  String get collection => 'אוסף';

  @override
  String get defaultCollection => 'אוסף ברירת מחדל';

  @override
  String get scroll => 'גלול';

  @override
  String get onStartup => 'בעת הפעלה';

  @override
  String get homeScreen => 'מסך הבית';

  @override
  String get lastNote => 'פתק אחרון';

  @override
  String get newNote => 'פתק חדש';

  @override
  String get convertToLayer => 'המר לשכבה';

  @override
  String get merge => 'מזג';

  @override
  String get up => 'למעלה';

  @override
  String get down => 'למטה';

  @override
  String get other => 'אחר';

  @override
  String countElements(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count פריטים',
      one: 'פריט אחד',
      zero: 'אין פריטים',
    );
    return '$_temp0';
  }

  @override
  String get colorToolbar => 'סרגל כלים צבע';

  @override
  String get yesButShowButtons => 'כן, אבל הצג כפתורים';

  @override
  String get optionsPanelPosition => 'מיקום חלונית האפשרויות';

  @override
  String get hideDuration => 'הסתר משך זמן';

  @override
  String get animation => 'אנימציה';

  @override
  String get performance => 'ביצועים';

  @override
  String get performanceDescription =>
      'מותאם למהירות ושימוש בזיכרון. רק החלק הנראה של הפתק נאפה לתוך התמונה.';

  @override
  String get normalDescription =>
      'מאזן בין איכות וביצועים. אופה תמונה המכסה פי 1.5 מהאזור הנראה, ומספק מעברים חלקים יותר בזמן גלילה.';

  @override
  String get high => 'גבוה';

  @override
  String get highDescription =>
      'Maximizes quality at the cost of performance. Bakes an image covering 2 times the visible area, ensuring seamless rendering even during rapid scrolling or zooming.';

  @override
  String get renderResolution => 'רזולוציית רינדור';

  @override
  String get translate => 'תרגם';

  @override
  String get unencrypted => 'לא מוצפן';

  @override
  String get encrypted => 'מוצפן';

  @override
  String get encryptDocumentMessage => 'לחץ כדי להצפין את המסמך';

  @override
  String get unencryptDocumentMessage => 'לחץ כדי לבטל את הצפנת המסמך';

  @override
  String get unencrypt => 'בטל הצפנה';

  @override
  String get encrypt => 'הצפן';

  @override
  String get encryptWarning =>
      'פעולה זו תצפין את המסמך. יהיה עליך לזכור את הסיסמה כדי לפענח אותו.';

  @override
  String get unencryptWarning =>
      'פעולה זו תבטל את הצפנת המסמך. הסיסמה תוסר וכל מי שיש לו גישה יוכל לפתוח אותו.';

  @override
  String get confirmPassword => 'אשר סיסמה';

  @override
  String get passwordMismatch => 'הסיסמאות אינן תואמות';

  @override
  String get action => 'פעולה';

  @override
  String get svgText => 'טקסט SVG';

  @override
  String get offset => 'היסט';

  @override
  String get positionDependent => 'תלוי מיקום';

  @override
  String get flipHorizontal => 'הפוך אופקית';

  @override
  String get flipVertical => 'הפוך אנכית';

  @override
  String get grayscale => 'גווני אפור';

  @override
  String get moveOnGesture => 'הזז במחווה';

  @override
  String get exportAllFiles => 'ייצא את כל הקבצים';

  @override
  String get restoreSettingsFromFile => 'שחזר הגדרות מקובץ';

  @override
  String get exportSettingsToFile => 'ייצא הגדרות לקובץ';

  @override
  String get barcode => 'ברקוד';

  @override
  String get barcodeType => 'סוג ברקוד';

  @override
  String get qrCode => 'קוד QR';

  @override
  String get dataMatrix => 'Data Matrix';

  @override
  String get code128 => 'Code 128';

  @override
  String defaultUserName(int index) {
    return 'משתמש $index';
  }

  @override
  String get moveLeft => 'הזז שמאלה';

  @override
  String get moveRight => 'הזז ימינה';

  @override
  String get bundledPacks => 'חבילות כלולות';

  @override
  String get component => 'Component';

  @override
  String get selectComponent => 'בחר רכיב';

  @override
  String get bundlePackInDocument => 'כלול חבילה במסמך';

  @override
  String get bundledPacksDescription =>
      'חבילות כלולות נכללות במסמך וניתן להשתמש בהן רק לשיתוף עם המסמך. ניתן להשתמש בנכסים במסמך רק אם החבילה מותקנת. ניתן להתקין חבילות על ידי לחיצה עליהן.';

  @override
  String get fillAlpha => 'שקיפות מילוי';

  @override
  String get packagedFile => 'קובץ ארוז';

  @override
  String get rawFile => 'קובץ גולמי';

  @override
  String get webSocketDescription =>
      'המכשיר שלך מארח את השרת, כך שמשתפי פעולה יכולים להצטרף רק דרך אותה רשת או מכל מקום אם תעביר את הפורט בנתב שלך.';

  @override
  String get swampDescription =>
      'ההודעות שלך מנותבות דרך שרת ממסר מאובטח עם הצפנה מקצה לקצה. נדרשת כתובת שרת Swamp ליצירת סשן.';

  @override
  String get createRawNote => 'צור פתק גולמי';

  @override
  String get polygon => 'מצולע';

  @override
  String get finishShape => 'סיים צורה';

  @override
  String get submit => 'שלח';

  @override
  String get math => 'Math';

  @override
  String get ignorePressure => 'Ignore pressure';

  @override
  String get ignoreFirstPressureDescription =>
      'On some devices, the first pressure value is not accurate. This setting will ignore the first pressure value and use the pressure of the second event instead.';

  @override
  String get temporary => 'Temporary';

  @override
  String get simpleToolbarVisibility => 'Simple toolbar visibility';

  @override
  String get autosaveDelay => 'Autosave delay';

  @override
  String get saved => 'Saved';

  @override
  String get saving => 'Saving...';

  @override
  String get readOnly => 'Read only';

  @override
  String get saveDelayed => 'Save delayed';

  @override
  String get unsaved => 'Unsaved';

  @override
  String get pdfEmptyDescription =>
      'There are currently no areas to export. Please select at least one area using the plus button in the top right corner or add all areas from the current page or from the whole document below.';
}
