// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Czech (`cs`).
class AppLocalizationsCs extends AppLocalizations {
  AppLocalizationsCs([String locale = 'cs']) : super(locale);

  @override
  String get open => 'Otevřít';

  @override
  String get settings => 'Nastavení';

  @override
  String get personalization => 'Přizpůsobení';

  @override
  String get theme => 'Téma';

  @override
  String get darkTheme => 'Tmavý motiv';

  @override
  String get lightTheme => 'Světlý motiv';

  @override
  String get systemTheme => 'Použít výchozí motiv systému';

  @override
  String get view => 'Zobrazit';

  @override
  String get edit => 'Upravit';

  @override
  String get export => 'Exportovat';

  @override
  String get save => 'Uložit';

  @override
  String get zoom => 'Přiblížení';

  @override
  String get zoomIn => 'Přiblížit';

  @override
  String get zoomOut => 'Oddálit';

  @override
  String get resetZoom => 'Resetovat zoom';

  @override
  String get strokeWidth => 'Šířka';

  @override
  String get includeEraser => 'Zahrnout gumu?';

  @override
  String get thinning => 'Ztenčování';

  @override
  String get pen => 'Tužka';

  @override
  String get invertedPen => 'Převrácená tužka';

  @override
  String get eraser => 'Guma';

  @override
  String get pathEraser => 'Vymazání tahem';

  @override
  String get label => 'Štítek';

  @override
  String get delete => 'Vymazat';

  @override
  String get areYouSure => 'Jste si jisti?';

  @override
  String get reallyDelete => 'Opravdu chcete odstranit tuto položku?';

  @override
  String get no => 'Ne';

  @override
  String get yes => 'Ano';

  @override
  String get undo => 'Zpět';

  @override
  String get redo => 'Znovu';

  @override
  String get general => 'Obecné';

  @override
  String get copyTitle => 'Zkopírováno do schránky';

  @override
  String get loading => 'Načítám...';

  @override
  String get enterText => 'Zadejte text';

  @override
  String get size => 'Velikost';

  @override
  String get width => 'Šířka';

  @override
  String get height => 'Výška';

  @override
  String get count => 'Počet';

  @override
  String get space => 'Prostor';

  @override
  String get background => 'Pozadí';

  @override
  String get box => 'Krabice';

  @override
  String get locale => 'Jazyk';

  @override
  String get systemLocale => 'Systémový jazyk';

  @override
  String get information => 'Informace';

  @override
  String get license => 'Licence';

  @override
  String get imprint => 'Tiráž';

  @override
  String get privacypolicy => 'Ochrana osobních údajů';

  @override
  String get sourceCode => 'Zdrojový kód';

  @override
  String get documentation => 'Dokumentace';

  @override
  String get changelog => 'Seznam změn';

  @override
  String get source => 'Zdroj';

  @override
  String get existOverride => 'Tento prvek již existuje. Přepsat?';

  @override
  String get description => 'Popis';

  @override
  String get fill => 'Vyplnit';

  @override
  String get defaultPalette => 'Výchozí paleta';

  @override
  String get highlighter => 'Zvýrazňovač';

  @override
  String get add => 'Přidat';

  @override
  String get remove => 'Odebrat';

  @override
  String get removeConfirm => 'Opravdu chcete toto odstranit?';

  @override
  String get resetPalette => 'Resetovat paletu';

  @override
  String get custom => 'Vlastní';

  @override
  String get decoration => 'Dekorace';

  @override
  String get underline => 'Podtrhnout';

  @override
  String get overline => 'Nadtržení';

  @override
  String get strikethrough => 'Přeškrtnutí';

  @override
  String get thickness => 'Tloušťka';

  @override
  String get style => 'Styl';

  @override
  String get solid => 'Pevný';

  @override
  String get double => 'Dvojitý';

  @override
  String get dotted => 'Tečkovaný';

  @override
  String get dashed => 'Přerušovaný';

  @override
  String get wavy => 'Zvlněný';

  @override
  String get fontWeight => 'Tloušťka písma';

  @override
  String get normal => 'Normální';

  @override
  String get bold => 'Tučný';

  @override
  String get italic => 'Kurzíva';

  @override
  String get clipboard => 'Schránka';

  @override
  String get file => 'Soubor';

  @override
  String get data => 'Údaje';

  @override
  String get share => 'Sdílet';

  @override
  String get spacing => 'Rozestup';

  @override
  String get image => 'Obrázek';

  @override
  String get enterUrl => 'Zadejte adresu URL';

  @override
  String get scale => 'Měřítko';

  @override
  String get help => 'Nápověda';

  @override
  String get reallyReset => 'Opravdu to chcete resetovat?';

  @override
  String get whatToDo => 'Co chcete udělat?';

  @override
  String get ignore => 'Ignorovat';

  @override
  String get backup => 'Záloha';

  @override
  String createdInNewerVersion(String fileName, int fileVersion) {
    return 'Soubor $fileName byl vytvořen v novější verzi ($fileVersion). Co chcete provést s tímto souborem?';
  }

  @override
  String get waypoints => 'Body';

  @override
  String get origin => 'Původ';

  @override
  String get import => 'Importovat';

  @override
  String get newContent => 'Nové';

  @override
  String get selectElement => 'Vyberte prvek';

  @override
  String get ctrlKey => 'Ctrl';

  @override
  String get shiftKey => 'Shift';

  @override
  String get altKey => 'Alt';

  @override
  String get copyVersion => 'Kopírovat verzi';

  @override
  String get input => 'Vstup';

  @override
  String get behaviors => 'Chování';

  @override
  String get dataDirectory => 'Datový adresář';

  @override
  String get defaultPath => 'Výchozí cesta';

  @override
  String get dateFormat => 'Formát data';

  @override
  String updatedAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'Aktualizováno na: $dateTimeString';
  }

  @override
  String createdAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'Vytvořeno v: $dateTimeString';
  }

  @override
  String get rename => 'Přejmenovat';

  @override
  String get duplicate => 'Duplikovat';

  @override
  String get hand => 'Ruka';

  @override
  String get folder => 'Složka';

  @override
  String get move => 'Přesunout';

  @override
  String get copy => 'Kopírovat';

  @override
  String get back => 'Zpět';

  @override
  String get zoomDependent => 'Přiblížení závislé';

  @override
  String get shapeDetection => 'Detekce tvarů';

  @override
  String get delay => 'Zpoždění';

  @override
  String get defaultLayer => 'Výchozí vrstva';

  @override
  String get layer => 'Vrstva';

  @override
  String get layers => 'Vrstvy';

  @override
  String get notSet => 'Nenastaveno';

  @override
  String get enterLayer => 'Zadejte název vrstvy';

  @override
  String get selectElements => 'Vybrat prvky';

  @override
  String get deleteElements => 'Odstranit prvky';

  @override
  String get deleteElementsConfirm => 'Opravdu chcete odstranit vybrané prvky?';

  @override
  String get selectCustomCollection => 'Vybrat vlastní kolekci';

  @override
  String get svg => 'SVG';

  @override
  String get sensitivity => 'Citlivost';

  @override
  String get sensitivityHint => 'Čím vyšší hodnota, tím citlivější je vstup';

  @override
  String get horizontal => 'Horizontální';

  @override
  String get vertical => 'Vertikální';

  @override
  String get plain => 'Jednoduchý';

  @override
  String get light => 'Světlý';

  @override
  String get ruled => 'Ovládáno';

  @override
  String get quad => 'Čárka';

  @override
  String get music => 'Hudba';

  @override
  String get dark => 'Tmavý';

  @override
  String get plainDark => 'Tmavý';

  @override
  String get ruledDark => 'Rušeno tmavé';

  @override
  String get quadDark => 'Čtyřnásobně tmavé';

  @override
  String get musicDark => 'Hudební tmavý';

  @override
  String get templates => 'Šablony';

  @override
  String get untitled => 'Bez názvu';

  @override
  String get createTemplate => 'Vytvořit šablonu';

  @override
  String get createTemplateContent =>
      'Opravdu chcete vytvořit šablonu z tohoto dokumentu? Původní dokument bude smazán.';

  @override
  String get replace => 'Nahradit';

  @override
  String get reallyReplace =>
      'Opravdu chcete nahradit šablonu? Tuto operaci nelze vrátit zpět!';

  @override
  String get defaultTemplate => 'Výchozí šablona';

  @override
  String get insert => 'Vložit';

  @override
  String get document => 'Dokument';

  @override
  String get camera => 'Fotoaparát';

  @override
  String get printout => 'Výtisk';

  @override
  String get selectCamera => 'Vybrat fotoaparát';

  @override
  String get changeDocumentPath => 'Změnit umístění dokumentu';

  @override
  String get deleteWholeStroke => 'Odstranit celý tah';

  @override
  String get alpha => 'Alfa';

  @override
  String get area => 'Oblast';

  @override
  String get selectArea => 'Vyberte oblast';

  @override
  String get aspectRatio => 'Poměr stran';

  @override
  String get presets => 'Předvolby';

  @override
  String get pagePortrait => 'Stránka na výšku';

  @override
  String get pageLandscape => 'Stránka na šířku';

  @override
  String get square => 'Čtverec';

  @override
  String get areas => 'Oblasti';

  @override
  String get enterArea => 'Vybrat oblast';

  @override
  String get exitArea => 'Opustit oblast';

  @override
  String get currentArea => 'Aktuální oblast';

  @override
  String get design => 'Vzhled';

  @override
  String get text => 'Text';

  @override
  String welcome(String codeName) {
    return 'Vítej v Linwood Butterfly $codeName';
  }

  @override
  String get welcomeContent => 'Svobodný a open-source prostor pro kreslení!';

  @override
  String updated(String version) {
    return 'Aplikace byla aktualizována na verzi $version';
  }

  @override
  String get releaseNotes => 'Poznámky k vydání';

  @override
  String get constraints => 'Omezení';

  @override
  String get scaled => 'Škálování';

  @override
  String get fixed => 'Pevný';

  @override
  String get dynamicContent => 'Dynamický';

  @override
  String get none => 'Nic';

  @override
  String get includeArea => 'Zahrnout oblast';

  @override
  String get verticalAlignment => 'Svislé zarovnání';

  @override
  String get horizontalAlignment => 'Vodorovné zarovnání';

  @override
  String get top => 'Nahoře';

  @override
  String get center => 'Uprostřed';

  @override
  String get bottom => 'Dole';

  @override
  String get left => 'Vlevo';

  @override
  String get right => 'Vpravo';

  @override
  String get justify => 'Zarovnat';

  @override
  String get constraint => 'Omezit';

  @override
  String get length => 'Délka';

  @override
  String get exportSvg => 'Exportovat SVG';

  @override
  String get pdf => 'PDF';

  @override
  String get selectPages => 'Vybrat stránky';

  @override
  String get recentFiles => 'Nedávné soubory';

  @override
  String get start => 'Začít';

  @override
  String get noRecentFiles => 'Žádné nedávné soubory';

  @override
  String countPages(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count stránky',
      one: '1 stránka',
      zero: 'Žádné stránky',
    );
    return '$_temp0';
  }

  @override
  String pageIndex(int index) {
    return 'Strana $index';
  }

  @override
  String get exit => 'Ukončit';

  @override
  String get noElements => 'Žádné prvky';

  @override
  String get invertSelection => 'Obrátit výběr';

  @override
  String get errorWhileImporting => 'Chyba při importovaní';

  @override
  String get errorWhileImportingContent =>
      'Při nahrávaní souboru došlo k chybě';

  @override
  String get showDetails => 'Zobrazit podrobnosti';

  @override
  String get hideDetails => 'Skrýt podrobnosti';

  @override
  String get error => 'Chyba';

  @override
  String get stackTrace => 'Trasování zásobníku';

  @override
  String get laser => 'Laser';

  @override
  String get duration => 'Doba trvání';

  @override
  String get quality => 'Kvalita';

  @override
  String get exportPdf => 'Exportovat PDF';

  @override
  String get local => 'Místní';

  @override
  String get addConnection => 'Přidat spojení';

  @override
  String get connections => 'Spojení';

  @override
  String get noConnections => 'Žádná spojení';

  @override
  String get url => 'URL';

  @override
  String get connect => 'Připojit';

  @override
  String get username => 'Uživatelské jméno';

  @override
  String get password => 'Heslo';

  @override
  String get webNotSupported => 'Web není podporován';

  @override
  String get advanced => 'Rozšířené';

  @override
  String get directory => 'Adresář';

  @override
  String get documentsDirectory => 'Adresář dokumentů';

  @override
  String get templatesDirectory => 'Adresář šablon';

  @override
  String get errorWhileCreatingConnection => 'Chyba při vytváření připojení';

  @override
  String get cannotConnect => 'Nelze se připojit';

  @override
  String get urlNotValid => 'Adresa URL není platná';

  @override
  String get icon => 'Ikona';

  @override
  String get update => 'Aktualizace';

  @override
  String get updateAvailable => 'K dispozici je aktualizace';

  @override
  String get stable => 'Stabilní';

  @override
  String get nightly => 'Nightly';

  @override
  String get checkForUpdates => 'Zkontrolovat aktualizace';

  @override
  String get checkForUpdatesWarning =>
      'Při kontrole aktualizací proběhne spojení s webem Butterfly.';

  @override
  String get usingLatestStable => 'Používáte nejnovější stabilní verzi';

  @override
  String get usingLatestNightly => 'Používáte nejnovější nightly verzi';

  @override
  String get currentVersion => 'Aktuální verze';

  @override
  String get updateNow => 'Aktualizovat nyní';

  @override
  String get shape => 'Tvar';

  @override
  String get circle => 'Kruh';

  @override
  String get rectangle => 'Obdélník';

  @override
  String get triangle => 'Trojúhelník';

  @override
  String get line => 'Řádek';

  @override
  String get cornerRadius => 'Zaoblení rohů';

  @override
  String get topLeft => 'Vlevo nahoře';

  @override
  String get topRight => 'Vpravo nahoře';

  @override
  String get bottomLeft => 'Vlevo dole';

  @override
  String get bottomRight => 'Vpravo dole';

  @override
  String get caches => 'Cache';

  @override
  String get manage => 'Spravovat';

  @override
  String get clearCaches => 'Vymazat cache';

  @override
  String get createCache => 'Vytvořit cache';

  @override
  String get thirdPartyLicenses => 'Licence třetích stran';

  @override
  String get syncing => 'Synchronizace...';

  @override
  String get synced => 'Synchronizováno';

  @override
  String get notSynced => 'Nesynchronizováno';

  @override
  String get conflict => 'Konflikt';

  @override
  String get keepLocal => 'Ponechat lokální';

  @override
  String get keepConnection => 'Zachovat připojení';

  @override
  String get keepBoth => 'Zachovat obojí';

  @override
  String get forAll => 'Pro všechny';

  @override
  String fileConflict(String file, String connection) {
    return '$file v $connection má konflikt';
  }

  @override
  String get offline => 'Offline';

  @override
  String get localLatest => 'Nejnovější místní';

  @override
  String get connectionLatest => 'Poslední připojení';

  @override
  String get path => 'Cesta';

  @override
  String get folderSynced => 'Složka synchronizována';

  @override
  String get syncRootDirectory => 'Synchronizovat kořenový adresář';

  @override
  String get penOnlyInput => 'Používat pouze tužku';

  @override
  String get inputGestures => 'Gesta';

  @override
  String get nativeTitleBar => 'Nativní titulek';

  @override
  String get syncMode => 'Režim synchronizace';

  @override
  String get connection => 'Připojení';

  @override
  String get always => 'Vždy';

  @override
  String get noMobile => 'Žádný mobil';

  @override
  String get manual => 'Ruční';

  @override
  String get search => 'Hledat';

  @override
  String get properties => 'Vlastnosti';

  @override
  String get pin => 'Připnout';

  @override
  String get unpin => 'Odepnout';

  @override
  String get element => 'Prvek';

  @override
  String get painter => 'Malíř';

  @override
  String get position => 'Pozice';

  @override
  String get note => 'Poznámka';

  @override
  String get packs => 'Balíčky';

  @override
  String get pack => 'Balení';

  @override
  String get more => 'Více';

  @override
  String get askForName => 'Požádat o název';

  @override
  String areaIndex(int index) {
    return 'Oblast $index';
  }

  @override
  String get startInFullScreen => 'Spustit na celou obrazovku';

  @override
  String get inputs => 'Vstupy';

  @override
  String get mouse => 'Myš';

  @override
  String get touch => 'Dotkněte se';

  @override
  String get keyboard => 'Klávesnice';

  @override
  String get shortcuts => 'Zkratky';

  @override
  String get middle => 'Uprostřed';

  @override
  String get first => 'První';

  @override
  String get second => 'Sekunda';

  @override
  String get activeTool => 'Aktivní nástroj';

  @override
  String get activeToolDescription =>
      'Použít aktuálně vybraný nástroj na panelu nástrojů';

  @override
  String get handTool => 'Ruční nástroj';

  @override
  String get handToolDescription => 'Přetažením pohybovat se kolem plátna';

  @override
  String get toolOnToolbar => 'Specifický nástroj na panelu nástrojů';

  @override
  String get toolOnToolbarDescription =>
      'Použít nástroj na určené pozici na nástrojové liště začínající vlevo';

  @override
  String toolOnToolbarShort(int display_position) {
    return 'Pozice panelu nástrojů: $display_position';
  }

  @override
  String get tools => 'Nástroje a nářadí';

  @override
  String get showGrid => 'Zobrazit mřížku';

  @override
  String get grid => 'Mřížka';

  @override
  String get ruler => 'Řidič';

  @override
  String get angle => 'Úhel';

  @override
  String get report => 'Nahlásit';

  @override
  String get newFolder => 'Nová složka';

  @override
  String get createPack => 'Vytvořit balíček';

  @override
  String get editPack => 'Upravit balíček';

  @override
  String get packsDirectory => 'Adresář balíčků';

  @override
  String get stamp => 'Razítko';

  @override
  String get addToPack => 'Přidat do balíčku';

  @override
  String get sureImportPack => 'Opravdu chcete importovat balíček?';

  @override
  String byAuthor(String author) {
    return 'od $author';
  }

  @override
  String get author => 'Autor';

  @override
  String get addAsset => 'Přidat majetek';

  @override
  String get editAsset => 'Upravit aktivum';

  @override
  String get scope => 'Oblast působnosti';

  @override
  String get noPacks => 'Momentálně nejsou dostupné žádné balíčky';

  @override
  String get components => 'Součásti';

  @override
  String get waypoint => 'Trasový bod';

  @override
  String get actions => 'Akce';

  @override
  String get painters => 'Malířské tmely';

  @override
  String get breakingChangesTitle => 'Zlomit změny';

  @override
  String breakingChangesMessage(int version, int newVersion) {
    return 'V této verzi jsou přerušované změny. Před aktualizací si prosím přečtěte seznam změn. Aktuální verze souboru je $version, nová verze je $newVersion.';
  }

  @override
  String get styles => 'Styly';

  @override
  String get paragraph => 'Odstavec';

  @override
  String get fontFamily => 'Rodina písma';

  @override
  String get smoothing => 'Vyhlazování';

  @override
  String get streamline => 'Streamline';

  @override
  String get presentation => 'Zobrazení';

  @override
  String get selectAsset => 'Vybrat aktivum';

  @override
  String get clearStyle => 'Vymazat styl';

  @override
  String get unknownImportType => 'Neznámý typ importu';

  @override
  String get sureImportTemplate =>
      'Jste si jisti, že chcete importovat šablonu?';

  @override
  String get frame => 'Rámeček';

  @override
  String get play => 'Hrát';

  @override
  String get video => 'Video';

  @override
  String get fps => 'FPS';

  @override
  String get breakpoint => 'Zarážka';

  @override
  String get presentationControls => 'Ovládání prezentace';

  @override
  String get nextSlide => 'Další snímek';

  @override
  String get nextSlideDescription =>
      'Přejetím doprava nebo stisknutím tlačítka pravé šipky přejdete na další snímek';

  @override
  String get previousSlide => 'Předchozí snímek';

  @override
  String get previousSlideDescription =>
      'Přejetím vlevo nebo stisknutím tlačítka vlevo přejděte na předchozí snímek';

  @override
  String get exitPresentation => 'Ukončit prezentaci';

  @override
  String get exitPresentationDescription =>
      'Stisknutím tlačítka úniku nebo přejetím dolů ukončíte prezentaci';

  @override
  String get pausePresentation => 'Pozastavit prezentaci';

  @override
  String get pausePresentationDescription =>
      'Klepněte na obrazovku nebo stiskněte mezerník pro pozastavení nebo pokračování prezentace';

  @override
  String get keyframe => 'Keyframe';

  @override
  String get endOfPresentation => 'Dosáhli jste konce prezentace';

  @override
  String get startOfPresentation => 'Dosáhli jste začátku prezentace';

  @override
  String get palettes => 'Palety';

  @override
  String headline(int index) {
    return 'Nadpis $index';
  }

  @override
  String get code => 'Kód';

  @override
  String get quote => 'Cenová nabídka';

  @override
  String get link => 'Odkaz';

  @override
  String get checkbox => 'Zaškrtávací políčko';

  @override
  String get deleted => 'Odstraněno';

  @override
  String get emphasis => 'Důraz';

  @override
  String get listBullet => 'Seznam odrážek';

  @override
  String get strong => 'Silný';

  @override
  String get markdown => 'Markdown';

  @override
  String get home => 'Domů';

  @override
  String get files => 'Soubory';

  @override
  String get sortBy => 'Seřadit podle';

  @override
  String get location => 'Poloha';

  @override
  String get whatsNew => 'Co je nového?';

  @override
  String get unstar => 'Odebrat z oblíbených';

  @override
  String get star => 'Hvězda';

  @override
  String get goUp => 'Přejít nahoru';

  @override
  String get created => 'Vytvořeno';

  @override
  String get modified => 'Upraveno';

  @override
  String get quickstart => 'Rychlý start';

  @override
  String get noTemplates => 'V současné době nejsou k dispozici žádné šablony';

  @override
  String get importCorePack => 'Importovat základní balíček';

  @override
  String get importCorePackDescription =>
      'Importovat základní balíček, který obsahuje všechny základní položky pro začátek. To přepíše aktuální balíček jádra.';

  @override
  String get never => 'Nikdy';

  @override
  String get onlyOnUpdates => 'Pouze při aktualizacích';

  @override
  String get visibility => 'Viditelnost';

  @override
  String get captureThumbnail => 'Snímat miniaturu';

  @override
  String get capturedThumbnail => 'Náhledy úspěšně zachyceny';

  @override
  String get chooseLabelMode => 'Zvolte mód popisku';

  @override
  String get foreground => 'Popředí';

  @override
  String get version => 'Verze';

  @override
  String get repository => 'Repozitář';

  @override
  String get pages => 'Stránky';

  @override
  String get navigator => 'Navigátor';

  @override
  String get arrange => 'Uspořádat';

  @override
  String get bringToFront => 'Přivést do popředí';

  @override
  String get sendToBack => 'Poslat zpět';

  @override
  String get bringForward => 'Posunout vpřed';

  @override
  String get sendBackward => 'Poslat zpět';

  @override
  String get rotation => 'Otáčení';

  @override
  String get onlyAvailableLargerScreen =>
      'Dostupné pouze na větších obrazovkách';

  @override
  String get toolbarPosition => 'Pozice panelu nástrojů';

  @override
  String get rotate => 'Otočit';

  @override
  String get spacer => 'Mezera';

  @override
  String get navigationRail => 'Navigační kolejnice';

  @override
  String get cut => 'Vyjmout';

  @override
  String get insertBefore => 'Vložit před';

  @override
  String get insertAfter => 'Vložit po';

  @override
  String get insertFirst => 'Nejdříve vložte';

  @override
  String get insertLast => 'Vložit poslední';

  @override
  String get paste => 'Vložit';

  @override
  String get ascending => 'Vzestupně';

  @override
  String get descending => 'Sestupně';

  @override
  String get imageScale => 'Měřítko obrázku';

  @override
  String get select => 'Vybrat';

  @override
  String get tool => 'Nástroj';

  @override
  String get texture => 'Textilie';

  @override
  String get platformTheme => 'Motiv platformy';

  @override
  String get desktop => 'Stolní počítače';

  @override
  String get mobile => 'Mobil';

  @override
  String get pdfQuality => 'Kvalita PDF';

  @override
  String get surface => 'Povrch';

  @override
  String get pattern => 'Vzor';

  @override
  String get sureClose => 'Opravdu chcete dokument zavřít?';

  @override
  String get thereAreUnsavedChanges => 'Existují neuložené změny';

  @override
  String get page => 'Stránka';

  @override
  String get iceServers => 'Servery ICE';

  @override
  String get collaboration => 'Spolupráce';

  @override
  String get webRtc => 'Web RTC';

  @override
  String get webSocket => 'Webová raketa';

  @override
  String get iceServer => 'Server ICE';

  @override
  String get port => 'Přístav';

  @override
  String get type => 'Typ';

  @override
  String get side => 'Boční';

  @override
  String get client => 'Zákazník';

  @override
  String get server => 'Server';

  @override
  String get switchView => 'Přepnout zobrazení';

  @override
  String get lasso => 'Lasso';

  @override
  String get hideUI => 'Skrýt uživatelské rozhraní';

  @override
  String get density => 'Hustota';

  @override
  String get compact => 'Kompaktní';

  @override
  String get comfortable => 'Komfortní';

  @override
  String get standard => 'Standardní';

  @override
  String get lock => 'Zamknout';

  @override
  String get addElement => 'Přidat prvek';

  @override
  String get notDefaultConnection => 'Není výchozí připojení';

  @override
  String get defaultConnection => 'Výchozí připojení';

  @override
  String get hide => 'Skrýt';

  @override
  String get show => 'Zobrazit';

  @override
  String get pause => 'Pozastavit';

  @override
  String get stop => 'Zastavit';

  @override
  String get refresh => 'Aktualizovat';

  @override
  String get print => 'Tisk';

  @override
  String get dav => 'DAV';

  @override
  String get eyeDropper => 'Kapátko';

  @override
  String get users => 'Uživatelé';

  @override
  String get experiments => 'Experimenty';

  @override
  String get experimentsWarning =>
      'Tyto vlastnosti jsou experimentální a mohou kdykoliv změnit, rozbít nebo zmizet. Jejich povolení může způsobit nestabilitu nebo ztrátu dat. Buďte opatrní. Nahlaste prosím chyby.';

  @override
  String get address => 'Adresa';

  @override
  String get spreadToPages => 'Rozšiřte na stránky';

  @override
  String get rootDirectorySpecifiedDescription =>
      'Kořenový adresář je zadán. Všechny pokročilé cesty adresáře budou relativní k tomuto adresáři. Ponechte prázdné pro vypnutí tohoto typu adresáře.';

  @override
  String get rootDirectoryNotSpecifiedDescription =>
      'Kořenový adresář není zadán. Je vyžadován název všech pokročilých adresářů budou absolutní. Ponechte prázdné pro vypnutí tohoto typu adresáře.';

  @override
  String get unsecureConnectionTitle => 'Nebezpečné připojení';

  @override
  String unsecureConnectionMessage(String fingerprint) {
    return 'Připojení není zabezpečené. Toto může představovat bezpečnostní riziko. Pokračujte prosím pouze pokud věříte spojení. Sdílený otisk prstu je $fingerprint.';
  }

  @override
  String get continueAnyway => 'Přesto pokračovat';

  @override
  String get zoomControl => 'Ovládání přiblížení';

  @override
  String get highContrast => 'Vysoký kontrast';

  @override
  String get shouldANumber => 'Tato hodnota by měla být platné číslo';

  @override
  String get createAreas => 'Vytvořit oblasti';

  @override
  String get autosave => 'Automatické uložení';

  @override
  String get invert => 'Převrátit';

  @override
  String get operations => 'Operace';

  @override
  String get medium => 'Střední';

  @override
  String get large => 'Velký';

  @override
  String get toolbarSize => 'Velikost panelu nástrojů';

  @override
  String get addAll => 'Přidat vše';

  @override
  String get onlyCurrentPage => 'Pouze aktuální stránka';

  @override
  String get smoothNavigation => 'Hladká navigace';

  @override
  String get exact => 'Přesné';

  @override
  String get inline => 'Řádek';

  @override
  String get toolbarRows => 'Řádky panelu nástrojů';

  @override
  String get pointerTest => 'Zkouška ukazovatele';

  @override
  String get pressure => 'Tlak';

  @override
  String get small => 'Malá';

  @override
  String get tiny => 'Malý';

  @override
  String get selectAll => 'Vybrat vše';

  @override
  String get overrideTools => 'Přepsat nástroje';

  @override
  String get hideCursorWhileDrawing => 'Skrýt kurzor při kreslení';

  @override
  String get installed => 'Nainstalováno';

  @override
  String get install => 'Instalovat';

  @override
  String get deselect => 'Zrušit výběr';

  @override
  String get changeCollection => 'Změnit kolekci';

  @override
  String get collections => 'Sbírky';

  @override
  String get fullSelection => 'Plný výběr';

  @override
  String get fullSelectionDescription =>
      'Vyžaduje, aby prvky byly plně ve výběrovém poli pro výběr.';

  @override
  String get collection => 'Sbírka';

  @override
  String get defaultCollection => 'Výchozí kolekce';

  @override
  String get scroll => 'Posunout';

  @override
  String get onStartup => 'Při startu';

  @override
  String get homeScreen => 'Domovská stránka';

  @override
  String get lastNote => 'Poslední poznámka';

  @override
  String get newNote => 'Nová poznámka';

  @override
  String get convertToLayer => 'Převést na vrstvu';

  @override
  String get merge => 'Sloučit';

  @override
  String get up => 'Nahoru';

  @override
  String get down => 'Dolů';

  @override
  String get other => 'Ostatní';

  @override
  String countElements(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count elementy',
      one: '1 element',
      zero: 'Žádné elementy',
    );
    return '$_temp0';
  }

  @override
  String get colorToolbar => 'Barevný panel nástrojů';

  @override
  String get yesButShowButtons => 'Ano, ale zobrazit tlačítka';

  @override
  String get optionsPanelPosition => 'Pozice panelu Možnosti';

  @override
  String get hideDuration => 'Doba trvání skrytí';

  @override
  String get animation => 'Animace';

  @override
  String get performance => 'Výkon';

  @override
  String get performanceDescription =>
      'Optimalizováno pro rychlost a využití paměti. Do obrázku se upíná pouze viditelná část poznámky.';

  @override
  String get normalDescription =>
      'Vyvažuje kvalitu a výkon. Peče obraz pokrývající 1,5 násobek viditelného prostoru, poskytuje tak hladší přechody při posouvání.';

  @override
  String get high => 'Vysoká';

  @override
  String get highDescription =>
      'Maximalizuje kvalitu za cenu výkonu. Bakes obrázek pokrývající dvojnásobek viditelného prostoru, který zajišťuje plynulé vykreslování i při rychlém posouvání nebo přiblížení.';

  @override
  String get renderResolution => 'Vykreslovat rozlišení';

  @override
  String get translate => 'Přeložit';

  @override
  String get unencrypted => 'Nešifrováno';

  @override
  String get encrypted => 'Šifrováno';

  @override
  String get encryptDocumentMessage => 'Kliknutím zašifrujete dokument';

  @override
  String get unencryptDocumentMessage =>
      'Kliknutím zrušíte šifrování dokumentu';

  @override
  String get unencrypt => 'Nešifrovat';

  @override
  String get encrypt => 'Šifrovat';

  @override
  String get encryptWarning =>
      'Tímto zašifrujete dokument. Pro dešifrování si budete muset zapamatovat heslo.';

  @override
  String get unencryptWarning =>
      'Tento dokument nebude zašifrován. Heslo bude odebráno a všichni s přístupem jej budou moci otevřít.';

  @override
  String get confirmPassword => 'Potvrdit heslo';

  @override
  String get passwordMismatch => 'Hesla se neshodují';

  @override
  String get action => 'Akce';

  @override
  String get svgText => 'SVG text';

  @override
  String get offset => 'Odsazení';

  @override
  String get positionDependent => 'Závislost na poloze';

  @override
  String get flipHorizontal => 'Překlopit vodorovně';

  @override
  String get flipVertical => 'Překlopit svisle';

  @override
  String get grayscale => 'Odstíny šedi';

  @override
  String get moveOnGesture => 'Přesunout gestem';

  @override
  String get exportAllFiles => 'Exportovat všechny soubory';

  @override
  String get restoreSettingsFromFile => 'Obnovit nastavení ze souboru';

  @override
  String get exportSettingsToFile => 'Exportovat nastavení do souboru';

  @override
  String get barcode => 'Čárový kód';

  @override
  String get barcodeType => 'Typ čárového kódu';

  @override
  String get qrCode => 'QR kód';

  @override
  String get dataMatrix => 'Datová matice';

  @override
  String get code128 => 'Kód 128';

  @override
  String defaultUserName(int index) {
    return 'Uživatel $index';
  }

  @override
  String get moveLeft => 'Přesunout vlevo';

  @override
  String get moveRight => 'Přesunout vpravo';

  @override
  String get bundledPacks => 'Balíčky';

  @override
  String get component => 'Komponenty';

  @override
  String get selectComponent => 'Vybrat komponentu';

  @override
  String get bundlePackInDocument => 'Balíček balíků v dokumentu';

  @override
  String get bundledPacksDescription =>
      'Balené balíčky jsou v dokumentu obsaženy a používají se pouze ke sdílení s dokumentem. Majetky mohou být použity v dokumentu pouze v případě, že je balíček nainstalován. Balíčky lze nainstalovat kliknutím na něj.';

  @override
  String get fillAlpha => 'Vyplnit alfa';

  @override
  String get packagedFile => 'Balený soubor';

  @override
  String get rawFile => 'Surový soubor';

  @override
  String get webSocketDescription =>
      'Vaše zařízení hostí server, takže se spolupracovníci mohou připojit přes stejnou síť nebo odkudkoliv pouze tehdy, pokud přeposíláte port na váš router.';

  @override
  String get swampDescription =>
      'Vaše zprávy jsou směrovány přes bezpečný server s koncovým šifrováním. Pro vytvoření relace je nutná adresa swamp serveru.';

  @override
  String get createRawNote => 'Vytvořit surovou poznámku';

  @override
  String get polygon => 'Polygon';

  @override
  String get finishShape => 'Dokončit tvar';

  @override
  String get submit => 'Odeslat';

  @override
  String get math => 'Matematika';

  @override
  String get ignorePressure => 'Ignorovat sílu stisku';

  @override
  String get ignoreFirstPressureDescription =>
      'U některých zařízení není první zaznamenaná hodnota tlaku přesná. Toto nastavení bude ignorovat první hodnotu tlaku a místo toho použije druhou.';

  @override
  String get temporary => 'Dočasné';

  @override
  String get simpleToolbarVisibility =>
      'Jednoduchá viditelnost panelu nástrojů';

  @override
  String get autosaveDelay => 'Prodleva automatického ukládání';

  @override
  String get saved => 'Uloženo';

  @override
  String get saving => 'Ukládání...';

  @override
  String get readOnly => 'Pouze pro čtení';

  @override
  String get saveDelayed => 'Uložit pozdě';

  @override
  String get unsaved => 'Neuloženo';

  @override
  String get pdfEmptyDescription =>
      'V současné době nejsou žádné oblasti pro vývoz. Vyberte prosím alespoň jednu oblast pomocí tlačítka plus v pravém horním rohu nebo přidejte všechny oblasti z aktuální stránky nebo z celého níže uvedeného dokumentu.';
}
