// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Catalan Valencian (`ca`).
class AppLocalizationsCa extends AppLocalizations {
  AppLocalizationsCa([String locale = 'ca']) : super(locale);

  @override
  String get open => 'Obrir';

  @override
  String get settings => 'Configuració';

  @override
  String get personalization => 'Personalització';

  @override
  String get theme => 'Tema';

  @override
  String get darkTheme => 'Tema fosc';

  @override
  String get lightTheme => 'Tema clar';

  @override
  String get systemTheme => 'Utilitzar tema del sistema per defecte';

  @override
  String get view => 'Veure';

  @override
  String get edit => 'Editar';

  @override
  String get export => 'Exportar';

  @override
  String get save => 'Desa';

  @override
  String get zoom => 'Zoom';

  @override
  String get zoomIn => 'Amplia';

  @override
  String get zoomOut => 'Redueix';

  @override
  String get resetZoom => 'Reinicia zoom';

  @override
  String get strokeWidth => 'Amplada del traç';

  @override
  String get includeEraser => 'Incloure esborrador?';

  @override
  String get thinning => 'Afinament';

  @override
  String get pen => 'Bolígraf';

  @override
  String get invertedPen => 'Bolígraf invertit';

  @override
  String get eraser => 'Esborrador';

  @override
  String get pathEraser => 'Esborrador de trajectes';

  @override
  String get label => 'Etiqueta';

  @override
  String get delete => 'Suprimeix';

  @override
  String get areYouSure => 'Estàs segur?';

  @override
  String get reallyDelete => 'Realment vols suprimir aquest element?';

  @override
  String get no => 'No';

  @override
  String get yes => 'Sí';

  @override
  String get undo => 'Desfer';

  @override
  String get redo => 'Tornar a fer';

  @override
  String get general => 'General';

  @override
  String get copyTitle => 'Copiat al porta-retalls';

  @override
  String get loading => 'Carregant...';

  @override
  String get enterText => 'Introdueix el text';

  @override
  String get size => 'Mida';

  @override
  String get width => 'Amplada';

  @override
  String get height => 'Alçada';

  @override
  String get count => 'Nombre';

  @override
  String get space => 'Espai';

  @override
  String get background => 'Fons';

  @override
  String get box => 'Quadre';

  @override
  String get locale => 'Configuració regional';

  @override
  String get systemLocale => 'Configuració regional del sistema';

  @override
  String get information => 'Informació';

  @override
  String get license => 'Llicència';

  @override
  String get imprint => 'Avís legal';

  @override
  String get privacypolicy => 'Política de privacitat';

  @override
  String get sourceCode => 'Codi font';

  @override
  String get documentation => 'Documentació';

  @override
  String get changelog => 'Registre de canvis';

  @override
  String get source => 'Font';

  @override
  String get existOverride => 'Aquest element ja existeix. Sobreescriure?';

  @override
  String get description => 'Descripció';

  @override
  String get fill => 'Omplir';

  @override
  String get defaultPalette => 'Paleta per defecte';

  @override
  String get highlighter => 'Marcador';

  @override
  String get add => 'Afegeix';

  @override
  String get remove => 'Elimina';

  @override
  String get removeConfirm => 'Realment vols eliminar això?';

  @override
  String get resetPalette => 'Reinicia paleta';

  @override
  String get custom => 'Personalitzat';

  @override
  String get decoration => 'Decoració';

  @override
  String get underline => 'Subratllat';

  @override
  String get overline => 'Sobrelineat';

  @override
  String get strikethrough => 'Ratllat';

  @override
  String get thickness => 'Gruix';

  @override
  String get style => 'Estil';

  @override
  String get solid => 'Sòlid';

  @override
  String get double => 'Doble';

  @override
  String get dotted => 'Puntejat';

  @override
  String get dashed => 'Guionet';

  @override
  String get wavy => 'Ondulat';

  @override
  String get fontWeight => 'Gruix de la font';

  @override
  String get normal => 'Normal';

  @override
  String get bold => 'Negreta';

  @override
  String get italic => 'Cursiva';

  @override
  String get clipboard => 'Porta-retalls';

  @override
  String get file => 'Fitxer';

  @override
  String get data => 'Dades';

  @override
  String get share => 'Comparteix';

  @override
  String get spacing => 'Espaiat';

  @override
  String get image => 'Imatge';

  @override
  String get enterUrl => 'Introdueix l\'URL';

  @override
  String get scale => 'Escala';

  @override
  String get help => 'Ajuda';

  @override
  String get reallyReset => 'Realment vols reiniciar-ho?';

  @override
  String get whatToDo => 'Què vols fer?';

  @override
  String get ignore => 'Ignora';

  @override
  String get backup => 'Còpia de seguretat';

  @override
  String createdInNewerVersion(String fileName, int fileVersion) {
    return 'El fitxer $fileName es va crear en una versió més nova ($fileVersion). Què cal fer amb aquest fitxer?';
  }

  @override
  String get waypoints => 'Punts de pas';

  @override
  String get origin => 'Origen';

  @override
  String get import => 'Importa';

  @override
  String get newContent => 'Nou';

  @override
  String get selectElement => 'Selecciona element';

  @override
  String get ctrlKey => 'Ctrl';

  @override
  String get shiftKey => 'Maj';

  @override
  String get altKey => 'Alt';

  @override
  String get copyVersion => 'Copia versió';

  @override
  String get input => 'Entrada';

  @override
  String get behaviors => 'Comportaments';

  @override
  String get dataDirectory => 'Directori de dades';

  @override
  String get defaultPath => 'Ruta per defecte';

  @override
  String get dateFormat => 'Format de data';

  @override
  String updatedAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'Actualitzat a: $dateTimeString';
  }

  @override
  String createdAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'Creat a: $dateTimeString';
  }

  @override
  String get rename => 'Canvia nom';

  @override
  String get duplicate => 'Duplica';

  @override
  String get hand => 'Mà';

  @override
  String get folder => 'Carpeta';

  @override
  String get move => 'Mou';

  @override
  String get copy => 'Copia';

  @override
  String get back => 'Enrere';

  @override
  String get zoomDependent => 'Depenent del zoom';

  @override
  String get shapeDetection => 'Detecció de formes';

  @override
  String get delay => 'Retard';

  @override
  String get defaultLayer => 'Capa per defecte';

  @override
  String get layer => 'Capa';

  @override
  String get layers => 'Capes';

  @override
  String get notSet => 'No establert';

  @override
  String get enterLayer => 'Introdueix el nom de la capa';

  @override
  String get selectElements => 'Selecciona elements';

  @override
  String get deleteElements => 'Suprimeix elements';

  @override
  String get deleteElementsConfirm =>
      'Realment vols suprimir els elements seleccionats?';

  @override
  String get selectCustomCollection =>
      'Selecciona una col·lecció personalitzada';

  @override
  String get svg => 'SVG';

  @override
  String get sensitivity => 'Sensibilitat';

  @override
  String get sensitivityHint =>
      'Com més alt el valor, més sensible serà l\'entrada';

  @override
  String get horizontal => 'Horitzontal';

  @override
  String get vertical => 'Vertical';

  @override
  String get plain => 'Pla';

  @override
  String get light => 'Clar';

  @override
  String get ruled => 'Ratllat';

  @override
  String get quad => 'Quadrícula';

  @override
  String get music => 'Música';

  @override
  String get dark => 'Fosc';

  @override
  String get plainDark => 'Pla fosc';

  @override
  String get ruledDark => 'Ratllat fosc';

  @override
  String get quadDark => 'Quadrícula fosca';

  @override
  String get musicDark => 'Música fosca';

  @override
  String get templates => 'Plantilles';

  @override
  String get untitled => 'Sense títol';

  @override
  String get createTemplate => 'Crea plantilla';

  @override
  String get createTemplateContent =>
      'Realment vols crear una plantilla d\'aquest document? El document original s\'eliminarà.';

  @override
  String get replace => 'Substitueix';

  @override
  String get reallyReplace =>
      'Realment vols substituir la plantilla? Aquesta operació no es pot desfer!';

  @override
  String get defaultTemplate => 'Plantilla per defecte';

  @override
  String get insert => 'Insereix';

  @override
  String get document => 'Document';

  @override
  String get camera => 'Càmera';

  @override
  String get printout => 'Impressió';

  @override
  String get selectCamera => 'Selecciona una càmera';

  @override
  String get changeDocumentPath => 'Canvia la ruta del document';

  @override
  String get deleteWholeStroke => 'Suprimeix tot el traç';

  @override
  String get alpha => 'Alfa';

  @override
  String get area => 'Àrea';

  @override
  String get selectArea => 'Selecciona l\'àrea';

  @override
  String get aspectRatio => 'Relació d\'aspecte';

  @override
  String get presets => 'Predefinits';

  @override
  String get pagePortrait => 'Pàgina vertical';

  @override
  String get pageLandscape => 'Pàgina horitzontal';

  @override
  String get square => 'Quadrat';

  @override
  String get areas => 'Àrees';

  @override
  String get enterArea => 'Introdueix l\'àrea';

  @override
  String get exitArea => 'Surt de l\'àrea';

  @override
  String get currentArea => 'Àrea actual';

  @override
  String get design => 'Disseny';

  @override
  String get text => 'Text';

  @override
  String welcome(String codeName) {
    return 'Hola, això és Linwood Butterfly $codeName';
  }

  @override
  String get welcomeContent => 'Un espai de dibuix lliure i de codi obert!';

  @override
  String updated(String version) {
    return 'Aplicació actualitzada a la versió $version';
  }

  @override
  String get releaseNotes => 'Notes de la versió';

  @override
  String get constraints => 'Restriccions';

  @override
  String get scaled => 'Escalat';

  @override
  String get fixed => 'Fix';

  @override
  String get dynamicContent => 'Dinàmic';

  @override
  String get none => 'Cap';

  @override
  String get includeArea => 'Inclou àrea';

  @override
  String get verticalAlignment => 'Alineació vertical';

  @override
  String get horizontalAlignment => 'Alineació horitzontal';

  @override
  String get top => 'Superior';

  @override
  String get center => 'Centre';

  @override
  String get bottom => 'Inferior';

  @override
  String get left => 'Esquerra';

  @override
  String get right => 'Dreta';

  @override
  String get justify => 'Justifica';

  @override
  String get constraint => 'Restricció';

  @override
  String get length => 'Longitud';

  @override
  String get exportSvg => 'Exporta SVG';

  @override
  String get pdf => 'PDF';

  @override
  String get selectPages => 'Selecciona pàgines';

  @override
  String get recentFiles => 'Fitxers recents';

  @override
  String get start => 'Inicia';

  @override
  String get noRecentFiles => 'Cap fitxer recent';

  @override
  String countPages(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pàgines',
      one: '1 pàgina',
      zero: 'Cap pàgina',
    );
    return '$_temp0';
  }

  @override
  String pageIndex(int index) {
    return 'Pàgina $index';
  }

  @override
  String get exit => 'Surt';

  @override
  String get noElements => 'Cap element';

  @override
  String get invertSelection => 'Inverteix selecció';

  @override
  String get errorWhileImporting => 'Error en importar';

  @override
  String get errorWhileImportingContent =>
      'Ha ocorregut un error en importar el fitxer';

  @override
  String get showDetails => 'Mostra detalls';

  @override
  String get hideDetails => 'Amaga detalls';

  @override
  String get error => 'Error';

  @override
  String get stackTrace => 'Traça de pila';

  @override
  String get laser => 'Làser';

  @override
  String get duration => 'Durada';

  @override
  String get quality => 'Qualitat';

  @override
  String get exportPdf => 'Exporta PDF';

  @override
  String get local => 'Local';

  @override
  String get addConnection => 'Afegeix connexió';

  @override
  String get connections => 'Connexions';

  @override
  String get noConnections => 'Cap connexió';

  @override
  String get url => 'URL';

  @override
  String get connect => 'Connecta';

  @override
  String get username => 'Nom d\'usuari';

  @override
  String get password => 'Contrasenya';

  @override
  String get webNotSupported => 'Web no compatible';

  @override
  String get advanced => 'Avançat';

  @override
  String get directory => 'Directori';

  @override
  String get documentsDirectory => 'Directori de documents';

  @override
  String get templatesDirectory => 'Directori de plantilles';

  @override
  String get errorWhileCreatingConnection => 'Error en crear connexió';

  @override
  String get cannotConnect => 'No es pot connectar';

  @override
  String get urlNotValid => 'URL no vàlida';

  @override
  String get icon => 'Icona';

  @override
  String get update => 'Actualitza';

  @override
  String get updateAvailable => 'Actualització disponible';

  @override
  String get stable => 'Estable';

  @override
  String get nightly => 'Nightly';

  @override
  String get checkForUpdates => 'Comprova actualitzacions';

  @override
  String get checkForUpdatesWarning =>
      'Fer una comprovació d\'actualitzacions se connectarà al lloc web de Butterfly per obtenir la informació.';

  @override
  String get usingLatestStable => 'Estàs utilitzant l\'última versió estable';

  @override
  String get usingLatestNightly => 'Estàs utilitzant l\'última versió nightly';

  @override
  String get currentVersion => 'Versió actual';

  @override
  String get updateNow => 'Actualitza ara';

  @override
  String get shape => 'Forma';

  @override
  String get circle => 'Cercle';

  @override
  String get rectangle => 'Rectangle';

  @override
  String get triangle => 'Triangle';

  @override
  String get line => 'Línia';

  @override
  String get cornerRadius => 'Radi de cantonada';

  @override
  String get topLeft => 'Superior esquerra';

  @override
  String get topRight => 'Superior dreta';

  @override
  String get bottomLeft => 'Inferior esquerra';

  @override
  String get bottomRight => 'Inferior dreta';

  @override
  String get caches => 'Cachés';

  @override
  String get manage => 'Gestiona';

  @override
  String get clearCaches => 'Neteja cachés';

  @override
  String get createCache => 'Crea caché';

  @override
  String get thirdPartyLicenses => 'Llicències de tercers';

  @override
  String get syncing => 'Sincronitzant...';

  @override
  String get synced => 'Sincronitzat';

  @override
  String get notSynced => 'No sincronitzat';

  @override
  String get conflict => 'Conflicte';

  @override
  String get keepLocal => 'Manté local';

  @override
  String get keepConnection => 'Manté connexió';

  @override
  String get keepBoth => 'Manté ambdós';

  @override
  String get forAll => 'Per a tots';

  @override
  String fileConflict(String file, String connection) {
    return '$file a $connection té un conflicte';
  }

  @override
  String get offline => 'Desconnectat';

  @override
  String get localLatest => 'Local més recent';

  @override
  String get connectionLatest => 'Connexió més recent';

  @override
  String get path => 'Ruta';

  @override
  String get folderSynced => 'Carpeta sincronitzada';

  @override
  String get syncRootDirectory => 'Directori arrel de sincronització';

  @override
  String get penOnlyInput => 'Entrada només bolígraf';

  @override
  String get inputGestures => 'Gestos d\'entrada';

  @override
  String get nativeTitleBar => 'Barra de títol nativa';

  @override
  String get syncMode => 'Mode de sincronització';

  @override
  String get connection => 'Connexió';

  @override
  String get always => 'Sempre';

  @override
  String get noMobile => 'Sense mòbil';

  @override
  String get manual => 'Manual';

  @override
  String get search => 'Cerca';

  @override
  String get properties => 'Propietats';

  @override
  String get pin => 'Fixar';

  @override
  String get unpin => 'Desfixar';

  @override
  String get element => 'Element';

  @override
  String get painter => 'Pintor';

  @override
  String get position => 'Posició';

  @override
  String get note => 'Nota';

  @override
  String get packs => 'Paquets';

  @override
  String get pack => 'Pack';

  @override
  String get more => 'Més';

  @override
  String get askForName => 'Demana nom';

  @override
  String areaIndex(int index) {
    return 'Àrea $index';
  }

  @override
  String get startInFullScreen => 'Inicia en pantalla completa';

  @override
  String get inputs => 'Entrades';

  @override
  String get mouse => 'Ratolí';

  @override
  String get touch => 'Tacte';

  @override
  String get keyboard => 'Teclat';

  @override
  String get shortcuts => 'Dreceres';

  @override
  String get middle => 'Mig';

  @override
  String get first => 'Primer';

  @override
  String get second => 'Segon';

  @override
  String get activeTool => 'Eina activa';

  @override
  String get activeToolDescription =>
      'Utilitza l\'eina seleccionada actualment a la barra d\'eines';

  @override
  String get handTool => 'Eina de mà';

  @override
  String get handToolDescription => 'Arrossega per desplaçar el llenç';

  @override
  String get toolOnToolbar => 'Eina específica a la barra d\'eines';

  @override
  String get toolOnToolbarDescription =>
      'Utilitza l\'eina en la posició especificada a la barra d\'eines, començant per l\'esquerra';

  @override
  String toolOnToolbarShort(int display_position) {
    return 'Posició a la barra: $display_position';
  }

  @override
  String get tools => 'Eines';

  @override
  String get showGrid => 'Mostra quadrícula';

  @override
  String get grid => 'Quadrícula';

  @override
  String get ruler => 'Regle';

  @override
  String get angle => 'Angle';

  @override
  String get report => 'Informe';

  @override
  String get newFolder => 'Nova carpeta';

  @override
  String get createPack => 'Crea pack';

  @override
  String get editPack => 'Edita pack';

  @override
  String get packsDirectory => 'Directori de packs';

  @override
  String get stamp => 'Segell';

  @override
  String get addToPack => 'Afegeix al pack';

  @override
  String get sureImportPack => 'Segur que vols importar el pack?';

  @override
  String byAuthor(String author) {
    return 'per $author';
  }

  @override
  String get author => 'Autor';

  @override
  String get addAsset => 'Afegeix recurs';

  @override
  String get editAsset => 'Edita recurs';

  @override
  String get scope => 'Àmbit';

  @override
  String get noPacks => 'Actualment no hi ha packs disponibles';

  @override
  String get components => 'Components';

  @override
  String get waypoint => 'Punt de pas';

  @override
  String get actions => 'Accions';

  @override
  String get painters => 'Pintors';

  @override
  String get breakingChangesTitle => 'Canvis incompatibles';

  @override
  String breakingChangesMessage(int version, int newVersion) {
    return 'Hi ha canvis incompatibles en aquesta versió. Llegeix el registre de canvis abans d\'actualitzar. La versió actual del fitxer és $version, la nova versió és $newVersion.';
  }

  @override
  String get styles => 'Estils';

  @override
  String get paragraph => 'Pàrraf';

  @override
  String get fontFamily => 'Tipus de lletra';

  @override
  String get smoothing => 'Suavització';

  @override
  String get streamline => 'Suavitzat';

  @override
  String get presentation => 'Presentació';

  @override
  String get selectAsset => 'Selecciona recurs';

  @override
  String get clearStyle => 'Esborra estil';

  @override
  String get unknownImportType => 'Tipus d\'importació desconegut';

  @override
  String get sureImportTemplate => 'Segur que vols importar la plantilla?';

  @override
  String get frame => 'Marc';

  @override
  String get play => 'Reprodueix';

  @override
  String get video => 'Vídeo';

  @override
  String get fps => 'FPS';

  @override
  String get breakpoint => 'Punt de ruptura';

  @override
  String get presentationControls => 'Controls de presentació';

  @override
  String get nextSlide => 'Següent diapositiva';

  @override
  String get nextSlideDescription =>
      'Fes lliscar a la dreta o prem la fletxa dreta per anar a la diapositiva següent';

  @override
  String get previousSlide => 'Diapositiva anterior';

  @override
  String get previousSlideDescription =>
      'Fes lliscar a l\'esquerra o prem la fletxa esquerra per anar a la diapositiva anterior';

  @override
  String get exitPresentation => 'Sortir de la presentació';

  @override
  String get exitPresentationDescription =>
      'Prem Esc o fes lliscar cap avall per sortir de la presentació';

  @override
  String get pausePresentation => 'Pausa presentació';

  @override
  String get pausePresentationDescription =>
      'Toca la pantalla o prem la barra espaiadora per pausar o reprendre la presentació';

  @override
  String get keyframe => 'Fotograma clau';

  @override
  String get endOfPresentation => 'Has arribat al final de la presentació';

  @override
  String get startOfPresentation => 'Has arribat al principi de la presentació';

  @override
  String get palettes => 'Paletes';

  @override
  String headline(int index) {
    return 'Títol $index';
  }

  @override
  String get code => 'Codi';

  @override
  String get quote => 'Cita';

  @override
  String get link => 'Enllaç';

  @override
  String get checkbox => 'Casella de selecció';

  @override
  String get deleted => 'Eliminat';

  @override
  String get emphasis => 'Èmfasi';

  @override
  String get listBullet => 'Llista amb vinyetes';

  @override
  String get strong => 'Fort';

  @override
  String get markdown => 'Markdown';

  @override
  String get home => 'Inici';

  @override
  String get files => 'Fitxers';

  @override
  String get sortBy => 'Ordena per';

  @override
  String get location => 'Ubicació';

  @override
  String get whatsNew => 'Què hi ha de nou?';

  @override
  String get unstar => 'Elimina estrella';

  @override
  String get star => 'Marca amb estrella';

  @override
  String get goUp => 'Puja';

  @override
  String get created => 'Creat';

  @override
  String get modified => 'Modificat';

  @override
  String get quickstart => 'Inici ràpid';

  @override
  String get noTemplates => 'Actualment no hi ha plantilles disponibles';

  @override
  String get importCorePack => 'Importa pack principal';

  @override
  String get importCorePackDescription =>
      'Importa el pack principal que conté tots els recursos bàsics per començar. Això sobreescriurà el pack principal actual.';

  @override
  String get never => 'Mai';

  @override
  String get onlyOnUpdates => 'Només en actualitzacions';

  @override
  String get visibility => 'Visibilitat';

  @override
  String get captureThumbnail => 'Captura la miniatura';

  @override
  String get capturedThumbnail => 'Miniatura capturada correctament';

  @override
  String get chooseLabelMode => 'Tria mode d\'etiqueta';

  @override
  String get foreground => 'Primer pla';

  @override
  String get version => 'Versió';

  @override
  String get repository => 'Repositori';

  @override
  String get pages => 'Pàgines';

  @override
  String get navigator => 'Navegador';

  @override
  String get arrange => 'Organitza';

  @override
  String get bringToFront => 'Porta al davant';

  @override
  String get sendToBack => 'Envia enrere';

  @override
  String get bringForward => 'Porta endavant';

  @override
  String get sendBackward => 'Envia enrere';

  @override
  String get rotation => 'Rotació';

  @override
  String get onlyAvailableLargerScreen => 'Només disponible en pantalles grans';

  @override
  String get toolbarPosition => 'Posició de la barra d\'eines';

  @override
  String get rotate => 'Rota';

  @override
  String get spacer => 'Separador';

  @override
  String get navigationRail => 'Rail de navegació';

  @override
  String get cut => 'Talla';

  @override
  String get insertBefore => 'Insereix abans';

  @override
  String get insertAfter => 'Insereix després';

  @override
  String get insertFirst => 'Insereix primer';

  @override
  String get insertLast => 'Insereix últim';

  @override
  String get paste => 'Enganxa';

  @override
  String get ascending => 'Ascendent';

  @override
  String get descending => 'Descendent';

  @override
  String get imageScale => 'Escala d\'imatge';

  @override
  String get select => 'Selecciona';

  @override
  String get tool => 'Eina';

  @override
  String get texture => 'Textura';

  @override
  String get platformTheme => 'Tema de plataforma';

  @override
  String get desktop => 'Escriptori';

  @override
  String get mobile => 'Mòbil';

  @override
  String get pdfQuality => 'Qualitat PDF';

  @override
  String get surface => 'Superfície';

  @override
  String get pattern => 'Patró';

  @override
  String get sureClose => 'Segur que vols tancar el document?';

  @override
  String get thereAreUnsavedChanges => 'Hi ha canvis sense desar';

  @override
  String get page => 'Pàgina';

  @override
  String get iceServers => 'Servidors ICE';

  @override
  String get collaboration => 'Col·laboració';

  @override
  String get webRtc => 'Web RTC';

  @override
  String get webSocket => 'Web Socket';

  @override
  String get iceServer => 'Servidor ICE';

  @override
  String get port => 'Port';

  @override
  String get type => 'Tipus';

  @override
  String get side => 'Costat';

  @override
  String get client => 'Client';

  @override
  String get server => 'Servidor';

  @override
  String get switchView => 'Canvia vista';

  @override
  String get lasso => 'Llaç';

  @override
  String get hideUI => 'Amaga la interfície';

  @override
  String get density => 'Densitat';

  @override
  String get compact => 'Compacte';

  @override
  String get comfortable => 'Còmode';

  @override
  String get standard => 'Estàndard';

  @override
  String get lock => 'Bloqueja';

  @override
  String get addElement => 'Afegeix element';

  @override
  String get notDefaultConnection => 'Connexió no per defecte';

  @override
  String get defaultConnection => 'Connexió per defecte';

  @override
  String get hide => 'Amaga';

  @override
  String get show => 'Mostra';

  @override
  String get pause => 'Pausa';

  @override
  String get stop => 'Atura';

  @override
  String get refresh => 'Actualitza';

  @override
  String get print => 'Imprimeix';

  @override
  String get dav => 'DAV';

  @override
  String get eyeDropper => 'Pipeta';

  @override
  String get users => 'Usuaris';

  @override
  String get experiments => 'Experiments';

  @override
  String get experimentsWarning =>
      'Aquestes funcions són experimentals i poden canviar, trencar-se o desaparèixer en qualsevol moment. Activar-les pot causar inestabilitat o pèrdua de dades. Procedeix amb precaució. Si us plau, informa de qualsevol error.';

  @override
  String get address => 'Adreça';

  @override
  String get spreadToPages => 'Estén a pàgines';

  @override
  String get rootDirectorySpecifiedDescription =>
      'S\'ha especificat el directori arrel. Totes les rutes de directori avançades seran relatives a aquest directori. Deixa-ho buit per desactivar aquest tipus de directori.';

  @override
  String get rootDirectoryNotSpecifiedDescription =>
      'No s\'ha especificat el directori arrel. Es requereix un nom. Totes les rutes de directori avançades seran absolutes. Deixa-ho buit per desactivar aquest tipus de directori.';

  @override
  String get unsecureConnectionTitle => 'Connexió insegura';

  @override
  String unsecureConnectionMessage(String fingerprint) {
    return 'La connexió no és segura. Això pot ser un risc de seguretat. Si us plau, només continua si confies en la connexió. La empremta sha1 és $fingerprint.';
  }

  @override
  String get continueAnyway => 'Continua igualment';

  @override
  String get zoomControl => 'Control de zoom';

  @override
  String get highContrast => 'Alt contrast';

  @override
  String get shouldANumber => 'Aquest valor ha de ser un nombre vàlid';

  @override
  String get createAreas => 'Crea àrees';

  @override
  String get autosave => 'Desament automàtic';

  @override
  String get invert => 'Inverteix';

  @override
  String get operations => 'Operacions';

  @override
  String get medium => 'Mitjà';

  @override
  String get large => 'Gran';

  @override
  String get toolbarSize => 'Mida de la barra d\'eines';

  @override
  String get addAll => 'Afegeix-ho tot';

  @override
  String get onlyCurrentPage => 'Només pàgina actual';

  @override
  String get smoothNavigation => 'Navegació fluida';

  @override
  String get exact => 'Exacte';

  @override
  String get inline => 'En línia';

  @override
  String get toolbarRows => 'Files de barra d\'eines';

  @override
  String get pointerTest => 'Prova de punter';

  @override
  String get pressure => 'Pressió';

  @override
  String get small => 'Petit';

  @override
  String get tiny => 'Minúscul';

  @override
  String get selectAll => 'Selecciona-ho tot';

  @override
  String get overrideTools => 'Sobreescriu eines';

  @override
  String get hideCursorWhileDrawing => 'Amaga el cursor mentre dibuixes';

  @override
  String get installed => 'Instal·lat';

  @override
  String get install => 'Instal·la';

  @override
  String get deselect => 'Deselecciona';

  @override
  String get changeCollection => 'Canvia col·lecció';

  @override
  String get collections => 'Col·leccions';

  @override
  String get fullSelection => 'Selecció completa';

  @override
  String get fullSelectionDescription =>
      'Requereix que els elements estiguin totalment dins del quadre de selecció per seleccionar-los.';

  @override
  String get collection => 'Col·lecció';

  @override
  String get defaultCollection => 'Col·lecció per defecte';

  @override
  String get scroll => 'Desplaça';

  @override
  String get onStartup => 'A l\'inici';

  @override
  String get homeScreen => 'Pantalla d\'inici';

  @override
  String get lastNote => 'Darrera nota';

  @override
  String get newNote => 'Nova nota';

  @override
  String get convertToLayer => 'Converteix a capa';

  @override
  String get merge => 'Fusiona';

  @override
  String get up => 'Amunt';

  @override
  String get down => 'Avall';

  @override
  String get other => 'Altres';

  @override
  String countElements(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count elements',
      one: '1 element',
      zero: 'Cap element',
    );
    return '$_temp0';
  }

  @override
  String get colorToolbar => 'Barra de color';

  @override
  String get yesButShowButtons => 'Sí, però mostra els botons';

  @override
  String get optionsPanelPosition => 'Posició del panell d\'opcions';

  @override
  String get hideDuration => 'Durada d\'ocultació';

  @override
  String get animation => 'Animació';

  @override
  String get performance => 'Rendiment';

  @override
  String get performanceDescription =>
      'Optimitzat per a velocitat i ús de memòria. Només la porció visible de la nota s\'integra a la imatge.';

  @override
  String get normalDescription =>
      'Equilibra qualitat i rendiment. Integra una imatge que cobreix 1,5 vegades l\'àrea visible, proporcionant transicions més suaus en desplaçar-se.';

  @override
  String get high => 'Alt';

  @override
  String get highDescription =>
      'Maximizes quality at the cost of performance. Bakes an image covering 2 times the visible area, ensuring seamless rendering even during rapid scrolling or zooming.';

  @override
  String get renderResolution => 'Resolució de renderitzat';

  @override
  String get translate => 'Tradueix';

  @override
  String get unencrypted => 'Sense xifrar';

  @override
  String get encrypted => 'Xifrat';

  @override
  String get encryptDocumentMessage => 'Fes clic per xifrar el document';

  @override
  String get unencryptDocumentMessage => 'Fes clic per desxifrar el document';

  @override
  String get unencrypt => 'Desxifra';

  @override
  String get encrypt => 'Xifra';

  @override
  String get encryptWarning =>
      'Això xifrarà el document. Hauràs de recordar la contrasenya per desxifrar-lo.';

  @override
  String get unencryptWarning =>
      'Això desxifrarà el document. La contrasenya s\'eliminarà i tothom amb accés podrà obrir-lo.';

  @override
  String get confirmPassword => 'Confirma la contrasenya';

  @override
  String get passwordMismatch => 'Les contrasenyes no coincideixen';

  @override
  String get action => 'Acció';

  @override
  String get svgText => 'Text SVG';

  @override
  String get offset => 'Desplaçament';

  @override
  String get positionDependent => 'Depend de la posició';

  @override
  String get flipHorizontal => 'Gira horitzontalment';

  @override
  String get flipVertical => 'Gira verticalment';

  @override
  String get grayscale => 'Escala de grisos';

  @override
  String get moveOnGesture => 'Mou amb gest';

  @override
  String get exportAllFiles => 'Exporta tots els fitxers';

  @override
  String get restoreSettingsFromFile => 'Restaura configuració des de fitxer';

  @override
  String get exportSettingsToFile => 'Exporta configuració a fitxer';

  @override
  String get barcode => 'Codi de barres';

  @override
  String get barcodeType => 'Tipus de codi de barres';

  @override
  String get qrCode => 'Codi QR';

  @override
  String get dataMatrix => 'Data Matrix';

  @override
  String get code128 => 'Code 128';

  @override
  String defaultUserName(int index) {
    return 'Usuari $index';
  }

  @override
  String get moveLeft => 'Mou a l\'esquerra';

  @override
  String get moveRight => 'Mou a la dreta';

  @override
  String get bundledPacks => 'Packs inclosos';

  @override
  String get component => 'Component';

  @override
  String get selectComponent => 'Selecciona component';

  @override
  String get bundlePackInDocument => 'Inclou pack en el document';

  @override
  String get bundledPacksDescription =>
      'Els packs inclosos estan en el document i només es poden utilitzar per compartir amb el document. Els recursos només es poden usar si el pack està instal·lat. Es poden instal·lar fent clic sobre ells.';

  @override
  String get fillAlpha => 'Alfa de farciment';

  @override
  String get packagedFile => 'Fitxer empaquetat';

  @override
  String get rawFile => 'Fitxer brut';

  @override
  String get webSocketDescription =>
      'El teu dispositiu allotja el servidor, així que els col·laboradors només poden unir-se per la mateixa xarxa o des de qualsevol lloc si reenvies el port al teu router.';

  @override
  String get swampDescription =>
      'Els teus missatges es redirigeixen a través d\'un servidor de relé segur amb xifrat de punta a punta. Es requereix una adreça de servidor swamp per crear una sessió.';

  @override
  String get createRawNote => 'Crea nota bruta';

  @override
  String get polygon => 'Polígon';

  @override
  String get finishShape => 'Acaba la forma';

  @override
  String get submit => 'Envia';

  @override
  String get math => 'Math';

  @override
  String get ignorePressure => 'Ignore pressure';

  @override
  String get ignoreFirstPressureDescription =>
      'On some devices, the first pressure value is not accurate. This setting will ignore the first pressure value and use the pressure of the second event instead.';

  @override
  String get temporary => 'Temporary';

  @override
  String get simpleToolbarVisibility => 'Simple toolbar visibility';

  @override
  String get autosaveDelay => 'Autosave delay';

  @override
  String get saved => 'Saved';

  @override
  String get saving => 'Saving...';

  @override
  String get readOnly => 'Read only';

  @override
  String get saveDelayed => 'Save delayed';

  @override
  String get unsaved => 'Unsaved';

  @override
  String get pdfEmptyDescription =>
      'There are currently no areas to export. Please select at least one area using the plus button in the top right corner or add all areas from the current page or from the whole document below.';
}
