// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Arabic (`ar`).
class AppLocalizationsAr extends AppLocalizations {
  AppLocalizationsAr([String locale = 'ar']) : super(locale);

  @override
  String get open => 'فتح';

  @override
  String get settings => 'الإعدادات';

  @override
  String get personalization => 'التخصيص';

  @override
  String get theme => 'السمة';

  @override
  String get darkTheme => 'السمة المظلمة';

  @override
  String get lightTheme => 'موضوع فاتح';

  @override
  String get systemTheme => 'استخدام سمة النظام الافتراضية';

  @override
  String get view => 'عرض';

  @override
  String get edit => 'تحرير';

  @override
  String get export => 'تصدير';

  @override
  String get save => 'حفظ';

  @override
  String get zoom => 'تكبير';

  @override
  String get zoomIn => 'تكبير في';

  @override
  String get zoomOut => 'تكبير خارجي';

  @override
  String get resetZoom => 'Reset zoom';

  @override
  String get strokeWidth => 'عرض جرة القلم';

  @override
  String get includeEraser => 'تضمين الممحاة؟';

  @override
  String get thinning => 'تفكير';

  @override
  String get pen => 'القلم';

  @override
  String get invertedPen => 'القلم المقلوب';

  @override
  String get eraser => 'Eraser';

  @override
  String get pathEraser => 'ممحاة المسار';

  @override
  String get label => 'تسمية';

  @override
  String get delete => 'حذف';

  @override
  String get areYouSure => 'هل أنت متأكد؟';

  @override
  String get reallyDelete => 'هل تريد حقاً حذف هذا العنصر؟';

  @override
  String get no => 'لا';

  @override
  String get yes => 'نعم';

  @override
  String get undo => 'التراجع';

  @override
  String get redo => 'إعادة';

  @override
  String get general => 'عام';

  @override
  String get copyTitle => 'نسخ إلى الحافظة';

  @override
  String get loading => 'تحميل...';

  @override
  String get enterText => 'أدخل النص';

  @override
  String get size => 'الحجم';

  @override
  String get width => 'Width';

  @override
  String get height => 'الارتفاع';

  @override
  String get count => 'العد';

  @override
  String get space => 'المساحة';

  @override
  String get background => 'الخلفية';

  @override
  String get box => 'صندوق';

  @override
  String get locale => 'المكان';

  @override
  String get systemLocale => 'محلي النظام';

  @override
  String get information => 'معلومات';

  @override
  String get license => 'الترخيص';

  @override
  String get imprint => 'بصمة';

  @override
  String get privacypolicy => 'سياسة الخصوصية';

  @override
  String get sourceCode => 'الكود المصدري';

  @override
  String get documentation => 'إرشادات الإستخدام';

  @override
  String get changelog => 'تغيير';

  @override
  String get source => 'المصدر';

  @override
  String get existOverride => 'هذا العنصر موجود بالفعل. استبدال؟';

  @override
  String get description => 'الوصف';

  @override
  String get fill => 'تعبئة';

  @override
  String get defaultPalette => 'اللوحة الافتراضية';

  @override
  String get highlighter => 'ابرز';

  @override
  String get add => 'إضافة';

  @override
  String get remove => 'إزالة';

  @override
  String get removeConfirm => 'هل تريد حقاً إزالة هذا؟';

  @override
  String get resetPalette => 'Reset palette';

  @override
  String get custom => 'مخصص';

  @override
  String get decoration => 'زخرفة';

  @override
  String get underline => 'أسفل';

  @override
  String get overline => 'اسطوانة';

  @override
  String get strikethrough => 'ضربة';

  @override
  String get thickness => 'السمك';

  @override
  String get style => 'النمط';

  @override
  String get solid => 'Solid';

  @override
  String get double => 'مزدوج';

  @override
  String get dotted => 'مقطوعة';

  @override
  String get dashed => 'متقلب';

  @override
  String get wavy => 'موسيقى';

  @override
  String get fontWeight => 'وزن الخط';

  @override
  String get normal => 'عادي';

  @override
  String get bold => 'Bold';

  @override
  String get italic => 'Italic';

  @override
  String get clipboard => 'الحافظة';

  @override
  String get file => 'ملف';

  @override
  String get data => 'البيانات';

  @override
  String get share => 'مشاركة';

  @override
  String get spacing => 'تباعد';

  @override
  String get image => 'صورة';

  @override
  String get enterUrl => 'أدخل عنوان URL';

  @override
  String get scale => 'المقياس';

  @override
  String get help => 'مساعدة';

  @override
  String get reallyReset => 'هل تريد حقاً إعادة تعيينه؟';

  @override
  String get whatToDo => 'ماذا تريد أن تفعل؟';

  @override
  String get ignore => 'تجاهل';

  @override
  String get backup => 'النسخ الاحتياطي';

  @override
  String createdInNewerVersion(String fileName, int fileVersion) {
    return 'تم إنشاء الملف $fileName في إصدار أحدث ($fileVersion). ماذا يجب أن يتم مع هذا الملف؟';
  }

  @override
  String get waypoints => 'إحداثيات';

  @override
  String get origin => 'الأصل';

  @override
  String get import => 'استيراد';

  @override
  String get newContent => 'جديد';

  @override
  String get selectElement => 'حدد العنصر';

  @override
  String get ctrlKey => 'Ctrl';

  @override
  String get shiftKey => 'تبديل';

  @override
  String get altKey => 'Alt';

  @override
  String get copyVersion => 'نسخ الإصدار';

  @override
  String get input => 'الإدخال';

  @override
  String get behaviors => 'السلوكيات';

  @override
  String get dataDirectory => 'دليل البيانات';

  @override
  String get defaultPath => 'المسار الافتراضي';

  @override
  String get dateFormat => 'تنسيق التاريخ';

  @override
  String updatedAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'تم التحديث في: $dateTimeString';
  }

  @override
  String createdAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'أنشئ في: $dateTimeString';
  }

  @override
  String get rename => 'إعادة تسمية';

  @override
  String get duplicate => 'استنساخ';

  @override
  String get hand => 'اليد';

  @override
  String get folder => 'مجلد';

  @override
  String get move => 'نقل';

  @override
  String get copy => 'نسخ';

  @override
  String get back => 'الرجوع';

  @override
  String get zoomDependent => 'تكبير الاعتماد';

  @override
  String get shapeDetection => 'كشف الشكل';

  @override
  String get delay => 'التأخير';

  @override
  String get defaultLayer => 'الطبقة الافتراضية';

  @override
  String get layer => 'الطبقة';

  @override
  String get layers => 'الطبقات';

  @override
  String get notSet => 'لم يتم تعيينه';

  @override
  String get enterLayer => 'أدخل اسم الطبقة';

  @override
  String get selectElements => 'حدد العناصر';

  @override
  String get deleteElements => 'حذف العناصر';

  @override
  String get deleteElementsConfirm => 'هل تريد حقاً حذف العناصر المحددة؟';

  @override
  String get selectCustomCollection => 'حدد مجموعة مخصصة';

  @override
  String get svg => 'SVG';

  @override
  String get sensitivity => 'الحساسية';

  @override
  String get sensitivityHint =>
      'كلما ارتفعت القيمة، كلما كان الإدخال أكثر حساسية';

  @override
  String get horizontal => 'أفقي';

  @override
  String get vertical => 'عمودي';

  @override
  String get plain => 'عادي';

  @override
  String get light => 'فاتح';

  @override
  String get ruled => 'حكم';

  @override
  String get quad => 'رباعي';

  @override
  String get music => 'الموسيقى';

  @override
  String get dark => 'داكن';

  @override
  String get plainDark => 'داكن';

  @override
  String get ruledDark => 'مخطط داكن';

  @override
  String get quadDark => 'مظلمة';

  @override
  String get musicDark => 'موسيقى مظلمة';

  @override
  String get templates => 'قوالب';

  @override
  String get untitled => 'بدون عنوان';

  @override
  String get createTemplate => 'إنشاء قالب';

  @override
  String get createTemplateContent =>
      'هل تريد حقاً إنشاء قالب من هذه الوثيقة؟ سيتم حذف المستند الأصلي.';

  @override
  String get replace => 'استبدل';

  @override
  String get reallyReplace =>
      'هل تريد حقاً استبدال القالب؟ هذه العملية لا يمكن التراجع عنها!';

  @override
  String get defaultTemplate => 'القالب الافتراضي';

  @override
  String get insert => 'Insert';

  @override
  String get document => 'مستند';

  @override
  String get camera => 'الكاميرا';

  @override
  String get printout => 'طباعة';

  @override
  String get selectCamera => 'اختر كاميرا';

  @override
  String get changeDocumentPath => 'تغيير مسار المستند';

  @override
  String get deleteWholeStroke => 'حذف الخط بأكمله';

  @override
  String get alpha => 'ألفا';

  @override
  String get area => 'المنطقة';

  @override
  String get selectArea => 'حدد منطقة';

  @override
  String get aspectRatio => 'نسبة الجوانب';

  @override
  String get presets => 'الإعدادات المسبقة';

  @override
  String get pagePortrait => 'صورة للصفحة';

  @override
  String get pageLandscape => 'صفحة أفقيه';

  @override
  String get square => 'مربع';

  @override
  String get areas => 'المناطق';

  @override
  String get enterArea => 'أدخل المنطقة';

  @override
  String get exitArea => 'الخروج من المنطقة';

  @override
  String get currentArea => 'المجال الحالي';

  @override
  String get design => 'تصميم';

  @override
  String get text => 'نص';

  @override
  String welcome(String codeName) {
    return 'مرحبا، هذه فراشة لينوود $codeName';
  }

  @override
  String get welcomeContent => 'مساحة رسم مجانية ومفتوحة المصدر!';

  @override
  String updated(String version) {
    return 'تم تحديث التطبيق إلى الإصدار $version';
  }

  @override
  String get releaseNotes => 'ملاحظات الإصدار';

  @override
  String get constraints => 'القيود';

  @override
  String get scaled => 'محسوب';

  @override
  String get fixed => 'ثابت';

  @override
  String get dynamicContent => 'ديناميكية';

  @override
  String get none => 'لا';

  @override
  String get includeArea => 'تضمين المنطقة';

  @override
  String get verticalAlignment => 'محاذاة عمودية';

  @override
  String get horizontalAlignment => 'محاذاة أفقية';

  @override
  String get top => 'أعلى';

  @override
  String get center => 'الوسط';

  @override
  String get bottom => 'أسفل';

  @override
  String get left => 'اليسار';

  @override
  String get right => 'يمين';

  @override
  String get justify => 'تبديل';

  @override
  String get constraint => 'التقييد';

  @override
  String get length => 'طول';

  @override
  String get exportSvg => 'تصدير SVG';

  @override
  String get pdf => 'PDF';

  @override
  String get selectPages => 'حدد صفحات';

  @override
  String get recentFiles => 'الملفات الأخيرة';

  @override
  String get start => 'ابدأ';

  @override
  String get noRecentFiles => 'لا توجد ملفات حديثة';

  @override
  String countPages(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count صفحات',
      one: 'صفحة 1',
      zero: 'لا توجد صفحات',
    );
    return '$_temp0';
  }

  @override
  String pageIndex(int index) {
    return 'الصفحة $index';
  }

  @override
  String get exit => 'الخروج';

  @override
  String get noElements => 'لا توجد عناصر';

  @override
  String get invertSelection => 'عكس التحديد';

  @override
  String get errorWhileImporting => 'حدث خطأ أثناء الاستيراد';

  @override
  String get errorWhileImportingContent => 'حدث خطأ أثناء استيراد الملف';

  @override
  String get showDetails => 'إظهار التفاصيل';

  @override
  String get hideDetails => 'إخفاء التفاصيل';

  @override
  String get error => 'خطأ';

  @override
  String get stackTrace => 'أثر المكدس';

  @override
  String get laser => 'ليزر';

  @override
  String get duration => 'المدة';

  @override
  String get quality => 'الجودة';

  @override
  String get exportPdf => 'تصدير PDF';

  @override
  String get local => 'محلي';

  @override
  String get addConnection => 'إضافة اتصال';

  @override
  String get connections => 'اتصالات';

  @override
  String get noConnections => 'لا توجد اتصالات';

  @override
  String get url => 'الرابط';

  @override
  String get connect => 'الاتصال';

  @override
  String get username => 'اسم المستخدم';

  @override
  String get password => 'كلمة المرور';

  @override
  String get webNotSupported => 'الويب غير مدعوم';

  @override
  String get advanced => 'متقدم';

  @override
  String get directory => 'دليل';

  @override
  String get documentsDirectory => 'دليل المستندات';

  @override
  String get templatesDirectory => 'دليل القوالب';

  @override
  String get errorWhileCreatingConnection => 'حدث خطأ أثناء إنشاء الاتصال';

  @override
  String get cannotConnect => 'لا يمكن الاتصال';

  @override
  String get urlNotValid => 'عنوان URL غير صالح';

  @override
  String get icon => 'أيقونة';

  @override
  String get update => 'تحديث';

  @override
  String get updateAvailable => 'التحديث متاح';

  @override
  String get stable => 'اسطبل';

  @override
  String get nightly => 'ليلي';

  @override
  String get checkForUpdates => 'التحقق من وجود تحديثات';

  @override
  String get checkForUpdatesWarning =>
      'سيؤدي إجراء التحقق من التحديثات إلى الاتصال بموقع الفراشة للحصول على المعلومات.';

  @override
  String get usingLatestStable => 'أنت تستخدم أحدث إصدار مستقر';

  @override
  String get usingLatestNightly => 'أنت تستخدم أحدث إصدار ليلي';

  @override
  String get currentVersion => 'الإصدار الحالي';

  @override
  String get updateNow => 'التحديث الآن';

  @override
  String get shape => 'شكل';

  @override
  String get circle => 'دائرة';

  @override
  String get rectangle => 'مستطيل';

  @override
  String get triangle => 'مثلث';

  @override
  String get line => 'سطر';

  @override
  String get cornerRadius => 'Corner radius';

  @override
  String get topLeft => 'أعلى اليسار';

  @override
  String get topRight => 'أعلى اليمين';

  @override
  String get bottomLeft => 'أسفل اليسار';

  @override
  String get bottomRight => 'أسفل اليمين';

  @override
  String get caches => 'المخبآت';

  @override
  String get manage => 'إدارة';

  @override
  String get clearCaches => 'مسح المخبآت';

  @override
  String get createCache => 'إنشاء ذاكرة التخزين المؤقت';

  @override
  String get thirdPartyLicenses => 'تراخيص الطرف الثالث';

  @override
  String get syncing => 'مزامنة...';

  @override
  String get synced => 'مزامنة';

  @override
  String get notSynced => 'غير مزامنة';

  @override
  String get conflict => 'تضارب';

  @override
  String get keepLocal => 'الحفاظ على محلي';

  @override
  String get keepConnection => 'الحفاظ على الاتصال';

  @override
  String get keepBoth => 'الحفاظ على كليهما';

  @override
  String get forAll => 'للجميع';

  @override
  String fileConflict(String file, String connection) {
    return '$file في $connection لديه تعارض';
  }

  @override
  String get offline => 'غير متصل';

  @override
  String get localLatest => 'الأحدث المحلي';

  @override
  String get connectionLatest => 'أحدث اتصال';

  @override
  String get path => 'المسار';

  @override
  String get folderSynced => 'تمت مزامنة المجلد';

  @override
  String get syncRootDirectory => 'مزامنة دليل الجذر';

  @override
  String get penOnlyInput => 'القلم الإدخال فقط';

  @override
  String get inputGestures => 'Input gestures';

  @override
  String get nativeTitleBar => 'استخدم شريط عنوان النظام';

  @override
  String get syncMode => 'وضع المزامنة';

  @override
  String get connection => 'اتصال';

  @override
  String get always => 'دائما';

  @override
  String get noMobile => 'لا يوجد هاتف';

  @override
  String get manual => 'دليل';

  @override
  String get search => 'البحث';

  @override
  String get properties => 'الخصائص';

  @override
  String get pin => 'تثبيت';

  @override
  String get unpin => 'Unpin';

  @override
  String get element => 'العنصر';

  @override
  String get painter => 'ألوان';

  @override
  String get position => 'الموضع';

  @override
  String get note => 'ملاحظة';

  @override
  String get packs => 'حزم';

  @override
  String get pack => 'باقة';

  @override
  String get more => 'المزيد';

  @override
  String get askForName => 'اسأل عن الاسم';

  @override
  String areaIndex(int index) {
    return 'المنطقة $index';
  }

  @override
  String get startInFullScreen => 'البدء في ملء الشاشة';

  @override
  String get inputs => 'Inputs';

  @override
  String get mouse => 'الفأرة';

  @override
  String get touch => 'المس';

  @override
  String get keyboard => 'Keyboard';

  @override
  String get shortcuts => 'الاختصارات';

  @override
  String get middle => 'وسط';

  @override
  String get first => 'الأول';

  @override
  String get second => 'الثاني';

  @override
  String get activeTool => 'أداة نشطة';

  @override
  String get activeToolDescription =>
      'استخدام الأداة المحددة حاليًا على شريط الأدوات';

  @override
  String get handTool => 'أداة اليد';

  @override
  String get handToolDescription => 'اسحب للتحرك حول اللوحه';

  @override
  String get toolOnToolbar => 'أداة محددة على شريط الأدوات';

  @override
  String get toolOnToolbarDescription =>
      'استخدام الأداة في الموضع المحدد على شريط الأدوات، بدءاً من اليسار';

  @override
  String toolOnToolbarShort(int display_position) {
    return 'موضع شريط الأدوات: $display_position';
  }

  @override
  String get tools => 'أدوات';

  @override
  String get showGrid => 'إظهار الشبكة';

  @override
  String get grid => 'الشبكة';

  @override
  String get ruler => 'حاكم';

  @override
  String get angle => 'زاوية';

  @override
  String get report => 'تقرير';

  @override
  String get newFolder => 'مجلد جديد';

  @override
  String get createPack => 'إنشاء حزمة';

  @override
  String get editPack => 'تحرير الحزمة';

  @override
  String get packsDirectory => 'دليل الحزم';

  @override
  String get stamp => 'وسام';

  @override
  String get addToPack => 'إضافة إلى الحزمة';

  @override
  String get sureImportPack => 'هل أنت متأكد من أنك تريد استيراد الحزمة؟';

  @override
  String byAuthor(String author) {
    return 'بواسطة $author';
  }

  @override
  String get author => 'المؤلف';

  @override
  String get addAsset => 'إضافة أصل';

  @override
  String get editAsset => 'تحرير الأصل';

  @override
  String get scope => 'النطاق';

  @override
  String get noPacks => 'لا توجد حزم متوفرة حاليا';

  @override
  String get components => 'المكونات';

  @override
  String get waypoint => 'إحداثية';

  @override
  String get actions => 'الإجراءات';

  @override
  String get painters => 'المؤمنون';

  @override
  String get breakingChangesTitle => 'كسر التغييرات';

  @override
  String breakingChangesMessage(int version, int newVersion) {
    return 'هناك تغييرات في هذا الإصدار. الرجاء قراءة سجل التغييرات قبل التحديث. الإصدار الحالي للملف هو $version، الإصدار الجديد هو $newVersion.';
  }

  @override
  String get styles => 'Styles';

  @override
  String get paragraph => 'الفقرة';

  @override
  String get fontFamily => 'عائلة الخط';

  @override
  String get smoothing => 'زحف';

  @override
  String get streamline => 'التبسيط';

  @override
  String get presentation => 'عرض';

  @override
  String get selectAsset => 'حدد الأصل';

  @override
  String get clearStyle => 'مسح النمط';

  @override
  String get unknownImportType => 'نوع الاستيراد غير معروف';

  @override
  String get sureImportTemplate => 'هل أنت متأكد من أنك تريد استيراد القالب؟';

  @override
  String get frame => 'Frame';

  @override
  String get play => 'تشغيل';

  @override
  String get video => 'فيديو';

  @override
  String get fps => 'FPS';

  @override
  String get breakpoint => 'نقطة توقف';

  @override
  String get presentationControls => 'ضوابط العرض';

  @override
  String get nextSlide => 'الشريحة التالية';

  @override
  String get nextSlideDescription =>
      'اسحب إلى اليمين أو اضغط على مفتاح السهم الأيمن للذهاب إلى الشريحة التالية';

  @override
  String get previousSlide => 'الشريحة السابقة';

  @override
  String get previousSlideDescription =>
      'اسحب إلى اليسار أو اضغط على مفتاح السهم الأيسر للذهاب إلى الشريحة السابقة';

  @override
  String get exitPresentation => 'الخروج من العرض التقديمي';

  @override
  String get exitPresentationDescription =>
      'اضغط على مفتاح الهروب أو مرر لأسفل للخروج من العرض';

  @override
  String get pausePresentation => 'إيقاف العرض المؤقت';

  @override
  String get pausePresentationDescription =>
      'اضغط على الشاشة أو اضغط على شريط المساحة لإيقاف أو استئناف العرض التقديمي';

  @override
  String get keyframe => 'Keyframe';

  @override
  String get endOfPresentation => 'لقد وصلت إلى نهاية العرض التقديمي';

  @override
  String get startOfPresentation => 'لقد وصلت إلى بداية العرض التقديمي';

  @override
  String get palettes => 'Palettes';

  @override
  String headline(int index) {
    return 'العنوان $index';
  }

  @override
  String get code => 'الكود';

  @override
  String get quote => 'اقتباس';

  @override
  String get link => 'رابط';

  @override
  String get checkbox => 'خانة';

  @override
  String get deleted => 'محذوف';

  @override
  String get emphasis => 'التوكيد';

  @override
  String get listBullet => 'رصاصة القائمة';

  @override
  String get strong => 'قوي';

  @override
  String get markdown => 'Markdown';

  @override
  String get home => 'المنزل';

  @override
  String get files => 'الملفات';

  @override
  String get sortBy => 'الترتيب حسب';

  @override
  String get location => 'الموقع';

  @override
  String get whatsNew => 'ما الجديد؟';

  @override
  String get unstar => 'إلغاء التمييز';

  @override
  String get star => 'نجوم';

  @override
  String get goUp => 'اذهب للأعلى';

  @override
  String get created => 'أنشئ';

  @override
  String get modified => 'معدّل';

  @override
  String get quickstart => 'البداية السريعة';

  @override
  String get noTemplates => 'لا توجد حاليا قوالب متاحة';

  @override
  String get importCorePack => 'استيراد حزمة النواة';

  @override
  String get importCorePackDescription =>
      'استيراد الحزمة الأساسية التي تحتوي على جميع الأصول الأساسية للبدء. وهذا سيتجاوز الحزمة الأساسية الحالية.';

  @override
  String get never => 'لا';

  @override
  String get onlyOnUpdates => 'فقط على التحديثات';

  @override
  String get visibility => 'الظهور';

  @override
  String get captureThumbnail => 'التقط الصورة المصغرة';

  @override
  String get capturedThumbnail => 'تم التقاط الصورة المصغرة بنجاح';

  @override
  String get chooseLabelMode => 'اختيار وضع التسمية';

  @override
  String get foreground => 'تمهيد';

  @override
  String get version => 'الإصدار';

  @override
  String get repository => 'المستودع';

  @override
  String get pages => 'الصفحات';

  @override
  String get navigator => 'مستكشف';

  @override
  String get arrange => 'ترتيب';

  @override
  String get bringToFront => 'إحضار إلى الأمام';

  @override
  String get sendToBack => 'إرسال إلى الخلف';

  @override
  String get bringForward => 'إحضار للأمام';

  @override
  String get sendBackward => 'إرسال إلى الخلف';

  @override
  String get rotation => 'دوران';

  @override
  String get onlyAvailableLargerScreen => 'متوفر فقط على شاشات أكبر';

  @override
  String get toolbarPosition => 'موضع شريط الأدوات';

  @override
  String get rotate => 'تدوير';

  @override
  String get spacer => 'المساحة';

  @override
  String get navigationRail => 'سكك حديدية للتنقل';

  @override
  String get cut => 'قطع';

  @override
  String get insertBefore => 'إدراج قبل';

  @override
  String get insertAfter => 'إدراج بعد';

  @override
  String get insertFirst => 'إدراج أولاً';

  @override
  String get insertLast => 'Insert last';

  @override
  String get paste => 'لصق';

  @override
  String get ascending => 'تصاعدي';

  @override
  String get descending => 'تنازلي';

  @override
  String get imageScale => 'حجم الصورة';

  @override
  String get select => 'حدد';

  @override
  String get tool => 'أداة';

  @override
  String get texture => 'نسيج';

  @override
  String get platformTheme => 'موضوع المنصة';

  @override
  String get desktop => 'سطح المكتب';

  @override
  String get mobile => 'الجوال';

  @override
  String get pdfQuality => 'جودة PDF';

  @override
  String get surface => 'السطح';

  @override
  String get pattern => 'النمط';

  @override
  String get sureClose => 'هل أنت متأكد من أنك تريد إغلاق الوثيقة؟';

  @override
  String get thereAreUnsavedChanges => 'هناك تغييرات غير محفوظة';

  @override
  String get page => 'الصفحة';

  @override
  String get iceServers => 'خوادم ICE';

  @override
  String get collaboration => 'التعاون';

  @override
  String get webRtc => 'Web RTC';

  @override
  String get webSocket => 'مقبس الويب';

  @override
  String get iceServer => 'خادم ICE';

  @override
  String get port => 'المنفذ';

  @override
  String get type => 'نوع';

  @override
  String get side => 'جانب';

  @override
  String get client => 'العميل';

  @override
  String get server => 'خادم';

  @override
  String get switchView => 'تبديل طريقة العرض';

  @override
  String get lasso => 'Lasso';

  @override
  String get hideUI => 'إخفاء واجهة المستخدم';

  @override
  String get density => 'الكثافة';

  @override
  String get compact => 'مدمج';

  @override
  String get comfortable => 'مريح';

  @override
  String get standard => 'قياسي';

  @override
  String get lock => 'قفل';

  @override
  String get addElement => 'إضافة عنصر';

  @override
  String get notDefaultConnection => 'ليس الإتصال الافتراضي';

  @override
  String get defaultConnection => 'الاتصال الافتراضي';

  @override
  String get hide => 'إخفاء';

  @override
  String get show => 'إظهار';

  @override
  String get pause => 'إيقاف';

  @override
  String get stop => 'توقف';

  @override
  String get refresh => 'تحديث';

  @override
  String get print => 'طباعة';

  @override
  String get dav => 'داف';

  @override
  String get eyeDropper => 'إسقاط العين';

  @override
  String get users => 'المستخدمون';

  @override
  String get experiments => 'التجارب';

  @override
  String get experimentsWarning =>
      'هذه الميزات تجريبية وقد تتغير أو تتقطع أو تختفي في أي وقت. تمكينهم قد يتسبب في عدم الاستقرار أو فقدان البيانات. المتابعة بحذر. الرجاء الإبلاغ عن أي أخطاء.';

  @override
  String get address => 'العنوان';

  @override
  String get spreadToPages => 'نشر إلى الصفحات';

  @override
  String get rootDirectorySpecifiedDescription =>
      'الدليل الجذر محدد. جميع مسارات الدليل المتقدمة ستكون مرتبطة بهذا الدليل. ابقه فارغاً لتعطيل هذا النوع من الدليل.';

  @override
  String get rootDirectoryNotSpecifiedDescription =>
      'الدليل الجذر غير محدد. الاسم مطلوب. جميع مسارات الدليل المتقدمة ستكون مطلقة. ابقه فارغاً لتعطيل هذا النوع من الدليل.';

  @override
  String get unsecureConnectionTitle => 'اتصال غير آمن';

  @override
  String unsecureConnectionMessage(String fingerprint) {
    return 'الاتصال غير آمن. يمكن أن يكون هذا خطرًا أمنيًا، يرجى المتابعة فقط إذا كنت تثق في الاتصال. بصمة الهزلية 1 هي $fingerprint.';
  }

  @override
  String get continueAnyway => 'المتابعة على أي حال';

  @override
  String get zoomControl => 'التحكم بالتكبير/التصغير';

  @override
  String get highContrast => 'تباين عالي';

  @override
  String get shouldANumber => 'يجب أن تكون هذه القيمة رقم صحيح';

  @override
  String get createAreas => 'إنشاء مناطق';

  @override
  String get autosave => 'Autosave';

  @override
  String get invert => 'Invert';

  @override
  String get operations => 'العمليات';

  @override
  String get medium => 'متوسط';

  @override
  String get large => 'كبير';

  @override
  String get toolbarSize => 'حجم شريط الأدوات';

  @override
  String get addAll => 'إضافة الكل';

  @override
  String get onlyCurrentPage => 'الصفحة الحالية فقط';

  @override
  String get smoothNavigation => 'التنقل السلس';

  @override
  String get exact => 'بالضبط';

  @override
  String get inline => 'مضمن';

  @override
  String get toolbarRows => 'صفوف شريط الأدوات';

  @override
  String get pointerTest => 'اختبار المؤشر';

  @override
  String get pressure => 'الضغط';

  @override
  String get small => 'صغير';

  @override
  String get tiny => 'صغير';

  @override
  String get selectAll => 'حدد الكل';

  @override
  String get overrideTools => 'أدوات التجاوز';

  @override
  String get hideCursorWhileDrawing => 'إخفاء المؤشر أثناء الرسم';

  @override
  String get installed => 'مثبت';

  @override
  String get install => 'تثبيت';

  @override
  String get deselect => 'إلغاء التحديد';

  @override
  String get changeCollection => 'تغيير المجموعة';

  @override
  String get collections => 'مجموعات';

  @override
  String get fullSelection => 'التحديد الكامل';

  @override
  String get fullSelectionDescription =>
      'يتطلب أن تكون العناصر كاملة داخل مربع الاختيار من أجل الاختيار.';

  @override
  String get collection => 'مجموعة';

  @override
  String get defaultCollection => 'المجموعة الافتراضية';

  @override
  String get scroll => 'تمرير';

  @override
  String get onStartup => 'عند بدء التشغيل';

  @override
  String get homeScreen => 'الشاشة الرئيسية';

  @override
  String get lastNote => 'الملاحظة الأخيرة';

  @override
  String get newNote => 'ملاحظة جديدة';

  @override
  String get convertToLayer => 'تحويل إلى طبقة';

  @override
  String get merge => 'دمج';

  @override
  String get up => 'أعلى';

  @override
  String get down => 'أسفل';

  @override
  String get other => 'اخرى';

  @override
  String countElements(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count عناصر',
      one: 'عنصر 1',
      zero: 'لا عناصر',
    );
    return '$_temp0';
  }

  @override
  String get colorToolbar => 'لون شريط الأدوات';

  @override
  String get yesButShowButtons => 'نعم، لكن إظهار الأزرار';

  @override
  String get optionsPanelPosition => 'موقف لوحة الخيارات';

  @override
  String get hideDuration => 'مدة الإخفاء';

  @override
  String get animation => 'الحركة';

  @override
  String get performance => 'الأداء';

  @override
  String get performanceDescription =>
      'تم تحسينه لاستخدام السرعة والذاكرة. فقط الجزء المرئي من الملاحظة يخبز في الصورة.';

  @override
  String get normalDescription =>
      'جودة الموازين والأداء. يعطي صورة تغطي 1.5 ضعف المساحة المرئية، مما يوفر انتقالات أكثر سلاسة عند التمرير.';

  @override
  String get high => 'مرتفع';

  @override
  String get highDescription =>
      'يزيد الجودة إلى أقصى حد على حساب الأداء. يعطي صورة تغطي ضعف المساحة المرئية، مع ضمان سلاسة حتى أثناء التمرير أو التكبير السريع.';

  @override
  String get renderResolution => 'عرض الدقة';

  @override
  String get translate => 'ترجم';

  @override
  String get unencrypted => 'غير مشفرة';

  @override
  String get encrypted => 'مشفرة';

  @override
  String get encryptDocumentMessage => 'انقر لتشفير المستند';

  @override
  String get unencryptDocumentMessage => 'انقر لإلغاء تشفير المستند';

  @override
  String get unencrypt => 'إلغاء التشفير';

  @override
  String get encrypt => 'تشفير';

  @override
  String get encryptWarning =>
      'سيؤدي هذا إلى تشفير المستند. ستحتاج إلى تذكر كلمة المرور لفك تشفيرها.';

  @override
  String get unencryptWarning =>
      'سيؤدي هذا إلى إلغاء تشفير المستند. سيتم إزالة كلمة المرور وسيتمكن كل من لديه حق الوصول من فتحها.';

  @override
  String get confirmPassword => 'تأكيد كلمة المرور';

  @override
  String get passwordMismatch => 'كلمات المرور غير متطابقة';

  @override
  String get action => 'اجراء';

  @override
  String get svgText => 'نص SVG';

  @override
  String get offset => 'إزاحة';

  @override
  String get positionDependent => 'موقع معتمد';

  @override
  String get flipHorizontal => 'قلب أفقي';

  @override
  String get flipVertical => 'قلب عمودي';

  @override
  String get grayscale => 'Grayscale';

  @override
  String get moveOnGesture => 'تحريك على الإيماءة';

  @override
  String get exportAllFiles => 'تصدير جميع الملفات';

  @override
  String get restoreSettingsFromFile => 'استعادة الإعدادات من الملف';

  @override
  String get exportSettingsToFile => 'تصدير الإعدادات إلى ملف';

  @override
  String get barcode => 'Barcode';

  @override
  String get barcodeType => 'نوع الباركود';

  @override
  String get qrCode => 'QR Code';

  @override
  String get dataMatrix => 'مصفوفة البيانات';

  @override
  String get code128 => 'الكود 128';

  @override
  String defaultUserName(int index) {
    return 'المستخدم $index';
  }

  @override
  String get moveLeft => 'تحريك لليسار';

  @override
  String get moveRight => 'تحريك لليمين';

  @override
  String get bundledPacks => 'حزم الحزم';

  @override
  String get component => 'المكون';

  @override
  String get selectComponent => 'حدد المكون';

  @override
  String get bundlePackInDocument => 'حزمة في المستند';

  @override
  String get bundledPacksDescription =>
      'والحزم المجمعة مدرجة في الوثيقة ولا تستخدم إلا للمشاركة مع الوثيقة. لا يمكن استخدام الأصول إلا في المستند إذا تم تثبيت الحزمة. يمكن تثبيت الحزم مع النقر عليها.';

  @override
  String get fillAlpha => 'ملء ألفا';

  @override
  String get packagedFile => 'ملف معبأ';

  @override
  String get rawFile => 'ملف خام';

  @override
  String get webSocketDescription =>
      'جهازك يستضيف الخادم، لذلك يمكن للمتعاونين الانضمام على نفس الشبكة فقط أو من أي مكان إذا قمت بإعادة توجيه المنفذ على جهاز التوجيه الخاص بك.';

  @override
  String get swampDescription =>
      'يتم توجيه رسائلك من خلال خادم نقل آمن مع تشفير من النهاية إلى النهاية. مطلوب عنوان خادم المستنقعات لإنشاء جلسة.';

  @override
  String get createRawNote => 'إنشاء ملاحظة خام';

  @override
  String get polygon => 'مضلع';

  @override
  String get finishShape => 'إنهاء الشكل';

  @override
  String get submit => 'إرسال';

  @override
  String get math => 'الرياضيات';

  @override
  String get ignorePressure => 'تجاهل الضغط';

  @override
  String get ignoreFirstPressureDescription =>
      'في بعض الأجهزة، قيمة الضغط الأول غير دقيقة. هذا الإعداد سوف يتجاهل قيمة الضغط الأول ويستخدم ضغط الحدث الثاني بدلاً من ذلك.';

  @override
  String get temporary => 'مؤقت';

  @override
  String get simpleToolbarVisibility => 'رؤية شريط الأدوات البسيطة';

  @override
  String get autosaveDelay => 'تأخير تلقائي';

  @override
  String get saved => 'محفوظ';

  @override
  String get saving => 'حفظ...';

  @override
  String get readOnly => 'قراءة فقط';

  @override
  String get saveDelayed => 'حفظ متأخر';

  @override
  String get unsaved => 'غير محفوظة';

  @override
  String get pdfEmptyDescription =>
      'لا توجد حاليا مناطق للتصدير. الرجاء تحديد منطقة واحدة على الأقل باستخدام الزر زائد في الزاوية اليمنى العلوية أو إضافة جميع المناطق من الصفحة الحالية أو من الوثيقة بأكملها أدناه.';
}
