---
title: Comparison
---

Butterfly is a note-taking app that aims for a unified experience across all platforms. It combines a simple UI with powerful customization. This page compares Butterfly to other popular note-taking and drawing applications to highlight what makes Butterfly unique.

## Quick Comparison Table

| Feature             | Butterfly                                           | OneNote                | Obsidian                           | Excalidraw                     | Xournal++                                          | Samsung Notes                                        |
| ------------------- | --------------------------------------------------- | ---------------------- | ---------------------------------- | ------------------------------ | -------------------------------------------------- | ---------------------------------------------------- |
| **Open Source**     | ✅ Yes (AGPL-3.0) | ❌ No                   | ❌ No                               | ✅ Yes (MIT) | ✅ Yes (GPL-2.0) | ❌ No                                                 |
| **Cost**            | Free                                                | Free                   | Free (personal) | Free + Paid tiers              | Free                                               | Free                                                 |
| **Android**         | ✅                                                   | ✅                      | ✅                                  | ❌                              | ❌                                                  | ✅                                                    |
| **Windows**         | ✅                                                   | ✅                      | ✅                                  | ❌                              | ✅ (Windows 10)                  | 🟧 Limited (Samsung devices ONLY) |
| **Linux**           | ✅                                                   | ❌                      | ✅                                  | ❌                              | ✅                                                  | ❌                                                    |
| **macOS**           | ✅                                                   | ✅                      | ✅                                  | ❌                              | ✅                                                  | ❌                                                    |
| **Web**             | ✅                                                   | ✅                      | ❌                                  | ✅                              | ❌                                                  | ❌                                                    |
| **Infinite Canvas** | ✅ Full                                              | ✅ Positive coords only | ✅                                  | ✅                              | ❌ Fixed pages                                      | ❌ Fixed pages                                        |
| **Handwriting**     | ✅                                                   | ✅                      | 🟧 Limited                         | ✅ Drawing                      | ✅                                                  | ✅                                                    |
| **Custom Colors**   | ✅ Full palette                                      | ✅                      | ✅ Themes                           | ✅                              | ✅                                                  | ✅                                                    |
| **PDF Import**      | ✅                                                   | ✅                      | 🟧 Limited                         | ❌                              | ✅                                                  | ✅                                                    |
| **PDF Export**      | ✅                                                   | ✅                      | ✅                                  | ✅                              | ✅                                                  | ✅                                                    |
| **SVG Support**     | ✅                                                   | ❌                      | ❌                                  | ✅                              | ❌                                                  | ❌                                                    |
| **Offline Use**     | ✅                                                   | ✅                      | ✅                                  | ✅ Basic                        | ✅                                                  | ✅                                                    |
| **Cloud Sync**      | WebDAV                                              | OneDrive/SharePoint    | Paid sync                          | Paid collab                    | ידני                                               | OneDrive/Samsung Cloud                               |

## Detailed Comparisons

### Butterfly vs Microsoft OneNote

**Similarities:**

- Infinite canvas for freeform note-taking
- Strong handwriting and drawing support
- Support for images and multimedia content
- Cross-platform availability

**Butterfly Advantages:**

- **Open source** – You can inspect, modify, and contribute to the code
- **True infinite canvas** – No coordinate limitations
- **Better privacy** – Store data locally or choose your own WebDAV provider
- **Lighter weight** – Faster startup and lower resource usage
- **SVG support** – Vector graphics import and export
- **No vendor lock-in** – Your data stays under your control

**OneNote Advantages:**

- **Deep Microsoft ecosystem integration** – Works seamlessly with Office 365
- **Advanced OCR** – Text recognition from handwritten notes and images
- **Enterprise features** – Advanced sharing and permission management

**Best for:**

- **Butterfly**: Privacy-conscious users, Linux users, those wanting lightweight open-source solutions
- **OneNote**: Microsoft ecosystem users, teams needing collaboration, macOS users

### Butterfly vs Obsidian

**Similarities:**

- Cross-platform support
- Customizable interface and themes
- Local data storage with sync options

**Butterfly Advantages:**

- **Canvas-based interface** – Freeform drawing and note placement
- **Built-in drawing tools** – No plugins required for handwriting
- **Simpler learning curve** – Ready to use out of the box
- **Better for visual thinkers** – Infinite canvas for mind mapping
- **Web version available** – No installation required

**Obsidian Advantages:**

- **Powerful linking system** – Bidirectional links between notes
- **Markdown-based** – Future-proof plain text format
- **Advanced search** – Complex queries and filtering
- **Graph view** – Visualize connections between notes
- **Better for text-heavy notes** – Structured note organization
- **Plugin/extension support** – For enhanced functionality

**Best for:**

- **Butterfly**: Visual note-takers, sketching, casual note-taking, students
- **Obsidian**: Knowledge workers, researchers, those building personal knowledge bases

### Butterfly vs Excalidraw

**Similarities:**

- Excellent drawing and diagramming capabilities
- Clean, intuitive interface
- Web-based accessibility
- Open-source foundation
- Hand-drawn aesthetic for diagrams

**Butterfly Advantages:**

- **Mobile apps** – iOS and Android support
- **Desktop applications** – Windows and Linux apps available
- **Text editing** – Rich text support beyond just drawings
- **File management** – Organize notes with pages and structure
- **PDF import** – Annotate existing documents
- **Offline-first** – Works without an internet connection

**Excalidraw Advantages:**

- **Collaboration focus** – Real-time collaborative drawing
- **Library system** – Reusable components and templates
- **Excalidraw Plus features** – Professional collaboration tools
- **Integration friendly** – Embeds well in other applications
- **Specialized for diagrams** – Purpose-built for technical drawings

**Best for:**

- **Butterfly**: General note-taking with drawing, mobile users, offline work
- **Excalidraw**: Team diagramming, technical documentation, collaborative sketching

### Butterfly vs Xournal++

**Similarities:**

- Excellent handwriting support
- PDF annotation capabilities
- Open-source and free
- Cross-platform (Windows, Linux)
- Stylus/pen input optimization

**Butterfly Advantages:**

- **Mobile support** – iOS and Android support
- **Web version** – Browser-based access
- **Modern interface** – Contemporary design and UX
- **Infinite canvas** – Not limited to page boundaries
- **Cloud sync** – WebDAV integration built-in
- **Multiple export formats** – SVG, PNG, PDF support

**Xournal++ Advantages:**

- **Built with GTK** – Natively integrated in the GNOME interface
- **Audio recording** – Link audio notes to written content

**Best for:**

- **Butterfly**: Mobile note-taking, modern UI preferences, cloud sync needs
- **Xournal++**: Academic users, PDF-heavy workflows

### Butterfly vs Samsung Notes

**Similarities:**

- Excellent handwriting support
- PDF annotation capabilities
- Free
- Stylus/pen input optimization
- תבניות

**Butterfly Advantages:**

- **Mobile support** – iOS and Android support
- **Web version** – Browser-based access
- **Infinite canvas** – Not limited to page boundaries
- **Cloud sync** – WebDAV integration built-in
- **Multiple export formats** – SVG, PNG, PDF support
- **Cross-platform** – Windows, Android, iOS, and Linux

**Samsung Notes Advantages:**

- **Native OneUI** – OneUI’s interface design
- **Audio recording** – Link audio notes to written content
- **Optimized for Samsung devices** – Works best on Samsung devices running OneUI, Samsung’s operating system

**Best for:**

- **Butterfly**: Mobile note-taking, cloud sync needs, infinite canvas, cross-platform usage
- **Samsung Notes**: PDF-heavy workflows, Samsung devices

## Migration and Compatibility

**From OneNote:**

- Export OneNote pages as PDFs and import them into Butterfly
- Recreate drawings and handwritten notes natively in Butterfly
- Consider using WebDAV sync to replace OneDrive synchronization

**From Obsidian:**

- Copy text content and recreate it in Butterfly’s text tools
- Convert Markdown files to PDF for import if needed
- Use Butterfly's infinite canvas for mind maps instead of the graph view

**From Excalidraw:**

- Export drawings as SVG and import them into Butterfly
- Recreate collaborative workflows using Butterfly’s sync features
- Transition from pure diagramming to mixed note-taking

**From Xournal++:**

- Export annotated PDFs and import them into Butterfly
- Transfer handwritten notes by recreating or importing them as images
- Adapt from a page-based to an infinite canvas workflow

**From Samsung Notes:**

- Export notes as PDFs and import them into Butterfly
- Handwritten annotations should be redrawn in Butterfly for the best experience
- Adapt from a page-based to an infinite canvas workflow
