// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Serbian (`sr`).
class AppLocalizationsSr extends AppLocalizations {
  AppLocalizationsSr([String locale = 'sr']) : super(locale);

  @override
  String get open => 'Otvori';

  @override
  String get settings => 'Podešavanja';

  @override
  String get personalization => 'Personalizacija';

  @override
  String get theme => 'Tema';

  @override
  String get darkTheme => 'Tamna tema';

  @override
  String get lightTheme => 'Svetla tema';

  @override
  String get systemTheme => 'Koristi podrazumevanu sistemsku temu';

  @override
  String get view => 'Prikaz';

  @override
  String get edit => 'Izmeni';

  @override
  String get export => 'Izvezi';

  @override
  String get save => 'Sačuvaj';

  @override
  String get zoom => 'Zumiranje';

  @override
  String get zoomIn => 'Uvećaj';

  @override
  String get zoomOut => 'Umanji';

  @override
  String get resetZoom => 'Resetuj zumiranje';

  @override
  String get strokeWidth => 'Debljina linije';

  @override
  String get includeEraser => 'Uključi gumicu?';

  @override
  String get thinning => 'Tanjanje';

  @override
  String get pen => 'Olovka';

  @override
  String get invertedPen => 'Invertovana olovka';

  @override
  String get eraser => 'Gumica';

  @override
  String get pathEraser => 'Gumica za putanje';

  @override
  String get label => 'Oznaka';

  @override
  String get delete => 'Obriši';

  @override
  String get areYouSure => 'Da li ste sigurni?';

  @override
  String get reallyDelete => 'Da li zaista želite da obrišete ovu stavku?';

  @override
  String get no => 'Ne';

  @override
  String get yes => 'Da';

  @override
  String get undo => 'Opozovi';

  @override
  String get redo => 'Ponovi';

  @override
  String get general => 'Opšte';

  @override
  String get copyTitle => 'Kopirano u klipbord';

  @override
  String get loading => 'Učitavanje...';

  @override
  String get enterText => 'Unesite tekst';

  @override
  String get size => 'Veličina';

  @override
  String get width => 'Širina';

  @override
  String get height => 'Visina';

  @override
  String get count => 'Broj';

  @override
  String get space => 'Prostor';

  @override
  String get background => 'Pozadina';

  @override
  String get box => 'Kutija';

  @override
  String get locale => 'Jezik';

  @override
  String get systemLocale => 'Sistemski jezik';

  @override
  String get information => 'Informacije';

  @override
  String get license => 'Licenca';

  @override
  String get imprint => 'Impresum';

  @override
  String get privacypolicy => 'Politika privatnosti';

  @override
  String get sourceCode => 'Izvorni kod';

  @override
  String get documentation => 'Dokumentacija';

  @override
  String get changelog => 'Dnevnik izmena';

  @override
  String get source => 'Izvor';

  @override
  String get existOverride => 'Ovaj element već postoji. Prepiši?';

  @override
  String get description => 'Opis';

  @override
  String get fill => 'Popuna';

  @override
  String get defaultPalette => 'Podrazumevana paleta';

  @override
  String get highlighter => 'Marker';

  @override
  String get add => 'Dodaj';

  @override
  String get remove => 'Ukloni';

  @override
  String get removeConfirm => 'Da li zaista želite da uklonite ovo?';

  @override
  String get resetPalette => 'Resetuj paletu';

  @override
  String get custom => 'Prilagođeno';

  @override
  String get decoration => 'Dekoracija';

  @override
  String get underline => 'Podvučeno';

  @override
  String get overline => 'Nadvučeno';

  @override
  String get strikethrough => 'Precrtano';

  @override
  String get thickness => 'Debljina';

  @override
  String get style => 'Stil';

  @override
  String get solid => 'Puna';

  @override
  String get double => 'Dvostruka';

  @override
  String get dotted => 'Tačkasta';

  @override
  String get dashed => 'Isprekidana';

  @override
  String get wavy => 'Talasasta';

  @override
  String get fontWeight => 'Debljina fonta';

  @override
  String get normal => 'Normalno';

  @override
  String get bold => 'Podebljano';

  @override
  String get italic => 'Kurziv';

  @override
  String get clipboard => 'Klipbord';

  @override
  String get file => 'Datoteka';

  @override
  String get data => 'Podaci';

  @override
  String get share => 'Deli';

  @override
  String get spacing => 'Razmak';

  @override
  String get image => 'Slika';

  @override
  String get enterUrl => 'Unesite URL';

  @override
  String get scale => 'Skala';

  @override
  String get help => 'Pomoć';

  @override
  String get reallyReset => 'Da li zaista želite da resetujete ovo?';

  @override
  String get whatToDo => 'Šta želite da uradite?';

  @override
  String get ignore => 'Ignoriši';

  @override
  String get backup => 'Rezervna kopija';

  @override
  String createdInNewerVersion(String fileName, int fileVersion) {
    return 'Datoteka $fileName je kreirana u novijoj verziji ($fileVersion). Šta treba uraditi sa ovom datotekom?';
  }

  @override
  String get waypoints => 'Tačke putanje';

  @override
  String get origin => 'Poreklo';

  @override
  String get import => 'Uvezi';

  @override
  String get newContent => 'Novo';

  @override
  String get selectElement => 'Izaberi element';

  @override
  String get ctrlKey => 'Ctrl';

  @override
  String get shiftKey => 'Shift';

  @override
  String get altKey => 'Alt';

  @override
  String get copyVersion => 'Kopiraj verziju';

  @override
  String get input => 'Unos';

  @override
  String get behaviors => 'Ponašanja';

  @override
  String get dataDirectory => 'Direktorijum sa podacima';

  @override
  String get defaultPath => 'Podrazumevana putanja';

  @override
  String get dateFormat => 'Format datuma';

  @override
  String updatedAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'Ažurirano: $dateTimeString';
  }

  @override
  String createdAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'Kreirano: $dateTimeString';
  }

  @override
  String get rename => 'Preimenuj';

  @override
  String get duplicate => 'Dupliraj';

  @override
  String get hand => 'Ruka';

  @override
  String get folder => 'Fascikla';

  @override
  String get move => 'Premesti';

  @override
  String get copy => 'Kopiraj';

  @override
  String get back => 'Nazad';

  @override
  String get zoomDependent => 'Zavisno od zuma';

  @override
  String get shapeDetection => 'Prepoznavanje oblika';

  @override
  String get delay => 'Odlaganje';

  @override
  String get defaultLayer => 'Podrazumevani sloj';

  @override
  String get layer => 'Sloj';

  @override
  String get layers => 'Slojevi';

  @override
  String get notSet => 'Nije postavljeno';

  @override
  String get enterLayer => 'Unesite naziv sloja';

  @override
  String get selectElements => 'Izaberi elemente';

  @override
  String get deleteElements => 'Obriši elemente';

  @override
  String get deleteElementsConfirm =>
      'Da li zaista želite da obrišete izabrane elemente?';

  @override
  String get selectCustomCollection => 'Izaberite prilagođenu kolekciju';

  @override
  String get svg => 'SVG';

  @override
  String get sensitivity => 'Osetljivost';

  @override
  String get sensitivityHint => 'Što je veća vrednost, to je unos osetljiviji';

  @override
  String get horizontal => 'Horizontalno';

  @override
  String get vertical => 'Vertikalno';

  @override
  String get plain => 'Obično';

  @override
  String get light => 'Svetlo';

  @override
  String get ruled => 'Linije';

  @override
  String get quad => 'Kvadrat';

  @override
  String get music => 'Muzika';

  @override
  String get dark => 'Tamno';

  @override
  String get plainDark => 'Tamno';

  @override
  String get ruledDark => 'Tamne linije';

  @override
  String get quadDark => 'Tamni kvadrati';

  @override
  String get musicDark => 'Tamna muzika';

  @override
  String get templates => 'Šabloni';

  @override
  String get untitled => 'Bez naslova';

  @override
  String get createTemplate => 'Kreiraj šablon';

  @override
  String get createTemplateContent =>
      'Da li zaista želite da kreirate šablon od ovog dokumenta? Originalni dokument će biti obrisan.';

  @override
  String get replace => 'Zameni';

  @override
  String get reallyReplace =>
      'Da li zaista želite da zamenite šablon? Ova operacija se ne može opozvati!';

  @override
  String get defaultTemplate => 'Podrazumevani šablon';

  @override
  String get insert => 'Ubaci';

  @override
  String get document => 'Dokument';

  @override
  String get camera => 'Kamera';

  @override
  String get printout => 'Ispis';

  @override
  String get selectCamera => 'Izaberite kameru';

  @override
  String get changeDocumentPath => 'Promeni putanju dokumenta';

  @override
  String get deleteWholeStroke => 'Obriši celu liniju';

  @override
  String get alpha => 'Alfa';

  @override
  String get area => 'Oblast';

  @override
  String get selectArea => 'Izaberite oblast';

  @override
  String get aspectRatio => 'Odnos širine i visine';

  @override
  String get presets => 'Unapred podešeno';

  @override
  String get pagePortrait => 'Portret stranica';

  @override
  String get pageLandscape => 'Pejzaž stranica';

  @override
  String get square => 'Kvadrat';

  @override
  String get areas => 'Oblasti';

  @override
  String get enterArea => 'Unesite oblast';

  @override
  String get exitArea => 'Izađite iz oblasti';

  @override
  String get currentArea => 'Trenutna oblast';

  @override
  String get design => 'Dizajn';

  @override
  String get text => 'Tekst';

  @override
  String welcome(String codeName) {
    return 'Zdravo, ovo je Linwood Butterfly $codeName';
  }

  @override
  String get welcomeContent => 'Besplatan prostor za crtanje otvorenog koda!';

  @override
  String updated(String version) {
    return 'Aplikacija ažurirana na verziju $version';
  }

  @override
  String get releaseNotes => 'Napomene o izdanju';

  @override
  String get constraints => 'Ograničenja';

  @override
  String get scaled => 'Skalirano';

  @override
  String get fixed => 'Fiksno';

  @override
  String get dynamicContent => 'Dinamično';

  @override
  String get none => 'Ništa';

  @override
  String get includeArea => 'Uključi oblast';

  @override
  String get verticalAlignment => 'Vertikalno poravnanje';

  @override
  String get horizontalAlignment => 'Horizontalno poravnanje';

  @override
  String get top => 'Vrh';

  @override
  String get center => 'Centar';

  @override
  String get bottom => 'Dno';

  @override
  String get left => 'Levo';

  @override
  String get right => 'Desno';

  @override
  String get justify => 'Obostrano';

  @override
  String get constraint => 'Ograničenje';

  @override
  String get length => 'Dužina';

  @override
  String get exportSvg => 'Izvezi SVG';

  @override
  String get pdf => 'PDF';

  @override
  String get selectPages => 'Izaberi stranice';

  @override
  String get recentFiles => 'Nedavne datoteke';

  @override
  String get start => 'Početak';

  @override
  String get noRecentFiles => 'Nema nedavnih datoteka';

  @override
  String countPages(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count stranice',
      one: '1 stranica',
      zero: 'Nema stranica',
    );
    return '$_temp0';
  }

  @override
  String pageIndex(int index) {
    return 'Stranica $index';
  }

  @override
  String get exit => 'Izlaz';

  @override
  String get noElements => 'Nema elemenata';

  @override
  String get invertSelection => 'Invertuj selekciju';

  @override
  String get errorWhileImporting => 'Greška prilikom uvoza';

  @override
  String get errorWhileImportingContent =>
      'Došlo je do greške prilikom uvoza datoteke';

  @override
  String get showDetails => 'Prikaži detalje';

  @override
  String get hideDetails => 'Sakrij detalje';

  @override
  String get error => 'Greška';

  @override
  String get stackTrace => 'Trag steka';

  @override
  String get laser => 'Laser';

  @override
  String get duration => 'Trajanje';

  @override
  String get quality => 'Kvalitet';

  @override
  String get exportPdf => 'Izvezi PDF';

  @override
  String get local => 'Lokalno';

  @override
  String get addConnection => 'Dodaj konekciju';

  @override
  String get connections => 'Konekcije';

  @override
  String get noConnections => 'Nema konekcija';

  @override
  String get url => 'URL';

  @override
  String get connect => 'Poveži se';

  @override
  String get username => 'Korisničko ime';

  @override
  String get password => 'Lozinka';

  @override
  String get webNotSupported => 'Web nije podržan';

  @override
  String get advanced => 'Napredno';

  @override
  String get directory => 'Direktorijum';

  @override
  String get documentsDirectory => 'Direktorijum dokumenata';

  @override
  String get templatesDirectory => 'Direktorijum šablona';

  @override
  String get errorWhileCreatingConnection => 'Greška pri kreiranju konekcije';

  @override
  String get cannotConnect => 'Povezivanje nije moguće';

  @override
  String get urlNotValid => 'URL nije važeći';

  @override
  String get icon => 'Ikona';

  @override
  String get update => 'Ažuriraj';

  @override
  String get updateAvailable => 'Dostupno ažuriranje';

  @override
  String get stable => 'Stabilno';

  @override
  String get nightly => 'Noćno';

  @override
  String get checkForUpdates => 'Proveri ažuriranja';

  @override
  String get checkForUpdatesWarning =>
      'Provera ažuriranja će se povezati sa Butterfly veb-sajtom radi dobijanja informacija.';

  @override
  String get usingLatestStable => 'Koristite najnoviju stabilnu verziju';

  @override
  String get usingLatestNightly => 'Koristite najnoviju noćnu verziju';

  @override
  String get currentVersion => 'Trenutna verzija';

  @override
  String get updateNow => 'Ažuriraj sada';

  @override
  String get shape => 'Oblik';

  @override
  String get circle => 'Krug';

  @override
  String get rectangle => 'Pravougaonik';

  @override
  String get triangle => 'Trougao';

  @override
  String get line => 'Linija';

  @override
  String get cornerRadius => 'Radijus ugla';

  @override
  String get topLeft => 'Gore levo';

  @override
  String get topRight => 'Gore desno';

  @override
  String get bottomLeft => 'Dole levo';

  @override
  String get bottomRight => 'Dole desno';

  @override
  String get caches => 'Keš memorije';

  @override
  String get manage => 'Upravljaj';

  @override
  String get clearCaches => 'Očisti keš memorije';

  @override
  String get createCache => 'Kreiraj keš';

  @override
  String get thirdPartyLicenses => 'Licence trećih strana';

  @override
  String get syncing => 'Sinhronizovanje...';

  @override
  String get synced => 'Sinhronizovano';

  @override
  String get notSynced => 'Nije sinhronizovano';

  @override
  String get conflict => 'Konflikt';

  @override
  String get keepLocal => 'Zadrži lokalno';

  @override
  String get keepConnection => 'Zadrži sa konekcije';

  @override
  String get keepBoth => 'Zadrži oba';

  @override
  String get forAll => 'Za sve';

  @override
  String fileConflict(String file, String connection) {
    return 'Datoteka $file na $connection ima konflikt';
  }

  @override
  String get offline => 'Van mreže';

  @override
  String get localLatest => 'Lokalno najnovije';

  @override
  String get connectionLatest => 'Sa konekcije najnovije';

  @override
  String get path => 'Putanja';

  @override
  String get folderSynced => 'Fascikla sinhronizovana';

  @override
  String get syncRootDirectory => 'Sinhronizuj korenski direktorijum';

  @override
  String get penOnlyInput => 'Unos samo olovkom';

  @override
  String get inputGestures => 'Pokreti unosa';

  @override
  String get nativeTitleBar => 'Nativna naslovna traka';

  @override
  String get syncMode => 'Režim sinhronizacije';

  @override
  String get connection => 'Konekcija';

  @override
  String get always => 'Uvek';

  @override
  String get noMobile => 'Nema na mobilnom';

  @override
  String get manual => 'Ručno';

  @override
  String get search => 'Pretraga';

  @override
  String get properties => 'Svojstva';

  @override
  String get pin => 'Zakači';

  @override
  String get unpin => 'Otkači';

  @override
  String get element => 'Element';

  @override
  String get painter => 'Crtaljka';

  @override
  String get position => 'Pozicija';

  @override
  String get note => 'Beleška';

  @override
  String get packs => 'Paketi';

  @override
  String get pack => 'Paket';

  @override
  String get more => 'Više';

  @override
  String get askForName => 'Pitaj za ime';

  @override
  String areaIndex(int index) {
    return 'Oblast $index';
  }

  @override
  String get startInFullScreen => 'Pokreni u režimu celog ekrana';

  @override
  String get inputs => 'Unosi';

  @override
  String get mouse => 'Miš';

  @override
  String get touch => 'Dodir';

  @override
  String get keyboard => 'Tastatura';

  @override
  String get shortcuts => 'Prečice';

  @override
  String get middle => 'Srednji';

  @override
  String get first => 'Prvi';

  @override
  String get second => 'Drugi';

  @override
  String get activeTool => 'Aktivni alat';

  @override
  String get activeToolDescription =>
      'Koristi trenutno izabrani alat sa trake sa alatkama';

  @override
  String get handTool => 'Alat Ruka';

  @override
  String get handToolDescription => 'Prevucite za kretanje po platnu';

  @override
  String get toolOnToolbar => 'Specifičan alat na traci sa alatkama';

  @override
  String get toolOnToolbarDescription =>
      'Koristi alat na navedenoj poziciji na traci sa alatkama, počevši sa leve strane';

  @override
  String toolOnToolbarShort(int display_position) {
    return 'Pozicija na traci: $display_position';
  }

  @override
  String get tools => 'Alati';

  @override
  String get showGrid => 'Prikaži mrežu';

  @override
  String get grid => 'Mreža';

  @override
  String get ruler => 'Lenjir';

  @override
  String get angle => 'Ugao';

  @override
  String get report => 'Prijavi';

  @override
  String get newFolder => 'Nova fascikla';

  @override
  String get createPack => 'Kreiraj paket';

  @override
  String get editPack => 'Izmeni paket';

  @override
  String get packsDirectory => 'Direktorijum paketa';

  @override
  String get stamp => 'Pečat';

  @override
  String get addToPack => 'Dodaj u paket';

  @override
  String get sureImportPack => 'Da li ste sigurni da želite da uvezete paket?';

  @override
  String byAuthor(String author) {
    return 'od $author';
  }

  @override
  String get author => 'Autor';

  @override
  String get addAsset => 'Dodaj resurs';

  @override
  String get editAsset => 'Izmeni resurs';

  @override
  String get scope => 'Obim';

  @override
  String get noPacks => 'Trenutno nema dostupnih paketa';

  @override
  String get components => 'Komponente';

  @override
  String get waypoint => 'Tačka putanje';

  @override
  String get actions => 'Akcije';

  @override
  String get painters => 'Crtaljke';

  @override
  String get breakingChangesTitle => 'Značajne izmene';

  @override
  String breakingChangesMessage(int version, int newVersion) {
    return 'U ovoj verziji postoje značajne izmene. Molimo pročitajte dnevnik izmena pre ažuriranja. Trenutna verzija datoteke je $version, nova verzija je $newVersion.';
  }

  @override
  String get styles => 'Stilovi';

  @override
  String get paragraph => 'Pasus';

  @override
  String get fontFamily => 'Porodica fontova';

  @override
  String get smoothing => 'Izglađivanje';

  @override
  String get streamline => 'Pojednostavljenje';

  @override
  String get presentation => 'Prezentacija';

  @override
  String get selectAsset => 'Izaberi resurs';

  @override
  String get clearStyle => 'Očisti stil';

  @override
  String get unknownImportType => 'Nepoznat tip uvoza';

  @override
  String get sureImportTemplate =>
      'Da li ste sigurni da želite da uvezete šablon?';

  @override
  String get frame => 'Okvir';

  @override
  String get play => 'Pusti';

  @override
  String get video => 'Video';

  @override
  String get fps => 'FPS';

  @override
  String get breakpoint => 'Tačka prekida';

  @override
  String get presentationControls => 'Kontrole prezentacije';

  @override
  String get nextSlide => 'Sledeći slajd';

  @override
  String get nextSlideDescription =>
      'Prevucite udesno ili pritisnite desnu strelicu da pređete na sledeći slajd';

  @override
  String get previousSlide => 'Prethodni slajd';

  @override
  String get previousSlideDescription =>
      'Prevucite ulevo ili pritisnite levu strelicu da se vratite na prethodni slajd';

  @override
  String get exitPresentation => 'Izađi iz prezentacije';

  @override
  String get exitPresentationDescription =>
      'Pritisnite taster Esc ili prevucite nadole da izađete iz prezentacije';

  @override
  String get pausePresentation => 'Pauziraj prezentaciju';

  @override
  String get pausePresentationDescription =>
      'Dodirnite ekran ili pritisnite razmaknicu da pauzirate ili nastavite prezentaciju';

  @override
  String get keyframe => 'Ključni kadar';

  @override
  String get endOfPresentation => 'Došli ste do kraja prezentacije';

  @override
  String get startOfPresentation => 'Došli ste do početka prezentacije';

  @override
  String get palettes => 'Palete';

  @override
  String headline(int index) {
    return 'Naslov $index';
  }

  @override
  String get code => 'Kod';

  @override
  String get quote => 'Citat';

  @override
  String get link => 'Link';

  @override
  String get checkbox => 'Polje za potvrdu';

  @override
  String get deleted => 'Obrisano';

  @override
  String get emphasis => 'Naglasak';

  @override
  String get listBullet => 'Znak za nabrajanje';

  @override
  String get strong => 'Jako';

  @override
  String get markdown => 'Markdown';

  @override
  String get home => 'Početna';

  @override
  String get files => 'Datoteke';

  @override
  String get sortBy => 'Sortiraj po';

  @override
  String get location => 'Lokacija';

  @override
  String get whatsNew => 'Šta je novo?';

  @override
  String get unstar => 'Ukloni zvezdicu';

  @override
  String get star => 'Dodaj zvezdicu';

  @override
  String get goUp => 'Idi gore';

  @override
  String get created => 'Kreirano';

  @override
  String get modified => 'Izmenjeno';

  @override
  String get quickstart => 'Brzi početak';

  @override
  String get noTemplates => 'Trenutno nema dostupnih šablona';

  @override
  String get importCorePack => 'Uvezi osnovni paket';

  @override
  String get importCorePackDescription =>
      'Uvezite osnovni paket koji sadrži sve osnovne resurse za početak. Ovo će prepisati trenutni osnovni paket.';

  @override
  String get never => 'Nikada';

  @override
  String get onlyOnUpdates => 'Samo pri ažuriranjima';

  @override
  String get visibility => 'Vidljivost';

  @override
  String get captureThumbnail => 'Snimi sličicu';

  @override
  String get capturedThumbnail => 'Uspešno snimljena sličica';

  @override
  String get chooseLabelMode => 'Izaberite režim oznake';

  @override
  String get foreground => 'Prednji plan';

  @override
  String get version => 'Verzija';

  @override
  String get repository => 'Repozitorijum';

  @override
  String get pages => 'Stranice';

  @override
  String get navigator => 'Navigator';

  @override
  String get arrange => 'Rasporedi';

  @override
  String get bringToFront => 'Dovedi napred';

  @override
  String get sendToBack => 'Pošalji nazad';

  @override
  String get bringForward => 'Pomeri napred';

  @override
  String get sendBackward => 'Pomeri nazad';

  @override
  String get rotation => 'Rotacija';

  @override
  String get onlyAvailableLargerScreen => 'Dostupno samo na većim ekranima';

  @override
  String get toolbarPosition => 'Pozicija trake sa alatkama';

  @override
  String get rotate => 'Rotiraj';

  @override
  String get spacer => 'Odstojnik';

  @override
  String get navigationRail => 'Navigaciona traka';

  @override
  String get cut => 'Iseci';

  @override
  String get insertBefore => 'Ubaci pre';

  @override
  String get insertAfter => 'Ubaci posle';

  @override
  String get insertFirst => 'Ubaci na početak';

  @override
  String get insertLast => 'Ubaci na kraj';

  @override
  String get paste => 'Nalepi';

  @override
  String get ascending => 'Uzlazno';

  @override
  String get descending => 'Silazno';

  @override
  String get imageScale => 'Skala slike';

  @override
  String get select => 'Izaberi';

  @override
  String get tool => 'Alat';

  @override
  String get texture => 'Tekstura';

  @override
  String get platformTheme => 'Tema platforme';

  @override
  String get desktop => 'Desktop';

  @override
  String get mobile => 'Mobilni';

  @override
  String get pdfQuality => 'Kvalitet PDF-a';

  @override
  String get surface => 'Površina';

  @override
  String get pattern => 'Šablon';

  @override
  String get sureClose => 'Da li ste sigurni da želite da zatvorite dokument?';

  @override
  String get thereAreUnsavedChanges => 'Postoje nesačuvane izmene';

  @override
  String get page => 'Stranica';

  @override
  String get iceServers => 'ICE serveri';

  @override
  String get collaboration => 'Saradnja';

  @override
  String get webRtc => 'Web RTC';

  @override
  String get webSocket => 'Web Socket';

  @override
  String get iceServer => 'ICE Server';

  @override
  String get port => 'Port';

  @override
  String get type => 'Tip';

  @override
  String get side => 'Strana';

  @override
  String get client => 'Klijent';

  @override
  String get server => 'Server';

  @override
  String get switchView => 'Promeni prikaz';

  @override
  String get lasso => 'Laso';

  @override
  String get hideUI => 'Sakrij interfejs';

  @override
  String get density => 'Gustina';

  @override
  String get compact => 'Kompaktno';

  @override
  String get comfortable => 'Komforno';

  @override
  String get standard => 'Standardno';

  @override
  String get lock => 'Zaključaj';

  @override
  String get addElement => 'Dodaj element';

  @override
  String get notDefaultConnection => 'Nije podrazumevana konekcija';

  @override
  String get defaultConnection => 'Podrazumevana konekcija';

  @override
  String get hide => 'Sakrij';

  @override
  String get show => 'Prikaži';

  @override
  String get pause => 'Pauziraj';

  @override
  String get stop => 'Zaustavi';

  @override
  String get refresh => 'Osveži';

  @override
  String get print => 'Štampaj';

  @override
  String get dav => 'DAV';

  @override
  String get eyeDropper => 'Kapaljka';

  @override
  String get users => 'Korisnici';

  @override
  String get experiments => 'Eksperimenti';

  @override
  String get experimentsWarning =>
      'Ove funkcije su eksperimentalne i mogu se promeniti, pokvariti ili nestati u bilo kom trenutku. Njihovo omogućavanje može izazvati nestabilnost ili gubitak podataka. Nastavite s oprezom. Molimo prijavite sve greške.';

  @override
  String get address => 'Adresa';

  @override
  String get spreadToPages => 'Proširi na stranice';

  @override
  String get rootDirectorySpecifiedDescription =>
      'Korenski direktorijum je naveden. Sve napredne putanje direktorijuma biće relativne u odnosu na ovaj direktorijum. Ostavite prazno da biste onemogućili ovaj tip direktorijuma.';

  @override
  String get rootDirectoryNotSpecifiedDescription =>
      'Korenski direktorijum nije naveden. Ime je obavezno. Sve napredne putanje direktorijuma biće apsolutne. Ostavite prazno da biste onemogućili ovaj tip direktorijuma.';

  @override
  String get unsecureConnectionTitle => 'Nebezbedna konekcija';

  @override
  String unsecureConnectionMessage(String fingerprint) {
    return 'Konekcija nije bezbedna. Ovo može predstavljati bezbednosni rizik. Molimo nastavite samo ako verujete konekciji. SHA1 otisak prsta je $fingerprint.';
  }

  @override
  String get continueAnyway => 'Nastavi svejedno';

  @override
  String get zoomControl => 'Kontrola zumiranja';

  @override
  String get highContrast => 'Visok kontrast';

  @override
  String get shouldANumber => 'Ova vrednost treba da bude važeći broj';

  @override
  String get createAreas => 'Kreiraj oblasti';

  @override
  String get autosave => 'Automatsko čuvanje';

  @override
  String get invert => 'Invertuj';

  @override
  String get operations => 'Operacije';

  @override
  String get medium => 'Srednje';

  @override
  String get large => 'Veliko';

  @override
  String get toolbarSize => 'Veličina trake sa alatkama';

  @override
  String get addAll => 'Dodaj sve';

  @override
  String get onlyCurrentPage => 'Samo trenutna stranica';

  @override
  String get smoothNavigation => 'Glatka navigacija';

  @override
  String get exact => 'Tačno';

  @override
  String get inline => 'Unutar linije';

  @override
  String get toolbarRows => 'Redovi trake sa alatkama';

  @override
  String get pointerTest => 'Test pokazivača';

  @override
  String get pressure => 'Pritisak';

  @override
  String get small => 'Malo';

  @override
  String get tiny => 'Sitno';

  @override
  String get selectAll => 'Izaberi sve';

  @override
  String get overrideTools => 'Prepiši alate';

  @override
  String get hideCursorWhileDrawing => 'Sakrij kursor tokom crtanja';

  @override
  String get installed => 'Instalirano';

  @override
  String get install => 'Instaliraj';

  @override
  String get deselect => 'Poništi izbor';

  @override
  String get changeCollection => 'Promeni kolekciju';

  @override
  String get collections => 'Kolekcije';

  @override
  String get fullSelection => 'Potpuna selekcija';

  @override
  String get fullSelectionDescription =>
      'Zahteva da elementi budu u potpunosti unutar okvira za selekciju da bi bili izabrani.';

  @override
  String get collection => 'Kolekcija';

  @override
  String get defaultCollection => 'Podrazumevana kolekcija';

  @override
  String get scroll => 'Skroluj';

  @override
  String get onStartup => 'Pri pokretanju';

  @override
  String get homeScreen => 'Početni ekran';

  @override
  String get lastNote => 'Poslednja beleška';

  @override
  String get newNote => 'Nova beleška';

  @override
  String get convertToLayer => 'Pretvori u sloj';

  @override
  String get merge => 'Spoji';

  @override
  String get up => 'Gore';

  @override
  String get down => 'Dole';

  @override
  String get other => 'Drugo';

  @override
  String countElements(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count elementa',
      one: '1 element',
      zero: 'Nema elemenata',
    );
    return '$_temp0';
  }

  @override
  String get colorToolbar => 'Traka sa bojama';

  @override
  String get yesButShowButtons => 'Da, ali prikaži dugmad';

  @override
  String get optionsPanelPosition => 'Pozicija panela sa opcijama';

  @override
  String get hideDuration => 'Sakrij trajanje';

  @override
  String get animation => 'Animacija';

  @override
  String get performance => 'Performanse';

  @override
  String get performanceDescription =>
      'Optimizovano za brzinu i korišćenje memorije. Samo vidljivi deo beleške se renderuje u sliku.';

  @override
  String get normalDescription =>
      'Balansira kvalitet i performanse. Renderuje sliku koja pokriva 1,5 puta vidljivu oblast, pružajući glatkije prelaze pri skrolovanju.';

  @override
  String get high => 'Visoko';

  @override
  String get highDescription =>
      'Maximizes quality at the cost of performance. Bakes an image covering 2 times the visible area, ensuring seamless rendering even during rapid scrolling or zooming.';

  @override
  String get renderResolution => 'Rezolucija renderovanja';

  @override
  String get translate => 'Prevedi';

  @override
  String get unencrypted => 'Nešifrovano';

  @override
  String get encrypted => 'Šifrovano';

  @override
  String get encryptDocumentMessage => 'Kliknite da šifrujete dokument';

  @override
  String get unencryptDocumentMessage => 'Kliknite da dešifrujete dokument';

  @override
  String get unencrypt => 'Dešifruj';

  @override
  String get encrypt => 'Šifruj';

  @override
  String get encryptWarning =>
      'Ovo će šifrovati dokument. Moraćete da zapamtite lozinku da biste ga dešifrovali.';

  @override
  String get unencryptWarning =>
      'Ovo će dešifrovati dokument. Lozinka će biti uklonjena i svako sa pristupom će moći da ga otvori.';

  @override
  String get confirmPassword => 'Potvrdi lozinku';

  @override
  String get passwordMismatch => 'Lozinke se ne podudaraju';

  @override
  String get action => 'Akcija';

  @override
  String get svgText => 'SVG Tekst';

  @override
  String get offset => 'Pomak';

  @override
  String get positionDependent => 'Zavisno od pozicije';

  @override
  String get flipHorizontal => 'Okreni horizontalno';

  @override
  String get flipVertical => 'Okreni vertikalno';

  @override
  String get grayscale => 'Sivi tonovi';

  @override
  String get moveOnGesture => 'Pomeri na pokret';

  @override
  String get exportAllFiles => 'Izvezi sve datoteke';

  @override
  String get restoreSettingsFromFile => 'Vrati podešavanja iz datoteke';

  @override
  String get exportSettingsToFile => 'Izvezi podešavanja u datoteku';

  @override
  String get barcode => 'Barkod';

  @override
  String get barcodeType => 'Tip barkoda';

  @override
  String get qrCode => 'QR kod';

  @override
  String get dataMatrix => 'Data Matrix';

  @override
  String get code128 => 'Code 128';

  @override
  String defaultUserName(int index) {
    return 'Korisnik $index';
  }

  @override
  String get moveLeft => 'Pomeri levo';

  @override
  String get moveRight => 'Pomeri desno';

  @override
  String get bundledPacks => 'Uključeni paketi';

  @override
  String get component => 'Component';

  @override
  String get selectComponent => 'Izaberi komponentu';

  @override
  String get bundlePackInDocument => 'Uključi paket u dokument';

  @override
  String get bundledPacksDescription =>
      'Uključeni paketi su sadržani u dokumentu i koriste se samo za deljenje sa dokumentom. Resursi se mogu koristiti u dokumentu samo ako je paket instaliran. Paketi se mogu instalirati klikom na njih.';

  @override
  String get fillAlpha => 'Alfa popune';

  @override
  String get packagedFile => 'Upakovana datoteka';

  @override
  String get rawFile => 'Sirova datoteka';

  @override
  String get webSocketDescription =>
      'Vaš uređaj hostuje server, tako da se saradnici mogu pridružiti samo preko iste mreže ili sa bilo kog mesta ako prosledite port na svom ruteru.';

  @override
  String get swampDescription =>
      'Vaše poruke se rutiraju kroz siguran relejni server sa end-to-end enkripcijom. Adresa swamp servera je potrebna za kreiranje sesije.';

  @override
  String get createRawNote => 'Kreiraj sirovu belešku';

  @override
  String get polygon => 'Poligon';

  @override
  String get finishShape => 'Završi oblik';

  @override
  String get submit => 'Pošalji';

  @override
  String get math => 'Math';

  @override
  String get ignorePressure => 'Ignore pressure';

  @override
  String get ignoreFirstPressureDescription =>
      'On some devices, the first pressure value is not accurate. This setting will ignore the first pressure value and use the pressure of the second event instead.';

  @override
  String get temporary => 'Temporary';

  @override
  String get simpleToolbarVisibility => 'Simple toolbar visibility';

  @override
  String get autosaveDelay => 'Autosave delay';

  @override
  String get saved => 'Saved';

  @override
  String get saving => 'Saving...';

  @override
  String get readOnly => 'Read only';

  @override
  String get saveDelayed => 'Save delayed';

  @override
  String get unsaved => 'Unsaved';

  @override
  String get pdfEmptyDescription =>
      'There are currently no areas to export. Please select at least one area using the plus button in the top right corner or add all areas from the current page or from the whole document below.';

  @override
  String get densityMaximize => 'Maximize';
}
