// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Korean (`ko`).
class AppLocalizationsKo extends AppLocalizations {
  AppLocalizationsKo([String locale = 'ko']) : super(locale);

  @override
  String get open => '열기';

  @override
  String get settings => '설정';

  @override
  String get personalization => '개인화';

  @override
  String get theme => '테마';

  @override
  String get darkTheme => '어두운 테마';

  @override
  String get lightTheme => '밝은 테마';

  @override
  String get systemTheme => '시스템 기본 테마 사용';

  @override
  String get view => '보기';

  @override
  String get edit => '편집';

  @override
  String get export => '내보내기';

  @override
  String get save => '저장';

  @override
  String get zoom => '확대/축소';

  @override
  String get zoomIn => '확대';

  @override
  String get zoomOut => '축소';

  @override
  String get resetZoom => '확대/축소 초기화';

  @override
  String get strokeWidth => '선 굵기';

  @override
  String get includeEraser => '지우개 포함?';

  @override
  String get thinning => '필압 감지';

  @override
  String get pen => '펜';

  @override
  String get invertedPen => '반전 펜';

  @override
  String get eraser => '지우개';

  @override
  String get pathEraser => '경로 지우개';

  @override
  String get label => '레이블';

  @override
  String get delete => '삭제';

  @override
  String get areYouSure => '확실하신가요?';

  @override
  String get reallyDelete => '이 항목을 정말로 삭제하시겠습니까?';

  @override
  String get no => '아니요';

  @override
  String get yes => '예';

  @override
  String get undo => '실행 취소';

  @override
  String get redo => '다시 실행';

  @override
  String get general => '일반';

  @override
  String get copyTitle => '클립보드에 복사됨';

  @override
  String get loading => '로드 중...';

  @override
  String get enterText => '텍스트를 입력하세요';

  @override
  String get size => '크기';

  @override
  String get width => '너비';

  @override
  String get height => '높이';

  @override
  String get count => '개수';

  @override
  String get space => '공간';

  @override
  String get background => '배경';

  @override
  String get box => '상자';

  @override
  String get locale => '언어';

  @override
  String get systemLocale => '시스템 언어';

  @override
  String get information => '정보';

  @override
  String get license => '라이선스';

  @override
  String get imprint => '제작 정보';

  @override
  String get privacypolicy => '개인정보처리방침';

  @override
  String get sourceCode => '소스 코드';

  @override
  String get documentation => '문서';

  @override
  String get changelog => '변경 로그';

  @override
  String get source => '소스';

  @override
  String get existOverride => '이 요소가 이미 존재합니다. 덮어쓰시겠습니까?';

  @override
  String get description => '설명';

  @override
  String get fill => '채우기';

  @override
  String get defaultPalette => '기본 팔레트';

  @override
  String get highlighter => '형광펜';

  @override
  String get add => '추가';

  @override
  String get remove => '제거';

  @override
  String get removeConfirm => '정말로 제거하시겠습니까?';

  @override
  String get resetPalette => '팔레트 초기화';

  @override
  String get custom => '사용자 지정';

  @override
  String get decoration => '장식';

  @override
  String get underline => '밑줄';

  @override
  String get overline => '윗줄';

  @override
  String get strikethrough => '취소선';

  @override
  String get thickness => '두께';

  @override
  String get style => '스타일';

  @override
  String get solid => '실선';

  @override
  String get double => '이중선';

  @override
  String get dotted => '점선';

  @override
  String get dashed => '파선';

  @override
  String get wavy => '물결선';

  @override
  String get fontWeight => '글꼴 두께';

  @override
  String get normal => '보통';

  @override
  String get bold => '굵게';

  @override
  String get italic => '기울임꼴';

  @override
  String get clipboard => '클립보드';

  @override
  String get file => '파일';

  @override
  String get data => '데이터';

  @override
  String get share => '공유';

  @override
  String get spacing => '간격';

  @override
  String get image => '이미지';

  @override
  String get enterUrl => 'URL을 입력하세요';

  @override
  String get scale => '배율';

  @override
  String get help => '도움말';

  @override
  String get reallyReset => '정말로 초기화하시겠습니까?';

  @override
  String get whatToDo => '어떻게 하시겠습니까?';

  @override
  String get ignore => '무시';

  @override
  String get backup => '백업';

  @override
  String createdInNewerVersion(String fileName, int fileVersion) {
    return '파일 $fileName이(가) 더 새로운 버전($fileVersion)에서 생성되었습니다. 이 파일을 어떻게 처리할까요?';
  }

  @override
  String get waypoints => '경유지';

  @override
  String get origin => '원본';

  @override
  String get import => '가져오기';

  @override
  String get newContent => '새로 만들기';

  @override
  String get selectElement => '요소 선택';

  @override
  String get ctrlKey => 'Ctrl';

  @override
  String get shiftKey => 'Shift';

  @override
  String get altKey => 'Alt';

  @override
  String get copyVersion => '버전 복사';

  @override
  String get input => '입력';

  @override
  String get behaviors => '동작';

  @override
  String get dataDirectory => '데이터 디렉터리';

  @override
  String get defaultPath => '기본 경로';

  @override
  String get dateFormat => '날짜 형식';

  @override
  String updatedAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return '업데이트: $dateTimeString';
  }

  @override
  String createdAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return '생성: $dateTimeString';
  }

  @override
  String get rename => '이름 바꾸기';

  @override
  String get duplicate => '복제';

  @override
  String get hand => '손';

  @override
  String get folder => '폴더';

  @override
  String get move => '이동';

  @override
  String get copy => '복사';

  @override
  String get back => '뒤로';

  @override
  String get zoomDependent => '확대/축소에 따라';

  @override
  String get shapeDetection => '도형 인식';

  @override
  String get delay => '지연';

  @override
  String get defaultLayer => '기본 레이어';

  @override
  String get layer => '레이어';

  @override
  String get layers => '레이어';

  @override
  String get notSet => '설정 안 됨';

  @override
  String get enterLayer => '레이어 이름을 입력하세요';

  @override
  String get selectElements => '요소 선택';

  @override
  String get deleteElements => '요소 삭제';

  @override
  String get deleteElementsConfirm => '선택한 요소를 정말로 삭제하시겠습니까?';

  @override
  String get selectCustomCollection => '사용자 지정 컬렉션 선택';

  @override
  String get svg => 'SVG';

  @override
  String get sensitivity => '민감도';

  @override
  String get sensitivityHint => '값이 높을수록 입력이 더 민감해집니다';

  @override
  String get horizontal => '가로';

  @override
  String get vertical => '세로';

  @override
  String get plain => '무지';

  @override
  String get light => '밝음';

  @override
  String get ruled => '줄무늬';

  @override
  String get quad => '격자';

  @override
  String get music => '오선지';

  @override
  String get dark => '어두움';

  @override
  String get plainDark => '어두운 무지';

  @override
  String get ruledDark => '어두운 줄무늬';

  @override
  String get quadDark => '어두운 격자';

  @override
  String get musicDark => '어두운 오선지';

  @override
  String get templates => '템플릿';

  @override
  String get untitled => '제목 없음';

  @override
  String get createTemplate => '템플릿 만들기';

  @override
  String get createTemplateContent => '이 문서로 템플릿을 만드시겠습니까? 원본 문서는 삭제됩니다.';

  @override
  String get replace => '바꾸기';

  @override
  String get reallyReplace => '템플릿을 정말로 바꾸시겠습니까? 이 작업은 되돌릴 수 없습니다!';

  @override
  String get defaultTemplate => '기본 템플릿';

  @override
  String get insert => '삽입';

  @override
  String get document => '문서';

  @override
  String get camera => '카메라';

  @override
  String get printout => '인쇄물';

  @override
  String get selectCamera => '카메라 선택';

  @override
  String get changeDocumentPath => '문서 경로 변경';

  @override
  String get deleteWholeStroke => '전체 획 삭제';

  @override
  String get alpha => '알파';

  @override
  String get area => '영역';

  @override
  String get selectArea => '영역 선택';

  @override
  String get aspectRatio => '종횡비';

  @override
  String get presets => '프리셋';

  @override
  String get pagePortrait => '세로 페이지';

  @override
  String get pageLandscape => '가로 페이지';

  @override
  String get square => '정사각형';

  @override
  String get areas => '영역';

  @override
  String get enterArea => '영역 입력';

  @override
  String get exitArea => '영역 나가기';

  @override
  String get currentArea => '현재 영역';

  @override
  String get design => '디자인';

  @override
  String get text => '텍스트';

  @override
  String welcome(String codeName) {
    return '안녕하세요, Linwood Butterfly $codeName입니다';
  }

  @override
  String get welcomeContent => '자유로운 오픈소스 드로잉 공간입니다!';

  @override
  String updated(String version) {
    return '앱이 $version 버전으로 업데이트되었습니다';
  }

  @override
  String get releaseNotes => '릴리스 노트';

  @override
  String get constraints => '제약 조건';

  @override
  String get scaled => '비율 유지';

  @override
  String get fixed => '고정';

  @override
  String get dynamicContent => '동적';

  @override
  String get none => '없음';

  @override
  String get includeArea => '영역 포함';

  @override
  String get verticalAlignment => '세로 정렬';

  @override
  String get horizontalAlignment => '가로 정렬';

  @override
  String get top => '위쪽';

  @override
  String get center => '가운데';

  @override
  String get bottom => '아래쪽';

  @override
  String get left => '왼쪽';

  @override
  String get right => '오른쪽';

  @override
  String get justify => '양쪽 맞춤';

  @override
  String get constraint => '제약 조건';

  @override
  String get length => '길이';

  @override
  String get exportSvg => 'SVG로 내보내기';

  @override
  String get pdf => 'PDF';

  @override
  String get selectPages => '페이지 선택';

  @override
  String get recentFiles => '최근 파일';

  @override
  String get start => '시작';

  @override
  String get noRecentFiles => '최근 파일 없음';

  @override
  String countPages(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 페이지',
      one: '1 페이지',
      zero: '페이지 없음',
    );
    return '$_temp0';
  }

  @override
  String pageIndex(int index) {
    return '페이지 $index';
  }

  @override
  String get exit => '종료';

  @override
  String get noElements => '요소 없음';

  @override
  String get invertSelection => '선택 반전';

  @override
  String get errorWhileImporting => '가져오는 중 오류 발생';

  @override
  String get errorWhileImportingContent => '파일을 가져오는 중 오류가 발생했습니다';

  @override
  String get showDetails => '자세히 보기';

  @override
  String get hideDetails => '자세히 숨기기';

  @override
  String get error => '오류';

  @override
  String get stackTrace => '스택 추적';

  @override
  String get laser => '레이저';

  @override
  String get duration => '지속 시간';

  @override
  String get quality => '품질';

  @override
  String get exportPdf => 'PDF로 내보내기';

  @override
  String get local => '로컬';

  @override
  String get addConnection => '연결 추가';

  @override
  String get connections => '연결';

  @override
  String get noConnections => '연결 없음';

  @override
  String get url => 'URL';

  @override
  String get connect => '연결';

  @override
  String get username => '사용자 이름';

  @override
  String get password => '비밀번호';

  @override
  String get webNotSupported => '웹은 지원되지 않습니다';

  @override
  String get advanced => '고급';

  @override
  String get directory => '디렉터리';

  @override
  String get documentsDirectory => '문서 디렉터리';

  @override
  String get templatesDirectory => '템플릿 디렉터리';

  @override
  String get errorWhileCreatingConnection => '연결 생성 중 오류 발생';

  @override
  String get cannotConnect => '연결할 수 없습니다';

  @override
  String get urlNotValid => '유효하지 않은 URL입니다';

  @override
  String get icon => '아이콘';

  @override
  String get update => '업데이트';

  @override
  String get updateAvailable => '업데이트 가능';

  @override
  String get stable => '안정';

  @override
  String get nightly => '나이틀리';

  @override
  String get checkForUpdates => '업데이트 확인';

  @override
  String get checkForUpdatesWarning =>
      '업데이트를 확인하면 Butterfly 웹사이트에 연결하여 정보를 가져옵니다.';

  @override
  String get usingLatestStable => '최신 안정 버전을 사용하고 있습니다';

  @override
  String get usingLatestNightly => '최신 나이틀리 버전을 사용하고 있습니다';

  @override
  String get currentVersion => '현재 버전';

  @override
  String get updateNow => '지금 업데이트';

  @override
  String get shape => '도형';

  @override
  String get circle => '원';

  @override
  String get rectangle => '사각형';

  @override
  String get triangle => '삼각형';

  @override
  String get line => '선';

  @override
  String get cornerRadius => '모서리 반지름';

  @override
  String get topLeft => '왼쪽 위';

  @override
  String get topRight => '오른쪽 위';

  @override
  String get bottomLeft => '왼쪽 아래';

  @override
  String get bottomRight => '오른쪽 아래';

  @override
  String get caches => '캐시';

  @override
  String get manage => '관리';

  @override
  String get clearCaches => '캐시 지우기';

  @override
  String get createCache => '캐시 생성';

  @override
  String get thirdPartyLicenses => '서드파티 라이선스';

  @override
  String get syncing => '동기화 중...';

  @override
  String get synced => '동기화됨';

  @override
  String get notSynced => '동기화되지 않음';

  @override
  String get conflict => '충돌';

  @override
  String get keepLocal => '로컬 파일 유지';

  @override
  String get keepConnection => '연결 파일 유지';

  @override
  String get keepBoth => '둘 다 유지';

  @override
  String get forAll => '모두에 적용';

  @override
  String fileConflict(String file, String connection) {
    return '$connection의 $file에 충돌이 발생했습니다';
  }

  @override
  String get offline => '오프라인';

  @override
  String get localLatest => '로컬이 최신';

  @override
  String get connectionLatest => '연결이 최신';

  @override
  String get path => '경로';

  @override
  String get folderSynced => '폴더 동기화됨';

  @override
  String get syncRootDirectory => '루트 디렉터리 동기화';

  @override
  String get penOnlyInput => '펜 전용 입력';

  @override
  String get inputGestures => '입력 제스처';

  @override
  String get nativeTitleBar => '네이티브 제목 표시줄';

  @override
  String get syncMode => '동기화 모드';

  @override
  String get connection => '연결';

  @override
  String get always => '항상';

  @override
  String get noMobile => '모바일 제외';

  @override
  String get manual => '수동';

  @override
  String get search => '검색';

  @override
  String get properties => '속성';

  @override
  String get pin => '고정';

  @override
  String get unpin => '고정 해제';

  @override
  String get element => '요소';

  @override
  String get painter => '페인터';

  @override
  String get position => '위치';

  @override
  String get note => '노트';

  @override
  String get packs => '팩';

  @override
  String get pack => '팩';

  @override
  String get more => '더 보기';

  @override
  String get askForName => '이름 요청';

  @override
  String areaIndex(int index) {
    return '영역 $index';
  }

  @override
  String get startInFullScreen => '전체 화면으로 시작';

  @override
  String get inputs => '입력';

  @override
  String get mouse => '마우스';

  @override
  String get touch => '터치';

  @override
  String get keyboard => '키보드';

  @override
  String get shortcuts => '단축키';

  @override
  String get middle => '가운데';

  @override
  String get first => '첫 번째';

  @override
  String get second => '두 번째';

  @override
  String get activeTool => '활성 도구';

  @override
  String get activeToolDescription => '도구 모음에서 현재 선택된 도구를 사용합니다';

  @override
  String get handTool => '손 도구';

  @override
  String get handToolDescription => '드래그하여 캔버스 주위를 이동합니다';

  @override
  String get toolOnToolbar => '도구 모음의 특정 도구';

  @override
  String get toolOnToolbarDescription =>
      '왼쪽부터 시작하여 도구 모음의 지정된 위치에 있는 도구를 사용합니다';

  @override
  String toolOnToolbarShort(int display_position) {
    return '도구 모음 위치: $display_position';
  }

  @override
  String get tools => '도구';

  @override
  String get showGrid => '격자 보기';

  @override
  String get grid => '격자';

  @override
  String get ruler => '자';

  @override
  String get angle => '각도';

  @override
  String get report => '보고';

  @override
  String get newFolder => '새 폴더';

  @override
  String get createPack => '팩 만들기';

  @override
  String get editPack => '팩 편집';

  @override
  String get packsDirectory => '팩 디렉터리';

  @override
  String get stamp => '스탬프';

  @override
  String get addToPack => '팩에 추가';

  @override
  String get sureImportPack => '팩을 가져오시겠습니까?';

  @override
  String byAuthor(String author) {
    return '$author 작성';
  }

  @override
  String get author => '작성자';

  @override
  String get addAsset => '에셋 추가';

  @override
  String get editAsset => '에셋 편집';

  @override
  String get scope => '범위';

  @override
  String get noPacks => '현재 사용 가능한 팩이 없습니다';

  @override
  String get components => '구성 요소';

  @override
  String get waypoint => '경유지';

  @override
  String get actions => '작업';

  @override
  String get painters => '페인터';

  @override
  String get breakingChangesTitle => '호환성이 손상되는 변경';

  @override
  String breakingChangesMessage(int version, int newVersion) {
    return '이 버전에는 호환성이 손상되는 변경 사항이 있습니다. 업데이트하기 전에 변경 로그를 읽어주세요. 현재 파일 버전은 $version이고, 새 버전은 $newVersion입니다.';
  }

  @override
  String get styles => '스타일';

  @override
  String get paragraph => '단락';

  @override
  String get fontFamily => '글꼴';

  @override
  String get smoothing => '부드럽게';

  @override
  String get streamline => '스트림라인';

  @override
  String get presentation => '프레젠테이션';

  @override
  String get selectAsset => '에셋 선택';

  @override
  String get clearStyle => '스타일 지우기';

  @override
  String get unknownImportType => '알 수 없는 가져오기 유형';

  @override
  String get sureImportTemplate => '템플릿을 가져오시겠습니까?';

  @override
  String get frame => '프레임';

  @override
  String get play => '재생';

  @override
  String get video => '비디오';

  @override
  String get fps => 'FPS';

  @override
  String get breakpoint => '중단점';

  @override
  String get presentationControls => '프레젠테이션 컨트롤';

  @override
  String get nextSlide => '다음 슬라이드';

  @override
  String get nextSlideDescription =>
      '오른쪽으로 스와이프하거나 오른쪽 화살표 키를 눌러 다음 슬라이드로 이동합니다';

  @override
  String get previousSlide => '이전 슬라이드';

  @override
  String get previousSlideDescription =>
      '왼쪽으로 스와이프하거나 왼쪽 화살표 키를 눌러 이전 슬라이드로 이동합니다';

  @override
  String get exitPresentation => '프레젠테이션 종료';

  @override
  String get exitPresentationDescription =>
      'Esc 키를 누르거나 아래로 스와이프하여 프레젠테이션을 종료합니다';

  @override
  String get pausePresentation => '프레젠테이션 일시 중지';

  @override
  String get pausePresentationDescription =>
      '화면을 탭하거나 스페이스바를 눌러 프레젠테이션을 일시 중지하거나 다시 시작합니다';

  @override
  String get keyframe => '키프레임';

  @override
  String get endOfPresentation => '프레젠테이션의 끝에 도달했습니다';

  @override
  String get startOfPresentation => '프레젠테이션의 시작에 도달했습니다';

  @override
  String get palettes => '팔레트';

  @override
  String headline(int index) {
    return '헤드라인 $index';
  }

  @override
  String get code => '코드';

  @override
  String get quote => '인용';

  @override
  String get link => '링크';

  @override
  String get checkbox => '체크박스';

  @override
  String get deleted => '삭제됨';

  @override
  String get emphasis => '강조';

  @override
  String get listBullet => '목록 글머리 기호';

  @override
  String get strong => '굵게';

  @override
  String get markdown => '마크다운';

  @override
  String get home => '홈';

  @override
  String get files => '파일';

  @override
  String get sortBy => '정렬 기준';

  @override
  String get location => '위치';

  @override
  String get whatsNew => '새로운 기능은?';

  @override
  String get unstar => '별표 해제';

  @override
  String get star => '별표';

  @override
  String get goUp => '위로 가기';

  @override
  String get created => '생성일';

  @override
  String get modified => '수정일';

  @override
  String get quickstart => '빠른 시작';

  @override
  String get noTemplates => '현재 사용 가능한 템플릿이 없습니다';

  @override
  String get importCorePack => '코어 팩 가져오기';

  @override
  String get importCorePackDescription =>
      '시작하는 데 필요한 모든 기본 에셋이 포함된 코어 팩을 가져옵니다. 이렇게 하면 현재 코어 팩을 덮어씁니다.';

  @override
  String get never => '안 함';

  @override
  String get onlyOnUpdates => '업데이트 시에만';

  @override
  String get visibility => '표시 여부';

  @override
  String get captureThumbnail => '미리보기 이미지 캡처';

  @override
  String get capturedThumbnail => '미리보기 이미지를 성공적으로 캡처했습니다';

  @override
  String get chooseLabelMode => '레이블 모드 선택';

  @override
  String get foreground => '전경';

  @override
  String get version => '버전';

  @override
  String get repository => '리포지토리';

  @override
  String get pages => '페이지';

  @override
  String get navigator => '탐색기';

  @override
  String get arrange => '정렬';

  @override
  String get bringToFront => '맨 앞으로 가져오기';

  @override
  String get sendToBack => '맨 뒤로 보내기';

  @override
  String get bringForward => '앞으로 가져오기';

  @override
  String get sendBackward => '뒤로 보내기';

  @override
  String get rotation => '회전';

  @override
  String get onlyAvailableLargerScreen => '더 큰 화면에서만 사용 가능';

  @override
  String get toolbarPosition => '도구 모음 위치';

  @override
  String get rotate => '회전';

  @override
  String get spacer => '간격';

  @override
  String get navigationRail => '탐색 레일';

  @override
  String get cut => '잘라내기';

  @override
  String get insertBefore => '앞에 삽입';

  @override
  String get insertAfter => '뒤에 삽입';

  @override
  String get insertFirst => '맨 앞에 삽입';

  @override
  String get insertLast => '맨 뒤에 삽입';

  @override
  String get paste => '붙여넣기';

  @override
  String get ascending => '오름차순';

  @override
  String get descending => '내림차순';

  @override
  String get imageScale => '이미지 배율';

  @override
  String get select => '선택';

  @override
  String get tool => '도구';

  @override
  String get texture => '질감';

  @override
  String get platformTheme => '플랫폼 테마';

  @override
  String get desktop => '데스크톱';

  @override
  String get mobile => '모바일';

  @override
  String get pdfQuality => 'PDF 품질';

  @override
  String get surface => '표면';

  @override
  String get pattern => '패턴';

  @override
  String get sureClose => '문서를 닫으시겠습니까?';

  @override
  String get thereAreUnsavedChanges => '저장되지 않은 변경 사항이 있습니다';

  @override
  String get page => '페이지';

  @override
  String get iceServers => 'ICE 서버';

  @override
  String get collaboration => '협업';

  @override
  String get webRtc => 'Web RTC';

  @override
  String get webSocket => '웹 소켓';

  @override
  String get iceServer => 'ICE 서버';

  @override
  String get port => '포트';

  @override
  String get type => '유형';

  @override
  String get side => '측면';

  @override
  String get client => '클라이언트';

  @override
  String get server => '서버';

  @override
  String get switchView => '보기 전환';

  @override
  String get lasso => '올가미';

  @override
  String get hideUI => 'UI 숨기기';

  @override
  String get density => '밀도';

  @override
  String get compact => '좁게';

  @override
  String get comfortable => '편안하게';

  @override
  String get standard => '표준';

  @override
  String get lock => '잠금';

  @override
  String get addElement => '요소 추가';

  @override
  String get notDefaultConnection => '기본 연결이 아님';

  @override
  String get defaultConnection => '기본 연결';

  @override
  String get hide => '숨기기';

  @override
  String get show => '표시';

  @override
  String get pause => '일시 중지';

  @override
  String get stop => '중지';

  @override
  String get refresh => '새로고침';

  @override
  String get print => '인쇄';

  @override
  String get dav => 'DAV';

  @override
  String get eyeDropper => '스포이트';

  @override
  String get users => '사용자';

  @override
  String get experiments => '실험 기능';

  @override
  String get experimentsWarning =>
      '이 기능들은 실험적이며 언제든지 변경, 중단 또는 사라질 수 있습니다. 활성화하면 불안정성이나 데이터 손실을 유발할 수 있습니다. 주의해서 진행하세요. 버그를 발견하면 보고해 주세요.';

  @override
  String get address => '주소';

  @override
  String get spreadToPages => '페이지에 펼치기';

  @override
  String get rootDirectorySpecifiedDescription =>
      '루트 디렉터리가 지정되었습니다. 모든 고급 디렉터리 경로는 이 디렉터리를 기준으로 합니다. 이 디렉터리 유형을 비활성화하려면 비워두세요.';

  @override
  String get rootDirectoryNotSpecifiedDescription =>
      '루트 디렉터리가 지정되지 않았습니다. 이름이 필요합니다. 모든 고급 디렉터리 경로는 절대 경로가 됩니다. 이 디렉터리 유형을 비활성화하려면 비워두세요.';

  @override
  String get unsecureConnectionTitle => '안전하지 않은 연결';

  @override
  String unsecureConnectionMessage(String fingerprint) {
    return '연결이 안전하지 않습니다. 보안 위험이 있을 수 있습니다. 연결을 신뢰하는 경우에만 계속하세요. SHA1 지문은 $fingerprint입니다.';
  }

  @override
  String get continueAnyway => '계속하기';

  @override
  String get zoomControl => '확대/축소 제어';

  @override
  String get highContrast => '고대비';

  @override
  String get shouldANumber => '이 값은 유효한 숫자여야 합니다';

  @override
  String get createAreas => '영역 만들기';

  @override
  String get autosave => '자동 저장';

  @override
  String get invert => '반전';

  @override
  String get operations => '작업';

  @override
  String get medium => '중간';

  @override
  String get large => '큼';

  @override
  String get toolbarSize => '도구 모음 크기';

  @override
  String get addAll => '모두 추가';

  @override
  String get onlyCurrentPage => '현재 페이지만';

  @override
  String get smoothNavigation => '부드러운 탐색';

  @override
  String get exact => '정확';

  @override
  String get inline => '인라인';

  @override
  String get toolbarRows => '도구 모음 행';

  @override
  String get pointerTest => '포인터 테스트';

  @override
  String get pressure => '필압';

  @override
  String get small => '작음';

  @override
  String get tiny => '매우 작음';

  @override
  String get selectAll => '모두 선택';

  @override
  String get overrideTools => '도구 재정의';

  @override
  String get hideCursorWhileDrawing => '그리는 동안 커서 숨기기';

  @override
  String get installed => '설치됨';

  @override
  String get install => '설치';

  @override
  String get deselect => '선택 해제';

  @override
  String get changeCollection => '컬렉션 변경';

  @override
  String get collections => '컬렉션';

  @override
  String get fullSelection => '전체 선택';

  @override
  String get fullSelectionDescription => '선택하려면 요소가 선택 상자 안에 완전히 포함되어야 합니다.';

  @override
  String get collection => '컬렉션';

  @override
  String get defaultCollection => '기본 컬렉션';

  @override
  String get scroll => '스크롤';

  @override
  String get onStartup => '시작 시';

  @override
  String get homeScreen => '홈 화면';

  @override
  String get lastNote => '마지막 노트';

  @override
  String get newNote => '새 노트';

  @override
  String get convertToLayer => '레이어로 변환';

  @override
  String get merge => '병합';

  @override
  String get up => '위로';

  @override
  String get down => '아래로';

  @override
  String get other => '기타';

  @override
  String countElements(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count개 요소',
      one: '요소 1개',
      zero: '요소 없음',
    );
    return '$_temp0';
  }

  @override
  String get colorToolbar => '색상 도구 모음';

  @override
  String get yesButShowButtons => '예, 하지만 버튼 표시';

  @override
  String get optionsPanelPosition => '옵션 패널 위치';

  @override
  String get hideDuration => '숨김 지속 시간';

  @override
  String get animation => '애니메이션';

  @override
  String get performance => '성능';

  @override
  String get performanceDescription =>
      '속도와 메모리 사용량에 최적화되었습니다. 노트의 보이는 부분만 이미지로 구워집니다.';

  @override
  String get normalDescription =>
      '품질과 성능의 균형을 맞춥니다. 보이는 영역의 1.5배를 덮는 이미지를 구워 스크롤 시 더 부드러운 전환을 제공합니다.';

  @override
  String get high => '높음';

  @override
  String get highDescription =>
      'Maximizes quality at the cost of performance. Bakes an image covering 2 times the visible area, ensuring seamless rendering even during rapid scrolling or zooming.';

  @override
  String get renderResolution => '렌더링 해상도';

  @override
  String get translate => '번역';

  @override
  String get unencrypted => '암호화되지 않음';

  @override
  String get encrypted => '암호화됨';

  @override
  String get encryptDocumentMessage => '문서를 암호화하려면 클릭하세요';

  @override
  String get unencryptDocumentMessage => '문서 암호화를 해제하려면 클릭하세요';

  @override
  String get unencrypt => '암호화 해제';

  @override
  String get encrypt => '암호화';

  @override
  String get encryptWarning => '문서가 암호화됩니다. 암호를 해제하려면 비밀번호를 기억해야 합니다.';

  @override
  String get unencryptWarning =>
      '문서 암호화가 해제됩니다. 비밀번호가 제거되며 접근 권한이 있는 모든 사람이 열 수 있습니다.';

  @override
  String get confirmPassword => '비밀번호 확인';

  @override
  String get passwordMismatch => '비밀번호가 일치하지 않습니다';

  @override
  String get action => '동작';

  @override
  String get svgText => 'SVG 텍스트';

  @override
  String get offset => '오프셋';

  @override
  String get positionDependent => '위치에 따라';

  @override
  String get flipHorizontal => '가로로 뒤집기';

  @override
  String get flipVertical => '세로로 뒤집기';

  @override
  String get grayscale => '그레이스케일';

  @override
  String get moveOnGesture => '제스처로 이동';

  @override
  String get exportAllFiles => '모든 파일 내보내기';

  @override
  String get restoreSettingsFromFile => '파일에서 설정 복원';

  @override
  String get exportSettingsToFile => '설정을 파일로 내보내기';

  @override
  String get barcode => '바코드';

  @override
  String get barcodeType => '바코드 유형';

  @override
  String get qrCode => 'QR 코드';

  @override
  String get dataMatrix => '데이터 매트릭스';

  @override
  String get code128 => '코드 128';

  @override
  String defaultUserName(int index) {
    return '사용자 $index';
  }

  @override
  String get moveLeft => '왼쪽으로 이동';

  @override
  String get moveRight => '오른쪽으로 이동';

  @override
  String get bundledPacks => '번들 팩';

  @override
  String get component => 'Component';

  @override
  String get selectComponent => '구성 요소 선택';

  @override
  String get bundlePackInDocument => '문서에 팩 번들';

  @override
  String get bundledPacksDescription =>
      '번들 팩은 문서에 포함되며 문서와 공유하는 데만 사용됩니다. 에셋은 팩이 설치된 경우에만 문서에서 사용할 수 있습니다. 팩을 클릭하여 설치할 수 있습니다.';

  @override
  String get fillAlpha => '채우기 알파';

  @override
  String get packagedFile => '패키지 파일';

  @override
  String get rawFile => '원본 파일';

  @override
  String get webSocketDescription =>
      '장치가 서버를 호스팅하므로 협업자는 동일한 네트워크를 통해서만 참여하거나 라우터에서 포트를 전달하는 경우 어디서든 참여할 수 있습니다.';

  @override
  String get swampDescription =>
      '메시지는 종단 간 암호화가 적용된 보안 릴레이 서버를 통해 라우팅됩니다. 세션을 생성하려면 스웜프 서버 주소가 필요합니다.';

  @override
  String get createRawNote => '원본 노트 만들기';

  @override
  String get polygon => '다각형';

  @override
  String get finishShape => '도형 완성';

  @override
  String get submit => '제출';

  @override
  String get math => 'Math';

  @override
  String get ignorePressure => 'Ignore pressure';

  @override
  String get ignoreFirstPressureDescription =>
      'On some devices, the first pressure value is not accurate. This setting will ignore the first pressure value and use the pressure of the second event instead.';

  @override
  String get temporary => 'Temporary';

  @override
  String get simpleToolbarVisibility => 'Simple toolbar visibility';

  @override
  String get autosaveDelay => 'Autosave delay';

  @override
  String get saved => 'Saved';

  @override
  String get saving => 'Saving...';

  @override
  String get readOnly => 'Read only';

  @override
  String get saveDelayed => 'Save delayed';

  @override
  String get unsaved => 'Unsaved';

  @override
  String get pdfEmptyDescription =>
      'There are currently no areas to export. Please select at least one area using the plus button in the top right corner or add all areas from the current page or from the whole document below.';

  @override
  String get densityMaximize => 'Maximize';
}
