// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Hindi (`hi`).
class AppLocalizationsHi extends AppLocalizations {
  AppLocalizationsHi([String locale = 'hi']) : super(locale);

  @override
  String get open => 'खोलें';

  @override
  String get settings => 'सेटिंग्स';

  @override
  String get personalization => 'वैयक्तिकरण';

  @override
  String get theme => 'थीम';

  @override
  String get darkTheme => 'डार्क थीम';

  @override
  String get lightTheme => 'लाइट थीम';

  @override
  String get systemTheme => 'सिस्टम की डिफ़ॉल्ट थीम का उपयोग करें';

  @override
  String get view => 'देखें';

  @override
  String get edit => 'संपादित करें';

  @override
  String get export => 'निर्यात करें';

  @override
  String get save => 'सहेजें';

  @override
  String get zoom => 'ज़ूम';

  @override
  String get zoomIn => 'ज़ूम इन करें';

  @override
  String get zoomOut => 'ज़ूम आउट करें';

  @override
  String get resetZoom => 'ज़ूम रीसेट करें';

  @override
  String get strokeWidth => 'स्ट्रोक की चौड़ाई';

  @override
  String get includeEraser => 'इरेज़र शामिल करें?';

  @override
  String get thinning => 'पतलापन';

  @override
  String get pen => 'पेन';

  @override
  String get invertedPen => 'उलटा पेन';

  @override
  String get eraser => 'इरेज़र';

  @override
  String get pathEraser => 'पथ इरेज़र';

  @override
  String get label => 'लेबल';

  @override
  String get delete => 'हटाएँ';

  @override
  String get areYouSure => 'क्या आप निश्चित हैं?';

  @override
  String get reallyDelete => 'क्या आप वाकई इस आइटम को हटाना चाहते हैं?';

  @override
  String get no => 'नहीं';

  @override
  String get yes => 'हाँ';

  @override
  String get undo => 'पूर्ववत् करें';

  @override
  String get redo => 'फिर से करें';

  @override
  String get general => 'सामान्य';

  @override
  String get copyTitle => 'क्लिपबोर्ड पर कॉपी किया गया';

  @override
  String get loading => 'लोड हो रहा है...';

  @override
  String get enterText => 'टेक्स्ट दर्ज करें';

  @override
  String get size => 'आकार';

  @override
  String get width => 'चौड़ाई';

  @override
  String get height => 'ऊंचाई';

  @override
  String get count => 'गिनती';

  @override
  String get space => 'जगह';

  @override
  String get background => 'पृष्ठभूमि';

  @override
  String get box => 'बॉक्स';

  @override
  String get locale => 'लोकेल';

  @override
  String get systemLocale => 'सिस्टम लोकेल';

  @override
  String get information => 'जानकारी';

  @override
  String get license => 'लाइसेंस';

  @override
  String get imprint => 'इंप्रिंट';

  @override
  String get privacypolicy => 'गोपनीयता नीति';

  @override
  String get sourceCode => 'सोर्स कोड';

  @override
  String get documentation => 'प्रलेखन';

  @override
  String get changelog => 'चेंजलॉग';

  @override
  String get source => 'स्रोत';

  @override
  String get existOverride => 'यह तत्व पहले से मौजूद है। ओवरराइट करें?';

  @override
  String get description => 'विवरण';

  @override
  String get fill => 'भरें';

  @override
  String get defaultPalette => 'डिफ़ॉल्ट पैलेट';

  @override
  String get highlighter => 'हाइलाइटर';

  @override
  String get add => 'जोड़ें';

  @override
  String get remove => 'हटाएं';

  @override
  String get removeConfirm => 'क्या आप वाकई इसे हटाना चाहते हैं?';

  @override
  String get resetPalette => 'पैलेट रीसेट करें';

  @override
  String get custom => 'कस्टम';

  @override
  String get decoration => 'सजावट';

  @override
  String get underline => 'अंडरलाइन';

  @override
  String get overline => 'ओवरलाइन';

  @override
  String get strikethrough => 'स्ट्राइकथ्रू';

  @override
  String get thickness => 'मोटाई';

  @override
  String get style => 'शैली';

  @override
  String get solid => 'ठोस';

  @override
  String get double => 'दोहरा';

  @override
  String get dotted => 'बिंदीदार';

  @override
  String get dashed => 'डैशयुक्त';

  @override
  String get wavy => 'लहरदार';

  @override
  String get fontWeight => 'फ़ॉन्ट का वज़न';

  @override
  String get normal => 'सामान्य';

  @override
  String get bold => 'बोल्ड';

  @override
  String get italic => 'इटैलिक';

  @override
  String get clipboard => 'क्लिपबोर्ड';

  @override
  String get file => 'फ़ाइल';

  @override
  String get data => 'डेटा';

  @override
  String get share => 'शेयर करें';

  @override
  String get spacing => 'स्पेसिंग';

  @override
  String get image => 'छवि';

  @override
  String get enterUrl => 'यूआरएल दर्ज करें';

  @override
  String get scale => 'स्केल';

  @override
  String get help => 'सहायता';

  @override
  String get reallyReset => 'क्या आप वाकई इसे रीसेट करना चाहते हैं?';

  @override
  String get whatToDo => 'आप क्या करना चाहते हैं?';

  @override
  String get ignore => 'अनदेखा करें';

  @override
  String get backup => 'बैकअप';

  @override
  String createdInNewerVersion(String fileName, int fileVersion) {
    return 'फ़ाइल $fileName एक नए संस्करण ($fileVersion) में बनाई गई थी। इस फ़ाइल के साथ क्या किया जाना चाहिए?';
  }

  @override
  String get waypoints => 'वेपॉइंट्स';

  @override
  String get origin => 'मूल';

  @override
  String get import => 'आयात करें';

  @override
  String get newContent => 'नया';

  @override
  String get selectElement => 'तत्व चुनें';

  @override
  String get ctrlKey => 'Ctrl';

  @override
  String get shiftKey => 'Shift';

  @override
  String get altKey => 'Alt';

  @override
  String get copyVersion => 'संस्करण कॉपी करें';

  @override
  String get input => 'इनपुट';

  @override
  String get behaviors => 'व्यवहार';

  @override
  String get dataDirectory => 'डेटा डायरेक्टरी';

  @override
  String get defaultPath => 'डिफ़ॉल्ट पथ';

  @override
  String get dateFormat => 'दिनांक प्रारूप';

  @override
  String updatedAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'इस पर अपडेट किया गया: $dateTimeString';
  }

  @override
  String createdAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'इस पर बनाया गया: $dateTimeString';
  }

  @override
  String get rename => 'नाम बदलें';

  @override
  String get duplicate => 'डुप्लिकेट';

  @override
  String get hand => 'हाथ';

  @override
  String get folder => 'फ़ोल्डर';

  @override
  String get move => 'स्थानांतरित करें';

  @override
  String get copy => 'कॉपी करें';

  @override
  String get back => 'वापस';

  @override
  String get zoomDependent => 'ज़ूम पर निर्भर';

  @override
  String get shapeDetection => 'आकृति पहचान';

  @override
  String get delay => 'देरी';

  @override
  String get defaultLayer => 'डिफ़ॉल्ट लेयर';

  @override
  String get layer => 'लेयर';

  @override
  String get layers => 'लेयर्स';

  @override
  String get notSet => 'सेट नहीं है';

  @override
  String get enterLayer => 'लेयर का नाम दर्ज करें';

  @override
  String get selectElements => 'तत्व चुनें';

  @override
  String get deleteElements => 'तत्व हटाएं';

  @override
  String get deleteElementsConfirm =>
      'क्या आप वाकई चयनित तत्वों को हटाना चाहते हैं?';

  @override
  String get selectCustomCollection => 'एक कस्टम संग्रह चुनें';

  @override
  String get svg => 'SVG';

  @override
  String get sensitivity => 'संवेदनशीलता';

  @override
  String get sensitivityHint =>
      'मान जितना अधिक होगा, इनपुट उतना ही संवेदनशील होगा';

  @override
  String get horizontal => 'क्षैतिज';

  @override
  String get vertical => 'लंबवत';

  @override
  String get plain => 'सादा';

  @override
  String get light => 'हल्का';

  @override
  String get ruled => 'रेखित';

  @override
  String get quad => 'क्वाड';

  @override
  String get music => 'संगीत';

  @override
  String get dark => 'डार्क';

  @override
  String get plainDark => 'डार्क';

  @override
  String get ruledDark => 'रेखित डार्क';

  @override
  String get quadDark => 'क्वाड डार्क';

  @override
  String get musicDark => 'संगीत डार्क';

  @override
  String get templates => 'टेम्पलेट्स';

  @override
  String get untitled => 'शीर्षकहीन';

  @override
  String get createTemplate => 'टेम्पलेट बनाएं';

  @override
  String get createTemplateContent =>
      'क्या आप वाकई इस दस्तावेज़ से एक टेम्पलेट बनाना चाहते हैं? मूल दस्तावेज़ हटा दिया जाएगा।';

  @override
  String get replace => 'बदलें';

  @override
  String get reallyReplace =>
      'क्या आप वाकई टेम्पलेट को बदलना चाहते हैं? इस ऑपरेशन को पूर्ववत् नहीं किया जा सकता है!';

  @override
  String get defaultTemplate => 'डिफ़ॉल्ट टेम्पलेट';

  @override
  String get insert => 'डालें';

  @override
  String get document => 'दस्तावेज़';

  @override
  String get camera => 'कैमरा';

  @override
  String get printout => 'प्रिंटआउट';

  @override
  String get selectCamera => 'एक कैमरा चुनें';

  @override
  String get changeDocumentPath => 'दस्तावेज़ का पथ बदलें';

  @override
  String get deleteWholeStroke => 'पूरा स्ट्रोक हटाएं';

  @override
  String get alpha => 'अल्फ़ा';

  @override
  String get area => 'क्षेत्र';

  @override
  String get selectArea => 'एक क्षेत्र चुनें';

  @override
  String get aspectRatio => 'पहलू अनुपात';

  @override
  String get presets => 'प्रीसेट';

  @override
  String get pagePortrait => 'पेज पोर्ट्रेट';

  @override
  String get pageLandscape => 'पेज लैंडस्केप';

  @override
  String get square => 'वर्ग';

  @override
  String get areas => 'क्षेत्र';

  @override
  String get enterArea => 'क्षेत्र दर्ज करें';

  @override
  String get exitArea => 'क्षेत्र से बाहर निकलें';

  @override
  String get currentArea => 'वर्तमान क्षेत्र';

  @override
  String get design => 'डिज़ाइन';

  @override
  String get text => 'टेक्स्ट';

  @override
  String welcome(String codeName) {
    return 'हे, यह लिनवुड बटरफ्लाई $codeName है';
  }

  @override
  String get welcomeContent => 'एक मुफ़्त और ओपन-सोर्स ड्राइंग स्पेस!';

  @override
  String updated(String version) {
    return 'ऐप संस्करण $version में अपडेट किया गया';
  }

  @override
  String get releaseNotes => 'रिलीज़ नोट्स';

  @override
  String get constraints => 'बाधाएं';

  @override
  String get scaled => 'स्केल किया हुआ';

  @override
  String get fixed => 'स्थिर';

  @override
  String get dynamicContent => 'गतिशील';

  @override
  String get none => 'कोई नहीं';

  @override
  String get includeArea => 'क्षेत्र शामिल करें';

  @override
  String get verticalAlignment => 'लंबवत संरेखण';

  @override
  String get horizontalAlignment => 'क्षैतिज संरेखण';

  @override
  String get top => 'ऊपर';

  @override
  String get center => 'केंद्र';

  @override
  String get bottom => 'नीचे';

  @override
  String get left => 'बाएँ';

  @override
  String get right => 'दाएँ';

  @override
  String get justify => 'जस्टिफाई';

  @override
  String get constraint => 'बाधा';

  @override
  String get length => 'लंबाई';

  @override
  String get exportSvg => 'SVG निर्यात करें';

  @override
  String get pdf => 'PDF';

  @override
  String get selectPages => 'पेज चुनें';

  @override
  String get recentFiles => 'हाल की फ़ाइलें';

  @override
  String get start => 'शुरू करें';

  @override
  String get noRecentFiles => 'कोई हाल की फ़ाइलें नहीं';

  @override
  String countPages(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count पेज',
      one: '1 पेज',
      zero: 'कोई पेज नहीं',
    );
    return '$_temp0';
  }

  @override
  String pageIndex(int index) {
    return 'पेज $index';
  }

  @override
  String get exit => 'बाहर निकलें';

  @override
  String get noElements => 'कोई तत्व नहीं';

  @override
  String get invertSelection => 'चयन को उलट दें';

  @override
  String get errorWhileImporting => 'आयात करते समय त्रुटि';

  @override
  String get errorWhileImportingContent => 'फ़ाइल आयात करते समय एक त्रुटि हुई';

  @override
  String get showDetails => 'विवरण दिखाएं';

  @override
  String get hideDetails => 'विवरण छिपाएं';

  @override
  String get error => 'त्रुटि';

  @override
  String get stackTrace => 'स्टैक ट्रेस';

  @override
  String get laser => 'लेज़र';

  @override
  String get duration => 'अवधि';

  @override
  String get quality => 'गुणवत्ता';

  @override
  String get exportPdf => 'PDF निर्यात करें';

  @override
  String get local => 'स्थानीय';

  @override
  String get addConnection => 'कनेक्शन जोड़ें';

  @override
  String get connections => 'कनेक्शन';

  @override
  String get noConnections => 'कोई कनेक्शन नहीं';

  @override
  String get url => 'URL';

  @override
  String get connect => 'कनेक्ट करें';

  @override
  String get username => 'उपयोगकर्ता नाम';

  @override
  String get password => 'पासवर्ड';

  @override
  String get webNotSupported => 'वेब समर्थित नहीं है';

  @override
  String get advanced => 'उन्नत';

  @override
  String get directory => 'डायरेक्टरी';

  @override
  String get documentsDirectory => 'दस्तावेज़ डायरेक्टरी';

  @override
  String get templatesDirectory => 'टेम्पलेट्स डायरेक्टरी';

  @override
  String get errorWhileCreatingConnection => 'कनेक्शन बनाते समय त्रुटि';

  @override
  String get cannotConnect => 'कनेक्ट नहीं हो सकता';

  @override
  String get urlNotValid => 'URL मान्य नहीं है';

  @override
  String get icon => 'आइकन';

  @override
  String get update => 'अपडेट';

  @override
  String get updateAvailable => 'अपडेट उपलब्ध है';

  @override
  String get stable => 'स्थिर';

  @override
  String get nightly => 'नाइटली';

  @override
  String get checkForUpdates => 'अपडेट्स के लिए जांचें';

  @override
  String get checkForUpdatesWarning =>
      'अपडेट्स के लिए जांच करने से जानकारी प्राप्त करने के लिए बटरफ्लाई वेबसाइट से कनेक्शन होगा।';

  @override
  String get usingLatestStable => 'आप नवीनतम स्थिर संस्करण का उपयोग कर रहे हैं';

  @override
  String get usingLatestNightly =>
      'आप नवीनतम नाइटली संस्करण का उपयोग कर रहे हैं';

  @override
  String get currentVersion => 'वर्तमान संस्करण';

  @override
  String get updateNow => 'अभी अपडेट करें';

  @override
  String get shape => 'आकृति';

  @override
  String get circle => 'वृत्त';

  @override
  String get rectangle => 'आयत';

  @override
  String get triangle => 'त्रिकोण';

  @override
  String get line => 'रेखा';

  @override
  String get cornerRadius => 'कोने की त्रिज्या';

  @override
  String get topLeft => 'ऊपर बाएँ';

  @override
  String get topRight => 'ऊपर दाएँ';

  @override
  String get bottomLeft => 'नीचे बाएँ';

  @override
  String get bottomRight => 'नीचे दाएँ';

  @override
  String get caches => 'कैश';

  @override
  String get manage => 'प्रबंधित करें';

  @override
  String get clearCaches => 'कैश साफ़ करें';

  @override
  String get createCache => 'कैश बनाएं';

  @override
  String get thirdPartyLicenses => 'तृतीय-पक्ष लाइसेंस';

  @override
  String get syncing => 'सिंक हो रहा है...';

  @override
  String get synced => 'सिंक हो गया';

  @override
  String get notSynced => 'सिंक नहीं हुआ';

  @override
  String get conflict => 'टकराव';

  @override
  String get keepLocal => 'स्थानीय रखें';

  @override
  String get keepConnection => 'कनेक्शन रखें';

  @override
  String get keepBoth => 'दोनों रखें';

  @override
  String get forAll => 'सभी के लिए';

  @override
  String fileConflict(String file, String connection) {
    return '$connection में $file में एक टकराव है';
  }

  @override
  String get offline => 'ऑफलाइन';

  @override
  String get localLatest => 'नवीनतम स्थानीय';

  @override
  String get connectionLatest => 'नवीनतम कनेक्शन';

  @override
  String get path => 'पथ';

  @override
  String get folderSynced => 'फ़ोल्डर सिंक हो गया';

  @override
  String get syncRootDirectory => 'रूट डायरेक्टरी सिंक करें';

  @override
  String get penOnlyInput => 'केवल पेन इनपुट';

  @override
  String get inputGestures => 'इनपुट जेस्चर';

  @override
  String get nativeTitleBar => 'नेटिव टाइटल बार';

  @override
  String get syncMode => 'सिंक मोड';

  @override
  String get connection => 'कनेक्शन';

  @override
  String get always => 'हमेशा';

  @override
  String get noMobile => 'कोई मोबाइल नहीं';

  @override
  String get manual => 'मैनुअल';

  @override
  String get search => 'खोजें';

  @override
  String get properties => 'गुण';

  @override
  String get pin => 'पिन करें';

  @override
  String get unpin => 'अनपिन करें';

  @override
  String get element => 'तत्व';

  @override
  String get painter => 'पेंटर';

  @override
  String get position => 'स्थिति';

  @override
  String get note => 'नोट';

  @override
  String get packs => 'पैक';

  @override
  String get pack => 'पैक';

  @override
  String get more => 'अधिक';

  @override
  String get askForName => 'नाम पूछें';

  @override
  String areaIndex(int index) {
    return 'क्षेत्र $index';
  }

  @override
  String get startInFullScreen => 'फुल स्क्रीन में शुरू करें';

  @override
  String get inputs => 'इनपुट';

  @override
  String get mouse => 'माउस';

  @override
  String get touch => 'टच';

  @override
  String get keyboard => 'कीबोर्ड';

  @override
  String get shortcuts => 'शॉर्टकट';

  @override
  String get middle => 'मध्य';

  @override
  String get first => 'पहला';

  @override
  String get second => 'दूसरा';

  @override
  String get activeTool => 'सक्रिय टूल';

  @override
  String get activeToolDescription =>
      'टूलबार पर वर्तमान में चयनित टूल का उपयोग करें';

  @override
  String get handTool => 'हैंड टूल';

  @override
  String get handToolDescription => 'कैनवास पर घूमने के लिए खींचें';

  @override
  String get toolOnToolbar => 'टूलबार पर विशिष्ट टूल';

  @override
  String get toolOnToolbarDescription =>
      'टूलबार पर निर्दिष्ट स्थिति पर टूल का उपयोग करें, बाईं ओर से शुरू करते हुए';

  @override
  String toolOnToolbarShort(int display_position) {
    return 'टूलबार स्थिति: $display_position';
  }

  @override
  String get tools => 'टूल्स';

  @override
  String get showGrid => 'ग्रिड दिखाएं';

  @override
  String get grid => 'ग्रिड';

  @override
  String get ruler => 'रूलर';

  @override
  String get angle => 'कोण';

  @override
  String get report => 'रिपोर्ट';

  @override
  String get newFolder => 'नया फ़ोल्डर';

  @override
  String get createPack => 'पैक बनाएं';

  @override
  String get editPack => 'पैक संपादित करें';

  @override
  String get packsDirectory => 'पैक डायरेक्टरी';

  @override
  String get stamp => 'स्टाम्प';

  @override
  String get addToPack => 'पैक में जोड़ें';

  @override
  String get sureImportPack => 'क्या आप वाकई पैक आयात करना चाहते हैं?';

  @override
  String byAuthor(String author) {
    return '$author द्वारा';
  }

  @override
  String get author => 'लेखक';

  @override
  String get addAsset => 'एसेट जोड़ें';

  @override
  String get editAsset => 'एसेट संपादित करें';

  @override
  String get scope => 'दायरा';

  @override
  String get noPacks => 'वर्तमान में कोई पैक उपलब्ध नहीं हैं';

  @override
  String get components => 'घटक';

  @override
  String get waypoint => 'वेपॉइंट';

  @override
  String get actions => 'क्रियाएँ';

  @override
  String get painters => 'पेंटर्स';

  @override
  String get breakingChangesTitle => 'ब्रेकिंग परिवर्तन';

  @override
  String breakingChangesMessage(int version, int newVersion) {
    return 'इस संस्करण में ब्रेकिंग परिवर्तन हैं। कृपया अपडेट करने से पहले चेंजलॉग पढ़ें। वर्तमान फ़ाइल संस्करण $version है, नया संस्करण $newVersion है।';
  }

  @override
  String get styles => 'शैलियाँ';

  @override
  String get paragraph => 'पैराग्राफ';

  @override
  String get fontFamily => 'फ़ॉन्ट परिवार';

  @override
  String get smoothing => 'स्मूथिंग';

  @override
  String get streamline => 'स्ट्रीमलाइन';

  @override
  String get presentation => 'प्रस्तुति';

  @override
  String get selectAsset => 'एसेट चुनें';

  @override
  String get clearStyle => 'शैली साफ़ करें';

  @override
  String get unknownImportType => 'अज्ञात आयात प्रकार';

  @override
  String get sureImportTemplate => 'क्या आप वाकई टेम्पलेट आयात करना चाहते हैं?';

  @override
  String get frame => 'फ्रेम';

  @override
  String get play => 'चलाएं';

  @override
  String get video => 'वीडियो';

  @override
  String get fps => 'FPS';

  @override
  String get breakpoint => 'ब्रेकपॉइंट';

  @override
  String get presentationControls => 'प्रस्तुति नियंत्रण';

  @override
  String get nextSlide => 'अगली स्लाइड';

  @override
  String get nextSlideDescription =>
      'अगली स्लाइड पर जाने के लिए दाईं ओर स्वाइप करें या दायाँ तीर कुंजी दबाएं';

  @override
  String get previousSlide => 'पिछली स्लाइड';

  @override
  String get previousSlideDescription =>
      'पिछली स्लाइड पर जाने के लिए बाईं ओर स्वाइप करें या बायाँ तीर कुंजी दबाएं';

  @override
  String get exitPresentation => 'प्रस्तुति से बाहर निकलें';

  @override
  String get exitPresentationDescription =>
      'प्रस्तुति से बाहर निकलने के लिए एस्केप कुंजी दबाएं या नीचे स्वाइप करें';

  @override
  String get pausePresentation => 'प्रस्तुति रोकें';

  @override
  String get pausePresentationDescription =>
      'प्रस्तुति को रोकने या फिर से शुरू करने के लिए स्क्रीन पर टैप करें या स्पेस बार दबाएं';

  @override
  String get keyframe => 'कीफ़्रेम';

  @override
  String get endOfPresentation => 'आप प्रस्तुति के अंत तक पहुँच गए हैं';

  @override
  String get startOfPresentation => 'आप प्रस्तुति की शुरुआत में पहुँच गए हैं';

  @override
  String get palettes => 'पैलेट';

  @override
  String headline(int index) {
    return 'हेडलाइन $index';
  }

  @override
  String get code => 'कोड';

  @override
  String get quote => 'उद्धरण';

  @override
  String get link => 'लिंक';

  @override
  String get checkbox => 'चेकबॉक्स';

  @override
  String get deleted => 'हटाया गया';

  @override
  String get emphasis => 'ज़ोर';

  @override
  String get listBullet => 'सूची बुलेट';

  @override
  String get strong => 'मज़बूत';

  @override
  String get markdown => 'मार्कडाउन';

  @override
  String get home => 'होम';

  @override
  String get files => 'फ़ाइलें';

  @override
  String get sortBy => 'इसके अनुसार छाँटें';

  @override
  String get location => 'स्थान';

  @override
  String get whatsNew => 'नया क्या है?';

  @override
  String get unstar => 'स्टार हटाएं';

  @override
  String get star => 'स्टार';

  @override
  String get goUp => 'ऊपर जाएं';

  @override
  String get created => 'बनाया गया';

  @override
  String get modified => 'संशोधित';

  @override
  String get quickstart => 'त्वरित आरंभ';

  @override
  String get noTemplates => 'वर्तमान में कोई टेम्पलेट उपलब्ध नहीं हैं';

  @override
  String get importCorePack => 'कोर पैक आयात करें';

  @override
  String get importCorePackDescription =>
      'शुरू करने के लिए सभी बुनियादी एसेट वाले कोर पैक को आयात करें। यह वर्तमान कोर पैक को ओवरराइड कर देगा।';

  @override
  String get never => 'कभी नहीँ';

  @override
  String get onlyOnUpdates => 'केवल अपडेट पर';

  @override
  String get visibility => 'दृश्यता';

  @override
  String get captureThumbnail => 'थंबनेल कैप्चर करें';

  @override
  String get capturedThumbnail => 'थंबनेल सफलतापूर्वक कैप्चर किया गया';

  @override
  String get chooseLabelMode => 'लेबल मोड चुनें';

  @override
  String get foreground => 'अग्रभूमि';

  @override
  String get version => 'संस्करण';

  @override
  String get repository => 'रिपॉजिटरी';

  @override
  String get pages => 'पेज';

  @override
  String get navigator => 'नेविगेटर';

  @override
  String get arrange => 'व्यवस्थित करें';

  @override
  String get bringToFront => 'सामने लाएं';

  @override
  String get sendToBack => 'पीछे भेजें';

  @override
  String get bringForward => 'आगे लाएं';

  @override
  String get sendBackward => 'पीछे भेजें';

  @override
  String get rotation => 'घूर्णन';

  @override
  String get onlyAvailableLargerScreen => 'केवल बड़ी स्क्रीन पर उपलब्ध है';

  @override
  String get toolbarPosition => 'टूलबार की स्थिति';

  @override
  String get rotate => 'घुमाएं';

  @override
  String get spacer => 'स्पेसर';

  @override
  String get navigationRail => 'नेविगेशन रेल';

  @override
  String get cut => 'काटें';

  @override
  String get insertBefore => 'पहले डालें';

  @override
  String get insertAfter => 'बाद में डालें';

  @override
  String get insertFirst => 'सबसे पहले डालें';

  @override
  String get insertLast => 'सबसे अंत में डालें';

  @override
  String get paste => 'चिपकाएं';

  @override
  String get ascending => 'आरोही';

  @override
  String get descending => 'अवरोही';

  @override
  String get imageScale => 'छवि स्केल';

  @override
  String get select => 'चुनें';

  @override
  String get tool => 'टूल';

  @override
  String get texture => 'बनावट';

  @override
  String get platformTheme => 'प्लेटफ़ॉर्म थीम';

  @override
  String get desktop => 'डेस्कटॉप';

  @override
  String get mobile => 'मोबाइल';

  @override
  String get pdfQuality => 'PDF गुणवत्ता';

  @override
  String get surface => 'सतह';

  @override
  String get pattern => 'पैटर्न';

  @override
  String get sureClose => 'क्या आप वाकई दस्तावेज़ को बंद करना चाहते हैं?';

  @override
  String get thereAreUnsavedChanges => 'बिना सहेजे गए परिवर्तन हैं';

  @override
  String get page => 'पेज';

  @override
  String get iceServers => 'ICE सर्वर्स';

  @override
  String get collaboration => 'सहयोग';

  @override
  String get webRtc => 'Web RTC';

  @override
  String get webSocket => 'Web Socket';

  @override
  String get iceServer => 'ICE सर्वर';

  @override
  String get port => 'पोर्ट';

  @override
  String get type => 'प्रकार';

  @override
  String get side => 'पक्ष';

  @override
  String get client => 'क्लाइंट';

  @override
  String get server => 'सर्वर';

  @override
  String get switchView => 'दृश्य बदलें';

  @override
  String get lasso => 'लासो';

  @override
  String get hideUI => 'UI छिपाएं';

  @override
  String get density => 'घनत्व';

  @override
  String get compact => 'कॉम्पैक्ट';

  @override
  String get comfortable => 'आरामदायक';

  @override
  String get standard => 'मानक';

  @override
  String get lock => 'लॉक';

  @override
  String get addElement => 'तत्व जोड़ें';

  @override
  String get notDefaultConnection => 'डिफ़ॉल्ट कनेक्शन नहीं';

  @override
  String get defaultConnection => 'डिफ़ॉल्ट कनेक्शन';

  @override
  String get hide => 'छिपाएं';

  @override
  String get show => 'दिखाएं';

  @override
  String get pause => 'रोकें';

  @override
  String get stop => 'रुकें';

  @override
  String get refresh => 'रीफ्रेश करें';

  @override
  String get print => 'प्रिंट करें';

  @override
  String get dav => 'DAV';

  @override
  String get eyeDropper => 'आई ड्रॉपर';

  @override
  String get users => 'उपयोगकर्ता';

  @override
  String get experiments => 'प्रयोग';

  @override
  String get experimentsWarning =>
      'ये सुविधाएँ प्रायोगिक हैं और किसी भी समय बदल, टूट या गायब हो सकती हैं। इन्हें सक्षम करने से अस्थिरता या डेटा हानि हो सकती है। सावधानी से आगे बढ़ें। कृपया किसी भी बग की रिपोर्ट करें।';

  @override
  String get address => 'पता';

  @override
  String get spreadToPages => 'पेजों पर फैलाएं';

  @override
  String get rootDirectorySpecifiedDescription =>
      'रूट डायरेक्टरी निर्दिष्ट है। सभी उन्नत डायरेक्टरी पथ इस डायरेक्टरी के सापेक्ष होंगे। इस डायरेक्टरी प्रकार को अक्षम करने के लिए इसे खाली रखें।';

  @override
  String get rootDirectoryNotSpecifiedDescription =>
      'रूट डायरेक्टरी निर्दिष्ट नहीं है। एक नाम आवश्यक है। सभी उन्नत डायरेक्टरी पथ पूर्ण होंगे। इस डायरेक्टरी प्रकार को अक्षम करने के लिए इसे खाली रखें।';

  @override
  String get unsecureConnectionTitle => 'असुरक्षित कनेक्शन';

  @override
  String unsecureConnectionMessage(String fingerprint) {
    return 'कनेक्शन सुरक्षित नहीं है। यह एक सुरक्षा जोखिम हो सकता है। कृपया तभी जारी रखें जब आप कनेक्शन पर भरोसा करते हैं। sha1 फिंगरप्रिंट $fingerprint है।';
  }

  @override
  String get continueAnyway => 'फिर भी जारी रखें';

  @override
  String get zoomControl => 'ज़ूम नियंत्रण';

  @override
  String get highContrast => 'उच्च कंट्रास्ट';

  @override
  String get shouldANumber => 'यह मान एक मान्य संख्या होनी चाहिए';

  @override
  String get createAreas => 'क्षेत्र बनाएं';

  @override
  String get autosave => 'ऑटोसेव';

  @override
  String get invert => 'उलट दें';

  @override
  String get operations => 'संचालन';

  @override
  String get medium => 'मध्यम';

  @override
  String get large => 'बड़ा';

  @override
  String get toolbarSize => 'टूलबार का आकार';

  @override
  String get addAll => 'सभी जोड़ें';

  @override
  String get onlyCurrentPage => 'केवल वर्तमान पेज';

  @override
  String get smoothNavigation => 'सहज नेविगेशन';

  @override
  String get exact => 'सटीक';

  @override
  String get inline => 'इनलाइन';

  @override
  String get toolbarRows => 'टूलबार पंक्तियाँ';

  @override
  String get pointerTest => 'पॉइंटर टेस्ट';

  @override
  String get pressure => 'दबाव';

  @override
  String get small => 'छोटा';

  @override
  String get tiny => 'बहुत छोटा';

  @override
  String get selectAll => 'सभी चुनें';

  @override
  String get overrideTools => 'टूल्स ओवरराइड करें';

  @override
  String get hideCursorWhileDrawing => 'ड्राइंग करते समय कर्सर छिपाएं';

  @override
  String get installed => 'स्थापित';

  @override
  String get install => 'इंस्टॉल करें';

  @override
  String get deselect => 'चयन हटाएं';

  @override
  String get changeCollection => 'संग्रह बदलें';

  @override
  String get collections => 'संग्रह';

  @override
  String get fullSelection => 'पूर्ण चयन';

  @override
  String get fullSelectionDescription =>
      'चयन के लिए तत्वों को पूरी तरह से चयन बॉक्स के भीतर होना आवश्यक है।';

  @override
  String get collection => 'संग्रह';

  @override
  String get defaultCollection => 'डिफ़ॉल्ट संग्रह';

  @override
  String get scroll => 'स्क्रॉल';

  @override
  String get onStartup => 'स्टार्टअप पर';

  @override
  String get homeScreen => 'होम स्क्रीन';

  @override
  String get lastNote => 'अंतिम नोट';

  @override
  String get newNote => 'नया नोट';

  @override
  String get convertToLayer => 'लेयर में बदलें';

  @override
  String get merge => 'विलय करें';

  @override
  String get up => 'ऊपर';

  @override
  String get down => 'नीचे';

  @override
  String get other => 'अन्य';

  @override
  String countElements(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count तत्व',
      one: '1 तत्व',
      zero: 'कोई तत्व नहीं',
    );
    return '$_temp0';
  }

  @override
  String get colorToolbar => 'रंग टूलबार';

  @override
  String get yesButShowButtons => 'हाँ, लेकिन बटन दिखाएं';

  @override
  String get optionsPanelPosition => 'विकल्प पैनल की स्थिति';

  @override
  String get hideDuration => 'अवधि छिपाएं';

  @override
  String get animation => 'एनिमेशन';

  @override
  String get performance => 'प्रदर्शन';

  @override
  String get performanceDescription =>
      'गति और मेमोरी उपयोग के लिए अनुकूलित। नोट का केवल दृश्यमान हिस्सा ही छवि में बेक किया जाता है।';

  @override
  String get normalDescription =>
      'गुणवत्ता और प्रदर्शन को संतुलित करता है। दृश्यमान क्षेत्र का 1.5 गुना कवर करने वाली एक छवि बेक करता है, जो स्क्रॉल करते समय सहज संक्रमण प्रदान करती है।';

  @override
  String get high => 'उच्च';

  @override
  String get highDescription =>
      'Maximizes quality at the cost of performance. Bakes an image covering 2 times the visible area, ensuring seamless rendering even during rapid scrolling or zooming.';

  @override
  String get renderResolution => 'रेंडर रिज़ॉल्यूशन';

  @override
  String get translate => 'अनुवाद करें';

  @override
  String get unencrypted => 'अनएन्क्रिप्टेड';

  @override
  String get encrypted => 'एन्क्रिप्टेड';

  @override
  String get encryptDocumentMessage =>
      'दस्तावेज़ को एन्क्रिप्ट करने के लिए क्लिक करें';

  @override
  String get unencryptDocumentMessage =>
      'दस्तावेज़ को अनएन्क्रिप्ट करने के लिए क्लिक करें';

  @override
  String get unencrypt => 'अनएन्क्रिप्ट करें';

  @override
  String get encrypt => 'एन्क्रिप्ट करें';

  @override
  String get encryptWarning =>
      'यह दस्तावेज़ को एन्क्रिप्ट करेगा। इसे डिक्रिप्ट करने के लिए आपको पासवर्ड याद रखना होगा।';

  @override
  String get unencryptWarning =>
      'यह दस्तावेज़ को अनएन्क्रिप्ट करेगा। पासवर्ड हटा दिया जाएगा और एक्सेस वाला हर कोई इसे खोल सकेगा।';

  @override
  String get confirmPassword => 'पासवर्ड की पुष्टि करें';

  @override
  String get passwordMismatch => 'पासवर्ड मेल नहीं खाते';

  @override
  String get action => 'कार्रवाई';

  @override
  String get svgText => 'SVG टेक्स्ट';

  @override
  String get offset => 'ऑफसेट';

  @override
  String get positionDependent => 'स्थिति पर निर्भर';

  @override
  String get flipHorizontal => 'क्षैतिज रूप से पलटें';

  @override
  String get flipVertical => 'लंबवत रूप से पलटें';

  @override
  String get grayscale => 'ग्रेस्केल';

  @override
  String get moveOnGesture => 'जेस्चर पर ले जाएं';

  @override
  String get exportAllFiles => 'सभी फाइलें निर्यात करें';

  @override
  String get restoreSettingsFromFile => 'फ़ाइल से सेटिंग्स पुनर्स्थापित करें';

  @override
  String get exportSettingsToFile => 'सेटिंग्स को फ़ाइल में निर्यात करें';

  @override
  String get barcode => 'बारकोड';

  @override
  String get barcodeType => 'बारकोड प्रकार';

  @override
  String get qrCode => 'QR कोड';

  @override
  String get dataMatrix => 'डेटा मैट्रिक्स';

  @override
  String get code128 => 'कोड 128';

  @override
  String defaultUserName(int index) {
    return 'उपयोगकर्ता $index';
  }

  @override
  String get moveLeft => 'बाएं ले जाएं';

  @override
  String get moveRight => 'दाएं ले जाएं';

  @override
  String get bundledPacks => 'बंडल किए गए पैक';

  @override
  String get component => 'Component';

  @override
  String get selectComponent => 'घटक चुनें';

  @override
  String get bundlePackInDocument => 'दस्तावेज़ में पैक बंडल करें';

  @override
  String get bundledPacksDescription =>
      'बंडल किए गए पैक दस्तावेज़ में शामिल होते हैं और केवल दस्तावेज़ के साथ साझा करने के लिए उपयोग किए जाते हैं। एसेट का उपयोग दस्तावेज़ में तभी किया जा सकता है जब पैक इंस्टॉल हो। पैक पर क्लिक करके उन्हें इंस्टॉल किया जा सकता है।';

  @override
  String get fillAlpha => 'अल्फ़ा भरें';

  @override
  String get packagedFile => 'पैकेज की गई फ़ाइल';

  @override
  String get rawFile => 'रॉ फ़ाइल';

  @override
  String get webSocketDescription =>
      'आपका डिवाइस सर्वर को होस्ट करता है, इसलिए सहयोगी केवल उसी नेटवर्क पर शामिल हो सकते हैं या कहीं से भी यदि आप अपने राउटर पर पोर्ट फॉरवर्ड करते हैं।';

  @override
  String get swampDescription =>
      'आपके संदेश एंड-टू-एंड एन्क्रिप्शन के साथ एक सुरक्षित रिले सर्वर के माध्यम से रूट किए जाते हैं। सत्र बनाने के लिए एक स्वैम्प सर्वर पते की आवश्यकता होती है।';

  @override
  String get createRawNote => 'रॉ नोट बनाएं';

  @override
  String get polygon => 'बहुभुज';

  @override
  String get finishShape => 'आकृति समाप्त करें';

  @override
  String get submit => 'सबमिट करें';

  @override
  String get math => 'Math';

  @override
  String get ignorePressure => 'Ignore pressure';

  @override
  String get ignoreFirstPressureDescription =>
      'On some devices, the first pressure value is not accurate. This setting will ignore the first pressure value and use the pressure of the second event instead.';

  @override
  String get temporary => 'Temporary';

  @override
  String get simpleToolbarVisibility => 'Simple toolbar visibility';

  @override
  String get autosaveDelay => 'Autosave delay';

  @override
  String get saved => 'Saved';

  @override
  String get saving => 'Saving...';

  @override
  String get readOnly => 'Read only';

  @override
  String get saveDelayed => 'Save delayed';

  @override
  String get unsaved => 'Unsaved';

  @override
  String get pdfEmptyDescription =>
      'There are currently no areas to export. Please select at least one area using the plus button in the top right corner or add all areas from the current page or from the whole document below.';

  @override
  String get densityMaximize => 'Maximize';
}
