// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Ukrainian (`uk`).
class AppLocalizationsUk extends AppLocalizations {
  AppLocalizationsUk([String locale = 'uk']) : super(locale);

  @override
  String get open => 'Відкриті';

  @override
  String get settings => 'Налаштування';

  @override
  String get personalization => 'Персоналізація';

  @override
  String get theme => 'Тема';

  @override
  String get darkTheme => 'Темна тема';

  @override
  String get lightTheme => 'Світла тема';

  @override
  String get systemTheme => 'Використовувати типову системну тему';

  @override
  String get view => 'Дивитись';

  @override
  String get edit => 'Редагувати';

  @override
  String get export => 'Експорт';

  @override
  String get save => 'Зберегти';

  @override
  String get zoom => 'Масштабування';

  @override
  String get zoomIn => 'Збільшити масштаб';

  @override
  String get zoomOut => 'Зменшити масштаб';

  @override
  String get resetZoom => 'Reset zoom';

  @override
  String get strokeWidth => 'Ширина штриха';

  @override
  String get includeEraser => 'Включати гущаду?';

  @override
  String get thinning => 'Думки';

  @override
  String get pen => 'Ручка';

  @override
  String get invertedPen => 'Інвертована пера';

  @override
  String get eraser => 'Eraser';

  @override
  String get pathEraser => 'Лінійка шляху';

  @override
  String get label => 'Мітка';

  @override
  String get delete => 'Видалити';

  @override
  String get areYouSure => 'Ви впевнені?';

  @override
  String get reallyDelete => 'Ви дійсно бажаєте видалити цей елемент?';

  @override
  String get no => 'Ні';

  @override
  String get yes => 'Так';

  @override
  String get undo => 'Скасувати';

  @override
  String get redo => 'Повторити дію';

  @override
  String get general => 'Загальні налаштування';

  @override
  String get copyTitle => 'Скопійовано до буферу обміну';

  @override
  String get loading => 'Завантажується...';

  @override
  String get enterText => 'Введіть текст';

  @override
  String get size => 'Розмір';

  @override
  String get width => 'Width';

  @override
  String get height => 'Висота';

  @override
  String get count => 'Підрахунок';

  @override
  String get space => 'З відступом';

  @override
  String get background => 'Фон';

  @override
  String get box => 'Ящик';

  @override
  String get locale => 'Локалізація';

  @override
  String get systemLocale => 'Мова локалізації системи';

  @override
  String get information => 'Інформація про нас';

  @override
  String get license => 'Ліцензія';

  @override
  String get imprint => 'Відомості';

  @override
  String get privacypolicy => 'Політика конфіденційності';

  @override
  String get sourceCode => 'Початковий код';

  @override
  String get documentation => 'Документація';

  @override
  String get changelog => 'Список змін';

  @override
  String get source => 'Джерело';

  @override
  String get existOverride => 'Цей елемент уже існує. Перезаписати?';

  @override
  String get description => 'Опис';

  @override
  String get fill => 'Заливка рядка';

  @override
  String get defaultPalette => 'Стандартна палітра';

  @override
  String get highlighter => 'Маркер';

  @override
  String get add => 'Додати';

  @override
  String get remove => 'Видалити';

  @override
  String get removeConfirm => 'Ви дійсно хочете видалити це?';

  @override
  String get resetPalette => 'Reset palette';

  @override
  String get custom => 'Користувацька';

  @override
  String get decoration => 'Декорація';

  @override
  String get underline => 'Підкреслений';

  @override
  String get overline => 'Оверлайн';

  @override
  String get strikethrough => 'Закреслений';

  @override
  String get thickness => 'Товщина';

  @override
  String get style => 'Стиль';

  @override
  String get solid => 'Solid';

  @override
  String get double => 'Подвійний';

  @override
  String get dotted => 'Пунктирна';

  @override
  String get dashed => 'Пунктирна';

  @override
  String get wavy => 'Хвилі';

  @override
  String get fontWeight => 'Вага Шрифту';

  @override
  String get normal => 'Нормальний';

  @override
  String get bold => 'Bold';

  @override
  String get italic => 'Italic';

  @override
  String get clipboard => 'Буфер обміну';

  @override
  String get file => 'Файл';

  @override
  String get data => 'Дані';

  @override
  String get share => 'Поділитись';

  @override
  String get spacing => 'Інтервал';

  @override
  String get image => 'Зображення';

  @override
  String get enterUrl => 'Введіть URL-адресу';

  @override
  String get scale => 'Масштаб';

  @override
  String get help => 'Довідка';

  @override
  String get reallyReset => 'Ви дійсно хочете скинути його?';

  @override
  String get whatToDo => 'Що ти хочеш зробити?';

  @override
  String get ignore => 'Ігнорувати';

  @override
  String get backup => 'Резервне копіювання';

  @override
  String createdInNewerVersion(String fileName, int fileVersion) {
    return 'Файл $fileName був створений у новішій версії ($fileVersion). Що слід зробити з цим файлом?';
  }

  @override
  String get waypoints => 'Точки';

  @override
  String get origin => 'Початок координат';

  @override
  String get import => 'Імпорт';

  @override
  String get newContent => 'Новий';

  @override
  String get selectElement => 'Виберіть елемент';

  @override
  String get ctrlKey => 'Сtrl';

  @override
  String get shiftKey => 'Зсув';

  @override
  String get altKey => 'Alt';

  @override
  String get copyVersion => 'Копіювати версію';

  @override
  String get input => 'Input';

  @override
  String get behaviors => 'Поведінка';

  @override
  String get dataDirectory => 'Каталог даних';

  @override
  String get defaultPath => 'Типовий шлях';

  @override
  String get dateFormat => 'Формат дати';

  @override
  String updatedAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'Оновлено на: $dateTimeString';
  }

  @override
  String createdAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'Створено: $dateTimeString';
  }

  @override
  String get rename => 'Перейменувати';

  @override
  String get duplicate => 'Duplicate';

  @override
  String get hand => 'Кисть';

  @override
  String get folder => 'Тека';

  @override
  String get move => 'Пересунути';

  @override
  String get copy => 'Копія';

  @override
  String get back => 'Відмінити';

  @override
  String get zoomDependent => 'Залежність масштабу';

  @override
  String get shapeDetection => 'Визначення форми';

  @override
  String get delay => 'Затримка';

  @override
  String get defaultLayer => 'Типовий шар';

  @override
  String get layer => 'Шар';

  @override
  String get layers => 'Шари';

  @override
  String get notSet => 'Не задано';

  @override
  String get enterLayer => 'Введіть назву шару';

  @override
  String get selectElements => 'Обрати елементи';

  @override
  String get deleteElements => 'Видалити елементи';

  @override
  String get deleteElementsConfirm =>
      'Ви дійсно бажаєте видалити вибрані елементи?';

  @override
  String get selectCustomCollection => 'Обрати користувацьку колекцію';

  @override
  String get svg => 'SVG';

  @override
  String get sensitivity => 'Чутливість';

  @override
  String get sensitivityHint =>
      'Чим вище значення, тим більш чутливе вхідне значення';

  @override
  String get horizontal => 'Горизонтально';

  @override
  String get vertical => 'Вертикально';

  @override
  String get plain => 'Рівнина';

  @override
  String get light => 'Світла';

  @override
  String get ruled => 'Лінійність';

  @override
  String get quad => 'Кварка';

  @override
  String get music => 'Музика';

  @override
  String get dark => 'Темна';

  @override
  String get plainDark => 'Темна';

  @override
  String get ruledDark => 'Лінійчата темна';

  @override
  String get quadDark => 'Квад темний';

  @override
  String get musicDark => 'Музика темна';

  @override
  String get templates => 'Шаблони';

  @override
  String get untitled => 'Без назви';

  @override
  String get createTemplate => 'Створити шаблон';

  @override
  String get createTemplateContent =>
      'Ви дійсно хочете створити шаблон з цього документа? Оригінальний документ буде видалено.';

  @override
  String get replace => 'Заміняти';

  @override
  String get reallyReplace =>
      'Ви дійсно хочете замінити шаблон? Цю операцію неможливо скасувати!';

  @override
  String get defaultTemplate => 'Шаблон за замовчуванням';

  @override
  String get insert => 'Insert';

  @override
  String get document => 'Документ';

  @override
  String get camera => 'Камера';

  @override
  String get printout => 'Прінтут';

  @override
  String get selectCamera => 'Обрати камеру';

  @override
  String get changeDocumentPath => 'Змінити шлях до документу';

  @override
  String get deleteWholeStroke => 'Видалити весь розряд';

  @override
  String get alpha => 'Альфа';

  @override
  String get area => 'Площа';

  @override
  String get selectArea => 'Вибір області';

  @override
  String get aspectRatio => 'Відношення сторін';

  @override
  String get presets => 'Шаблони';

  @override
  String get pagePortrait => 'Вертикальна орієнтація';

  @override
  String get pageLandscape => 'Сторінка в ландшафтному режимі';

  @override
  String get square => 'Квадрат';

  @override
  String get areas => 'Розділи';

  @override
  String get enterArea => 'Введіть область';

  @override
  String get exitArea => 'Вийти з району';

  @override
  String get currentArea => 'Поточна область';

  @override
  String get design => 'Дизайн';

  @override
  String get text => 'Текст';

  @override
  String welcome(String codeName) {
    return 'Гей, це метелик Лінвуда $codeName';
  }

  @override
  String get welcomeContent => 'Вільне та відкрите місце для малювання!';

  @override
  String updated(String version) {
    return 'Додаток оновлено до версії $version';
  }

  @override
  String get releaseNotes => 'Примітки до випуску';

  @override
  String get constraints => 'Обмеження';

  @override
  String get scaled => 'Масштабування';

  @override
  String get fixed => 'Виправлена';

  @override
  String get dynamicContent => 'Динамічний';

  @override
  String get none => 'Без ефекту';

  @override
  String get includeArea => 'Включити площу';

  @override
  String get verticalAlignment => 'Вертикальне вирівнювання';

  @override
  String get horizontalAlignment => 'Горизонтальне вирівнювання';

  @override
  String get top => 'Верх';

  @override
  String get center => 'Центр';

  @override
  String get bottom => 'Униз';

  @override
  String get left => 'Ліворуч';

  @override
  String get right => 'Праворуч';

  @override
  String get justify => 'Вирівняти';

  @override
  String get constraint => 'Обмеження';

  @override
  String get length => 'Довжина';

  @override
  String get exportSvg => 'Експорт SVG';

  @override
  String get pdf => 'Файл pdf';

  @override
  String get selectPages => 'Вибрати сторінки';

  @override
  String get recentFiles => 'Останні файли';

  @override
  String get start => 'Старт';

  @override
  String get noRecentFiles => 'Немає останніх файлів';

  @override
  String countPages(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Сторінки',
      one: '1 сторінка',
      zero: 'Жодних сторінок',
    );
    return '$_temp0';
  }

  @override
  String pageIndex(int index) {
    return 'Сторінка $index';
  }

  @override
  String get exit => 'Вийти';

  @override
  String get noElements => 'Немає елементів';

  @override
  String get invertSelection => 'Інвертувати виділення';

  @override
  String get errorWhileImporting => 'Помилка при імпорті';

  @override
  String get errorWhileImportingContent => 'Помилка при імпорті файлу';

  @override
  String get showDetails => 'Детальніше про твіт';

  @override
  String get hideDetails => 'Приховати подробиці';

  @override
  String get error => 'Помилка';

  @override
  String get stackTrace => 'Траса стеку';

  @override
  String get laser => 'Лазер';

  @override
  String get duration => 'Тривалість';

  @override
  String get quality => 'Якість';

  @override
  String get exportPdf => 'Експорт PDF';

  @override
  String get local => 'Місцевий';

  @override
  String get addConnection => 'Додати зв\'язок';

  @override
  String get connections => 'З\'єднання';

  @override
  String get noConnections => 'Немає підключень';

  @override
  String get url => 'Адреса';

  @override
  String get connect => 'Підключитися';

  @override
  String get username => 'Ім\'я користувача';

  @override
  String get password => 'Пароль';

  @override
  String get webNotSupported => 'Мережа не підтримується';

  @override
  String get advanced => 'Додатково';

  @override
  String get directory => 'Каталог';

  @override
  String get documentsDirectory => 'Каталог документів';

  @override
  String get templatesDirectory => 'Шаблонівський каталог';

  @override
  String get errorWhileCreatingConnection => 'Помилка при створенні з\'єднання';

  @override
  String get cannotConnect => 'Не вдалося підключитися';

  @override
  String get urlNotValid => 'Неприпустима URL-адреса';

  @override
  String get icon => 'Іконка';

  @override
  String get update => 'Оновити';

  @override
  String get updateAvailable => 'Доступне оновлення';

  @override
  String get stable => 'Стабільний';

  @override
  String get nightly => 'Нічна';

  @override
  String get checkForUpdates => 'Перевірити наявність оновлень';

  @override
  String get checkForUpdatesWarning =>
      'Перевірка оновлень з’єднується з сайтом Butterfly для отримання інформації.';

  @override
  String get usingLatestStable => 'Ви використовуєте останню стабільну версію';

  @override
  String get usingLatestNightly => 'Ви використовуєте останню нічну версію';

  @override
  String get currentVersion => 'Поточна версія';

  @override
  String get updateNow => 'Оновити зараз';

  @override
  String get shape => 'Форма';

  @override
  String get circle => 'Коло';

  @override
  String get rectangle => 'Прямокутник';

  @override
  String get triangle => 'Трикутник';

  @override
  String get line => 'Лінія';

  @override
  String get cornerRadius => 'Corner radius';

  @override
  String get topLeft => 'Зверху зліва';

  @override
  String get topRight => 'Зверху праворуч';

  @override
  String get bottomLeft => 'Внизу ліворуч';

  @override
  String get bottomRight => 'Нижній правий';

  @override
  String get caches => 'Кеш';

  @override
  String get manage => 'Керування';

  @override
  String get clearCaches => 'Очистити кеш';

  @override
  String get createCache => 'Створити кеш';

  @override
  String get thirdPartyLicenses => 'Сторонні ліцензії';

  @override
  String get syncing => 'Синхронізація...';

  @override
  String get synced => 'Синхронізовано';

  @override
  String get notSynced => 'Не синхронізовано';

  @override
  String get conflict => 'Конфлікт';

  @override
  String get keepLocal => 'Зберегти локально';

  @override
  String get keepConnection => 'Залишити з’єднання';

  @override
  String get keepBoth => 'Залишити обидва';

  @override
  String get forAll => 'Для всіх';

  @override
  String fileConflict(String file, String connection) {
    return '$file у $connection має конфлікт';
  }

  @override
  String get offline => 'В автономному режимі';

  @override
  String get localLatest => 'Локальне оновлення';

  @override
  String get connectionLatest => 'Підключення до останнього';

  @override
  String get path => 'Шлях';

  @override
  String get folderSynced => 'Папку синхронізовано';

  @override
  String get syncRootDirectory => 'Синхронізація кореневого каталогу';

  @override
  String get penOnlyInput => 'Тільки введення Pen';

  @override
  String get inputGestures => 'Input gestures';

  @override
  String get nativeTitleBar => 'Область заголовка';

  @override
  String get syncMode => 'Режим синхронізації';

  @override
  String get connection => 'З\'єднання';

  @override
  String get always => 'Завжди';

  @override
  String get noMobile => 'Немає мобільного телефону';

  @override
  String get manual => 'Вручну';

  @override
  String get search => 'Пошук';

  @override
  String get properties => 'Властивості';

  @override
  String get pin => 'Закріплення повідомлень';

  @override
  String get unpin => 'Unpin';

  @override
  String get element => 'Елемент';

  @override
  String get painter => 'Вазописець';

  @override
  String get position => 'Позиція';

  @override
  String get note => 'Примітка';

  @override
  String get packs => 'Пакунки';

  @override
  String get pack => 'Набір';

  @override
  String get more => 'Більше';

  @override
  String get askForName => 'Запитати про ім\'я';

  @override
  String areaIndex(int index) {
    return 'Площа $index';
  }

  @override
  String get startInFullScreen => 'Запускати в повноекранному режимі';

  @override
  String get inputs => 'Inputs';

  @override
  String get mouse => 'Миша';

  @override
  String get touch => 'Дотик';

  @override
  String get keyboard => 'Keyboard';

  @override
  String get shortcuts => 'Гарячі клавіші';

  @override
  String get middle => 'По центру';

  @override
  String get first => 'Перший';

  @override
  String get second => 'Секунда';

  @override
  String get activeTool => 'Активний інструмент';

  @override
  String get activeToolDescription =>
      'Використовувати зараз обраний інструмент на панелі інструментів';

  @override
  String get handTool => 'Інструмент для рук';

  @override
  String get handToolDescription => 'Перетягніть, щоб перемістити полотно';

  @override
  String get toolOnToolbar => 'Специфічний інструмент на панелі інструментів';

  @override
  String get toolOnToolbarDescription =>
      'Використовувати інструмент у зазначеній позиції на панелі інструментів, починаючи з зліва';

  @override
  String toolOnToolbarShort(int display_position) {
    return 'Позиція панелі інструментів: $display_position';
  }

  @override
  String get tools => 'Інструменти';

  @override
  String get showGrid => 'Показати сітку';

  @override
  String get grid => 'Сітка';

  @override
  String get ruler => 'Лінійка';

  @override
  String get angle => 'Кут';

  @override
  String get report => 'Доповісти';

  @override
  String get newFolder => 'Нова папка';

  @override
  String get createPack => 'Створити пакет';

  @override
  String get editPack => 'Редагувати пакет';

  @override
  String get packsDirectory => 'Пакунковий каталог';

  @override
  String get stamp => 'Відзнака';

  @override
  String get addToPack => 'Додати до набору';

  @override
  String get sureImportPack => 'Ви впевнені, що хочете імпортувати пакет?';

  @override
  String byAuthor(String author) {
    return 'від $author';
  }

  @override
  String get author => 'Автор';

  @override
  String get addAsset => 'Додати медіафайл';

  @override
  String get editAsset => 'Редагувати медіафайли';

  @override
  String get scope => 'Область використання';

  @override
  String get noPacks => 'Наразі немає доступних пакетів';

  @override
  String get components => 'Компоненти';

  @override
  String get waypoint => 'Шляхова Точка';

  @override
  String get actions => 'Дії';

  @override
  String get painters => 'Художники';

  @override
  String get breakingChangesTitle => 'Порушення змін';

  @override
  String breakingChangesMessage(int version, int newVersion) {
    return 'Зміни у цій версії є недоступними. Будь ласка, прочитайте список змін перед оновленням. Поточна версія файлу $version, нова версія $newVersion.';
  }

  @override
  String get styles => 'Styles';

  @override
  String get paragraph => 'Абзац';

  @override
  String get fontFamily => 'Сімейство шрифтів';

  @override
  String get smoothing => 'Згладжування';

  @override
  String get streamline => 'Стреймлін';

  @override
  String get presentation => 'Презентація';

  @override
  String get selectAsset => 'Виберіть медіафайл';

  @override
  String get clearStyle => 'Очистити стиль';

  @override
  String get unknownImportType => 'Невідомий тип імпорту';

  @override
  String get sureImportTemplate => 'Ви впевнені, що хочете імпортувати шаблон?';

  @override
  String get frame => 'Frame';

  @override
  String get play => 'Відтворити';

  @override
  String get video => 'Відео';

  @override
  String get fps => 'Кадрів в секунду';

  @override
  String get breakpoint => 'Точка зупину';

  @override
  String get presentationControls => 'Керування представленням';

  @override
  String get nextSlide => 'Наступний слайд';

  @override
  String get nextSlideDescription =>
      'Проведіть пальцем вправо або натисніть клавішу стрілки, щоб перейти до наступного слайду';

  @override
  String get previousSlide => 'Попередній слайд';

  @override
  String get previousSlideDescription =>
      'Проведіть пальцем вліво або натисніть клавішу стрілки, щоб перейти до попереднього слайду';

  @override
  String get exitPresentation => 'Вийти з презентації';

  @override
  String get exitPresentationDescription =>
      'Натисніть клавішу виходу або проведіть пальцем униз, щоб вийти з презентації';

  @override
  String get pausePresentation => 'Призупинити презентацію';

  @override
  String get pausePresentationDescription =>
      'Торкніться екрану або натисніть пробілу, щоб призупинити або відновити презентацію';

  @override
  String get keyframe => 'Keyframe';

  @override
  String get endOfPresentation => 'Ви досягли кінця презентації';

  @override
  String get startOfPresentation => 'Ви досягли початку презентації';

  @override
  String get palettes => 'Palettes';

  @override
  String headline(int index) {
    return 'Заголовок $index';
  }

  @override
  String get code => 'Код';

  @override
  String get quote => 'Цитувати';

  @override
  String get link => 'Лінк';

  @override
  String get checkbox => 'Прапорець';

  @override
  String get deleted => 'Видалено';

  @override
  String get emphasis => 'У Emphasє';

  @override
  String get listBullet => 'Список кулі';

  @override
  String get strong => 'Сильний';

  @override
  String get markdown => 'Markdown';

  @override
  String get home => 'Домашній екран';

  @override
  String get files => 'Файли';

  @override
  String get sortBy => 'Сортувати за';

  @override
  String get location => 'Місцезнаходження';

  @override
  String get whatsNew => 'Що новенького?';

  @override
  String get unstar => 'Вилучити з обраного';

  @override
  String get star => 'Зірка';

  @override
  String get goUp => 'Догори';

  @override
  String get created => 'Створений';

  @override
  String get modified => 'Змінено';

  @override
  String get quickstart => 'Швидкий старт';

  @override
  String get noTemplates => 'Наразі немає доступних шаблонів';

  @override
  String get importCorePack => 'Імпортувати базовий пакет';

  @override
  String get importCorePackDescription =>
      'Імпортувати основний пакет, який містить всі основні активи для початку. Це перевизначить поточний базовий пакет.';

  @override
  String get never => 'Ніколи';

  @override
  String get onlyOnUpdates => 'Тільки при оновленні';

  @override
  String get visibility => 'Видимість';

  @override
  String get captureThumbnail => 'Захопити ескіз';

  @override
  String get capturedThumbnail => 'Успішно захоплено ескіз';

  @override
  String get chooseLabelMode => 'Виберіть режим мітки';

  @override
  String get foreground => 'Активний режим';

  @override
  String get version => 'Версія';

  @override
  String get repository => 'Репозиторій';

  @override
  String get pages => 'Сторінки';

  @override
  String get navigator => 'Navigator';

  @override
  String get arrange => 'Організувати';

  @override
  String get bringToFront => 'Привести на передній план';

  @override
  String get sendToBack => 'Відправити на задній план';

  @override
  String get bringForward => 'Поверніть вперед';

  @override
  String get sendBackward => 'Відправити назад';

  @override
  String get rotation => 'Поворот екрану';

  @override
  String get onlyAvailableLargerScreen => 'Доступно тільки на більших екранах';

  @override
  String get toolbarPosition => 'Позиція панелі інструментів';

  @override
  String get rotate => 'Обертати';

  @override
  String get spacer => 'Розділювач';

  @override
  String get navigationRail => 'Навігаційна залізниця';

  @override
  String get cut => 'Вирізати';

  @override
  String get insertBefore => 'Вставити до';

  @override
  String get insertAfter => 'Вставити після';

  @override
  String get insertFirst => 'Вставити перший';

  @override
  String get insertLast => 'Insert last';

  @override
  String get paste => 'Вставити';

  @override
  String get ascending => 'За зростанням';

  @override
  String get descending => 'За спаданням';

  @override
  String get imageScale => 'Масштаб зображення';

  @override
  String get select => 'Вибрати';

  @override
  String get tool => 'Інструмент';

  @override
  String get texture => 'Текстура';

  @override
  String get platformTheme => 'Тема платформи';

  @override
  String get desktop => 'Стільниця';

  @override
  String get mobile => 'Мобільний';

  @override
  String get pdfQuality => 'Якість PDF';

  @override
  String get surface => 'Поверхня';

  @override
  String get pattern => 'Графічний ключ';

  @override
  String get sureClose => 'Ви впевнені, що хочете закрити документ?';

  @override
  String get thereAreUnsavedChanges => 'Є незбережені зміни';

  @override
  String get page => 'Сторінка';

  @override
  String get iceServers => 'ICE сервери';

  @override
  String get collaboration => 'Співпраця';

  @override
  String get webRtc => 'Web RTC';

  @override
  String get webSocket => 'Веб-сокет';

  @override
  String get iceServer => 'Сервер ICE';

  @override
  String get port => 'Порт';

  @override
  String get type => 'Тип';

  @override
  String get side => 'Сторона';

  @override
  String get client => 'Клієнт';

  @override
  String get server => 'Сервер';

  @override
  String get switchView => 'Перемкнути у вигляд';

  @override
  String get lasso => 'Lasso';

  @override
  String get hideUI => 'Приховати інтерфейс';

  @override
  String get density => 'Густина';

  @override
  String get compact => 'Компактний';

  @override
  String get comfortable => 'Комфортний';

  @override
  String get standard => 'Стандартна';

  @override
  String get lock => 'Зачинити';

  @override
  String get addElement => 'Додати елемент';

  @override
  String get notDefaultConnection => 'Не з\'єднатися за замовчуванням';

  @override
  String get defaultConnection => 'З\'єднання за замовчуванням';

  @override
  String get hide => 'Приховати';

  @override
  String get show => 'Показати';

  @override
  String get pause => 'Пауза';

  @override
  String get stop => 'Зупинити';

  @override
  String get refresh => 'Оновити';

  @override
  String get print => 'Друк';

  @override
  String get dav => 'ДАНІ';

  @override
  String get eyeDropper => 'Піпетка';

  @override
  String get users => 'Спільноти';

  @override
  String get experiments => 'Експерименти';

  @override
  String get experimentsWarning =>
      'Ці функції експериментальні і можуть змінюватися, перебиватися чи зникати в будь-який час. Включення їх може викликати нестабільність або втрату даних. Будьте обачні. Будь ласка, повідомте про будь-які помилки.';

  @override
  String get address => 'Адреса';

  @override
  String get spreadToPages => 'Поширення на сторінки';

  @override
  String get rootDirectorySpecifiedDescription =>
      'Кореневий каталог вказаний. Всі просунуті шляхи будуть відносно цієї теки. Залиште порожнім, щоб вимкнути цей тип каталогу.';

  @override
  String get rootDirectoryNotSpecifiedDescription =>
      'Кореневий каталог не вказано. Ім\'я вимагається. Всі розширені шляхи до каталогів будуть абсолютні. Залиште порожнім, щоб вимкнути цей тип каталогу.';

  @override
  String get unsecureConnectionTitle => 'Незахищене з\'єднання';

  @override
  String unsecureConnectionMessage(String fingerprint) {
    return 'Підключення не безпечне. Це може бути безпечним ризиком. Будь ласка, продовжуйте, якщо довіряєте підключенню. Відбиток на рівні $fingerprint.';
  }

  @override
  String get continueAnyway => 'Все одно продовжити';

  @override
  String get zoomControl => 'Управління масштабуванням';

  @override
  String get highContrast => 'Високий контраст';

  @override
  String get shouldANumber => 'Це значення має бути дійсним числом';

  @override
  String get createAreas => 'Створення області';

  @override
  String get autosave => 'Autosave';

  @override
  String get invert => 'Invert';

  @override
  String get operations => 'Операції';

  @override
  String get medium => 'Медіум';

  @override
  String get large => 'Великий';

  @override
  String get toolbarSize => 'Розмір панелі інструментів';

  @override
  String get addAll => 'Додати всі';

  @override
  String get onlyCurrentPage => 'Тільки поточна сторінка';

  @override
  String get smoothNavigation => 'Плавна навігація';

  @override
  String get exact => 'Точно';

  @override
  String get inline => 'У тексті';

  @override
  String get toolbarRows => 'Рядки панелі інструментів';

  @override
  String get pointerTest => 'Тест вказівника';

  @override
  String get pressure => 'Тиск';

  @override
  String get small => 'Маленький';

  @override
  String get tiny => 'Дрібний';

  @override
  String get selectAll => 'Виділити все';

  @override
  String get overrideTools => 'Змінити інструменти';

  @override
  String get hideCursorWhileDrawing => 'Сховати курсор під час малювання';

  @override
  String get installed => 'Встановлено';

  @override
  String get install => 'Інсталювати';

  @override
  String get deselect => 'Зняти виділення';

  @override
  String get changeCollection => 'Змінити збірку';

  @override
  String get collections => 'Колекції';

  @override
  String get fullSelection => 'Повний вибір';

  @override
  String get fullSelectionDescription => 'Для вибору потрібні елементи.';

  @override
  String get collection => 'Колекція';

  @override
  String get defaultCollection => 'Типова збірка';

  @override
  String get scroll => 'Прокрутка';

  @override
  String get onStartup => 'При запуску';

  @override
  String get homeScreen => 'Домашній екран';

  @override
  String get lastNote => 'Остання примітка';

  @override
  String get newNote => 'Нова нотатка';

  @override
  String get convertToLayer => 'Конвертувати в шар';

  @override
  String get merge => 'Об\'єднати';

  @override
  String get up => 'Вгору';

  @override
  String get down => 'Донизу';

  @override
  String get other => 'Інше';

  @override
  String countElements(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count елементи',
      one: '1 елемент',
      zero: 'Немає елементів',
    );
    return '$_temp0';
  }

  @override
  String get colorToolbar => 'Панель кольорів';

  @override
  String get yesButShowButtons => 'Так, але показувати кнопки';

  @override
  String get optionsPanelPosition => 'Позиція панелі налаштувань';

  @override
  String get hideDuration => 'Приховати тривалість';

  @override
  String get animation => 'Анімація';

  @override
  String get performance => 'Продуктивність';

  @override
  String get performanceDescription =>
      'Оптимізується для швидкості та використання пам\'яті. Відображається лише видима частина нотаток, яка відтворена у зображення.';

  @override
  String get normalDescription =>
      'Активує якість та продуктивність. Створює зображення що охоплює відстань в 1,5 рази від видимої області, забезпечуючи більш плавні переходи при прокручуванні.';

  @override
  String get high => 'Високий';

  @override
  String get highDescription =>
      'Підвищує якість відповідно до продуктивності. Випускає область зображення, що розкриває 2 рази видимості, забезпечує безшовний рендеринг навіть під час швидкого прокручування чи масштабування.';

  @override
  String get renderResolution => 'Роздільна здатність візуалізації';

  @override
  String get translate => 'Переклад';

  @override
  String get unencrypted => 'Незашифровано';

  @override
  String get encrypted => 'Зашифрований';

  @override
  String get encryptDocumentMessage => 'Натисніть для шифрування документа';

  @override
  String get unencryptDocumentMessage => 'Натисніть, щоб розшифрувати документ';

  @override
  String get unencrypt => 'Нешифрувати';

  @override
  String get encrypt => 'Шифрувати';

  @override
  String get encryptWarning =>
      'Це буде шифрувати документ. Вам потрібно буде пам\'ятати пароль, щоб розшифрувати його.';

  @override
  String get unencryptWarning =>
      'Це розшифрує документ. Пароль буде видалений, і всі користувачі з доступом зможуть відкрити його.';

  @override
  String get confirmPassword => 'Підтвердити пароль';

  @override
  String get passwordMismatch => 'Паролі не співпадають';

  @override
  String get action => 'Дія';

  @override
  String get svgText => 'SVG текст';

  @override
  String get offset => 'Зміщення';

  @override
  String get positionDependent => 'Залежність від позиції';

  @override
  String get flipHorizontal => 'Віддзеркалити горизонтально';

  @override
  String get flipVertical => 'Віддзеркалити вертикально';

  @override
  String get grayscale => 'Grayscale';

  @override
  String get moveOnGesture => 'Перемістити жест';

  @override
  String get exportAllFiles => 'Експортувати всі файли';

  @override
  String get restoreSettingsFromFile => 'Відновити налаштування з файлу';

  @override
  String get exportSettingsToFile => 'Експорт налаштувань у файл';

  @override
  String get barcode => 'Barcode';

  @override
  String get barcodeType => 'Тип штрихкоду';

  @override
  String get qrCode => 'QR Code';

  @override
  String get dataMatrix => 'Матриця даних';

  @override
  String get code128 => 'Код 128';

  @override
  String defaultUserName(int index) {
    return 'Користувач $index';
  }

  @override
  String get moveLeft => 'Посунути ліворуч';

  @override
  String get moveRight => 'Рухатися праворуч';

  @override
  String get bundledPacks => 'Зібрані пакети';

  @override
  String get component => 'Компонент';

  @override
  String get selectComponent => 'Компонент';

  @override
  String get bundlePackInDocument => 'Комплектний пакет в документі';

  @override
  String get bundledPacksDescription =>
      'Комплектні пакети включені в документ і використовуються тільки для спільного використання з документом. Активи можуть бути використані тільки в документі, якщо пакет встановлений. Пакунки можуть бути встановлені за допомогою натискання на них.';

  @override
  String get fillAlpha => 'Заповнити альфа';

  @override
  String get packagedFile => 'Упакований файл';

  @override
  String get rawFile => 'Raw файл';

  @override
  String get webSocketDescription =>
      'Ваш пристрій хостить сервер, тому співробітники можуть приєднатися тільки до тієї ж мережі або з деінде, якщо переходити до порту на маршрутизаторі.';

  @override
  String get swampDescription =>
      'Ваші повідомлення перенаправляються через безпечний сервер ретранслятора з обмеженим шифруванням. Для створення сеансу потрібна адреса болота.';

  @override
  String get createRawNote => 'Створити сиру нотатку';

  @override
  String get polygon => 'Многокутник';

  @override
  String get finishShape => 'Завершити форму';

  @override
  String get submit => 'Ввести';

  @override
  String get math => 'Математика';

  @override
  String get ignorePressure => 'Ігнорувати тиск';

  @override
  String get ignoreFirstPressureDescription =>
      'На деяких пристроях перше значення тиску не точне. Ця настройка ігноруватиме перше значення тиску і буде використовувати тиск другої події.';

  @override
  String get temporary => 'Тимчасово';

  @override
  String get simpleToolbarVisibility => 'Проста видимість панелі інструментів';

  @override
  String get autosaveDelay => 'Затримка автозбереження';

  @override
  String get saved => 'Збережено';

  @override
  String get saving => 'Збереження...';

  @override
  String get readOnly => 'Тільки для читання';

  @override
  String get saveDelayed => 'Зберегти затримку';

  @override
  String get unsaved => 'Не збережено';

  @override
  String get pdfEmptyDescription =>
      'Наразі немає областей для експорту. Будь ласка, виберіть принаймні одну ділянку, використовуючи \"+\" у правому верхньому куті, або додайте усі області з поточної сторінки або з документу нижче.';

  @override
  String get densityMaximize => 'Maximize';
}
