// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Oriya (`or`).
class AppLocalizationsOr extends AppLocalizations {
  AppLocalizationsOr([String locale = 'or']) : super(locale);

  @override
  String get open => 'ଖୋଲନ୍ତୁ';

  @override
  String get settings => 'ସେଟିଂସ୍';

  @override
  String get personalization => 'ବ୍ୟକ୍ତିଗତୀକରଣ';

  @override
  String get theme => 'ଥୀମ୍';

  @override
  String get darkTheme => 'ହଳୁଦ ଅନ୍ଧକାର ଥୀମ୍';

  @override
  String get lightTheme => 'ହଳୁଦ ଆଲୋକିତ ଥୀମ୍';

  @override
  String get systemTheme => 'ଡିଫଲ୍ଟ ସିଷ୍ଟମ୍ ଥୀମ୍ ବ୍ୟବହାର କରନ୍ତୁ';

  @override
  String get view => 'ଦେଖନ୍ତୁ';

  @override
  String get edit => 'ସମ୍ପାଦନା';

  @override
  String get export => 'ନିର୍ୟାତ';

  @override
  String get save => 'ସଞ୍ଚୟ';

  @override
  String get zoom => 'ଜୁମ୍';

  @override
  String get zoomIn => 'ଜୁମ୍ ଏବଂ ବଡ କରନ୍ତୁ';

  @override
  String get zoomOut => 'ଜୁମ୍ ଛୋଟ କରନ୍ତୁ';

  @override
  String get resetZoom => 'ଜୁମ୍ ପୁନଃସ୍ଥାପନ';

  @override
  String get strokeWidth => 'ଲାଇନ୍ ପ୍ରସ୍ଥ';

  @override
  String get includeEraser => 'ଇରେଜର୍ ସମ୍ମିଳିତ କରିବେ?';

  @override
  String get thinning => 'ଚିରକରଣ';

  @override
  String get pen => 'କଳମ';

  @override
  String get invertedPen => 'ଉଲ୍ଟା କଳମ';

  @override
  String get eraser => 'ଇରେଜର୍';

  @override
  String get pathEraser => 'ପଥ ଇରେଜର୍';

  @override
  String get label => 'ଲେବେଲ୍';

  @override
  String get delete => 'ମୁଚାନ୍ତୁ';

  @override
  String get areYouSure => 'ତୁମେ ନିଶ୍ଚିତ?';

  @override
  String get reallyDelete =>
      'ତୁମେ ଏହି ଆଇଟମ୍‌ଟି ବାସ୍ତବରେ ଡିଲିଟ୍ କରିବାକୁ ଚାହୁଁଛ?';

  @override
  String get no => 'ନା';

  @override
  String get yes => 'ହଁ';

  @override
  String get undo => 'ପୂର୍ବବତୀ କାର୍ଯ୍ୟ ଫେରାନ୍ତୁ';

  @override
  String get redo => 'ପୁନଃକ୍ରିୟା କରନ୍ତୁ';

  @override
  String get general => 'ସାଧାରଣ';

  @override
  String get copyTitle => 'କ୍ଲିପବୋର୍ଡକୁ କପି ହେଲା';

  @override
  String get loading => 'ଲୋଡ୍ ହେଉଛି...';

  @override
  String get enterText => 'ପାଠ୍ୟ ଲେଖନ୍ତୁ';

  @override
  String get size => 'ଆକାର';

  @override
  String get width => 'ପ୍ରସ୍ଥ';

  @override
  String get height => 'ଉଚ୍ଚତା';

  @override
  String get count => 'ଗଣନା';

  @override
  String get space => 'ଅନ୍ତରାଳ';

  @override
  String get background => 'ପୃଷ୍ଠଭୂମି';

  @override
  String get box => 'ପେଟିକା';

  @override
  String get locale => 'ଲୋକେଲ୍';

  @override
  String get systemLocale => 'ସିଷ୍ଟମ୍ ଲୋକେଲ୍';

  @override
  String get information => 'ତଥ୍ୟ';

  @override
  String get license => 'ଲାଇସେନ୍ସ';

  @override
  String get imprint => 'ଇମ୍ପ୍ରିଣ୍ଟ୍';

  @override
  String get privacypolicy => 'ଗୋପନୀୟତା ନୀତି';

  @override
  String get sourceCode => 'ସ୍ରୋତ କୋଡ୍';

  @override
  String get documentation => 'ଡକ୍ୟୁମେଣ୍ଟେସନ୍';

  @override
  String get changelog => 'ଚେଇଞ୍ଜଲଗ୍';

  @override
  String get source => 'ସ୍ରୋତ';

  @override
  String get existOverride =>
      'ଏହି ଉପାଦାନ ପূର୍ବରୁ ଅବସ୍ଥିତ ଅଛି। ଓଭର୍ରାଇଟ୍ କରିବେ?';

  @override
  String get description => 'ବିବରଣୀ';

  @override
  String get fill => 'ପୂରଣ';

  @override
  String get defaultPalette => 'ଡିଫଲ୍ଟ ପ୍ୟାଲେଟ୍';

  @override
  String get highlighter => 'ହାଇଲାଇଟର୍';

  @override
  String get add => 'ଯୋଗ କରନ୍ତୁ';

  @override
  String get remove => 'ହଟାନ୍ତୁ';

  @override
  String get removeConfirm => 'ତୁମେ ଏହାକୁ ବାସ୍ତବରେ ହଟାଇବାକୁ ଚାହୁଁଛ?';

  @override
  String get resetPalette => 'ପ୍ୟାଲେଟ୍ ପୁନଃସ୍ଥାପନ';

  @override
  String get custom => 'କଷ୍ଟମ୍';

  @override
  String get decoration => 'ସଜାଣ';

  @override
  String get underline => 'ତଳ ରେଖା';

  @override
  String get overline => 'ଉପର ରେଖା';

  @override
  String get strikethrough => 'କଟକଣ୍ଡ ରେଖା';

  @override
  String get thickness => 'ମୋଟାଇ';

  @override
  String get style => 'ଶୈଳୀ';

  @override
  String get solid => 'ଦୃଢ';

  @override
  String get double => 'ଦ୍ୱିତୀୟ';

  @override
  String get dotted => 'ଛିଇଆ';

  @override
  String get dashed => 'ଲାଇଆ';

  @override
  String get wavy => 'ତରଙ୍ଗାକାର';

  @override
  String get fontWeight => 'ଫଣ୍ଟ ଓଜନ';

  @override
  String get normal => 'ସାଧାରଣ';

  @override
  String get bold => 'ହେମ୍';

  @override
  String get italic => 'ଇଟାଲିକ୍';

  @override
  String get clipboard => 'କ୍ଲିପବୋର୍ଡ';

  @override
  String get file => 'ଫାଇଲ୍';

  @override
  String get data => 'ତଥ୍ୟ';

  @override
  String get share => 'ଶେୟାର୍';

  @override
  String get spacing => 'ଅନ୍ତରାଳ';

  @override
  String get image => 'ଛବି';

  @override
  String get enterUrl => 'URL ଦାଖଲ କରନ୍ତୁ';

  @override
  String get scale => 'ପ୍ରମାଣ';

  @override
  String get help => 'ସାହାଯ୍ୟ';

  @override
  String get reallyReset => 'ତୁମେ ଏହାକୁ ବାସ୍ତବରେ ପୁନଃସ୍ଥାପନ କରିବାକୁ ଚାହୁଁଛ?';

  @override
  String get whatToDo => 'ତୁମେ କʼଣ କରିବାକୁ ଚାହୁଁଛ?';

  @override
  String get ignore => 'ଅନଦେଖା କରନ୍ତୁ';

  @override
  String get backup => 'ବ୍ୟାକଅପ୍';

  @override
  String createdInNewerVersion(String fileName, int fileVersion) {
    return 'ଫାଇଲ୍ $fileName ଏକ ନୂତନ ସଂସ୍କରଣ ($fileVersion)ରେ ସୃଷ୍ଟି ହୋଇଛି। ଏହି ଫାଇଲ୍ ସହ କʼଣ କରିବେ?';
  }

  @override
  String get waypoints => 'ପଥବିଂଦୁ';

  @override
  String get origin => 'ମୂଳ';

  @override
  String get import => 'ଆମଦାନି';

  @override
  String get newContent => 'ନୂତନ';

  @override
  String get selectElement => 'ଉପାଦାନ ଚୟନ କରନ୍ତୁ';

  @override
  String get ctrlKey => 'Ctrl';

  @override
  String get shiftKey => 'Shift';

  @override
  String get altKey => 'Alt';

  @override
  String get copyVersion => 'ସଂସ୍କରଣ କପି';

  @override
  String get input => 'ଇନ୍ପୁଟ୍';

  @override
  String get behaviors => 'ଆଚରଣ';

  @override
  String get dataDirectory => 'ଡାଟା ଡିରେକ୍ଟୋରି';

  @override
  String get defaultPath => 'ଡିଫଲ୍ଟ ପଥ';

  @override
  String get dateFormat => 'ତାରିଖ ଫର୍ମାଟ୍';

  @override
  String updatedAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'ଅଦ୍ୟତିତ: $dateTimeString';
  }

  @override
  String createdAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'ତିଆରି: $dateTimeString';
  }

  @override
  String get rename => 'ନାମ ପରିବର୍ତ୍ତନ କରନ୍ତୁ';

  @override
  String get duplicate => 'ନକଲି କରନ୍ତୁ';

  @override
  String get hand => 'ହାତ';

  @override
  String get folder => 'ଫୋଲ୍ଡର୍';

  @override
  String get move => 'ସରାନ୍ତୁ';

  @override
  String get copy => 'ନକଲି';

  @override
  String get back => 'ବାକି';

  @override
  String get zoomDependent => 'ଜୁମ୍ ନିର୍ଭର';

  @override
  String get shapeDetection => 'ଆକୃତି ଚିହ୍ନଟ';

  @override
  String get delay => 'ବିଳମ୍ବ';

  @override
  String get defaultLayer => 'ଡିଫଲ୍ଟ ସ୍ତର';

  @override
  String get layer => 'ସ୍ତର';

  @override
  String get layers => 'ସ୍ତରଗୁଡିକ';

  @override
  String get notSet => 'ସଜିତ ନୁହେଁ';

  @override
  String get enterLayer => 'ସ୍ତରର ନାମ ପ୍ରବେଶ କରନ୍ତୁ';

  @override
  String get selectElements => 'ଉପାଦାନଗୁଡିକ ଚୟନ କରନ୍ତୁ';

  @override
  String get deleteElements => 'ଉପାଦାନଗୁଡିକ ମୁଚାନ୍ତୁ';

  @override
  String get deleteElementsConfirm =>
      'ତୁମେ ଚୟିତ ଉପାଦାନଗୁଡିକ ବାସ୍ତବରେ ଡିଲିଟ୍ କରିବାକୁ ଚାହୁଁଛ?';

  @override
  String get selectCustomCollection => 'କଷ୍ଟମ୍ ସଂଗ୍ରହ ଚୟନ କରନ୍ତୁ';

  @override
  String get svg => 'SVG';

  @override
  String get sensitivity => 'ସଂවේଦନଶୀଳତା';

  @override
  String get sensitivityHint => 'ଅଧିକ ମୂଲ୍ୟ, ଅଧିକ ସଂਵੇଦନଶୀଳ';

  @override
  String get horizontal => 'ଆଡ଼';

  @override
  String get vertical => 'ଉର୍ଧ୍ୱା';

  @override
  String get plain => 'ସାଧାରଣ';

  @override
  String get light => 'ହଳୁକା';

  @override
  String get ruled => 'ରୂଲ୍ଡ';

  @override
  String get quad => 'ଚତୁର୍ଭୁଜ';

  @override
  String get music => 'ସଙ୍ଗୀତ';

  @override
  String get dark => 'ଅନ୍ଧକାର';

  @override
  String get plainDark => 'ସାଧାରଣ ଅନ୍ଧକାର';

  @override
  String get ruledDark => 'ରୂଲ୍ଡ ଅନ୍ଧକାର';

  @override
  String get quadDark => 'ଚତୁର୍ଭୁଜ ଅନ୍ଧକାର';

  @override
  String get musicDark => 'ସଙ୍ଗୀତ ଅନ୍ଧକାର';

  @override
  String get templates => 'ଟେମ୍ପଲେଟ୍';

  @override
  String get untitled => 'ଶୀର୍ଷକ ନାହିଁ';

  @override
  String get createTemplate => 'ଟେମ୍ପଲେଟ୍ ତିଆରି କରନ୍ତୁ';

  @override
  String get createTemplateContent =>
      'ତୁମେ ବାସ୍ତବରେ ଏହି ଡକ୍ୟୁମେଣ୍ଟରୁ ଟେମ୍ପଲେଟ୍ ତିଆରି କରିବାକୁ ଚାହୁଁଛ? ମୂଳ ଡକ୍ୟୁମେଣ୍ଟ ଡିଲିଟ୍ ହେବ।';

  @override
  String get replace => 'ବଦଳାନ୍ତୁ';

  @override
  String get reallyReplace =>
      'ତୁମେ ବାସ୍ତବରେ টେମ୍ପଲେଟ୍ ବଦଳାଇବାକୁ ଚାହୁଁଛ? ଏହା ପୁନଃପ୍ରାରମ୍ଭ ହେବା ନାହିଁ!';

  @override
  String get defaultTemplate => 'ଡିଫଲ୍ଟ ଟେମ୍ପଲେଟ୍';

  @override
  String get insert => 'ସାମିଲ କରନ୍ତୁ';

  @override
  String get document => 'ଡକ୍ୟୁମେଣ୍ଟ';

  @override
  String get camera => 'କ୍ୟାମେରା';

  @override
  String get printout => 'ପ୍ରିଣ୍ଟ୍ଆଉଟ୍';

  @override
  String get selectCamera => 'କ୍ୟାମେରା ଚୟନ କରନ୍ତୁ';

  @override
  String get changeDocumentPath => 'ଡକ୍ୟୁମେଣ୍ଟ ପଥ ପରିବର୍ତ୍ତନ କରନ୍ତୁ';

  @override
  String get deleteWholeStroke => 'ସମ୍ପୁର୍ଣ୍ଣ ଲାଇନ୍ ଡିଲିଟ୍ କରନ୍ତୁ';

  @override
  String get alpha => 'ଆଲଫା';

  @override
  String get area => 'ଅଞ୍ଚଳ';

  @override
  String get selectArea => 'ଅଞ୍ଚଳ ଚୟନ କରନ୍ତୁ';

  @override
  String get aspectRatio => 'ପ୍ରମାଣୁପାତ';

  @override
  String get presets => 'ପ୍ରିସେଟ୍';

  @override
  String get pagePortrait => 'ପେଜ ପୋର୍ଟ୍ରେଟ୍';

  @override
  String get pageLandscape => 'ପେଜ ଲ୍ୟାଣ୍ଡସ୍କେପ୍';

  @override
  String get square => 'ବର୍ଗ';

  @override
  String get areas => 'ଅଞ୍ଚଳଗୁଡିକ';

  @override
  String get enterArea => 'ଅଞ୍ଚଳ ଲେଖନ୍ତୁ';

  @override
  String get exitArea => 'ଅଞ୍ଚଳ ଛାଡ଼ନ୍ତୁ';

  @override
  String get currentArea => 'ଚଳୁ ଅଞ୍ଚଳ';

  @override
  String get design => 'ଡିଜାଇନ୍';

  @override
  String get text => 'ପାଠ୍ୟ';

  @override
  String welcome(String codeName) {
    return 'ହେଲୋ, ଏହା Linwood Butterfly $codeName';
  }

  @override
  String get welcomeContent => 'ମୁକ୍ତ ଏବଂ ଓପେନ୍-ସୋର୍ସ ଡ୍ରୟିଂ ସ୍ପେସ୍!';

  @override
  String updated(String version) {
    return 'ଆପ୍ $version ସଂସ୍କରଣକୁ ଅଦ୍ୟତିତ';
  }

  @override
  String get releaseNotes => 'ରିଲିଜ୍ ନୋଟ୍';

  @override
  String get constraints => 'ନିବନ୍ଧନ';

  @override
  String get scaled => 'ମାପିତ';

  @override
  String get fixed => 'ନିଶ୍ଚିତ';

  @override
  String get dynamicContent => 'ଗତିଶୀଳ';

  @override
  String get none => 'କିଛି ନୁହେଁ';

  @override
  String get includeArea => 'ଅଞ୍ଚଳ ସମ୍ମିଳିତ କରନ୍ତୁ';

  @override
  String get verticalAlignment => 'ଉର୍ଧ୍ୱା ସମନ୍ୱୟ';

  @override
  String get horizontalAlignment => 'ଆଡ଼ ସମନ୍ୱୟ';

  @override
  String get top => 'ଶୀର୍ଷ';

  @override
  String get center => 'ମଧ୍ୟ';

  @override
  String get bottom => 'ତଳ';

  @override
  String get left => 'ବାମ';

  @override
  String get right => 'ଦକ୍ଷିଣ';

  @override
  String get justify => 'ସମାନ';

  @override
  String get constraint => 'ନିବନ୍ଧନ';

  @override
  String get length => 'ଦৈର୍ଘ୍ୟ';

  @override
  String get exportSvg => 'SVG ନିର୍ୟାତ';

  @override
  String get pdf => 'PDF';

  @override
  String get selectPages => 'ପୃଷ୍ଠାଗୁଡିକ ଚୟନ କରନ୍ତୁ';

  @override
  String get recentFiles => 'ନୂତନ ଫାଇଲ୍';

  @override
  String get start => 'ଆରମ୍ଭ';

  @override
  String get noRecentFiles => 'କୌଣସି ନୂତନ ଫାଇଲ୍ ନାହିଁ';

  @override
  String countPages(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ପୃଷ୍ଠା',
      one: '1 ପୃଷ୍ଠା',
      zero: 'କୌଣସି ପୃଷ୍ଠା ନାହିଁ',
    );
    return '$_temp0';
  }

  @override
  String pageIndex(int index) {
    return 'ପୃଷ୍ଠା $index';
  }

  @override
  String get exit => 'ବାହାରିବେ';

  @override
  String get noElements => 'କୌଣସି ଉପାଦାନ ନାହିଁ';

  @override
  String get invertSelection => 'ଚୟନ ବିପରୀତ';

  @override
  String get errorWhileImporting => 'ଆମଦାନିକାଳୀନ ত্ৰୁଟି';

  @override
  String get errorWhileImportingContent => 'ଫାଇଲ୍ ଆମଦାନି ସମୟରେ ଏକ ত୍ରୁଟି ଘଟିଛି';

  @override
  String get showDetails => 'ବିବରଣୀ ଦେଖାନ୍ତୁ';

  @override
  String get hideDetails => 'ବିବରଣୀ ଲୁଚାନ୍ତୁ';

  @override
  String get error => 'ତ୍ରୁଟି';

  @override
  String get stackTrace => 'ସ୍ଟ୍ୟାକ୍ ଟ୍ରେସ୍';

  @override
  String get laser => 'ଲେଜର୍';

  @override
  String get duration => 'ଦୀର୍ଘତା';

  @override
  String get quality => 'ଗୁಣତ୍ତା';

  @override
  String get exportPdf => 'PDF ନିର୍ୟାତ';

  @override
  String get local => 'ଲୋକାଲ୍';

  @override
  String get addConnection => 'ଯୋଡନ୍ତୁ ସଂଯୋଗ';

  @override
  String get connections => 'ସଂଯୋଗଗୁଡିକ';

  @override
  String get noConnections => 'କୌଣସି ସଂଯୋଗ ନାହିଁ';

  @override
  String get url => 'URL';

  @override
  String get connect => 'ସଂଯୋଗ କରନ୍ତୁ';

  @override
  String get username => 'ଉପଯୋଗକର୍ତ୍ତା ନାମ';

  @override
  String get password => 'ପାସୱାର୍ଡ';

  @override
  String get webNotSupported => 'ଓଲଇନ୍ ସମର୍ଥିତ ନୁହେଁ';

  @override
  String get advanced => 'ଉନ୍ନତ';

  @override
  String get directory => 'ଡିରେକ୍ଟୋରି';

  @override
  String get documentsDirectory => 'ଡକ୍ୟୁମେଣ୍ଟ ଡିରେକ୍ଟୋରି';

  @override
  String get templatesDirectory => 'ଟେମ୍ପଲେଟ୍ ଡିରେକ୍ଟୋରି';

  @override
  String get errorWhileCreatingConnection => 'ସଂଯୋଗ ତିଆରି କାଳୀନ ত୍ରୁଟି';

  @override
  String get cannotConnect => 'ସଂଯୋଗ ସମ୍ଭବ ନୁହେଁ';

  @override
  String get urlNotValid => 'URL ମାନ୍ୟ ନୁହେଁ';

  @override
  String get icon => 'ଆଇକନ୍';

  @override
  String get update => 'ଅଦ୍ୟତିତ';

  @override
  String get updateAvailable => 'ଅଦ୍ୟତିତ ଉପଲବ୍ଧ';

  @override
  String get stable => 'ସ୍ଥିର';

  @override
  String get nightly => 'ନିଶିତଳ';

  @override
  String get checkForUpdates => 'ଅଦ୍ୟତନ ପରୀକ୍ଷା କରନ୍ତୁ';

  @override
  String get checkForUpdatesWarning =>
      'ଅଦ୍ୟତନ ପରୀକ୍ଷା କରିବା ସମୟରେ Butterfly ୱେବସାଇଟ୍ ସହ ଯୋଗାଯୋଗ କରାଯିବ।';

  @override
  String get usingLatestStable => 'ତୁମେ ସବୁଠୁ ନୂତନ ସ୍ଥିର ସଂସ୍କରଣ ବ୍ୟବହାର କରୁଛ';

  @override
  String get usingLatestNightly =>
      'ତୁମେ ସବୁଠୁ ନୂତନ ନିଶିତଳ ସଂସ୍କରଣ ବ୍ୟବହାର କରୁଛ';

  @override
  String get currentVersion => 'ଚଲୁ ସଂସ୍କରଣ';

  @override
  String get updateNow => 'ଭଳିଅବେଲାରେ ଅଦ୍ୟତିତ କରନ୍ତୁ';

  @override
  String get shape => 'ଆକୃତି';

  @override
  String get circle => 'ବୃତ୍ତ';

  @override
  String get rectangle => 'ଆୟତ';

  @override
  String get triangle => 'ତିଭୁଜ';

  @override
  String get line => 'ରେଖା';

  @override
  String get cornerRadius => 'କୋନ୍ ରୌଦ୍ରତା';

  @override
  String get topLeft => 'ଉପର ବାମ';

  @override
  String get topRight => 'ଉପର ଦକ୍ଷିଣ';

  @override
  String get bottomLeft => 'ତଳ ବାମ';

  @override
  String get bottomRight => 'ତଳ ଦକ୍ଷିଣ';

  @override
  String get caches => 'କ୍ୟାଶଗୁଡିକ';

  @override
  String get manage => 'ପରିଚାଳନା';

  @override
  String get clearCaches => 'କ୍ୟାଶ ସଫା କରନ୍ତୁ';

  @override
  String get createCache => 'କ୍ୟାଶ ସୃଷ୍ଟି କରନ୍ତୁ';

  @override
  String get thirdPartyLicenses => 'ତୃତୀୟ ପକ୍ଷ ଲାଇସେନ୍ସ';

  @override
  String get syncing => 'ସିଙ୍କ୍ ହେଉଛି...';

  @override
  String get synced => 'ସିଙ୍କ୍ ହୋଇଛି';

  @override
  String get notSynced => 'ସିଙ୍କ୍ ହୋଇନାହିଁ';

  @override
  String get conflict => 'ସଂଘର୍ଷ';

  @override
  String get keepLocal => 'ଲୋକାଲ୍ ରଖନ୍ତୁ';

  @override
  String get keepConnection => 'ସଂଯୋଗ ରଖନ୍ତୁ';

  @override
  String get keepBoth => 'ଦୁହେଁଟି ରଖନ୍ତୁ';

  @override
  String get forAll => 'ସମସ୍ତଙ୍କ ପାଇଁ';

  @override
  String fileConflict(String file, String connection) {
    return '$file ଏବଂ $connection ମଧ୍ୟରେ ସଂଘର୍ଷ ଅଛି';
  }

  @override
  String get offline => 'ଅଫ୍ଲାଇନ୍';

  @override
  String get localLatest => 'ସ୍ଥାନୀୟ ନୂତମ';

  @override
  String get connectionLatest => 'ସଂଯୋଗ ନୂତମ';

  @override
  String get path => 'ପଥ';

  @override
  String get folderSynced => 'ଫୋଲ୍ଡର୍ ସିଙ୍କ୍ ହୋଇଛି';

  @override
  String get syncRootDirectory => 'ରୁଟ୍ ସିଙ୍କ୍ ଡିରେକ୍ଟୋରି';

  @override
  String get penOnlyInput => 'କଳମ ମାତ୍ର ଇନ୍ପୁଟ୍';

  @override
  String get inputGestures => 'ଇନ୍ପୁଟ୍ ଇଶାରାଗୁଡିକ';

  @override
  String get nativeTitleBar => 'ନେଟିଭ୍ ଟାଇଟେଲ୍ ବାର୍';

  @override
  String get syncMode => 'ସିଙ୍କ୍ ମୋଡ୍';

  @override
  String get connection => 'ସଂଯୋଗ';

  @override
  String get always => 'ସମୟ ସମୟ';

  @override
  String get noMobile => 'ମୋବାଇଲ୍ ନୁହେଁ';

  @override
  String get manual => 'ମାନୁଆଲ୍';

  @override
  String get search => 'ଶୋଧନ';

  @override
  String get properties => 'ଗୁଣ';

  @override
  String get pin => 'ପିନ୍';

  @override
  String get unpin => 'ଅନପିନ୍';

  @override
  String get element => 'ଉପାଦାନ';

  @override
  String get painter => 'ଚିତ୍ରକାର';

  @override
  String get position => 'ସ୍ଥିତି';

  @override
  String get note => 'ଟିପ୍ପଣୀ';

  @override
  String get packs => 'ପ୍ୟାକ୍';

  @override
  String get pack => 'ପ୍ୟାକ୍';

  @override
  String get more => 'ଅଧିକ';

  @override
  String get askForName => 'ନାମ ପଚାରନ୍ତୁ';

  @override
  String areaIndex(int index) {
    return 'ଅଞ୍ଚଳ $index';
  }

  @override
  String get startInFullScreen => 'ପୂର୍ଣ୍ଣ ସ୍କ୍ରିନ୍ ଆରମ୍ଭ';

  @override
  String get inputs => 'ଇନ୍ପୁଟ୍ସ୍';

  @override
  String get mouse => 'ମାଉସ୍';

  @override
  String get touch => 'ଟଚ୍';

  @override
  String get keyboard => 'କୀବୋର୍ଡ୍';

  @override
  String get shortcuts => 'ଶଧାନ୍ତ୍ର';

  @override
  String get middle => 'ମଧ୍ୟମ';

  @override
  String get first => 'ପ୍ରଥମ';

  @override
  String get second => 'ଦ୍ୱିତୀୟ';

  @override
  String get activeTool => 'ସକ୍ରିୟ ଟୁଲ୍';

  @override
  String get activeToolDescription => 'ଟୁଲ୍ବାରରେ ଚୟନିତ ଟୁଲ୍ ବ୍ୟବହାର କରନ୍ତୁ';

  @override
  String get handTool => 'ହାତ ଟୁଲ୍';

  @override
  String get handToolDescription => 'କ୍ୟାନଭାସ୍ ଘୁମାଇବାକୁ ଡ୍ରାଗ୍ କରନ୍ତୁ';

  @override
  String get toolOnToolbar => 'ଟୁଲ୍ବାରରେ ନିର୍ଦ୍ଦିଷ୍ଟ ଟୁଲ୍';

  @override
  String get toolOnToolbarDescription =>
      'ବାମ ଦିଗରୁ ଗଣନା କରି ଟୁଲ୍ବାରର ସ୍ଥିତି ଅନୁଯାୟୀ ଟୁଲ୍ ବ୍ୟବହାର କରନ୍ତୁ';

  @override
  String toolOnToolbarShort(int display_position) {
    return 'ଟୁଲ୍ବାର ସ୍ଥିତି: $display_position';
  }

  @override
  String get tools => 'ଟୁଲ୍';

  @override
  String get showGrid => 'ଗ୍ରିଡ୍ ଦେଖାନ୍ତୁ';

  @override
  String get grid => 'ଗ୍ରିଡ୍';

  @override
  String get ruler => 'ରୁଲର୍';

  @override
  String get angle => 'କୋଣ';

  @override
  String get report => 'ରିପୋର୍ଟ';

  @override
  String get newFolder => 'ନୂତନ ଫୋଲ୍ଡର୍';

  @override
  String get createPack => 'ପ୍ୟାକ୍ ତିଆରି କରନ୍ତୁ';

  @override
  String get editPack => 'ପ୍ୟାକ୍ ସମ୍ପାଦନା';

  @override
  String get packsDirectory => 'ପ୍ୟାକ୍ ଡିରେକ୍ଟୋରି';

  @override
  String get stamp => 'ଷ୍ଟାମ୍ପ୍';

  @override
  String get addToPack => 'ପ୍ୟାକ୍ ଭିତରକୁ ଯୋଗ କରନ୍ତୁ';

  @override
  String get sureImportPack =>
      'ତୁମେ ନିଶ୍ଚିତ ଭାବେ ପ୍ୟାକ୍ ଆମଦାନି କରିବାକୁ ଚାହୁଁଛ?';

  @override
  String byAuthor(String author) {
    return '$authorଙ୍କ ଦ୍ୱାରା';
  }

  @override
  String get author => 'ଲେଖକ';

  @override
  String get addAsset => 'ଏସେଟ୍ ଯୋଡନ୍ତୁ';

  @override
  String get editAsset => 'ଏସେଟ୍ ସମ୍ପାଦନା';

  @override
  String get scope => 'ପରିଧି';

  @override
  String get noPacks => 'ସାମ୍ପ୍ରତିକ ଭାବରେ କୌଣସି ପ୍ୟାକ୍ ଉପଲବ୍ଧ ନାହିଁ';

  @override
  String get components => 'ଉପାଦାନ';

  @override
  String get waypoint => 'ପଥବିଂଦୁ';

  @override
  String get actions => 'କାର୍ଯ୍ୟ';

  @override
  String get painters => 'ଚିତ୍ରକାର';

  @override
  String get breakingChangesTitle => 'ବ୍ରେକିଂ ପରିବର୍ତ୍ତନ';

  @override
  String breakingChangesMessage(int version, int newVersion) {
    return 'ଏହି ସଂସ୍କରଣରେ ବ୍ରେକିଂ ପରିବର୍ତ୍ତନ ଅଛି। ଅଦ୍ୟତନ ପୂର୍ବରୁ ଚେଇଞ୍ଜଲଗ୍ ପଢ଼ନ୍ତୁ। ଚଳୁ ଫାଇଲ୍ ସଂସ୍କରଣ $version, ନୂତନ ସଂସ୍କରଣ $newVersion।';
  }

  @override
  String get styles => 'ଶୈଳୀ';

  @override
  String get paragraph => 'ଅନୁଛେଦ';

  @override
  String get fontFamily => 'ଫଣ୍ଟ ପରିବାର';

  @override
  String get smoothing => 'ସ୍ମୂଥିଂ';

  @override
  String get streamline => 'ସ୍ଟ୍ରିମଲାଇନ୍';

  @override
  String get presentation => 'ପ୍ରସ୍ତୁତିକରଣ';

  @override
  String get selectAsset => 'ଏସେଟ୍ ଚୟନ କରନ୍ତୁ';

  @override
  String get clearStyle => 'ଶୈଳୀ ସଫା କରନ୍ତୁ';

  @override
  String get unknownImportType => 'ଅଜଣା ଆମଦାନି ପ୍ରକାର';

  @override
  String get sureImportTemplate =>
      'ତୁମେ ନିଶ୍ଚିତ ଭାବେ ଟେମ୍ପଲେଟ୍ ଆମଦାନି କରିବାକୁ ଚାହୁଁଛ?';

  @override
  String get frame => 'ଫ୍ରେମ୍';

  @override
  String get play => 'ଚାଳନା';

  @override
  String get video => 'ଭିଡିଓ';

  @override
  String get fps => 'FPS';

  @override
  String get breakpoint => 'ବ୍ରେକପଏଣ୍ଟ';

  @override
  String get presentationControls => 'ପ୍ରସ୍ତୁତିକରଣ ନିୟନ୍ତ୍ରଣ';

  @override
  String get nextSlide => 'ପରବର୍ତ୍ତୀ ସ୍ଲାଇଡ୍';

  @override
  String get nextSlideDescription =>
      'ଡାହାଣ କୋଣକୁ ସ୍ୱାଇପ୍ କରନ୍ତୁ କିମ୍ବା ସଜା ବାଣ୍ୟ କୀକୁ ଦାବନ୍ତୁ';

  @override
  String get previousSlide => 'ପୂର୍ବବର୍ତ୍ତୀ ସ୍ଲାଇଡ୍';

  @override
  String get previousSlideDescription =>
      'ବାମ କୋଣକୁ ସ୍ୱାଇପ୍ କରନ୍ତୁ କିମ୍ବା ବାମ ଏରୋ କୀକୁ ଦାବନ୍ତୁ';

  @override
  String get exitPresentation => 'ପ୍ରସ୍ତୁତିକରଣ ଛାଡ଼ନ୍ତୁ';

  @override
  String get exitPresentationDescription =>
      'ESC କିକିମ୍ବା ତଳକୁ ସ୍ୱାଇପ୍ କରି ପ୍ରସ୍ତୁତିକରଣ ଛାଡ଼ନ୍ତୁ';

  @override
  String get pausePresentation => 'ପ୍ରସ୍ତୁତିକରଣ ବିରତି';

  @override
  String get pausePresentationDescription =>
      'ତ୍ୟାବ କିମ୍ବା ସ୍ପେସ୍ ବାର୍ ଦାବି ପ୍ରସ୍ତୁତିକରଣ ବିରତି କିମ୍ବା ଚାଳୁ କରନ୍ତୁ';

  @override
  String get keyframe => 'କୀଫ୍ରେମ୍';

  @override
  String get endOfPresentation => 'ତୁମେ ପ୍ରସ୍ତୁତିକରଣର ଶେଷକୁ ପହଞ୍ଚିଛ';

  @override
  String get startOfPresentation => 'ତୁମେ ପ୍ରସ୍ତୁତିକରଣର ଆରମ୍ଭକୁ ପହଞ୍ଚିଛ';

  @override
  String get palettes => 'ପ୍ୟାଲେଟ୍';

  @override
  String headline(int index) {
    return 'ଶୀର୍ଷକ $index';
  }

  @override
  String get code => 'କୋଡ୍';

  @override
  String get quote => 'ଉଦ୍ଧୃତ';

  @override
  String get link => 'ଲିଙ୍କ୍';

  @override
  String get checkbox => 'ଚେକ୍ବକ୍ସ୍';

  @override
  String get deleted => 'ଡିଲିଟ୍ ହେଲା';

  @override
  String get emphasis => 'ଗୁରୁତ୍ୱାକର୍ଷଣ';

  @override
  String get listBullet => 'ଲିଷ୍ଟ୍ ବୁଲେଟ୍';

  @override
  String get strong => 'ହେମ୍';

  @override
  String get markdown => 'Markdown';

  @override
  String get home => 'ହୋମ୍';

  @override
  String get files => 'ଫାଇଲ୍ଗୁଡିକ';

  @override
  String get sortBy => 'ଦ୍ୱାରା ଛାଣନ୍ତୁ';

  @override
  String get location => 'ସ୍ଥାନ';

  @override
  String get whatsNew => 'କ\'ଣ ନୂତନ?';

  @override
  String get unstar => 'ଅନସ୍ଟାର୍';

  @override
  String get star => 'ସ୍ଟାର୍';

  @override
  String get goUp => 'ଉପରକୁ ଯାନ୍ତୁ';

  @override
  String get created => 'ତିଆରି';

  @override
  String get modified => 'ସଂଶୋଧିତ';

  @override
  String get quickstart => 'ଦ୍ରୁତ ଆରମ୍ଭ';

  @override
  String get noTemplates => 'ସାମ୍ପ୍ରତିକ ଭାବରେ କୌଣସି ଟେମ୍ପଲେଟ୍ ନାହିଁ';

  @override
  String get importCorePack => 'କୋର୍ ପ୍ୟାକ୍ ଆମଦାନି';

  @override
  String get importCorePackDescription =>
      'ସମସ୍ତ ବେସିକ୍ ଏସେଟ୍ ସହ କୋର୍ ପ୍ୟାକ୍ ଆମଦାନି କରନ୍ତୁ। ଏହା ଚଳୁ କୋर୍ ପ୍ୟାକ୍ କୁ ଓଭର୍ରାଇଟ୍ କରିବ।';

  @override
  String get never => 'କେବେ ନୁହେଁ';

  @override
  String get onlyOnUpdates => 'କେବଳ ଅଦ୍ୟତନରେ';

  @override
  String get visibility => 'ଦୃଶ୍ୟତା';

  @override
  String get captureThumbnail => 'ଥମ୍ନେଲ୍ ଧରନ୍ତୁ';

  @override
  String get capturedThumbnail => 'ଥମ୍ନେଲ୍ ସଫଳତାର ସହିତ ଧରାଗଲା';

  @override
  String get chooseLabelMode => 'ଲେବେଲ୍ ମୋଡ୍ ଚୟନ କରନ୍ତୁ';

  @override
  String get foreground => 'ସାମ୍ନା';

  @override
  String get version => 'ସଂସ୍କରଣ';

  @override
  String get repository => 'ରିପୋଜିଟୋରି';

  @override
  String get pages => 'ପୃଷ୍ଠାଗୁଡିକ';

  @override
  String get navigator => 'ନାଭିଗେଟର୍';

  @override
  String get arrange => 'ସଜାନ୍ତୁ';

  @override
  String get bringToFront => 'ସାମ୍ନାକୁ ଆଣନ୍ତୁ';

  @override
  String get sendToBack => 'ପଛକୁ ପଠାନ୍ତୁ';

  @override
  String get bringForward => 'ଆଗକୁ ଆଣନ୍ତୁ';

  @override
  String get sendBackward => 'ପଛକୁ ପଠାନ୍ତୁ';

  @override
  String get rotation => 'ଘୁର୍ଣ୍ଣନ';

  @override
  String get onlyAvailableLargerScreen => 'ମାତ୍ର ବଡ଼ ସ୍କ୍ରିନ୍ ଉପଲବ୍ଧ';

  @override
  String get toolbarPosition => 'ଟୁଲ୍ବାର ସ୍ଥାନ';

  @override
  String get rotate => 'ଘୁରାନ୍ତୁ';

  @override
  String get spacer => 'ସ୍ପେସର୍';

  @override
  String get navigationRail => 'ନାଭିଗେସନ୍ ରେଲ୍';

  @override
  String get cut => 'କଟ୍';

  @override
  String get insertBefore => 'ପୂର୍ବରୁ ସଂଯୋଜନ';

  @override
  String get insertAfter => 'ପରେ ସଂଯୋଜନ';

  @override
  String get insertFirst => 'ପ୍ରଥମେ ସଂଯୋଜନ';

  @override
  String get insertLast => 'ଶେଷରେ ସଂଯୋଜନ';

  @override
  String get paste => 'ପେଷ୍ଟ୍';

  @override
  String get ascending => 'ଉର୍ଦ୍ଧ୍ୱଗତ';

  @override
  String get descending => 'ଅବରୋହଣ';

  @override
  String get imageScale => 'ଛବି ପ୍ରମାଣ';

  @override
  String get select => 'ଚୟନ କରନ୍ତୁ';

  @override
  String get tool => 'ଉପକରଣ';

  @override
  String get texture => 'ବିତାନା';

  @override
  String get platformTheme => 'ଛୋଟ';

  @override
  String get desktop => 'ଡେସ୍କଟପ୍';

  @override
  String get mobile => 'ମୋବାଇଲ୍';

  @override
  String get pdfQuality => 'PDF ଗୁଣତ୍ତା';

  @override
  String get surface => 'ପୃଷ୍ଠତଳ';

  @override
  String get pattern => 'ନମୁନା';

  @override
  String get sureClose => 'ତୁମେ ନିଶ୍ଚିତ ଭାବେ ଡକ୍ୟୁମେଣ୍ଟ ବନ୍ଦ କରିବାକୁ ଚାହୁଁଛ?';

  @override
  String get thereAreUnsavedChanges => 'ଅସଞ୍ଚିତ ପରିବର୍ତ୍ତନ ଅଛି';

  @override
  String get page => 'ପୃଷ୍ଠା';

  @override
  String get iceServers => 'ICE ସର୍ବର୍ଗୁଡିକ';

  @override
  String get collaboration => 'ସହଯୋଗ';

  @override
  String get webRtc => 'Web RTC';

  @override
  String get webSocket => 'Web Socket';

  @override
  String get iceServer => 'ICE ସର୍ବର୍';

  @override
  String get port => 'ପୋର୍ଟ୍';

  @override
  String get type => 'ପ୍ରକାର';

  @override
  String get side => 'ପାଆର୍ଶ୍ୱ';

  @override
  String get client => 'କ୍ଲାୟେଣ୍ଟ୍';

  @override
  String get server => 'ସର୍ବର୍';

  @override
  String get switchView => 'ଭିଉ ମାପଂତୁ';

  @override
  String get lasso => 'ଲାସୋ';

  @override
  String get hideUI => 'UI ଲୁଚାନ୍ତୁ';

  @override
  String get density => 'ଘନତା';

  @override
  String get compact => 'ସଂକ୍ଷିପ୍ତ';

  @override
  String get comfortable => 'आरାମଦାୟକ';

  @override
  String get standard => 'ମାନ';

  @override
  String get lock => 'ଲକ୍';

  @override
  String get addElement => 'ଉପାଦାନ ଯୋଡନ୍ତୁ';

  @override
  String get notDefaultConnection => 'ଡିଫଲ୍ଟ ସଂଯୋଗ ନୁହେଁ';

  @override
  String get defaultConnection => 'ଡିଫଲ୍ଟ ସଂଯୋଗ';

  @override
  String get hide => 'ଲୁଚାନ୍ତୁ';

  @override
  String get show => 'ଦେଖାନ୍ତୁ';

  @override
  String get pause => 'ବିରତି';

  @override
  String get stop => 'ବନ୍ଦ କରନ୍ତୁ';

  @override
  String get refresh => 'ତାଜା କରନ୍ତୁ';

  @override
  String get print => 'ମୁଦ୍ରଣ';

  @override
  String get dav => 'DAV';

  @override
  String get eyeDropper => 'ଆଖିର ଛଡା';

  @override
  String get users => 'ବ୍ୟବହାରକାରୀ';

  @override
  String get experiments => 'ପ୍ରୟୋଗ';

  @override
  String get experimentsWarning =>
      'ଏହି ବୈଶିଷ୍ଟ୍ୟଗୁଡିକ ପ୍ରୟୋଗଶୀଳ ଏବଂ କେବେ ମଧ୍ୟ ଫେରି ଯାଇପାରିବ। ସଚେତନ ଭାବେ ଆଗକୁ ଆଗୁଆ କରନ୍ତୁ। ଦୟାକରି କ bug ଣସି ବଗ୍ ଚିହ୍ନଟ କରନ୍ତୁ।';

  @override
  String get address => 'ଠିକଣା';

  @override
  String get spreadToPages => 'ପୃଷ୍ଠାଗୁଡିକକୁ ପ୍ରସାରିତ କରନ୍ତୁ';

  @override
  String get rootDirectorySpecifiedDescription =>
      'ମୂଳ ଡିରେକ୍ଟୋରି ନିର୍ଦ୍ଦିଷ୍ଟ। ସମସ୍ତ ଉନ୍ନତ ଡିରେକ୍ଟୋରି ପଥ ଏହା ପ୍ରତ୍ୟକ୍ଷ କରିବ। ଏହାକୁ ଖାଲି ରଖିଲେ ଏହି ପ୍ରକାର ବନ୍ଦ ହେବ।';

  @override
  String get rootDirectoryNotSpecifiedDescription =>
      'ମୂଳ ଡିରେକ୍ଟୋରି ନିର୍ଦ୍ଦିଷ୍ଟ ନୁହେଁ। ଏକ ନାମ ଆବଶ୍ୟକ। ସମସ୍ତ ଉନ୍ନତ ଡିରେକ୍ଟୋରି ପଥ ସମ୍ପୂର୍ଣ୍ଣ ହେବ। ଏହାକୁ ଖାଲି ରଖିଲେ ଏହି ପ୍ରକାର ବନ୍ଦ ହେବ।';

  @override
  String get unsecureConnectionTitle => 'ନିରାପଦ ସଂଯୋଗ';

  @override
  String unsecureConnectionMessage(String fingerprint) {
    return 'ସଂଯୋଗ ସୁରକ୍ଷିତ ନୁହେଁ। ଏହା ଏକ ସୁରକ୍ଷା ବିପଦ ହୋଇପାରେ। ମାତ୍ର ଯଦି ତୁମେ ଭରସା କର, ତେବେ ଆଗକୁ ଚାଲନ୍ତୁ। ସha1 ଫିଙ୍ଗରପ୍ରିଣ୍ଟ୍ $fingerprint।';
  }

  @override
  String get continueAnyway => 'ତଥାପି ଆଗକୁ ବଢ଼ନ୍ତୁ';

  @override
  String get zoomControl => 'ଜୁମ୍ ନିୟନ୍ତ୍ରଣ';

  @override
  String get highContrast => 'ଉଚ୍ଚ ବିପରୀତତା';

  @override
  String get shouldANumber => 'ଏହି ମୂଲ୍ୟଟି ବୈଧ ସଂଖ୍ୟା ହେବା ଉଚିତ';

  @override
  String get createAreas => 'ଅଞ୍ଚଳ ତିଆରି କରନ୍ତୁ';

  @override
  String get autosave => 'ସ୍ଵୟଂଚାଳିତ ସଞ୍ଚୟ';

  @override
  String get invert => 'ବିପରୀତ';

  @override
  String get operations => 'କାର୍ଯ୍ୟାନୁଷ୍ଠାନ';

  @override
  String get medium => 'ମଧ୍ୟମ';

  @override
  String get large => 'ବଡ଼';

  @override
  String get toolbarSize => 'ଟୁଲ୍ବାର ଆକାର';

  @override
  String get addAll => 'ସବୁଯୋଗ କରନ୍ତୁ';

  @override
  String get onlyCurrentPage => 'କେବଳ ଚଳୁ ପୃଷ୍ଠା';

  @override
  String get smoothNavigation => 'ସ୍ମୂଥ୍ ନାଭିଗେସନ୍';

  @override
  String get exact => 'ଖୋଲ୍';

  @override
  String get inline => 'ଇନ୍ଲାଇନ୍';

  @override
  String get toolbarRows => 'ଟୁଲ୍ବାର ତାଲିକା';

  @override
  String get pointerTest => 'ପଏଣ୍ଟର୍ ପରୀକ୍ଷା';

  @override
  String get pressure => 'ଦବାଇ';

  @override
  String get small => 'ଛୋଟ';

  @override
  String get tiny => 'ମିନି';

  @override
  String get selectAll => 'ସବୁ ଚୟନ କରନ୍ତୁ';

  @override
  String get overrideTools => 'ଟୁଲ୍ ଓଭର୍ରାଇଟ୍';

  @override
  String get hideCursorWhileDrawing => 'ଚିତ୍ରାଙ୍କନ କାଳୀନ କର୍ସର୍ ଲୁଚାନ୍ତୁ';

  @override
  String get installed => 'ଇନ୍‌ସ୍ଟଲ୍ ହେଲା';

  @override
  String get install => 'ଇନ୍‌ସ୍ଟଲ୍';

  @override
  String get deselect => 'ଚୟନ ହଟାନ୍ତୁ';

  @override
  String get changeCollection => 'ସଂଗ୍ରହ ପରିବର୍ତ୍ତନ';

  @override
  String get collections => 'ସଂଗ୍ରହ';

  @override
  String get fullSelection => 'ସମ୍ପୂର୍ଣ୍ଣ ଚୟନ';

  @override
  String get fullSelectionDescription =>
      'ଚୟନ ପେଟିକା ମଧ୍ୟରେ ଅନ୍ତର୍ଗତ ଉପାଦାନକୁ ମାତ୍ର ଚୟନ କରନ୍ତୁ।';

  @override
  String get collection => 'ସଂଗ୍ରହ';

  @override
  String get defaultCollection => 'ଡିଫଲ୍ଟ ସଂଗ୍ରହ';

  @override
  String get scroll => 'ସ୍କ୍ରୋଲ୍';

  @override
  String get onStartup => 'ଆରମ୍ଭରେ';

  @override
  String get homeScreen => 'ହୋମ୍ ସ୍କ୍ରିନ୍';

  @override
  String get lastNote => 'ଶେଷ ଟିପ୍ପଣୀ';

  @override
  String get newNote => 'ନୂତନ ଟିପ୍ପଣୀ';

  @override
  String get convertToLayer => 'ସ୍ତରକୁ ପରିବର୍ତ୍ତନ';

  @override
  String get merge => 'ମିଶାନ୍ତୁ';

  @override
  String get up => 'ଉପରକୁ';

  @override
  String get down => 'ନିମ୍ନକୁ';

  @override
  String get other => 'ଅନ୍ୟ';

  @override
  String countElements(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ଉପାଦାନ',
      one: '1 ଉପାଦାନ',
      zero: 'କୌଣସି ଉପାଦାନ ନାହିଁ',
    );
    return '$_temp0';
  }

  @override
  String get colorToolbar => 'ରଙ୍ଗ ଟୁଲ୍ବାର';

  @override
  String get yesButShowButtons => 'ହଁ, କିନ୍ତୁ ବଟନ୍ଗୁଡିକ ଦେଖାନ୍ତୁ';

  @override
  String get optionsPanelPosition => 'ଓପ୍ସନ୍ ପ୍ୟାନେଲ୍ ସ୍ଥାନ';

  @override
  String get hideDuration => 'ଦୀର୍ଘତା ଲୁଚାନ୍ତୁ';

  @override
  String get animation => 'ଅନିମେସନ୍';

  @override
  String get performance => 'ଦକ୍ଷତା';

  @override
  String get performanceDescription =>
      'ଗତି ଏବଂ ସ୍ମୃତି ବ୍ୟବହାର ପାଇଁ ଅପ୍ଟିମାଇଜ୍। କେବଳ ଦେଖାଯାଉଥିବା ଅଞ୍ଚଳ ଇମେଜ୍ ବେକ୍ କରାଯାଏ।';

  @override
  String get normalDescription =>
      'ଗୁଣତ୍ତା ଏବଂ ଦକ୍ଷତା ମଧ୍ୟରେ ସମତୁଳନ। ଦৃଶ୍ୟମାନ ଅଞ୍ଚଳର 1.5 ଗୁଣ ଇମେଜ୍ ବେକ୍ କରାଯାଏ, ଯାହା ସ୍କ୍ରୋଲ୍ ସମୟରେ ସ୍ମୂଥ୍ ରୂପରେ ତରଙ୍ଗ ପ୍ରଦାନ କରେ।';

  @override
  String get high => 'ଉଚ୍ଚ';

  @override
  String get highDescription =>
      'Maximizes quality at the cost of performance. Bakes an image covering 2 times the visible area, ensuring seamless rendering even during rapid scrolling or zooming.';

  @override
  String get renderResolution => 'ରେଣ୍ଡର୍ ରେଜୋଲ୍ୟୁସନ୍';

  @override
  String get translate => 'ଅନୁବାଦ';

  @override
  String get unencrypted => 'ଅଏନ୍କ୍ରିପ୍ଟେଡ୍';

  @override
  String get encrypted => 'ଏନ୍କ୍ରିପ୍ଟେଡ୍';

  @override
  String get encryptDocumentMessage =>
      'ଡକ୍ୟୁମେଣ୍ଟ ଏନ୍କ୍ରିପ୍ଟ କରିବାକୁ କ୍ଲିକ୍ କରନ୍ତୁ';

  @override
  String get unencryptDocumentMessage =>
      'ଡକ୍ୟୁମେଣ୍ଟ ଅଏନ୍କ୍ରିପ୍ଟ କରିବାକୁ କ୍ଲିକ୍ କରନ୍ତୁ';

  @override
  String get unencrypt => 'ଅଏନ୍କ୍ରିପ୍ଟ କରନ୍ତୁ';

  @override
  String get encrypt => 'ଏନ୍କ୍ରିପ୍ଟ କରନ୍ତୁ';

  @override
  String get encryptWarning =>
      'ଏହା ଡକ୍ୟୁମେଣ୍ଟ ଏନ୍କ୍ରିପ୍ଟ କରିବ। ଡିକ୍ରିପ୍ଟ କରିବାକୁ ପାସୱାର୍ଡ ସ୍ମରଣ ରଖିବାକୁ ପଡ଼ିବ।';

  @override
  String get unencryptWarning =>
      'ଏହା ଡକ୍ୟୁମେଣ୍ଟ ଅଏନ୍କ୍ରିପ୍ଟ କରିବ। ପାସୱାର୍ଡ ହଟିଯିବ ଏବଂ ସମସ୍ତଙ୍କୁ ଖୋଲିବାର ଅଧିକାର ମିଳିବ।';

  @override
  String get confirmPassword => 'ପାସୱାର୍ଡ ପୁନଃପ୍ରମାଣିତ କରନ୍ତୁ';

  @override
  String get passwordMismatch => 'ପାସୱାର୍ଡ ମେଳ ଖାଉନାହିଁ';

  @override
  String get action => 'କାର୍ୟ';

  @override
  String get svgText => 'SVG ଟେକ୍ସ୍ଟ୍';

  @override
  String get offset => 'ଓଫସେଟ୍';

  @override
  String get positionDependent => 'ସ୍ଥିତି ନିର୍ଭର';

  @override
  String get flipHorizontal => 'ଆଡ଼ ଫ୍ଲିପ୍';

  @override
  String get flipVertical => 'ଉର୍ଧ୍ୱା ଫ୍ଲିପ୍';

  @override
  String get grayscale => 'ଗ୍ରେସ୍କେଲ୍';

  @override
  String get moveOnGesture => 'ଇଶାରାରେ ସରାନ୍ତୁ';

  @override
  String get exportAllFiles => 'ସମସ୍ତ ଫାଇଲ୍ ନିର୍ୟାତ';

  @override
  String get restoreSettingsFromFile => 'ଫାଇଲ୍ରୁ ସେଟିଂସ୍ ପୁନଃସ୍ଥାପନ';

  @override
  String get exportSettingsToFile => 'ସେଟିଂସ୍ ଫାଇଲ୍ ରେ ନିର୍ୟାତ';

  @override
  String get barcode => 'ବାର୍କୋଡ୍';

  @override
  String get barcodeType => 'ବାର୍କୋଡ୍ ପ୍ରକାର';

  @override
  String get qrCode => 'QR କୋଡ୍';

  @override
  String get dataMatrix => 'ଡାଟା ମ୍ୟାଟ୍ରିକ୍ସ';

  @override
  String get code128 => 'କୋଡ୍ 128';

  @override
  String defaultUserName(int index) {
    return 'ଉପଯୋଗକର୍ତ୍ତା $index';
  }

  @override
  String get moveLeft => 'ବାମକୁ ସରାନ୍ତୁ';

  @override
  String get moveRight => 'ଦକ୍ଷିଣକୁ ସରାନ୍ତୁ';

  @override
  String get bundledPacks => 'ବନ୍ଧା ପ୍ୟାକ୍';

  @override
  String get component => 'Component';

  @override
  String get selectComponent => 'ଉପାଦାନ ଚୟନ କରନ୍ତୁ';

  @override
  String get bundlePackInDocument => 'ଡକ୍ୟୁମେଣ୍ଟରେ ପ୍ୟାକ୍ ବନ୍ଧନ୍ତୁ';

  @override
  String get bundledPacksDescription =>
      'ବନ୍ଧା ପ୍ୟାକ୍ ଡକ୍ୟୁମେଣ୍ଟରେ ସହିତ ଥାଏ, ପ୍ରତି ଡକ୍ୟୁମେଣ୍ଟରେ ବାଣ୍ଟିବା ପାଇଁ। ଏପି ପ୍ୟାକ୍ ଇନ୍‌ସ୍ଟଲ୍ କଲେ ଉପାଦାନ ବ୍ୟବହାର ହେବ।';

  @override
  String get fillAlpha => 'ଆଲଫା ପୂରଣ';

  @override
  String get packagedFile => 'ପ୍ୟାକେଜ୍ ଫାଇଲ୍';

  @override
  String get rawFile => 'କଚ୍ଚା ଫାଇଲ୍';

  @override
  String get webSocketDescription =>
      'ତୁମର ଡିଭାଇସ୍ ସର୍ବର୍ ହୋଷ୍ଟ୍ କରିଥାଏ, ସହଯୋଗୀମାନେ ଏକେଇ ନେଟୱର୍କ୍ ପାଇଁ କିମ୍ବା ପୋର୍ଟ୍ ଫରୱାର୍ଡ କଲେ ଯେଉଁଠାରୁ ଯୋଡିପାରିବେ।';

  @override
  String get swampDescription =>
      'ତୁମର ମେସେଜ୍ ଏକ ସୁରକ୍ଷିତ ମଞ୍ଜିଲ୍ ସର୍ଭର୍ ମାଧ୍ୟମରେ ଗତି କରେ। ସେସନ୍ ସୃଷ୍ଟି ପାଇଁ swamp ସର୍ବର୍ ଠିକଣା ଆବଶ୍ୟକ।';

  @override
  String get createRawNote => 'କଚ୍ଚା ଟିପ୍ପଣୀ ତିଆରି କରନ୍ତୁ';

  @override
  String get polygon => 'ବহୁଭୁଜ';

  @override
  String get finishShape => 'ଆକୃତି ସମାପ୍ତ';

  @override
  String get submit => 'ଦାଖଲ କରନ୍ତୁ';

  @override
  String get math => 'Math';

  @override
  String get ignorePressure => 'Ignore pressure';

  @override
  String get ignoreFirstPressureDescription =>
      'On some devices, the first pressure value is not accurate. This setting will ignore the first pressure value and use the pressure of the second event instead.';

  @override
  String get temporary => 'Temporary';

  @override
  String get simpleToolbarVisibility => 'Simple toolbar visibility';

  @override
  String get autosaveDelay => 'Autosave delay';

  @override
  String get saved => 'Saved';

  @override
  String get saving => 'Saving...';

  @override
  String get readOnly => 'Read only';

  @override
  String get saveDelayed => 'Save delayed';

  @override
  String get unsaved => 'Unsaved';

  @override
  String get pdfEmptyDescription =>
      'There are currently no areas to export. Please select at least one area using the plus button in the top right corner or add all areas from the current page or from the whole document below.';

  @override
  String get densityMaximize => 'Maximize';
}
