// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Finnish (`fi`).
class AppLocalizationsFi extends AppLocalizations {
  AppLocalizationsFi([String locale = 'fi']) : super(locale);

  @override
  String get open => 'Avaa';

  @override
  String get settings => 'Asetukset';

  @override
  String get personalization => 'Mukauttaminen';

  @override
  String get theme => 'Teema';

  @override
  String get darkTheme => 'Tumma teema';

  @override
  String get lightTheme => 'Vaalea teema';

  @override
  String get systemTheme => 'Käytä järjestelmän oletusteemaa';

  @override
  String get view => 'Näytä';

  @override
  String get edit => 'Muokkaa';

  @override
  String get export => 'Vie';

  @override
  String get save => 'Tallenna';

  @override
  String get zoom => 'Zoomaus';

  @override
  String get zoomIn => 'Zoomaa sisään';

  @override
  String get zoomOut => 'Zoomaa ulos';

  @override
  String get resetZoom => 'Reset zoom';

  @override
  String get strokeWidth => 'Aivojen leveys';

  @override
  String get includeEraser => 'Sisällytä tyhjennys?';

  @override
  String get thinning => 'Hehkuminen';

  @override
  String get pen => 'Kynä';

  @override
  String get invertedPen => 'Käänteinen Kynä';

  @override
  String get eraser => 'Eraser';

  @override
  String get pathEraser => 'Polun poistaminen';

  @override
  String get label => 'Tunniste';

  @override
  String get delete => 'Poista';

  @override
  String get areYouSure => 'Oletko varma?';

  @override
  String get reallyDelete => 'Haluatko varmasti poistaa tämän kohteen?';

  @override
  String get no => 'Ei';

  @override
  String get yes => 'Kyllä';

  @override
  String get undo => 'Kumoa';

  @override
  String get redo => 'Toista';

  @override
  String get general => 'Yleiset';

  @override
  String get copyTitle => 'Kopioitu leikepöydälle';

  @override
  String get loading => 'Ladataan...';

  @override
  String get enterText => 'Syötä teksti';

  @override
  String get size => 'Koko';

  @override
  String get width => 'Width';

  @override
  String get height => 'Korkeus';

  @override
  String get count => 'Lukumäärä';

  @override
  String get space => 'Tila';

  @override
  String get background => 'Tausta';

  @override
  String get box => 'Laatikko';

  @override
  String get locale => 'Lokaatio';

  @override
  String get systemLocale => 'Järjestelmän kieli';

  @override
  String get information => 'Tiedot';

  @override
  String get license => 'Lisenssi';

  @override
  String get imprint => 'Jälki';

  @override
  String get privacypolicy => 'Yksityisyyden suoja';

  @override
  String get sourceCode => 'Lähdekoodi';

  @override
  String get documentation => 'Dokumentaatio';

  @override
  String get changelog => 'Muutosloki';

  @override
  String get source => 'Lähde';

  @override
  String get existOverride => 'Tämä elementti on jo olemassa. Korvaa?';

  @override
  String get description => 'Kuvaus';

  @override
  String get fill => 'Täytä';

  @override
  String get defaultPalette => 'Oletus paletti';

  @override
  String get highlighter => 'Korostus';

  @override
  String get add => 'Lisää';

  @override
  String get remove => 'Poista';

  @override
  String get removeConfirm => 'Haluatko todella poistaa tämän?';

  @override
  String get resetPalette => 'Reset palette';

  @override
  String get custom => 'Mukautettu';

  @override
  String get decoration => 'Koristelu';

  @override
  String get underline => 'Alleviivaa';

  @override
  String get overline => 'Yliviiva';

  @override
  String get strikethrough => 'Yliviivaus';

  @override
  String get thickness => 'Paksuus';

  @override
  String get style => 'Tyyli';

  @override
  String get solid => 'Solid';

  @override
  String get double => 'Kaksinkertainen';

  @override
  String get dotted => 'Pisteytetty';

  @override
  String get dashed => 'Katkoviiva';

  @override
  String get wavy => 'Wavy';

  @override
  String get fontWeight => 'Kirjasimen paino';

  @override
  String get normal => 'Normaali';

  @override
  String get bold => 'Bold';

  @override
  String get italic => 'Italic';

  @override
  String get clipboard => 'Leikepöytä';

  @override
  String get file => 'Tiedosto';

  @override
  String get data => 'Tiedot';

  @override
  String get share => 'Jaa';

  @override
  String get spacing => 'Väli';

  @override
  String get image => 'Kuva';

  @override
  String get enterUrl => 'Anna URL-osoite';

  @override
  String get scale => 'Skaalaa';

  @override
  String get help => 'Ohje';

  @override
  String get reallyReset => 'Haluatko todella palauttaa sen?';

  @override
  String get whatToDo => 'Mitä sinä haluat tehdä?';

  @override
  String get ignore => 'Ohita';

  @override
  String get backup => 'Varmuuskopio';

  @override
  String createdInNewerVersion(String fileName, int fileVersion) {
    return 'Tiedosto $fileName on luotu uudempaan versioon ($fileVersion). Mitä pitäisi tehdä tällä tiedostolla?';
  }

  @override
  String get waypoints => 'Reittipisteet';

  @override
  String get origin => 'Alkuperä';

  @override
  String get import => 'Tuo';

  @override
  String get newContent => 'Uusi';

  @override
  String get selectElement => 'Valitse elementti';

  @override
  String get ctrlKey => 'Ctrl';

  @override
  String get shiftKey => 'Vaihto';

  @override
  String get altKey => 'Alt';

  @override
  String get copyVersion => 'Kopioi versio';

  @override
  String get input => 'Input';

  @override
  String get behaviors => 'Käyttäytymiset';

  @override
  String get dataDirectory => 'Datakansio';

  @override
  String get defaultPath => 'Oletus polku';

  @override
  String get dateFormat => 'Päivämäärän muoto';

  @override
  String updatedAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'Päivitetty: $dateTimeString';
  }

  @override
  String createdAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'Luotu $dateTimeString';
  }

  @override
  String get rename => 'Uudelleennimeä';

  @override
  String get duplicate => 'Duplicate';

  @override
  String get hand => 'Käsi';

  @override
  String get folder => 'Kansio';

  @override
  String get move => 'Siirrä';

  @override
  String get copy => 'Kopioi';

  @override
  String get back => 'Takaisin';

  @override
  String get zoomDependent => 'Lähennys riippuvainen';

  @override
  String get shapeDetection => 'Muodon Tunnistaminen';

  @override
  String get delay => 'Viive';

  @override
  String get defaultLayer => 'Oletus taso';

  @override
  String get layer => 'Taso';

  @override
  String get layers => 'Kerrokset';

  @override
  String get notSet => 'Ei asetettu';

  @override
  String get enterLayer => 'Syötä kerroksen nimi';

  @override
  String get selectElements => 'Valitse elementit';

  @override
  String get deleteElements => 'Poista elementit';

  @override
  String get deleteElementsConfirm =>
      'Haluatko varmasti poistaa valitut elementit?';

  @override
  String get selectCustomCollection => 'Valitse mukautettu kokoelma';

  @override
  String get svg => 'SVG';

  @override
  String get sensitivity => 'Herkkyys';

  @override
  String get sensitivityHint => 'Mitä suurempi arvo on, sitä herkempiä syöte';

  @override
  String get horizontal => 'Vaakasuora';

  @override
  String get vertical => 'Pystysuora';

  @override
  String get plain => 'Tavallinen';

  @override
  String get light => 'Vaalea';

  @override
  String get ruled => 'Kielletty';

  @override
  String get quad => 'Quad';

  @override
  String get music => 'Musiikki';

  @override
  String get dark => 'Tumma';

  @override
  String get plainDark => 'Tumma';

  @override
  String get ruledDark => 'Vedetty tumma';

  @override
  String get quadDark => 'Quad tumma';

  @override
  String get musicDark => 'Musiikki tumma';

  @override
  String get templates => 'Mallit';

  @override
  String get untitled => 'Nimetön';

  @override
  String get createTemplate => 'Luo malli';

  @override
  String get createTemplateContent =>
      'Haluatko varmasti luoda mallin tästä asiakirjasta? Alkuperäinen asiakirja poistetaan.';

  @override
  String get replace => 'Korvaa';

  @override
  String get reallyReplace =>
      'Haluatko varmasti korvata mallin? Tätä toimintoa ei voi kumota!';

  @override
  String get defaultTemplate => 'Oletus malli';

  @override
  String get insert => 'Insert';

  @override
  String get document => 'Asiakirja';

  @override
  String get camera => 'Kamera';

  @override
  String get printout => 'Tuloste';

  @override
  String get selectCamera => 'Valitse kamera';

  @override
  String get changeDocumentPath => 'Muuta asiakirjan polkua';

  @override
  String get deleteWholeStroke => 'Poista koko aivohalvaus';

  @override
  String get alpha => 'Alfa';

  @override
  String get area => 'Alue';

  @override
  String get selectArea => 'Valitse alue';

  @override
  String get aspectRatio => 'Kuvasuhde';

  @override
  String get presets => 'Esiasetukset';

  @override
  String get pagePortrait => 'Sivun muotokuva';

  @override
  String get pageLandscape => 'Sivun vaakakuva';

  @override
  String get square => 'Neliö';

  @override
  String get areas => 'Alueet';

  @override
  String get enterArea => 'Syötä alue';

  @override
  String get exitArea => 'Poistu alueesta';

  @override
  String get currentArea => 'Nykyinen alue';

  @override
  String get design => 'Ulkoasu';

  @override
  String get text => 'Teksti';

  @override
  String welcome(String codeName) {
    return 'Hei, tämä on Linwood Butterfly $codeName';
  }

  @override
  String get welcomeContent => 'Vapaa ja avoimen lähdekoodin piirtotila!';

  @override
  String updated(String version) {
    return 'Sovellus päivitetty versioon $version';
  }

  @override
  String get releaseNotes => 'Vapauta muistiinpanot';

  @override
  String get constraints => 'Rajoitukset';

  @override
  String get scaled => 'Skaalattu';

  @override
  String get fixed => 'Kiinteä';

  @override
  String get dynamicContent => 'Dynaaminen';

  @override
  String get none => 'Ei Mitään';

  @override
  String get includeArea => 'Sisällytä alue';

  @override
  String get verticalAlignment => 'Pystysuuntainen suuntaus';

  @override
  String get horizontalAlignment => 'Vaakasuora suuntaus';

  @override
  String get top => 'Ylhäällä';

  @override
  String get center => 'Keskitetty';

  @override
  String get bottom => 'Alhaalla';

  @override
  String get left => 'Vasen';

  @override
  String get right => 'Oikea';

  @override
  String get justify => 'Tasaa';

  @override
  String get constraint => 'Rajoitus';

  @override
  String get length => 'Pituus';

  @override
  String get exportSvg => 'Vie SVG';

  @override
  String get pdf => 'PDF';

  @override
  String get selectPages => 'Valitse sivut';

  @override
  String get recentFiles => 'Viimeisimmät tiedostot';

  @override
  String get start => 'Aloita';

  @override
  String get noRecentFiles => 'Ei viimeaikaisia tiedostoja';

  @override
  String countPages(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count sivua',
      one: '1 sivu',
      zero: 'Ei sivuja',
    );
    return '$_temp0';
  }

  @override
  String pageIndex(int index) {
    return 'Sivu $index';
  }

  @override
  String get exit => 'Poistu';

  @override
  String get noElements => 'Ei elementtejä';

  @override
  String get invertSelection => 'Käännä valinta';

  @override
  String get errorWhileImporting => 'Virhe tuotaessa';

  @override
  String get errorWhileImportingContent =>
      'Tiedoston tuonnin yhteydessä tapahtui virhe';

  @override
  String get showDetails => 'Näytä tiedot';

  @override
  String get hideDetails => 'Piilota tiedot';

  @override
  String get error => 'Virhe';

  @override
  String get stackTrace => 'Pino jälki';

  @override
  String get laser => 'Laser';

  @override
  String get duration => 'Kesto';

  @override
  String get quality => 'Laatu';

  @override
  String get exportPdf => 'Vie PDF';

  @override
  String get local => 'Paikallinen';

  @override
  String get addConnection => 'Lisää yhteys';

  @override
  String get connections => 'Yhteydet';

  @override
  String get noConnections => 'Ei yhteyksiä';

  @override
  String get url => 'URL-osoite';

  @override
  String get connect => 'Yhdistä';

  @override
  String get username => 'Käyttäjätunnus';

  @override
  String get password => 'Salasana';

  @override
  String get webNotSupported => 'Verkkoa ei tueta';

  @override
  String get advanced => 'Lisäasetukset';

  @override
  String get directory => 'Hakemisto';

  @override
  String get documentsDirectory => 'Asiakirjojen hakemisto';

  @override
  String get templatesDirectory => 'Mallien hakemisto';

  @override
  String get errorWhileCreatingConnection => 'Virhe yhteyttä luotaessa';

  @override
  String get cannotConnect => 'Ei voi yhdistää';

  @override
  String get urlNotValid => 'URL ei kelpaa';

  @override
  String get icon => 'Kuvake';

  @override
  String get update => 'Päivitä';

  @override
  String get updateAvailable => 'Päivitys saatavilla';

  @override
  String get stable => 'Vakaa';

  @override
  String get nightly => 'Yöllä';

  @override
  String get checkForUpdates => 'Tarkista päivitykset';

  @override
  String get checkForUpdatesWarning =>
      'Tarkistamalla päivityksiä voit ottaa yhteyttä Butterflen verkkosivuihin saadaksesi tiedot.';

  @override
  String get usingLatestStable => 'Käytät viimeisintä vakaata versiota';

  @override
  String get usingLatestNightly => 'Olet käyttämässä uusinta yöllä versiota';

  @override
  String get currentVersion => 'Nykyinen versio';

  @override
  String get updateNow => 'Päivitä nyt';

  @override
  String get shape => 'Muoto';

  @override
  String get circle => 'Ympyrä';

  @override
  String get rectangle => 'Suorakulmio';

  @override
  String get triangle => 'Kolmio';

  @override
  String get line => 'Viiva';

  @override
  String get cornerRadius => 'Corner radius';

  @override
  String get topLeft => 'Vasen yläreuna';

  @override
  String get topRight => 'Oikea yläreuna';

  @override
  String get bottomLeft => 'Vasen alareuna';

  @override
  String get bottomRight => 'Oikea alareuna';

  @override
  String get caches => 'Kätköt';

  @override
  String get manage => 'Hallitse';

  @override
  String get clearCaches => 'Tyhjennä kätköt';

  @override
  String get createCache => 'Luo välimuisti';

  @override
  String get thirdPartyLicenses => 'Kolmansien osapuolten lisenssit';

  @override
  String get syncing => 'Synkronoi...';

  @override
  String get synced => 'Synkronoitu';

  @override
  String get notSynced => 'Ei synkronoitu';

  @override
  String get conflict => 'Ristiriita';

  @override
  String get keepLocal => 'Säilytä paikallinen';

  @override
  String get keepConnection => 'Pidä yhteys';

  @override
  String get keepBoth => 'Pidä molemmat';

  @override
  String get forAll => 'Kaikille';

  @override
  String fileConflict(String file, String connection) {
    return '$file kohteessa $connection on ristiriita';
  }

  @override
  String get offline => 'Offline-tilassa';

  @override
  String get localLatest => 'Paikallinen viimeisin';

  @override
  String get connectionLatest => 'Yhteys viimeisin';

  @override
  String get path => 'Polku';

  @override
  String get folderSynced => 'Kansio synkronoitu';

  @override
  String get syncRootDirectory => 'Synkronoi juurikansio';

  @override
  String get penOnlyInput => 'Vain kynä syöttö';

  @override
  String get inputGestures => 'Input gestures';

  @override
  String get nativeTitleBar => 'Alkuperäinen otsikkopalkki';

  @override
  String get syncMode => 'Synkronoinnin tila';

  @override
  String get connection => 'Yhteys';

  @override
  String get always => 'Aina';

  @override
  String get noMobile => 'Ei matkapuhelinta';

  @override
  String get manual => 'Manuaalinen';

  @override
  String get search => 'Etsi';

  @override
  String get properties => 'Ominaisuudet';

  @override
  String get pin => 'Kiinnitä';

  @override
  String get unpin => 'Unpin';

  @override
  String get element => 'Elementti';

  @override
  String get painter => 'Maalari';

  @override
  String get position => 'Sijainti';

  @override
  String get note => 'Huomautus';

  @override
  String get packs => 'Paketit';

  @override
  String get pack => 'Paketti';

  @override
  String get more => 'Lisää';

  @override
  String get askForName => 'Pyydä nimeä';

  @override
  String areaIndex(int index) {
    return 'Alue $index';
  }

  @override
  String get startInFullScreen => 'Aloita koko näytöllä';

  @override
  String get inputs => 'Inputs';

  @override
  String get mouse => 'Hiiri';

  @override
  String get touch => 'Kosketa';

  @override
  String get keyboard => 'Keyboard';

  @override
  String get shortcuts => 'Pikanäppäimet';

  @override
  String get middle => 'Keskellä';

  @override
  String get first => 'Ensimmäinen';

  @override
  String get second => 'Sekunti';

  @override
  String get activeTool => 'Aktiivinen Työkalu';

  @override
  String get activeToolDescription =>
      'Käytä tällä hetkellä valittua työkalua työkalurivillä';

  @override
  String get handTool => 'Käsin Työkalu';

  @override
  String get handToolDescription => 'Vedä liikkuaksesi kankaan ympärillä';

  @override
  String get toolOnToolbar => 'Työkalurivin erityinen työkalu';

  @override
  String get toolOnToolbarDescription =>
      'Käytä työkalua määritellyssä kohdassa työkalurivin kohdalla, vasemmalta alkaen';

  @override
  String toolOnToolbarShort(int display_position) {
    return 'Työkalupalkin Asema: $display_position';
  }

  @override
  String get tools => 'Työkalut';

  @override
  String get showGrid => 'Näytä ruudukko';

  @override
  String get grid => 'Ruudukko';

  @override
  String get ruler => 'Viiva';

  @override
  String get angle => 'Kulma';

  @override
  String get report => 'Raportoi';

  @override
  String get newFolder => 'Uusi kansio';

  @override
  String get createPack => 'Luo paketti';

  @override
  String get editPack => 'Muokkaa pakettia';

  @override
  String get packsDirectory => 'Paketti hakemisto';

  @override
  String get stamp => 'Leima';

  @override
  String get addToPack => 'Lisää pakettiin';

  @override
  String get sureImportPack => 'Oletko varma, että haluat tuoda paketin?';

  @override
  String byAuthor(String author) {
    return 'esittäjä $author';
  }

  @override
  String get author => 'Tekijä';

  @override
  String get addAsset => 'Lisää assetti';

  @override
  String get editAsset => 'Muokkaa assettia';

  @override
  String get scope => 'Soveltamisala';

  @override
  String get noPacks => 'Paketteja ei ole tällä hetkellä saatavilla';

  @override
  String get components => 'Komponentit';

  @override
  String get waypoint => 'Reittipiste';

  @override
  String get actions => 'Toiminnot';

  @override
  String get painters => 'Maalarit';

  @override
  String get breakingChangesTitle => 'Muutosten murtaminen';

  @override
  String breakingChangesMessage(int version, int newVersion) {
    return 'Tässä versiossa on murrettu muutoksia. Lue muutosloki ennen päivitystä. Nykyinen tiedosto on $version, uusi versio on $newVersion.';
  }

  @override
  String get styles => 'Styles';

  @override
  String get paragraph => 'Kappale';

  @override
  String get fontFamily => 'Kirjasinperhe';

  @override
  String get smoothing => 'Pehmennys';

  @override
  String get streamline => 'Streamline';

  @override
  String get presentation => 'Esitys';

  @override
  String get selectAsset => 'Valitse assetti';

  @override
  String get clearStyle => 'Tyhjennä tyyli';

  @override
  String get unknownImportType => 'Tuntematon tuontityyppi';

  @override
  String get sureImportTemplate =>
      'Oletko varma, että haluat tuoda sivupohjan?';

  @override
  String get frame => 'Frame';

  @override
  String get play => 'Toista';

  @override
  String get video => 'Video';

  @override
  String get fps => 'FPS';

  @override
  String get breakpoint => 'Keskeytyspiste';

  @override
  String get presentationControls => 'Esityksen valvonta';

  @override
  String get nextSlide => 'Seuraava dia';

  @override
  String get nextSlideDescription =>
      'Pyyhkäise oikealle tai paina oikeaa nuolinäppäintä mennäksesi seuraavaan diaan';

  @override
  String get previousSlide => 'Edellinen dia';

  @override
  String get previousSlideDescription =>
      'Pyyhkäise vasemmalle tai paina vasenta nuolinäppäintä mennäksesi edelliseen diaan';

  @override
  String get exitPresentation => 'Poistu esitystavasta';

  @override
  String get exitPresentationDescription =>
      'Paina poistumisnäppäintä tai pyyhkäise alas poistuaksesi esityksestä';

  @override
  String get pausePresentation => 'Keskeytä esitystapa';

  @override
  String get pausePresentationDescription =>
      'Napauta näyttöä tai paina välilyöntiä pysäyttääksesi tai jatkaaksesi esitystä';

  @override
  String get keyframe => 'Keyframe';

  @override
  String get endOfPresentation => 'Olet saavuttanut esityksen loppuun asti';

  @override
  String get startOfPresentation => 'Olet jo saavuttanut esityksen alun';

  @override
  String get palettes => 'Palettes';

  @override
  String headline(int index) {
    return 'Otsikko $index';
  }

  @override
  String get code => 'Koodi';

  @override
  String get quote => 'Tarjous';

  @override
  String get link => 'Linkki';

  @override
  String get checkbox => 'Valintaruutu';

  @override
  String get deleted => 'Poistettu';

  @override
  String get emphasis => 'Korostus';

  @override
  String get listBullet => 'Listaa luettelomerkki';

  @override
  String get strong => 'Vahva';

  @override
  String get markdown => 'Markdown';

  @override
  String get home => 'Koti';

  @override
  String get files => 'Tiedostot';

  @override
  String get sortBy => 'Järjestä';

  @override
  String get location => 'Sijainti';

  @override
  String get whatsNew => 'Mitä uutta?';

  @override
  String get unstar => 'Poista';

  @override
  String get star => 'Tähti';

  @override
  String get goUp => 'Mene ylös';

  @override
  String get created => 'Luotu';

  @override
  String get modified => 'Muokattu';

  @override
  String get quickstart => 'Quickstart';

  @override
  String get noTemplates => 'Tällä hetkellä pohjia ei ole saatavilla';

  @override
  String get importCorePack => 'Tuo ydinpaketti';

  @override
  String get importCorePackDescription =>
      'Tuo ydin, joka sisältää kaikki perusassetit päästäksesi alkuun. Tämä ohittaa nykyisen ydinpaketin.';

  @override
  String get never => 'Ei Koskaan';

  @override
  String get onlyOnUpdates => 'Vain päivityksissä';

  @override
  String get visibility => 'Näkyvyys';

  @override
  String get captureThumbnail => 'Tallenna pikkukuva';

  @override
  String get capturedThumbnail => 'Pienoiskuvan talteenotto onnistui';

  @override
  String get chooseLabelMode => 'Valitse tunnistetila';

  @override
  String get foreground => 'Etuala';

  @override
  String get version => 'Versio';

  @override
  String get repository => 'Versiovarasto';

  @override
  String get pages => 'Sivut';

  @override
  String get navigator => 'Navigator';

  @override
  String get arrange => 'Järjestä';

  @override
  String get bringToFront => 'Tuo eteen';

  @override
  String get sendToBack => 'Lähetä takaisin';

  @override
  String get bringForward => 'Tuo eteenpäin';

  @override
  String get sendBackward => 'Lähetä taaksepäin';

  @override
  String get rotation => 'Kierto';

  @override
  String get onlyAvailableLargerScreen =>
      'Saatavilla vain suuremmilla näytöillä';

  @override
  String get toolbarPosition => 'Työkalupalkin sijainti';

  @override
  String get rotate => 'Kierrä';

  @override
  String get spacer => 'Välilyönti';

  @override
  String get navigationRail => 'Navigointi rautatie';

  @override
  String get cut => 'Leikkaa';

  @override
  String get insertBefore => 'Lisää ennen';

  @override
  String get insertAfter => 'Lisää jälkeen';

  @override
  String get insertFirst => 'Lisää ensin';

  @override
  String get insertLast => 'Insert last';

  @override
  String get paste => 'Liitä';

  @override
  String get ascending => 'Nouseva';

  @override
  String get descending => 'Laskeva';

  @override
  String get imageScale => 'Kuvan mittakaava';

  @override
  String get select => 'Valitse';

  @override
  String get tool => 'Työkalu';

  @override
  String get texture => 'Tekstuuri';

  @override
  String get platformTheme => 'Alustan teema';

  @override
  String get desktop => 'Työpöytä';

  @override
  String get mobile => 'Mobiili';

  @override
  String get pdfQuality => 'PDF laatu';

  @override
  String get surface => 'Pinta';

  @override
  String get pattern => 'Kuvio';

  @override
  String get sureClose => 'Oletko varma, että haluat sulkea asiakirjan?';

  @override
  String get thereAreUnsavedChanges => 'Muutoksia ei ole tallennettu';

  @override
  String get page => 'Sivu';

  @override
  String get iceServers => 'Ice- Palvelimet';

  @override
  String get collaboration => 'Yhteistyö';

  @override
  String get webRtc => 'Web RTC';

  @override
  String get webSocket => 'Web- Socket';

  @override
  String get iceServer => 'Ice- Palvelin';

  @override
  String get port => 'Portti';

  @override
  String get type => 'Tyyppi';

  @override
  String get side => 'Sivu';

  @override
  String get client => 'Asiakas';

  @override
  String get server => 'Palvelin';

  @override
  String get switchView => 'Vaihda Näkymää';

  @override
  String get lasso => 'Lasso';

  @override
  String get hideUI => 'Piilota Käyttöliittymä';

  @override
  String get density => 'Tiheys';

  @override
  String get compact => 'Kompakti';

  @override
  String get comfortable => 'Mukava';

  @override
  String get standard => 'Normaali';

  @override
  String get lock => 'Lukitse';

  @override
  String get addElement => 'Lisää elementti';

  @override
  String get notDefaultConnection => 'Ei oletusyhteyttä';

  @override
  String get defaultConnection => 'Oletus yhteys';

  @override
  String get hide => 'Piilota';

  @override
  String get show => 'Näytä';

  @override
  String get pause => 'Tauko';

  @override
  String get stop => 'Pysäytä';

  @override
  String get refresh => 'Päivitä';

  @override
  String get print => 'Tulosta';

  @override
  String get dav => 'DAV';

  @override
  String get eyeDropper => 'Silmien pipetillä';

  @override
  String get users => 'Käyttäjät';

  @override
  String get experiments => 'Kokeet';

  @override
  String get experimentsWarning =>
      'Nämä ominaisuudet ovat kokeellisia ja voivat muuttua, katkaista tai kadota milloin tahansa. Niiden käyttöönotto voi aiheuttaa epävakautta tai tietojen menetystä. Jatka varovaisesti. Ilmoita kaikista vioista.';

  @override
  String get address => 'Osoite';

  @override
  String get spreadToPages => 'Levitä sivuille';

  @override
  String get rootDirectorySpecifiedDescription =>
      'Juurihakemisto on määritetty. Kaikki kehittyneet hakemistopolut ovat suhteellisia tähän hakemistoon. Pidä se tyhjänä, jos haluat poistaa tämän hakemiston tyypin.';

  @override
  String get rootDirectoryNotSpecifiedDescription =>
      'Juurihakemistoa ei ole määritelty. Nimi vaaditaan. Kaikki kehittyneet hakemistopolut ovat absoluuttisia. Pidä se tyhjänä, jos haluat poistaa tämän hakemistotyypin.';

  @override
  String get unsecureConnectionTitle => 'Epäturvallinen yhteys';

  @override
  String unsecureConnectionMessage(String fingerprint) {
    return 'Yhteys ei ole suojattu. Tämä voi olla turvallisuusriski. Jatka vain, jos luotat yhteyteen. Sha1 sormenjälki on $fingerprint.';
  }

  @override
  String get continueAnyway => 'Jatka joka tapauksessa';

  @override
  String get zoomControl => 'Zoomauksen hallinta';

  @override
  String get highContrast => 'Korkea kontrasti';

  @override
  String get shouldANumber => 'Tämän arvon on oltava kelvollinen numero';

  @override
  String get createAreas => 'Luo alueita';

  @override
  String get autosave => 'Autosave';

  @override
  String get invert => 'Invert';

  @override
  String get operations => 'Toiminnot';

  @override
  String get medium => 'Keskitaso';

  @override
  String get large => 'Suuri';

  @override
  String get toolbarSize => 'Työkalupalkin koko';

  @override
  String get addAll => 'Lisää kaikki';

  @override
  String get onlyCurrentPage => 'Vain nykyinen sivu';

  @override
  String get smoothNavigation => 'Pehmeä navigointi';

  @override
  String get exact => 'Tarkka';

  @override
  String get inline => 'Inline';

  @override
  String get toolbarRows => 'Työkalupalkin rivit';

  @override
  String get pointerTest => 'Osoittimen testi';

  @override
  String get pressure => 'Paine';

  @override
  String get small => 'Pieni';

  @override
  String get tiny => 'Pieni';

  @override
  String get selectAll => 'Valitse kaikki';

  @override
  String get overrideTools => 'Ohita työkalut';

  @override
  String get hideCursorWhileDrawing => 'Piilota kohdistin piirroksen aikana';

  @override
  String get installed => 'Asennettu';

  @override
  String get install => 'Asenna';

  @override
  String get deselect => 'Poista Valinta';

  @override
  String get changeCollection => 'Vaihda kokoelmaa';

  @override
  String get collections => 'Kokoelmat';

  @override
  String get fullSelection => 'Täysi valinta';

  @override
  String get fullSelectionDescription =>
      'Vaatii, että elementit ovat täysin valintakentän sisällä.';

  @override
  String get collection => 'Kokoelma';

  @override
  String get defaultCollection => 'Oletus kokoelma';

  @override
  String get scroll => 'Vieritä';

  @override
  String get onStartup => 'Käynnistyksessä';

  @override
  String get homeScreen => 'Kotinäyttö';

  @override
  String get lastNote => 'Viimeisin merkintä';

  @override
  String get newNote => 'Uusi muistiinpano';

  @override
  String get convertToLayer => 'Muunna tasoksi';

  @override
  String get merge => 'Yhdistä';

  @override
  String get up => 'Ylös';

  @override
  String get down => 'Alas';

  @override
  String get other => 'Muu';

  @override
  String countElements(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count elementtejä',
      one: '1 elementti',
      zero: 'Ei elementtejä',
    );
    return '$_temp0';
  }

  @override
  String get colorToolbar => 'Värin työkalupalkki';

  @override
  String get yesButShowButtons => 'Kyllä, mutta näytä painikkeet';

  @override
  String get optionsPanelPosition => 'Valintapaneelin sijainti';

  @override
  String get hideDuration => 'Piilota kesto';

  @override
  String get animation => 'Animaatio';

  @override
  String get performance => 'Suorituskyky';

  @override
  String get performanceDescription =>
      'Optimoitu nopeuden ja muistin käyttöä varten. Kuvaan paistetaan vain muistin näkyvä osa.';

  @override
  String get normalDescription =>
      'Tasapainojen laatu ja suorituskyky. Bakes kuvan, joka kattaa 1,5 kertaa näkyvän alueen, tarjoaa sujuvampia siirtymiä vierittäessä.';

  @override
  String get high => 'Korkea';

  @override
  String get highDescription =>
      'Maksimoi laatua suorituskyvyn kustannuksella. Bakes kuvan, joka kattaa 2 kertaa näkyvän alueen, varmistaen saumattoman renderöinnin myös nopean vierityksen tai zoomauksen.';

  @override
  String get renderResolution => 'Renderöi resoluutio';

  @override
  String get translate => 'Käännä';

  @override
  String get unencrypted => 'Salaamaton';

  @override
  String get encrypted => 'Salattu';

  @override
  String get encryptDocumentMessage => 'Klikkaa salataksesi asiakirjan';

  @override
  String get unencryptDocumentMessage =>
      'Klikkaa poistaaksesi asiakirjan salauksen';

  @override
  String get unencrypt => 'Salaamaton';

  @override
  String get encrypt => 'Salaa';

  @override
  String get encryptWarning =>
      'Tämä salaa asiakirjan. Sinun tulee muistaa salasana, jotta voit purkaa sen salauksen.';

  @override
  String get unencryptWarning =>
      'Tämä poistaa asiakirjan salauksen. Salasana poistetaan ja kaikki ne, joilla on pääsy siihen.';

  @override
  String get confirmPassword => 'Vahvista salasana';

  @override
  String get passwordMismatch => 'Salasanat eivät täsmää';

  @override
  String get action => 'Toiminto';

  @override
  String get svgText => 'Svg- Teksti';

  @override
  String get offset => 'Siirtymä';

  @override
  String get positionDependent => 'Asema riippuu';

  @override
  String get flipHorizontal => 'Käännä vaakasuora';

  @override
  String get flipVertical => 'Käännä pystysuuntainen';

  @override
  String get grayscale => 'Grayscale';

  @override
  String get moveOnGesture => 'Siirrä ele';

  @override
  String get exportAllFiles => 'Vie kaikki tiedostot';

  @override
  String get restoreSettingsFromFile => 'Palauta asetukset tiedostosta';

  @override
  String get exportSettingsToFile => 'Vie asetukset tiedostoon';

  @override
  String get barcode => 'Barcode';

  @override
  String get barcodeType => 'Viivakoodin tyyppi';

  @override
  String get qrCode => 'QR Code';

  @override
  String get dataMatrix => 'Data Matriisi';

  @override
  String get code128 => 'Koodi 128';

  @override
  String defaultUserName(int index) {
    return 'Käyttäjä $index';
  }

  @override
  String get moveLeft => 'Siirrä vasemmalle';

  @override
  String get moveRight => 'Siirrä oikealle';

  @override
  String get bundledPacks => 'Yhdistetyt paketit';

  @override
  String get component => 'Komponentti';

  @override
  String get selectComponent => 'Valitse komponentti';

  @override
  String get bundlePackInDocument => 'Paketti asiakirjassa';

  @override
  String get bundledPacksDescription =>
      'Dokumentissa on mukana useita pakkauksia, ja niitä voidaan käyttää vain asiakirjan jakamiseen. Assetteja voidaan käyttää dokumentissa vain, jos paketti on asennettu. Paketteja voidaan asentaa klikkaamalla niitä.';

  @override
  String get fillAlpha => 'Täytä alfa';

  @override
  String get packagedFile => 'Pakattu tiedosto';

  @override
  String get rawFile => 'Raaka tiedosto';

  @override
  String get webSocketDescription =>
      'Laitteesi isännöi palvelinta, joten yhteistyökumppanit voivat liittyä samaan verkkoon tai mistä tahansa vain, jos jatkat porttia reitittimessäsi.';

  @override
  String get swampDescription =>
      'Viestisi reititetään turvallisen relepalvelimen kautta, jossa on end-to-end salaus. Ison palvelimen osoite tarvitaan istunnon luomiseksi.';

  @override
  String get createRawNote => 'Luo raaka merkintä';

  @override
  String get polygon => 'Monikulmio';

  @override
  String get finishShape => 'Viimeistele muoto';

  @override
  String get submit => 'Lähetä';

  @override
  String get math => 'Matematiikka';

  @override
  String get ignorePressure => 'Ohita paine';

  @override
  String get ignoreFirstPressureDescription =>
      'Joissain laitteissa ensimmäinen paineen arvo ei ole tarkka. Tämä asetus jättää huomiotta ensimmäisen paineen arvon ja käyttää sen sijaan toisen tapahtuman painetta.';

  @override
  String get temporary => 'Väliaikainen';

  @override
  String get simpleToolbarVisibility => 'Yksinkertainen työkalupalkin näkyvyys';

  @override
  String get autosaveDelay => 'Automaattisen tallennuksen viive';

  @override
  String get saved => 'Tallennettu';

  @override
  String get saving => 'Tallennetaan...';

  @override
  String get readOnly => 'Vain luku';

  @override
  String get saveDelayed => 'Tallennus viivästynyt';

  @override
  String get unsaved => 'Tallentamaton';

  @override
  String get pdfEmptyDescription =>
      'Tällä hetkellä ei ole vientialueita. Valitse ainakin yksi alue käyttämällä oikeassa yläkulmassa olevaa plus -painiketta tai lisää kaikki alueet nykyiseltä sivulta tai koko asiakirjasta.';

  @override
  String get densityMaximize => 'Maximize';
}
