// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Arabic (`ar`).
class AppLocalizationsAr extends AppLocalizations {
  AppLocalizationsAr([String locale = 'ar']) : super(locale);

  @override
  String get open => 'فتح';

  @override
  String get settings => 'الإعدادات';

  @override
  String get personalization => 'التخصيص';

  @override
  String get theme => 'السمة';

  @override
  String get darkTheme => 'المظهر الداكن';

  @override
  String get lightTheme => 'المظهر الفاتح';

  @override
  String get systemTheme => 'استخدام سمة النظام الافتراضية';

  @override
  String get view => 'العرض';

  @override
  String get edit => 'تحرير';

  @override
  String get export => 'تصدير';

  @override
  String get save => 'حفظ';

  @override
  String get zoom => 'تكبير';

  @override
  String get zoomIn => 'تقريب';

  @override
  String get zoomOut => 'تصغير';

  @override
  String get resetZoom => 'إعادة ضبط التكبير';

  @override
  String get strokeWidth => 'سُمك الخط';

  @override
  String get includeEraser => 'تضمين الممحاة؟';

  @override
  String get thinning => 'الترقيق';

  @override
  String get pen => 'القلم';

  @override
  String get invertedPen => 'قلم معكوس';

  @override
  String get eraser => 'ممحاة';

  @override
  String get pathEraser => 'ممحاة المسار';

  @override
  String get label => 'علامة نصية';

  @override
  String get delete => 'حذف';

  @override
  String get areYouSure => 'هل أنت متأكد؟';

  @override
  String get reallyDelete => 'هل تريد حقاً حذف هذا العنصر؟';

  @override
  String get no => 'لا';

  @override
  String get yes => 'نعم';

  @override
  String get undo => 'تراجع';

  @override
  String get redo => 'إعادة';

  @override
  String get general => 'إعدادات عامة';

  @override
  String get copyTitle => 'نسخ إلى الحافظة';

  @override
  String get loading => 'جاري التحميل...';

  @override
  String get enterText => 'أدخل النص';

  @override
  String get size => 'الحجم';

  @override
  String get width => 'العرض';

  @override
  String get height => 'الارتفاع';

  @override
  String get count => 'العد';

  @override
  String get space => 'المساحة';

  @override
  String get background => 'الخلفية';

  @override
  String get box => 'مربع';

  @override
  String get locale => 'اللُّغَة';

  @override
  String get systemLocale => 'لغة النظام';

  @override
  String get information => 'معلومات';

  @override
  String get license => 'الترخيص';

  @override
  String get imprint => 'علامة الناشر';

  @override
  String get privacypolicy => 'سياسة الخصوصية';

  @override
  String get sourceCode => 'الكود المصدري';

  @override
  String get documentation => 'إرشادات الإستخدام';

  @override
  String get changelog => 'سِجل التغييرات';

  @override
  String get source => 'المصدر';

  @override
  String get existOverride => 'هذا العنصر موجود بالفعل. استبدال؟';

  @override
  String get description => 'الوصف';

  @override
  String get fill => 'تعبئة';

  @override
  String get defaultPalette => 'اللوحة الافتراضية';

  @override
  String get highlighter => 'قلم تظليل';

  @override
  String get add => 'إضافة';

  @override
  String get remove => 'إزالة';

  @override
  String get removeConfirm => 'هل تريد حقاً إزالة هذا؟';

  @override
  String get resetPalette => 'إعادة تعيين لوحة الألوان';

  @override
  String get custom => 'مخصص';

  @override
  String get decoration => 'زخرفة';

  @override
  String get underline => 'أسفل';

  @override
  String get overline => 'خط علوي';

  @override
  String get strikethrough => 'مشطوب';

  @override
  String get thickness => 'السماكة';

  @override
  String get style => 'النمط';

  @override
  String get solid => 'صلب';

  @override
  String get double => 'مزدوج';

  @override
  String get dotted => 'مُنَقط';

  @override
  String get dashed => 'متقطع';

  @override
  String get wavy => 'مموج';

  @override
  String get fontWeight => 'وزن الخط';

  @override
  String get normal => 'عادي';

  @override
  String get bold => 'عريض';

  @override
  String get italic => 'مائل';

  @override
  String get clipboard => 'الحافظة';

  @override
  String get file => 'ملف';

  @override
  String get data => 'البيانات';

  @override
  String get share => 'مشاركة';

  @override
  String get spacing => 'تباعد';

  @override
  String get image => 'صورة';

  @override
  String get enterUrl => 'أدخل عنوان URL';

  @override
  String get scale => 'مقاس';

  @override
  String get help => 'مساعدة';

  @override
  String get reallyReset => 'هل تريد حقاً إعادة تعيينه؟';

  @override
  String get whatToDo => 'ماذا تريد أن تفعل؟';

  @override
  String get ignore => 'تجاهل';

  @override
  String get backup => 'النسخ الاحتياطي';

  @override
  String createdInNewerVersion(String fileName, int fileVersion) {
    return 'تم إنشاء الملف $fileName في إصدار أحدث ($fileVersion). ما الذي ينبغي فعله مع هذا الملف؟';
  }

  @override
  String get waypoints => 'نقطة طريق';

  @override
  String get origin => 'الأصل';

  @override
  String get import => 'استيراد';

  @override
  String get newContent => 'جديد';

  @override
  String get selectElement => 'حدد العنصر';

  @override
  String get ctrlKey => 'Ctrl';

  @override
  String get shiftKey => 'Shift';

  @override
  String get altKey => 'Alt';

  @override
  String get copyVersion => 'نسخ الإصدار';

  @override
  String get input => 'الإدخال';

  @override
  String get behaviors => 'السلوكيات';

  @override
  String get dataDirectory => 'مجلد البيانات';

  @override
  String get defaultPath => 'المجلد الافتراضي';

  @override
  String get dateFormat => 'تنسيق التاريخ';

  @override
  String updatedAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'حُدّث في: $dateTimeString';
  }

  @override
  String createdAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'أُنشئ في: $dateTimeString';
  }

  @override
  String get rename => 'إعادة تسمية';

  @override
  String get duplicate => 'استنساخ';

  @override
  String get hand => 'اليد';

  @override
  String get folder => 'مجلد';

  @override
  String get move => 'نقل';

  @override
  String get copy => 'نسخ';

  @override
  String get back => 'رجوع';

  @override
  String get zoomDependent => 'يتغير حسب التكبير';

  @override
  String get shapeDetection => 'اكتشاف الشكل';

  @override
  String get delay => 'التأخير';

  @override
  String get defaultLayer => 'الطبقة الافتراضية';

  @override
  String get layer => 'طبقة';

  @override
  String get layers => 'طبقات';

  @override
  String get notSet => 'غير محدد';

  @override
  String get enterLayer => 'أدخل اسم الطبقة';

  @override
  String get selectElements => 'حدد العناصر';

  @override
  String get deleteElements => 'حذف العناصر';

  @override
  String get deleteElementsConfirm => 'هل تريد حقاً حذف العناصر المحددة؟';

  @override
  String get selectCustomCollection => 'حدد مجموعة مخصصة';

  @override
  String get svg => 'SVG';

  @override
  String get sensitivity => 'الحساسية';

  @override
  String get sensitivityHint => 'ارتفاع القيمة، يزيد حساسية الإدخال';

  @override
  String get horizontal => 'أفقي';

  @override
  String get vertical => 'عمودي';

  @override
  String get plain => 'سادة';

  @override
  String get light => 'فاتح';

  @override
  String get ruled => 'مخطط';

  @override
  String get quad => 'رباعي';

  @override
  String get music => 'موسيقى';

  @override
  String get dark => 'داكن';

  @override
  String get plainDark => 'داكن';

  @override
  String get ruledDark => 'مخطط داكن';

  @override
  String get quadDark => 'رباعي داكن';

  @override
  String get musicDark => 'موسيقى داكن';

  @override
  String get templates => 'قوالب';

  @override
  String get untitled => 'بلا عنوان';

  @override
  String get createTemplate => 'إنشاء قالب';

  @override
  String get createTemplateContent =>
      'هل تريد حقاً إنشاء قالب من هذا المستند؟ سيتم حذف المستند الأصلي.';

  @override
  String get replace => 'استبدل';

  @override
  String get reallyReplace =>
      'هل تريد حقاً استبدال القالب؟ هذه العملية لا يمكن التراجع عنها!';

  @override
  String get defaultTemplate => 'القالب الافتراضي';

  @override
  String get insert => 'إدخال';

  @override
  String get document => 'مستند';

  @override
  String get camera => 'كاميرا';

  @override
  String get printout => 'طباعة';

  @override
  String get selectCamera => 'اختر كاميرا';

  @override
  String get changeDocumentPath => 'تغيير مكان المستند';

  @override
  String get deleteWholeStroke => 'حذف الخط بأكمله';

  @override
  String get alpha => 'الشفافية';

  @override
  String get area => 'المنطقة';

  @override
  String get selectArea => 'حدد منطقة';

  @override
  String get aspectRatio => 'نسبة الجوانب';

  @override
  String get presets => 'الإعدادات المسبقة';

  @override
  String get pagePortrait => 'صورة للصفحة';

  @override
  String get pageLandscape => 'صفحة أفقيه';

  @override
  String get square => 'مربع';

  @override
  String get areas => 'المناطق';

  @override
  String get enterArea => 'أدخل المنطقة';

  @override
  String get exitArea => 'الخروج من المنطقة';

  @override
  String get currentArea => 'المنطقة الحالي';

  @override
  String get design => 'تصميم';

  @override
  String get text => 'نص';

  @override
  String welcome(String codeName) {
    return 'مرحباً، هذه Linwood Butterfly $codeName';
  }

  @override
  String get welcomeContent => 'مساحة رسم مجانية ومفتوحة المصدر!';

  @override
  String updated(String version) {
    return 'تم تحديث التطبيق إلى الإصدار $version';
  }

  @override
  String get releaseNotes => 'ملاحظات الإصدار';

  @override
  String get constraints => 'القيود';

  @override
  String get scaled => 'مُكبر';

  @override
  String get fixed => 'ثابت';

  @override
  String get dynamicContent => 'ديناميكية';

  @override
  String get none => 'لا شَيْء';

  @override
  String get includeArea => 'تضمين المنطقة';

  @override
  String get verticalAlignment => 'محاذاة عمودية';

  @override
  String get horizontalAlignment => 'محاذاة أفقية';

  @override
  String get top => 'أعلى';

  @override
  String get center => 'الوسط';

  @override
  String get bottom => 'أسفل';

  @override
  String get left => 'اليسار';

  @override
  String get right => 'يمين';

  @override
  String get justify => 'محاذاة الكلمات';

  @override
  String get constraint => 'التقييد';

  @override
  String get length => 'طول';

  @override
  String get exportSvg => 'تصدير SVG';

  @override
  String get pdf => 'PDF';

  @override
  String get selectPages => 'حدد صفحات';

  @override
  String get recentFiles => 'الملفات الأخيرة';

  @override
  String get start => 'ابدأ';

  @override
  String get noRecentFiles => 'لا توجد ملفات حديثة';

  @override
  String countPages(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count صفحات',
      one: 'صفحة 1',
      zero: 'لا توجد صفحات',
    );
    return '$_temp0';
  }

  @override
  String pageIndex(int index) {
    return 'الصفحة $index';
  }

  @override
  String get exit => 'الخروج';

  @override
  String get noElements => 'لا توجد عناصر';

  @override
  String get invertSelection => 'إعكس التحديد';

  @override
  String get errorWhileImporting => 'حدث خطأ أثناء الاستيراد';

  @override
  String get errorWhileImportingContent => 'حدث خطأ أثناء استيراد الملف';

  @override
  String get showDetails => 'إظهار التفاصيل';

  @override
  String get hideDetails => 'إخفاء التفاصيل';

  @override
  String get error => 'خطأ';

  @override
  String get stackTrace => 'تتبع المكدس';

  @override
  String get laser => 'ليزر';

  @override
  String get duration => 'المدة';

  @override
  String get quality => 'الجودة';

  @override
  String get exportPdf => 'تصدير PDF';

  @override
  String get local => 'محلي';

  @override
  String get addConnection => 'إضافة اتصال';

  @override
  String get connections => 'اتصالات';

  @override
  String get noConnections => 'لا توجد اتصالات';

  @override
  String get url => 'عنوان URL';

  @override
  String get connect => 'توصيل';

  @override
  String get username => 'اسم المستخدم';

  @override
  String get password => 'كلمة المرور';

  @override
  String get webNotSupported => 'نسخة الويب غير مدعومه';

  @override
  String get advanced => 'خيارات متقدمة';

  @override
  String get directory => 'المُجلد';

  @override
  String get documentsDirectory => 'مجلد المستندات';

  @override
  String get templatesDirectory => 'مجلد القوالب';

  @override
  String get errorWhileCreatingConnection => 'حدث خطأ أثناء إنشاء الاتصال';

  @override
  String get cannotConnect => 'تعذر الاتصال';

  @override
  String get urlNotValid => 'عنوان URL غير صحيح';

  @override
  String get icon => 'أيقونة';

  @override
  String get update => 'تحديث';

  @override
  String get updateAvailable => 'التحديث متاح';

  @override
  String get stable => 'الإصدار المستقر';

  @override
  String get nightly => 'الإصدار الليلي';

  @override
  String get checkForUpdates => 'تحقق من التحديثات';

  @override
  String get checkForUpdatesWarning =>
      'للتحقق من التحديثات، سيتصل التطبيق بموقع المطور للحصول على المعلومات.';

  @override
  String get usingLatestStable => 'أنت تستخدم أحدث إصدار مستقر';

  @override
  String get usingLatestNightly => 'أنت تستخدم أحدث إصدار تجريبي';

  @override
  String get currentVersion => 'الإصدار الحالي';

  @override
  String get updateNow => 'التحديث الآن';

  @override
  String get shape => 'شكل';

  @override
  String get circle => 'دائرة';

  @override
  String get rectangle => 'مستطيل';

  @override
  String get triangle => 'مثلث';

  @override
  String get line => 'سطر';

  @override
  String get cornerRadius => 'انحناء الزاوية';

  @override
  String get topLeft => 'أعلى اليسار';

  @override
  String get topRight => 'أعلى اليمين';

  @override
  String get bottomLeft => 'أسفل اليسار';

  @override
  String get bottomRight => 'أسفل اليمين';

  @override
  String get caches => 'المخبآت';

  @override
  String get manage => 'إدارة';

  @override
  String get clearCaches => 'مسح المخبآت';

  @override
  String get createCache => 'إنشاء مخبئ';

  @override
  String get thirdPartyLicenses => 'تراخيص الطرف الثالث';

  @override
  String get syncing => 'مزامنة...';

  @override
  String get synced => 'متزامن';

  @override
  String get notSynced => 'غير متزامن';

  @override
  String get conflict => 'تعارض';

  @override
  String get keepLocal => 'احتفظ بالمحلي';

  @override
  String get keepConnection => 'احتفظ بالاتصال';

  @override
  String get keepBoth => 'الاحتفاظ بكليهما';

  @override
  String get forAll => 'للجميع';

  @override
  String fileConflict(String file, String connection) {
    return '$file في $connection لديه تعارض';
  }

  @override
  String get offline => 'غير متصل';

  @override
  String get localLatest => 'الأحدث';

  @override
  String get connectionLatest => 'أحدث اتصال';

  @override
  String get path => 'المسار';

  @override
  String get folderSynced => 'تمت مزامنة المجلد';

  @override
  String get syncRootDirectory => 'مزامنة مجلد الجذر';

  @override
  String get penOnlyInput => 'الرسم باستخدام القلم فقط';

  @override
  String get inputGestures => 'إيماءات الإدخال';

  @override
  String get nativeTitleBar => 'استخدم شريط عنوان النظام';

  @override
  String get syncMode => 'وضع المزامنة';

  @override
  String get connection => 'اتصال';

  @override
  String get always => 'دائما';

  @override
  String get noMobile => 'لا تستخدم الاتصال الخلوي';

  @override
  String get manual => 'يدوي';

  @override
  String get search => 'البحث';

  @override
  String get properties => 'الخصائص';

  @override
  String get pin => 'تثبيت';

  @override
  String get unpin => 'إزالة التثبيت';

  @override
  String get element => 'العنصر';

  @override
  String get painter => 'رسام';

  @override
  String get position => 'الموضع';

  @override
  String get note => 'ملاحظة';

  @override
  String get packs => 'حزم';

  @override
  String get pack => 'باقة';

  @override
  String get more => 'المزيد';

  @override
  String get askForName => 'اسأل عن الاسم';

  @override
  String areaIndex(int index) {
    return 'المنطقة $index';
  }

  @override
  String get startInFullScreen => 'البدء في ملء الشاشة';

  @override
  String get inputs => 'الإدخال';

  @override
  String get mouse => 'الفأرة';

  @override
  String get touch => 'اللمس';

  @override
  String get keyboard => 'لوحة المفاتيح';

  @override
  String get shortcuts => 'الاختصارات';

  @override
  String get middle => 'وسط';

  @override
  String get first => 'الأول';

  @override
  String get second => 'الثاني';

  @override
  String get activeTool => 'الأداة المفعلة';

  @override
  String get activeToolDescription =>
      'استخدام الأداة المحددة حاليًا على شريط الأدوات';

  @override
  String get handTool => 'أداة اليد';

  @override
  String get handToolDescription => 'اسحب للتحرك حول اللوحه';

  @override
  String get toolOnToolbar => 'أداة محددة على شريط الأدوات';

  @override
  String get toolOnToolbarDescription =>
      'استخدام الأداة في الموضع المحدد على شريط الأدوات، بدءاً من اليسار';

  @override
  String toolOnToolbarShort(int display_position) {
    return 'موضع شريط الأدوات: $display_position';
  }

  @override
  String get tools => 'أدوات';

  @override
  String get showGrid => 'إظهار الشبكة';

  @override
  String get grid => 'الشبكة';

  @override
  String get ruler => 'مسطرة';

  @override
  String get angle => 'الزاوية';

  @override
  String get report => 'إبلاغ';

  @override
  String get newFolder => 'مجلد جديد';

  @override
  String get createPack => 'إنشاء باقة';

  @override
  String get editPack => 'تحرير باقة';

  @override
  String get packsDirectory => 'مجلد الباقات';

  @override
  String get stamp => 'ختم';

  @override
  String get addToPack => 'إضافة إلى باقة';

  @override
  String get sureImportPack => 'هل أنت متأكد من أنك تريد استيراد الباقة؟';

  @override
  String byAuthor(String author) {
    return 'من قِبل $author';
  }

  @override
  String get author => 'المؤلف';

  @override
  String get addAsset => 'إضافة عنصر';

  @override
  String get editAsset => 'تحرير عنصر';

  @override
  String get scope => 'النطاق';

  @override
  String get noPacks => 'لا توجد باقات متوفرة حاليا';

  @override
  String get components => 'المكونات';

  @override
  String get waypoint => 'نقطة طريق';

  @override
  String get actions => 'الإجراءات';

  @override
  String get painters => 'المؤمنون';

  @override
  String get breakingChangesTitle => 'تغييرات مخالفه';

  @override
  String breakingChangesMessage(int version, int newVersion) {
    return 'هناك تغييرات في هذا الإصدار. الرجاء قراءة سجل التغييرات قبل التحديث. الإصدار الحالي للملف هو $version، الإصدار الجديد هو $newVersion.';
  }

  @override
  String get styles => 'الأنماط';

  @override
  String get paragraph => 'الفقرة';

  @override
  String get fontFamily => 'عائلة الخط';

  @override
  String get smoothing => 'التنعيم';

  @override
  String get streamline => 'التبسيط';

  @override
  String get presentation => 'عرض تقديمي';

  @override
  String get selectAsset => 'حدد العنصر';

  @override
  String get clearStyle => 'مسح النمط';

  @override
  String get unknownImportType => 'استيراد مجهول النوعية';

  @override
  String get sureImportTemplate => 'هل أنت متأكد من أنك تريد استيراد القالب؟';

  @override
  String get frame => 'إطار';

  @override
  String get play => 'تشغيل';

  @override
  String get video => 'فيديو';

  @override
  String get fps => 'الإطارات في الثانية';

  @override
  String get breakpoint => 'نقطة توقف';

  @override
  String get presentationControls => 'إعدادات العرض';

  @override
  String get nextSlide => 'الشريحة التالية';

  @override
  String get nextSlideDescription =>
      'اسحب إلى اليمين أو اضغط على مفتاح السهم الأيمن للذهاب إلى الشريحة التالية';

  @override
  String get previousSlide => 'الشريحة السابقة';

  @override
  String get previousSlideDescription =>
      'اسحب إلى اليسار أو اضغط على مفتاح السهم الأيسر للذهاب إلى الشريحة السابقة';

  @override
  String get exitPresentation => 'الخروج من العرض التقديمي';

  @override
  String get exitPresentationDescription =>
      'اضغط على المفتاح Escape أو مرر لأسفل للخروج من العرض';

  @override
  String get pausePresentation => 'الإيقاف المؤقت للعرض';

  @override
  String get pausePresentationDescription =>
      'اضغط على الشاشة أو اضغط على زر المسافة لإيقاف أو استئناف العرض التقديمي';

  @override
  String get keyframe => 'مفتاح الإطار';

  @override
  String get endOfPresentation => 'لقد وصلت إلى نهاية العرض التقديمي';

  @override
  String get startOfPresentation => 'لقد وصلت إلى بداية العرض التقديمي';

  @override
  String get palettes => 'ألواح الألوان';

  @override
  String headline(int index) {
    return 'العنوان $index';
  }

  @override
  String get code => 'رمز برمجي';

  @override
  String get quote => 'اقتباس';

  @override
  String get link => 'رابط';

  @override
  String get checkbox => 'خانة';

  @override
  String get deleted => 'محذوف';

  @override
  String get emphasis => 'إبراز';

  @override
  String get listBullet => 'قائمه نقطية';

  @override
  String get strong => 'قوي';

  @override
  String get markdown => 'Markdown';

  @override
  String get home => 'المنزل';

  @override
  String get files => 'الملفات';

  @override
  String get sortBy => 'الترتيب حسب';

  @override
  String get location => 'الموقع';

  @override
  String get whatsNew => 'ما الجديد؟';

  @override
  String get unstar => 'إلغاء التمييز';

  @override
  String get star => 'تمييز';

  @override
  String get goUp => 'اذهب للأعلى';

  @override
  String get created => 'أنشئ';

  @override
  String get modified => 'معدّل';

  @override
  String get quickstart => 'البداية السريعة';

  @override
  String get noTemplates => 'لا توجد حاليا قوالب متاحة';

  @override
  String get importCorePack => 'استيراد الباقة الأساسية';

  @override
  String get importCorePackDescription =>
      'استورد الباقة الأساسية التي تحتوي على جميع الموارد الأساسية للبدء. سيؤدي ذلك إلى استبدال الباقة الأساسية الحالية.';

  @override
  String get never => 'مطلقًا';

  @override
  String get onlyOnUpdates => 'فقط عند التحديثات';

  @override
  String get visibility => 'الظهور';

  @override
  String get captureThumbnail => 'التقط صورة مصغرة';

  @override
  String get capturedThumbnail => 'تم التقاط صورة مصغرة بنجاح';

  @override
  String get chooseLabelMode => 'اختر وضع التسمية';

  @override
  String get foreground => 'الأمامي';

  @override
  String get version => 'الإصدار';

  @override
  String get repository => 'المستودع';

  @override
  String get pages => 'الصفحات';

  @override
  String get navigator => 'مستكشف';

  @override
  String get arrange => 'ترتيب';

  @override
  String get bringToFront => 'إلى الأمام';

  @override
  String get sendToBack => 'إلى الخلف';

  @override
  String get bringForward => 'خطوة إلى الأمام';

  @override
  String get sendBackward => 'خطوة إلى الخلف';

  @override
  String get rotation => 'دوران';

  @override
  String get onlyAvailableLargerScreen => 'متوفر فقط على شاشات أكبر';

  @override
  String get toolbarPosition => 'موضع شريط الأدوات';

  @override
  String get rotate => 'تدوير';

  @override
  String get spacer => 'المساحة';

  @override
  String get navigationRail => 'سكة التوجيه';

  @override
  String get cut => 'قصّ';

  @override
  String get insertBefore => 'أدخل قبل';

  @override
  String get insertAfter => 'أدخل بعد';

  @override
  String get insertFirst => 'أدخل أولاً';

  @override
  String get insertLast => 'أدخل أخراً';

  @override
  String get paste => 'لصق';

  @override
  String get ascending => 'تصاعدي';

  @override
  String get descending => 'تنازلي';

  @override
  String get imageScale => 'حجم الصورة';

  @override
  String get select => 'حدد';

  @override
  String get tool => 'أداة';

  @override
  String get texture => 'نسيج';

  @override
  String get platformTheme => 'مظهر النظام';

  @override
  String get desktop => 'سطح المكتب';

  @override
  String get mobile => 'الجوال';

  @override
  String get pdfQuality => 'جودة PDF';

  @override
  String get surface => 'السطح';

  @override
  String get pattern => 'النمط';

  @override
  String get sureClose => 'هل أنت متأكد من إغلاق المستند؟';

  @override
  String get thereAreUnsavedChanges => 'هناك تغييرات غير محفوظة';

  @override
  String get page => 'الصفحة';

  @override
  String get iceServers => 'خوادم ICE';

  @override
  String get collaboration => 'التعاون';

  @override
  String get webRtc => 'Web RTC';

  @override
  String get webSocket => 'مقبس الويب';

  @override
  String get iceServer => 'خادم ICE';

  @override
  String get port => 'المنفذ';

  @override
  String get type => 'نوع';

  @override
  String get side => 'جانب';

  @override
  String get client => 'العميل';

  @override
  String get server => 'خادم';

  @override
  String get switchView => 'تبديل طريقة العرض';

  @override
  String get lasso => 'تحديد الحبل';

  @override
  String get hideUI => 'إخفاء الواجهة';

  @override
  String get density => 'الكثافة';

  @override
  String get compact => 'مضغوط';

  @override
  String get comfortable => 'مريح';

  @override
  String get standard => 'قياسي';

  @override
  String get lock => 'إقفال';

  @override
  String get addElement => 'إضافة عنصر';

  @override
  String get notDefaultConnection => 'ليس الإتصال الافتراضي';

  @override
  String get defaultConnection => 'الاتصال الافتراضي';

  @override
  String get hide => 'إخفاء';

  @override
  String get show => 'إظهار';

  @override
  String get pause => 'إيقاف';

  @override
  String get stop => 'توقف';

  @override
  String get refresh => 'تحديث';

  @override
  String get print => 'طباعة';

  @override
  String get dav => 'DAV';

  @override
  String get eyeDropper => 'قطّارة';

  @override
  String get users => 'المستخدمون';

  @override
  String get experiments => 'التجارب';

  @override
  String get experimentsWarning =>
      'هذه الميزات تجريبية وقد تتغير أو لا تعمل أو تختفي في أي وقت. تمكينهم قد يتسبب في أخطاء أو فقدان البيانات. تابع بحذر. الرجاء الإبلاغ عن أي أخطاء.';

  @override
  String get address => 'العنوان';

  @override
  String get spreadToPages => 'نشر إلى الصفحات';

  @override
  String get rootDirectorySpecifiedDescription =>
      'تم تحديد مجلد الجذر. ستكون جميع المجلدات المتقدمة نسبية لهذا المجلد. اتركه فارغًا لتعطيل هذا النوع من المجلدات.';

  @override
  String get rootDirectoryNotSpecifiedDescription =>
      'لم يتم تحديد المجلد الجذر. يجب إدخال اسم. ستكون جميع مسارات المجلدات المتقدمة مُطلقة. اتركه فارغًا لتعطيل هذا النوع من المجلدات.';

  @override
  String get unsecureConnectionTitle => 'اتصال غير آمن';

  @override
  String unsecureConnectionMessage(String fingerprint) {
    return 'الاتصال غير آمن. قد يؤدي ذلك إلى مخاطر أمنية. يرجى المتابعة فقط إذا كنت تثق في الاتصال. بصمة sha1 هي $fingerprint.';
  }

  @override
  String get continueAnyway => 'المتابعة على أي حال';

  @override
  String get zoomControl => 'التحكم بالتكبير/التصغير';

  @override
  String get highContrast => 'تباين عالي';

  @override
  String get shouldANumber => 'يجب أن تكون هذه القيمة رقماً صحيحاً';

  @override
  String get createAreas => 'إنشاء مناطق';

  @override
  String get autosave => 'حفظ تلقائي';

  @override
  String get invert => 'عكس';

  @override
  String get operations => 'العمليات';

  @override
  String get medium => 'متوسط';

  @override
  String get large => 'كبير';

  @override
  String get toolbarSize => 'حجم شريط الأدوات';

  @override
  String get addAll => 'إضافة الكل';

  @override
  String get onlyCurrentPage => 'الصفحة الحالية فقط';

  @override
  String get smoothNavigation => 'التنقل السلس';

  @override
  String get exact => 'بالضبط';

  @override
  String get inline => 'مضمن';

  @override
  String get toolbarRows => 'صفوف شريط الأدوات';

  @override
  String get pointerTest => 'اختبار المؤشر';

  @override
  String get pressure => 'الضغط';

  @override
  String get small => 'صغير';

  @override
  String get tiny => 'صغير';

  @override
  String get selectAll => 'حدد الكل';

  @override
  String get overrideTools => 'أدوات التجاوز';

  @override
  String get hideCursorWhileDrawing => 'إخفاء المؤشر أثناء الرسم';

  @override
  String get installed => 'مثبت';

  @override
  String get install => 'تثبيت';

  @override
  String get deselect => 'إلغاء التحديد';

  @override
  String get changeCollection => 'تغيير المجموعة';

  @override
  String get collections => 'مجموعات';

  @override
  String get fullSelection => 'التحديد الكامل';

  @override
  String get fullSelectionDescription =>
      'اختر فقط العناصر المحددة بالكامل في مربع التحديد';

  @override
  String get collection => 'مجموعة';

  @override
  String get defaultCollection => 'المجموعة الافتراضية';

  @override
  String get scroll => 'تمرير';

  @override
  String get onStartup => 'عند بدء التشغيل';

  @override
  String get homeScreen => 'الشاشة الرئيسة';

  @override
  String get lastNote => 'الملاحظة الأخيرة';

  @override
  String get newNote => 'ملاحظة جديدة';

  @override
  String get convertToLayer => 'تحويل إلى طبقة';

  @override
  String get merge => 'دمج';

  @override
  String get up => 'أعلى';

  @override
  String get down => 'أسفل';

  @override
  String get other => 'أخرى';

  @override
  String countElements(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count عناصر',
      one: 'عنصر 1',
      zero: 'بدون عنصر',
    );
    return '$_temp0';
  }

  @override
  String get colorToolbar => 'لون شريط الأدوات';

  @override
  String get yesButShowButtons => 'نعم، لكن أظهر الأزرار';

  @override
  String get optionsPanelPosition => 'موضع لوحة الخيارات';

  @override
  String get hideDuration => 'مدة الإخفاء';

  @override
  String get animation => 'الحركة';

  @override
  String get performance => 'السرعة';

  @override
  String get performanceDescription =>
      'محسن للسرعة واستخدام الذاكرة. يُحمّل فقط الجزء المرئي من الملاحظة.';

  @override
  String get normalDescription =>
      'يوازن بين الجودة والأداء. يحمّل صورة تغطي 1.5 ضعف المساحة المرئية، مما يوفر انتقالات أكثر سلاسة عند التمرير.';

  @override
  String get high => 'مرتفع';

  @override
  String get highDescription =>
      'يزيد الجودة إلى أقصى حد على حساب الأداء. يعطي صورة تغطي ضعف المساحة المرئية، لضمان السلاسة في أثناء التمرير أو التكبير السريع. لكنه يتطلب جهازًا قويًا.';

  @override
  String get renderResolution => ' دقة العرض';

  @override
  String get translate => 'ترجم';

  @override
  String get unencrypted => 'غير مشفرة';

  @override
  String get encrypted => 'مشفرة';

  @override
  String get encryptDocumentMessage => 'انقر لتشفير المستند';

  @override
  String get unencryptDocumentMessage => 'انقر لإلغاء تشفير المستند';

  @override
  String get unencrypt => 'إلغاء التشفير';

  @override
  String get encrypt => 'تشفير';

  @override
  String get encryptWarning =>
      'سيؤدي هذا إلى تشفير المستند. ستحتاج إلى تذكر كلمة المرور لفك تشفيرها.';

  @override
  String get unencryptWarning =>
      'سيؤدي هذا إلى إلغاء تشفير المستند. سيتم إزالة كلمة المرور وسيتمكن كل من لديه حق الوصول من فتحها.';

  @override
  String get confirmPassword => 'تأكيد كلمة المرور';

  @override
  String get passwordMismatch => 'كلمات المرور لا تتطابق';

  @override
  String get action => 'اجراء';

  @override
  String get svgText => 'نص SVG';

  @override
  String get offset => 'إزاحة';

  @override
  String get positionDependent => 'يعتمد على الموقع';

  @override
  String get flipHorizontal => 'قلب أفقي';

  @override
  String get flipVertical => 'قلب عمودي';

  @override
  String get grayscale => 'تدرّج الرمادي';

  @override
  String get moveOnGesture => 'إيماءة التحريك';

  @override
  String get exportAllFiles => 'تصدير جميع الملفات';

  @override
  String get restoreSettingsFromFile => 'استعادة الإعدادات من الملف';

  @override
  String get exportSettingsToFile => 'تصدير الإعدادات إلى ملف';

  @override
  String get barcode => 'الرمز الشريطي (الباركود)';

  @override
  String get barcodeType => 'نوع الرمز الشريطي (الباركود)';

  @override
  String get qrCode => 'رمز الاستجابة السريعة';

  @override
  String get dataMatrix => 'مصفوفة البيانات';

  @override
  String get code128 => 'رمز 128';

  @override
  String defaultUserName(int index) {
    return 'المستخدم $index';
  }

  @override
  String get moveLeft => 'تحريك لليسار';

  @override
  String get moveRight => 'تحريك لليمين';

  @override
  String get bundledPacks => 'الباقات المجمعة';

  @override
  String get component => 'المكون';

  @override
  String get selectComponent => 'حدد المكون';

  @override
  String get bundlePackInDocument => 'اجمع الباقة في المستند';

  @override
  String get bundledPacksDescription =>
      'يتم تضمين الباقات في المستند ولا يمكن استخدامها إلا للمشاركة مع المستند. لا يمكن استخدام الموارد في المستند إلا إذا تم تثبيت الباقة. يمكن تثبيت الباقات بالنقر عليها.';

  @override
  String get fillAlpha => 'شفافية التعبئة';

  @override
  String get packagedFile => 'ملف الحزمة';

  @override
  String get rawFile => 'ملف خام';

  @override
  String get webSocketDescription =>
      'يقوم جهازك باستضافة الخادم، لذا لا يمكن للمتعاونين الانضمام إلا من الشبكة نفسها أو من أيّ مكان آخر إذا قمت بتوجيه المنفذ على جهاز التوجيه الخاص بك.';

  @override
  String get swampDescription =>
      'يتم توجيه رسائلك عبر خادم ترحيل آمن مع تشفير من طرف إلى طرف. يلزم وجود عنوان خادم swamp لإنشاء جلسة.';

  @override
  String get createRawNote => 'إنشاء ملاحظة خامّة';

  @override
  String get polygon => 'مضلع';

  @override
  String get finishShape => 'إنهاء الشكل';

  @override
  String get submit => 'إرسال';

  @override
  String get math => 'الرياضيات';

  @override
  String get ignorePressure => 'تجاهل الضغط';

  @override
  String get ignoreFirstPressureDescription =>
      'في بعض الأجهزة، قيمة الضغط الأولى غير دقيقة. سيتجاهل هذا الإعداد قيمة الضغط الأولى ويستخدم ضغط الحدث الثاني بدلاً منها.';

  @override
  String get temporary => 'مؤقت';

  @override
  String get simpleToolbarVisibility => 'عرض شريط الأدوات البسيطة';

  @override
  String get autosaveDelay => 'تأخير الحفظ التلقائي';

  @override
  String get saved => 'محفوظ';

  @override
  String get saving => 'يُحفَظ...';

  @override
  String get readOnly => 'قراءة فقط';

  @override
  String get saveDelayed => 'الحفظ مؤجل';

  @override
  String get unsaved => 'غير محفوظة';

  @override
  String get pdfEmptyDescription =>
      'لا توجد حالياً أي مناطق للتصدير. يرجى تحديد منطقة واحدة على الأقل باستخدام زر الإضافة في الزاوية العلوية اليمنى أو إضافة جميع المناطق من الصفحة الحالية أو من المستند بأكمله أدناه.';

  @override
  String get densityMaximize => 'مضغوط جداً';
}
