# Security Policy

## Supported Versions

| Version                      | Supported          |                                                                             |
| ---------------------------- | ------------------ | --------------------------------------------------------------------------- |
| 2.4.2-dev (Black Hairstreak) | :warning:          | [Release](https://github.com/LinwoodDev/butterfly/releases/tag/v2.4.2-rc.1) |
| 2.4.1 (Black Hairstreak)     | :white_check_mark: | [Release](https://github.com/LinwoodDev/butterfly/releases/tag/v2.4.1)      |
| 2.3.4 (Adonis Blue)          | :x:                | [Release](https://github.com/LinwoodDev/butterfly/releases/tag/v2.3.4)      |
| 2.2.4                        | :x:                | [Release](https://github.com/LinwoodDev/butterfly/releases/tag/v2.2.4)      |
| 2.1.1                        | :x:                | [Release](https://github.com/LinwoodDev/butterfly/releases/tag/v2.1.1)      |
| 2.0.3                        | :x:                | [Release](https://github.com/LinwoodDev/butterfly/releases/tag/v2.0.3)      |
| 1.6.1                        | :x:                | [Release](https://github.com/LinwoodDev/butterfly/releases/tag/v1.6.1)      |
| 1.5.1                        | :x:                | [Release](https://github.com/LinwoodDev/butterfly/releases/tag/v1.5.1)      |
| 1.4.4                        | :x:                | [Release](https://github.com/LinwoodDev/butterfly/releases/tag/v1.4.4)      |
| 1.3.2                        | :x:                | [Release](https://github.com/LinwoodDev/butterfly/releases/tag/v1.3.2)      |
| 1.2.1                        | :x:                | [Release](https://github.com/LinwoodDev/butterfly/releases/tag/v1.2.1)      |
| 1.1.2                        | :x:                | [Release](https://github.com/LinwoodDev/butterfly/releases/tag/v1.1.2)      |
| 1.0.0                        | :x:                | [Release](https://github.com/LinwoodDev/butterfly/releases/tag/v1.0.0)      |

Older versions can be found [here](https://butterfly.linwood.dev/community/pre-1-0).

## Reporting a Vulnerability

Please use [the bug tracker](https://github.com/LinwoodDev/butterfly/issues) for reporting bugs. Please make sure you are on the latest stable or nightly release.

Use [security@linwood.dev](mailto:security@linwood.dev) or [the github security advisory](https://github.com/LinwoodDev/butterfly/security/advisories) if you want to report a security vulnerability.
**Don't use the bug tracker for security vulnerabilities!**

## Version scheme

The version scheme is based on [Semantic Versioning](https://semver.org/spec/v2.0.0.html). All stable versions will be released in stable branch while all alpha, beta and release candidates will be released in the nightly branch.
There will be alphas, betas and release candidates on every major release, betas and release candidates on every minor release and release candidates on every patch release.

## Branches

| Name    | Support |                                                                                                  Description | Tag     |
| :------ | :-----: | -----------------------------------------------------------------------------------------------------------: | ------- |
| main    |    ✅    |                   This branch is production ready. It will be updated when a new stable version is released! | Stable  |
| develop |    ⚠️    | This branch is only for testing and developing. Pull request for feature requests should only be added here! | Nightly |

Read more about nightly [here](https://butterfly.linwood.dev/community/nightly).
