/*
 *   Copyright 2020-2024 Leon Latsch
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */

package dev.leonlatsch.photok.sort.data.db.model

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.ForeignKey
import androidx.room.PrimaryKey
import dev.leonlatsch.photok.model.database.entity.AlbumTable
import dev.leonlatsch.photok.sort.domain.Sort


@Entity(
    tableName = SortTable.TABLE_NAME,
    foreignKeys = [
        ForeignKey(
            entity = AlbumTable::class,
            parentColumns = arrayOf(AlbumTable.ALBUM_UUID),
            childColumns = arrayOf(AlbumTable.ALBUM_UUID),
            onDelete = ForeignKey.CASCADE,
        ),
    ]
)
data class SortTable(
    @PrimaryKey(autoGenerate = true)
    val id: Long,
    @ColumnInfo(name = AlbumTable.ALBUM_UUID, index = true)
    val albumUuid: String? = null,
    val field: Sort.Field,
    val order: Sort.Order,
) {
    companion object {
        const val TABLE_NAME = "sort"
    }
}