/*
 *   Copyright 2020-2024 Leon Latsch
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */

package dev.leonlatsch.photok.security.di

import dagger.Binds
import dagger.Module
import dagger.hilt.InstallIn
import dagger.hilt.components.SingletonComponent
import dev.leonlatsch.photok.security.EncryptionManager
import dev.leonlatsch.photok.security.EncryptionManagerImpl
import dev.leonlatsch.photok.security.biometric.BiometricUnlock
import dev.leonlatsch.photok.security.biometric.BiometricUnlockImpl
import dev.leonlatsch.photok.security.migration.LegacyEncryptionManager
import dev.leonlatsch.photok.security.migration.LegacyEncryptionManagerImpl
import javax.inject.Singleton

@Module
@InstallIn(SingletonComponent::class)
interface EncryptionModule {

    @Binds
    @Singleton
    fun bindEncryptionManager(impl: EncryptionManagerImpl): EncryptionManager

    @Binds
    @Singleton
    @LegacyEncryptionManager
    fun bindLegacyEncryptionManager(impl: LegacyEncryptionManagerImpl): EncryptionManager

    @Binds
    @Singleton
    fun bindBiometricUnlock(impl: BiometricUnlockImpl): BiometricUnlock
}