/*
 *   Copyright 2020-2024 Leon Latsch
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */

package dev.leonlatsch.photok.sort.data

import dev.leonlatsch.photok.sort.data.db.model.SortTable
import dev.leonlatsch.photok.sort.domain.Sort

fun Sort.toData(albumUuid: String?): SortTable {
    return SortTable(
        id = 0,
        albumUuid = albumUuid,
        field = field,
        order = order,
    )
}

fun SortTable.toDomain(): Sort {
    return Sort(
        field = field,
        order = order,
    )
}