import { useEffect, useState } from "react";
import { Uniwind } from "../core/index.js";
import { UniwindStore } from "../core/native/index.js";
import { StyleDependency } from "../types.js";
export const useUniwind = () => {
  const [theme, setTheme] = useState(Uniwind.currentTheme);
  const [hasAdaptiveThemes, setHasAdaptiveThemes] = useState(Uniwind.hasAdaptiveThemes);
  useEffect(() => {
    const dispose = UniwindStore.subscribe(() => {
      setTheme(Uniwind.currentTheme);
      setHasAdaptiveThemes(Uniwind.hasAdaptiveThemes);
    }, [StyleDependency.Theme]);
    return () => {
      dispose();
    };
  }, []);
  return {
    theme,
    hasAdaptiveThemes
  };
};
