import { formatHex, formatHex8, interpolate, parse } from "culori";
export const colorMix = (color, weight, mixColor) => {
  const parsedWeight = typeof weight === "string" ? parseFloat(weight) / 100 : weight;
  if (mixColor === "#00000000") {
    const parsedColor = parse(color);
    if (parsedColor === void 0) {
      return color;
    }
    return formatHex8({
      ...parsedColor,
      alpha: parsedWeight * (parsedColor.alpha ?? 1)
    });
  }
  return formatHex(interpolate([mixColor, color])(parsedWeight));
};
export function lightDark(light, dark) {
  if (this.currentThemeName === "dark") {
    return dark;
  }
  return light;
}
export const cloneWithAccessors = (obj) => {
  const proto = Object.getPrototypeOf(obj);
  const clone = Object.create(proto);
  Object.defineProperties(clone, Object.getOwnPropertyDescriptors(obj));
  return clone;
};
