import { useEffect, useMemo, useReducer } from "react";
import { UniwindStore } from "../../core/native/index.js";
const emptyState = { styles: {}, dependencies: [] };
export const useStyle = (className, state) => {
  const [_, rerender] = useReducer(() => ({}), {});
  const styleState = useMemo(
    () => className ? UniwindStore.getStyles(className, state) : emptyState,
    [className, _, state?.isDisabled, state?.isFocused, state?.isPressed]
  );
  useEffect(() => {
    if (__DEV__ || styleState.dependencies.length > 0) {
      const dispose = UniwindStore.subscribe(() => rerender(), styleState.dependencies);
      return dispose;
    }
  }, [styleState]);
  return styleState.styles;
};
