import { jsx } from "react/jsx-runtime";
import { RefreshControl as RNRefreshControl } from "react-native";
import { useUniwindAccent } from "../../hooks/index.js";
import { copyComponentProperties } from "../utils.js";
import { useStyle } from "./useStyle.js";
export const RefreshControl = copyComponentProperties(RNRefreshControl, (props) => {
  const style = useStyle(props.className);
  const color = useUniwindAccent(props.colorsClassName);
  const tintColor = useUniwindAccent(props.tintColorClassName);
  const titleColor = useUniwindAccent(props.titleColorClassName);
  const progressBackgroundColor = useUniwindAccent(props.progressBackgroundColorClassName);
  return /* @__PURE__ */ jsx(
    RNRefreshControl,
    {
      ...props,
      style: [style, props.style],
      colors: props.colors ?? (color !== void 0 ? [color] : void 0),
      tintColor: props.tintColor ?? tintColor,
      titleColor: props.titleColor ?? titleColor,
      progressBackgroundColor: props.progressBackgroundColor ?? progressBackgroundColor
    }
  );
});
export default RefreshControl;
