import { jsx } from "react/jsx-runtime";
import { ImageBackground as RNImageBackground } from "react-native";
import { useUniwindAccent } from "../../hooks/index.js";
import { copyComponentProperties } from "../utils.js";
import { useStyle } from "./useStyle.js";
export const ImageBackground = copyComponentProperties(RNImageBackground, (props) => {
  const style = useStyle(props.className);
  const imageStyle = useStyle(props.imageClassName);
  const tintColor = useUniwindAccent(props.tintColorClassName);
  return /* @__PURE__ */ jsx(
    RNImageBackground,
    {
      ...props,
      style: [style, props.style],
      imageStyle: [imageStyle, props.imageStyle],
      tintColor: props.tintColor ?? tintColor
    }
  );
});
export default ImageBackground;
