"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildCSS = void 0;
var _fs = _interopRequireDefault(require("fs"));
var _path = _interopRequireDefault(require("path"));
var _insets = require("./insets");
var _themes = require("./themes");
var _variants = require("./variants");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const buildCSS = async (themes, input) => {
  const variants = (0, _variants.generateCSSForVariants)();
  const insets = (0, _insets.generateCSSForInsets)();
  const themesCSS = await (0, _themes.generateCSSForThemes)(themes, input);
  const cssFile = _path.default.join(__dirname, "../../uniwind.css");
  const oldCSSFile = _fs.default.existsSync(cssFile) ? _fs.default.readFileSync(cssFile, "utf-8") : "";
  if (oldCSSFile === cssFile) {
    return;
  }
  _fs.default.writeFileSync(cssFile, [variants, insets, themesCSS].join("\n"));
};
exports.buildCSS = buildCSS;