"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UniwindRuntime = void 0;
var _reactNative = require("react-native");
var _types = require("../../types");
var _nativeUtils = require("./native-utils");
const window = _reactNative.Dimensions.get("window");
const initialColorScheme = _reactNative.Appearance.getColorScheme() ?? _types.ColorScheme.Light;
const UniwindRuntime = exports.UniwindRuntime = {
  screen: {
    width: window.width,
    height: window.height
  },
  colorScheme: initialColorScheme,
  currentThemeName: initialColorScheme,
  orientation: window.width > window.height ? _types.Orientation.Landscape : _types.Orientation.Portrait,
  fontScale: value => value * _reactNative.PixelRatio.getFontScale(),
  hairlineWidth: _reactNative.StyleSheet.hairlineWidth,
  rtl: _reactNative.I18nManager.isRTL,
  insets: {
    top: 0,
    left: 0,
    bottom: 0,
    right: 0
  },
  colorMix: _nativeUtils.colorMix,
  pixelRatio: value => value * _reactNative.PixelRatio.get(),
  cubicBezier: () => "",
  lightDark: () => ""
};
UniwindRuntime.lightDark = _nativeUtils.lightDark.bind(UniwindRuntime);