"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
module.exports = exports.Pressable = void 0;
var _jsxRuntime = require("react/jsx-runtime");
var _reactNative = require("react-native");
var _native = require("../../core/native");
var _utils = require("../utils");
var _useStyle = require("./useStyle");
const Pressable = exports.Pressable = (0, _utils.copyComponentProperties)(_reactNative.Pressable, props => {
  const style = (0, _useStyle.useStyle)(props.className, {
    isDisabled: Boolean(props.disabled)
  });
  return /* @__PURE__ */(0, _jsxRuntime.jsx)(_reactNative.Pressable, {
    ...props,
    style: state => {
      if (state.pressed) {
        return [_native.UniwindStore.getStyles(props.className, {
          isDisabled: Boolean(props.disabled),
          isPressed: true
        }).styles, typeof props.style === "function" ? props.style(state) : props.style];
      }
      return [style, typeof props.style === "function" ? props.style(state) : props.style];
    }
  });
});
module.exports = Pressable;