"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
module.exports = exports.FlatList = void 0;
var _jsxRuntime = require("react/jsx-runtime");
var _reactNative = require("react-native");
var _hooks = require("../../hooks");
var _utils = require("../utils");
var _useStyle = require("./useStyle");
const FlatList = exports.FlatList = (0, _utils.copyComponentProperties)(_reactNative.FlatList, props => {
  const style = (0, _useStyle.useStyle)(props.className);
  const styleColumnWrapper = (0, _useStyle.useStyle)(props.columnWrapperClassName);
  const styleContentContainer = (0, _useStyle.useStyle)(props.contentContainerClassName);
  const styleListFooterComponent = (0, _useStyle.useStyle)(props.ListFooterComponentClassName);
  const styleListHeaderComponent = (0, _useStyle.useStyle)(props.ListHeaderComponentClassName);
  const endFillColor = (0, _hooks.useUniwindAccent)(props.endFillColorClassName);
  const hasSingleColumn = !("numColumns" in props) || props.numColumns === 1;
  return /* @__PURE__ */(0, _jsxRuntime.jsx)(_reactNative.FlatList, {
    ...props,
    style: [style, props.style],
    columnWrapperStyle: hasSingleColumn ? void 0 : [styleColumnWrapper, props.columnWrapperStyle],
    contentContainerStyle: [styleContentContainer, props.contentContainerStyle],
    ListFooterComponentStyle: [styleListFooterComponent, props.ListFooterComponentStyle],
    ListHeaderComponentStyle: [styleListHeaderComponent, props.ListHeaderComponentStyle],
    endFillColor: props.endFillColor ?? endFillColor
  });
});
module.exports = FlatList;