"use strict";
// src/api/SuggestionsService.ts
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SuggestionsService = void 0;
class SuggestionsService {
    constructor(fetchWrapper) {
        this.fetchWrapper = fetchWrapper;
    }
    /**
     * Fetches a list of alternative search terms (suggestions) for a given search term.
     *
     * @param params - An object containing the search parameters.
     * @returns A promise that resolves to a SuggestionsResponse containing the suggested search terms.
     */
    getSuggestions(params) {
        return __awaiter(this, void 0, void 0, function* () {
            const endpoint = 'search_suggestions';
            return this.fetchWrapper.get(endpoint, params);
        });
    }
}
exports.SuggestionsService = SuggestionsService;
