"use strict";
// src/api/SearchService.ts
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SearchService = void 0;
class SearchService {
    constructor(fetchWrapper) {
        this.fetchWrapper = fetchWrapper;
    }
    /**
     * Searches for GIFs, stickers, or other media types based on the provided parameters.
     *
     * @param params - An object containing the search parameters.
     * @returns A promise that resolves to a SearchResponse containing the search results and the next page token.
     */
    query(params) {
        return __awaiter(this, void 0, void 0, function* () {
            const endpoint = 'search';
            return this.fetchWrapper.get(endpoint, params);
        });
    }
    /**
     * Fetches the next page of results based on the provided next token.
     *
     * @param next - The next page token from a previous search response.
     * @returns A promise that resolves to a SearchResponse containing the next set of results.
     */
    fetchNext(next) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.query({ pos: next });
        });
    }
}
exports.SearchService = SearchService;
