import type { FocusedInputEventsModule, KeyboardBackgroundViewProps, KeyboardControllerNativeModule, KeyboardControllerProps, KeyboardEventsModule, KeyboardExtenderProps, KeyboardGestureAreaProps, OverKeyboardViewProps, WindowDimensionsEventsModule } from "./types";
export declare const KeyboardControllerNative: KeyboardControllerNativeModule;
/**
 * An event emitter that provides a way to subscribe to next keyboard events:
 * - `keyboardWillShow`;
 * - `keyboardDidShow`;
 * - `keyboardWillHide`;
 * - `keyboardDidHide`.
 *
 * Use `addListener` function to add your event listener for a specific keyboard event.
 */
export declare const KeyboardEvents: KeyboardEventsModule;
/**
 * This API is not documented, it's for internal usage only (for now), and is a subject to potential breaking changes in future.
 * Use it with cautious.
 */
export declare const FocusedInputEvents: FocusedInputEventsModule;
export declare const WindowDimensionsEvents: WindowDimensionsEventsModule;
/**
 * A view that sends events whenever keyboard or focused events are happening.
 *
 * @see {@link https://kirillzyusko.github.io/react-native-keyboard-controller/docs/api/keyboard-controller-view|Documentation} page for more details.
 */
export declare const KeyboardControllerView: React.FC<KeyboardControllerProps>;
/**
 * A view that defines a region on the screen, where gestures will control the keyboard position.
 *
 * @see {@link https://kirillzyusko.github.io/react-native-keyboard-controller/docs/api/keyboard-gesture-area|Documentation} page for more details.
 */
export declare const KeyboardGestureArea: React.FC<KeyboardGestureAreaProps>;
export declare const RCTOverKeyboardView: React.FC<OverKeyboardViewProps>;
/**
 * A view that matches keyboard background.
 *
 * @see {@link https://kirillzyusko.github.io/react-native-keyboard-controller/docs/api/keyboard-background-view|Documentation} page for more details.
 */
export declare const KeyboardBackgroundView: React.FC<KeyboardBackgroundViewProps>;
/**
 * A container that will embed its children into the keyboard
 * and will always show them above the keyboard.
 *
 * @see {@link https://kirillzyusko.github.io/react-native-keyboard-controller/docs/api/keyboard-extender|Documentation} page for more details.
 */
export declare const RCTKeyboardExtender: React.FC<KeyboardExtenderProps>;
