# react-native-keyboard-controller

A universal keyboard handling solution for React Native — lightweight, fully customizable, and built for real-world apps. Smooth animations, consistent behavior on both iOS and Android, with a developer-oriented design.

<div>
  <img align="right" width="32%" src="./gifs/demo.png?raw=true">
</div>

### Key features

- 🧬 Map keyboard movement to animated values
- 🧪 `keyboardWillShow` / `keyboardWillHide` events now available on Android
- 🔮 Change soft input mode on Android
- ⚡ Preload keyboard to avoid first-time focus lag
- 🚀 Reanimated support
- 📱 Interactive keyboard dismissing 👆📱
- 📚 Prebuilt components (`KeyboardStickyView`, `KeyboardAwareScrollView`, reworked `KeyboardAvoidingView`)
- 📐 `KeyboardToolbar` with customizable _**previous**_, _**next**_, and _**done**_ buttons
- 🌐 Display anything over the keyboard (without dismissing it) using `OverKeyboardView`
- 🎨 Match keyboard background with `KeyboardBackgroundView`
- 🧩 Extend keyboard with custom buttons/UI via `KeyboardExtender`
- 📝 Easy retrieval of focused input info
- 🧭 Compatible with any navigation library
- ✨ More coming soon... stay tuned! 😊

### Installation

Check out the [installation](https://kirillzyusko.github.io/react-native-keyboard-controller/docs/installation) section of the docs for detailed setup instructions.

### Documentation

Full API reference and guides available at:  
[https://kirillzyusko.github.io/react-native-keyboard-controller/](https://kirillzyusko.github.io/react-native-keyboard-controller/)

### Contributing

See the [contributing guide](CONTRIBUTING.md) to learn how to contribute to the repo and development workflow.

### License

MIT
