"use strict";

import React from 'react';
import ULElement from "../elements/ULElement.js";
import { useRendererProps } from "../context/RenderersPropsProvider.js";
function getFallbackListStyleTypeFromNestLevel(nestLevel) {
  switch (nestLevel % 3) {
    case 0:
      return 'disc';

    /* istanbul ignore next */
    case 1:
      return 'circle';

    /* istanbul ignore next */
    default:
      return 'square';
  }
}
export function useULElementProps(props) {
  const config = useRendererProps('ul');
  return {
    ...props,
    getFallbackListStyleTypeFromNestLevel,
    ...config
  };
}
const ULRenderer = props => {
  return /*#__PURE__*/React.createElement(ULElement, useULElementProps(props));
};
export default ULRenderer;
//# sourceMappingURL=ULRenderer.js.map