"use strict";

import lookupRecord from "../helpers/lookupRecord.js";
import BRRenderer from "../renderers/BRRenderer.js";
import WBRRenderer from "../renderers/WBRRenderer.js";
import internalRenderers from "./internalRenderers.js";
const internalTextRenderers = {
  br: BRRenderer,
  wbr: WBRRenderer
};
export default class RenderRegistry {
  constructor(customRenderers = {}, elementModels) {
    this.customRenderers = customRenderers;
    this.elementModels = elementModels;
  }
  customRenderers = {};
  getCustomRendererForTNode(tnode) {
    if (tnode.tagName in this.customRenderers) {
      const renderer = this.customRenderers[tnode.tagName];
      /* istanbul ignore next */
      if (typeof __DEV__ === 'boolean' && __DEV__) {
        // In DEV, check for discrepancies.
        const elementModel = this.elementModels[tnode.tagName];
        if (!elementModel) {
          console.warn(`You are attempting to render a ${tnode.tagName} tag but you didn't provide an HTMLElementModel. Make sure you register a model for this tag in "customHTMLElementModels" prop. `);
        } else if (!tnode.matchContentModel(elementModel.contentModel)) {
          console.warn(`You are attempting to render "${tnode.tagName}" of type "${tnode.displayName}", but the registered renderer is of content model type ${elementModel?.contentModel} which is incompatible with "${tnode.displayName}".`);
        }
      }
      return renderer;
    }
    return null;
  }
  getDefaultRendererForTNode(tnode) {
    if (tnode.tagName in internalRenderers) {
      //@ts-expect-error we know that the tagName is in the map
      return internalRenderers[tnode.tagName];
    }
    return null;
  }
  getInternalTextRenderer(tagName) {
    if (lookupRecord(internalTextRenderers, tagName)) {
      return internalTextRenderers[tagName];
    }
    return null;
  }
  getRendererConfigForTNode(tnode) {
    return {
      Custom: this.getCustomRendererForTNode(tnode),
      Default: this.getDefaultRendererForTNode(tnode)
    };
  }
}
//# sourceMappingURL=RenderRegistry.js.map