"use strict";

import React from 'react';
import { ActivityIndicator, StyleSheet, Text, View } from 'react-native';
import { jsxs as _jsxs, jsx as _jsx } from "react/jsx-runtime";
const styles = StyleSheet.create({
  alignCenter: {
    flex: 1,
    alignItems: 'center',
    justifyContent: 'center'
  },
  errorText: {
    fontStyle: 'italic',
    fontSize: 16
  }
});
export function defaultRenderError(source) {
  return /*#__PURE__*/_jsx(View, {
    testID: "loader-error",
    style: styles.alignCenter,
    children: /*#__PURE__*/_jsxs(Text, {
      style: styles.errorText,
      children: ["Failed to load HTML from ", source.uri]
    })
  });
}
export function defaultRenderLoading() {
  return /*#__PURE__*/_jsx(View, {
    testID: "loader-loading",
    style: styles.alignCenter,
    children: /*#__PURE__*/_jsx(ActivityIndicator, {})
  });
}
const sourceLoaderContext = /*#__PURE__*/React.createContext({
  remoteErrorView: defaultRenderError,
  remoteLoadingView: defaultRenderLoading
});
export default sourceLoaderContext;
//# sourceMappingURL=sourceLoaderContext.js.map