"use strict";

import React, { useMemo } from 'react';
import useProfiler from "../hooks/useProfiler.js";
import RenderRegistry from "../render/RenderRegistry.js";
import { jsx as _jsx } from "react/jsx-runtime";
export const RenderRegistryContext = /*#__PURE__*/React.createContext(null);
export function useRendererRegistry() {
  return React.useContext(RenderRegistryContext);
}
export function useRendererConfig(tnode) {
  return React.useContext(RenderRegistryContext).getRendererConfigForTNode(tnode);
}
export function useInternalTextRenderer(tnode) {
  return React.useContext(RenderRegistryContext).getInternalTextRenderer(tnode.tagName);
}
export default function RenderRegistryProvider({
  children,
  elementModels,
  renderers
}) {
  const profile = useProfiler({
    prop: 'renderers'
  });
  const registry = useMemo(() => {
    typeof __DEV__ === 'boolean' && __DEV__ && profile();
    return new RenderRegistry(renderers, elementModels);
  }, [renderers, elementModels, profile]);
  return /*#__PURE__*/_jsx(RenderRegistryContext.Provider, {
    value: registry,
    children: children
  });
}
//# sourceMappingURL=RenderRegistryProvider.js.map