"use strict";

/* eslint-disable react-native/no-inline-styles */

import mapObjIndexed from 'ramda/src/mapObjIndexed';
import React, { createContext, useContext, useMemo } from 'react';
import { Text, View } from 'react-native';
import defaultListStyleSpecs from "../elements/defaultListStyleSpecs.js";
import { useSharedProps } from "./SharedPropsProvider.js";
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
const listStyleSpecsContext = /*#__PURE__*/createContext(defaultListStyleSpecs);
export function useListStyleSpecs() {
  return useContext(listStyleSpecsContext);
}
function createSymbolicMarkerRenderer({
  Component,
  counterStyleRenderer
}) {
  const prefix = counterStyleRenderer.renderPrefix();
  const suffix = counterStyleRenderer.renderSuffix();
  return ({
    style,
    markerTextStyle,
    counterIndex,
    rtlMarkerReversed
  }) => {
    return /*#__PURE__*/_jsxs(View, {
      style: [style, {
        flexDirection: rtlMarkerReversed ? 'row-reverse' : 'row',
        justifyContent: 'flex-end'
      }],
      children: [!!prefix && /*#__PURE__*/_jsx(Text, {
        style: markerTextStyle,
        children: prefix
      }), /*#__PURE__*/React.createElement(Component, {
        ...markerTextStyle,
        index: counterIndex
      }), !!suffix && /*#__PURE__*/_jsx(Text, {
        style: markerTextStyle,
        children: suffix
      })]
    });
  };
}
const makeMarkerRenderers = mapObjIndexed(value => {
  if (value.type === 'unitary') {
    return {
      ...value,
      renderMarker: createSymbolicMarkerRenderer(value)
    };
  }
  return value;
});
export default function ListStyleSpecsProvider({
  children
}) {
  const {
    customListStyleSpecs
  } = useSharedProps();
  const mergedListStyleSpecs = useMemo(() => {
    return makeMarkerRenderers(customListStyleSpecs != null ? {
      ...defaultListStyleSpecs,
      ...customListStyleSpecs
    } : defaultListStyleSpecs);
  }, [customListStyleSpecs]);
  return /*#__PURE__*/_jsx(listStyleSpecsContext.Provider, {
    value: mergedListStyleSpecs,
    children: children
  });
}
//# sourceMappingURL=ListStyleSpecsProvider.js.map