"use strict";

import React from 'react';
import RenderHTMLDebug from "./RenderHTMLDebug.js";
import TRenderEngineProvider from "./TRenderEngineProvider.js";
import RenderHTMLConfigProvider from "./RenderHTMLConfigProvider.js";
import RenderHTMLSource from "./RenderHTMLSource.js";

/**
 * Render HTML text in native views!
 *
 * @remarks If your application uses many instances of this component, you
 * should share the render engine across those instances via the
 * {@link TRenderEngineProvider} and {@link RenderHTMLConfigProvider}
 * components, and render the HTML with {@link RenderHTMLSource} instead. That
 * should significantly increase performance.
 *
 * @warning It should never be a child of a React Native `Text` element, as the
 * layout will break.
 *
 * @public
 */
import { jsx as _jsx } from "react/jsx-runtime";
export default function RenderHTML(props) {
  const {
    source,
    onHTMLLoaded,
    onTTreeChange,
    onDocumentMetadataLoaded,
    contentWidth,
    ...otherProps
  } = props;
  return /*#__PURE__*/_jsx(RenderHTMLDebug, {
    ...props,
    children: /*#__PURE__*/_jsx(TRenderEngineProvider, {
      ...otherProps,
      children: /*#__PURE__*/_jsx(RenderHTMLConfigProvider, {
        ...otherProps,
        children: /*#__PURE__*/React.createElement(RenderHTMLSource, {
          source,
          onHTMLLoaded,
          onTTreeChange,
          onDocumentMetadataLoaded,
          contentWidth
        })
      })
    })
  });
}
//# sourceMappingURL=RenderHTML.js.map