import type { Config } from "@react-native-community/cli-types";
export declare const REACT_NATIVE_CONFIG_FILES: string[];
/**
 * Finds path to `@react-native-community/cli`.
 * @param root Project root
 * @param reactNativePath Path to `react-native`, if known
 */
export declare function resolveCommunityCLI(root: string, reactNativePath?: string): string;
/**
 * Equivalent to calling `loadConfig()` from `@react-native-community/cli`, but
 * the result is cached for faster subsequent accesses.
 * @param projectRoot Project root; defaults to current working directory
 */
export declare function loadContext(projectRoot?: string): Config;
/**
 * Equivalent to calling `loadConfigAsync()` (with fallback to `loadConfig()`)
 * from `@react-native-community/cli`, but the result is cached for faster
 * subsequent accesses.
 * @param projectRoot Project root; defaults to current working directory
 */
export declare function loadContextAsync(projectRoot?: string): Promise<Config>;
export declare function readReactNativeConfig(packageDir: string, cwd?: string): Record<string, unknown> | undefined;
//# sourceMappingURL=context.d.ts.map