import * as nodefs from "fs";
type FileType = "file" | "directory";
type FindUpOptions = {
    type?: FileType;
    startDir?: string;
    stopAt?: string;
    allowSymlinks?: boolean;
};
/**
 * Finds the specified file(s) or directory(s) by walking up parent directories.
 * @param names One or multiple names to search for
 * @param options
 */
export declare function findUp(names: string | string[], { type, startDir, stopAt, allowSymlinks, }?: FindUpOptions, 
/** @internal */ fs?: typeof nodefs): string | undefined;
/**
 * Normalize the separators in a path, converting each backslash ('\\') to a foreward
 * slash ('/').
 *
 * @param p Path to normalize
 * @returns Normalized path
 */
export declare function normalizePath(p: string): string;
export {};
//# sourceMappingURL=path.d.ts.map