"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.getFromDir = getFromDir;
exports.makeEnhancedResolveOptions = makeEnhancedResolveOptions;
const platform_1 = require("@rnx-kit/tools-react-native/platform");
const path = __importStar(require("node:path"));
const metro_1 = require("./metro");
function getFromDir({ originModulePath, }) {
    return originModulePath ? path.dirname(originModulePath) : process.cwd();
}
function makeEnhancedResolveOptions(context, platform = "common") {
    const { extraNodeModules, mainFields, sourceExts, unstable_conditionNames } = context;
    const extensions = sourceExts.map((ext) => `.${ext}`);
    const enablePackageExports = (0, metro_1.isPackageExportsEnabled)(context);
    return {
        // Map Metro's `context.extraNodeModules` to Webpack's `resolve.alias`.
        // Metro's implementation is a subset of Webpack's. See:
        // - https://facebook.github.io/metro/docs/resolution
        // - https://webpack.js.org/configuration/resolve/#resolvealias
        alias: extraNodeModules ?? undefined,
        aliasFields: ["browser"],
        // Add `require` to handle packages that are missing `default`
        // conditional. See
        // https://github.com/webpack/enhanced-resolve/issues/313
        conditionNames: enablePackageExports
            ? unstable_conditionNames.slice()
            : ["require", "node"],
        // Unless `unstable_enablePackageExports` is enabled, disable exports
        // map as it currently takes precedence over the `react-native` field.
        ...(enablePackageExports ? undefined : { exportsFields: [] }),
        extensions: platform === "common"
            ? extensions
            : (0, platform_1.expandPlatformExtensions)(platform, extensions),
        mainFields: mainFields.slice(),
    };
}
//# sourceMappingURL=enhancedResolveHelpers.js.map