"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getResolver = getResolver;
const console_1 = require("@rnx-kit/console");
const enhanced_resolve_1 = require("./resolvers/enhanced-resolve");
const metro_resolver_1 = require("./resolvers/metro-resolver");
const oxc_resolver_1 = require("./resolvers/oxc-resolver");
const metro_1 = require("./utils/metro");
function getResolver(options) {
    const retryFromDisk = (0, metro_1.shouldEnableRetryResolvingFromDisk)(options);
    if (retryFromDisk) {
        (0, metro_1.patchMetro)(options);
    }
    switch (options.resolver) {
        case "enhanced-resolve":
            return enhanced_resolve_1.applyEnhancedResolver;
        case "oxc-resolver":
            (0, console_1.info)("Note: Oxc Resolver support is still experimental");
            return oxc_resolver_1.applyOxcResolver;
        default:
            return retryFromDisk ? enhanced_resolve_1.applyEnhancedResolver : metro_resolver_1.applyMetroResolver;
    }
}
//# sourceMappingURL=resolvers.js.map