"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _TStyles = require("../styles/TStyles");

var _markersPrototype = _interopRequireDefault(require("./markersPrototype"));

var _tnodeSnapshot = _interopRequireDefault(require("./tnodeSnapshot"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function updateNodeIndexes(node, i) {
  node.nodeIndex = i;
}

const emptyAttrs = Object.freeze({});
const emptyClasses = Object.freeze([]);

function findNativeRole(ariaRole) {
  if (ariaRole === 'img') {
    return 'image';
  }

  if (ariaRole === 'heading') {
    return 'header';
  }

  if (ariaRole === 'dialog') {
    return 'alert';
  }

  if (ariaRole === 'presentation') {
    return 'none';
  }

  if (ariaRole === 'button' || ariaRole === 'switch' || ariaRole === 'checkbox' || ariaRole === 'radio' || ariaRole === 'radiogroup' || ariaRole === 'link' || ariaRole === 'search') {
    return ariaRole;
  }
}

function setMarkersFromAttributes(targetMarkers, _parentMarkers, {
  attributes
}) {
  if ('dir' in attributes) {
    targetMarkers.direction = attributes.dir;
  }

  if ('lang' in attributes) {
    targetMarkers.lang = attributes.lang;
  }
}

function transformPropsDefinitionsToSwitch(definition) {
  if (!definition) {
    return null;
  }

  return {
    text: { ...definition.native,
      ...definition.text
    },
    view: { ...definition.native,
      ...definition.view
    }
  };
}

function mergeSwitches(prev, next) {
  if (!prev) {
    return next;
  }

  if (!next) {
    return prev;
  }

  return {
    text: { ...prev.text,
      ...next.text
    },
    view: { ...prev.view,
      ...next.view
    }
  };
}

const prototype = {
  children: Object.freeze([]),
  init: Object.freeze({}),
  classes: Object.freeze([]),
  styles: Object.freeze(_TStyles.TStyles.empty()),
  markers: _markersPrototype.default,
  __nodeIndex: null,
  __trimmedLeft: false,
  __trimmedRight: false,
  __nativeProps: false,
  __nativeStyles: false,
  __webStyles: false,

  __generateNativePropsFromTNode() {
    let ret = null;

    if (this.styles.webTextFlow.userSelect) {
      ret = mergeSwitches(ret, {
        text: {
          selectable: this.styles.webTextFlow.userSelect !== 'none'
        }
      });
    }

    if (this.attributes['aria-label']) {
      const accessibilityProps = {
        accessibilityLabel: this.attributes['aria-label']
      };
      ret = mergeSwitches(ret, {
        view: accessibilityProps,
        text: accessibilityProps
      });
    }

    if (this.attributes.role) {
      const role = this.attributes.role;
      const accessibilityRole = findNativeRole(role);

      if (accessibilityRole) {
        const accessibilityProps = {
          accessibilityRole: accessibilityRole
        };
        ret = mergeSwitches(ret, {
          view: accessibilityProps,
          text: accessibilityProps
        });
      }
    }

    return ret;
  },

  __generateDynamicNativePropsFromModel(autoGeneratedProps) {
    const elm = this.elementModel;

    if (!elm || !elm.getReactNativeProps) {
      return null;
    }

    return transformPropsDefinitionsToSwitch(elm.getReactNativeProps(this, autoGeneratedProps, this.domNode) || null);
  },

  get attributes() {
    var _this$domNode;

    return ((_this$domNode = this.domNode) === null || _this$domNode === void 0 ? void 0 : _this$domNode.attribs) || emptyAttrs;
  },

  get hasWhiteSpaceCollapsingEnabled() {
    return typeof this.styles.webTextFlow.whiteSpace === 'string' ? this.styles.webTextFlow.whiteSpace === 'normal' : true;
  },

  get contentModel() {
    var _this$elementModel;

    return ((_this$elementModel = this.elementModel) === null || _this$elementModel === void 0 ? void 0 : _this$elementModel.contentModel) || null;
  },

  get parentStyles() {
    var _this$parent;

    return this.init.parentStyles || ((_this$parent = this.parent) === null || _this$parent === void 0 ? void 0 : _this$parent.styles) || null;
  },

  get id() {
    return this.attributes.id || null;
  },

  get domNode() {
    return this.init.domNode || null;
  },

  get elementModel() {
    return this.init.elementModel;
  },

  get tagName() {
    var _this$init$domNode;

    return ((_this$init$domNode = this.init.domNode) === null || _this$init$domNode === void 0 ? void 0 : _this$init$domNode.name) || null;
  },

  get parent() {
    return this.init.parent || null;
  },

  get nodeIndex() {
    if (this.__nodeIndex === null) {
      this.__nodeIndex = this.init.nodeIndex || 0;
    }

    return this.__nodeIndex;
  },

  get isUnregistered() {
    return this.init.isUnregistered || false;
  },

  set nodeIndex(nodeIndex) {
    this.__nodeIndex = nodeIndex;
  },

  bindChildren(children, shouldUpdateNodeIndexes = false) {
    //@ts-ignore
    this.children = children;

    if (shouldUpdateNodeIndexes) {
      children.forEach(updateNodeIndexes);
    }
  },

  cloneInitParams(partial) {
    return Object.assign({}, this.init, partial);
  },

  isCollapsibleLeft() {
    if (this.children.length) {
      return this.hasWhiteSpaceCollapsingEnabled && this.children[0].isCollapsibleLeft();
    }

    return false;
  },

  isCollapsibleRight() {
    if (this.children.length) {
      return this.hasWhiteSpaceCollapsingEnabled && this.children[this.children.length - 1].isCollapsibleRight();
    }

    return false;
  },

  isEmpty() {
    return false;
  },

  trimLeft() {
    if (!this.__trimmedLeft && this.children.length) {
      const firstChild = this.children[0];
      firstChild.trimLeft();

      if (firstChild.isEmpty()) {
        //@ts-ignore
        this.children.splice(0, 1);
      }

      this.__trimmedLeft = true;
    }
  },

  trimRight() {
    if (!this.__trimmedRight && this.children.length) {
      const lastChild = this.children[this.children.length - 1];
      lastChild.trimRight();

      if (lastChild.isEmpty()) {
        //@ts-ignore
        this.children.splice(-1, 1);
      }

      this.__trimmedRight = true;
    }
  },

  matchContentModel() {
    return false;
  },

  spliceChildren(indexesToSplice) {
    let offset = 0;

    for (const i of indexesToSplice) {
      //@ts-ignore
      this.children.splice(i - offset, 1);
      offset += 1;
    }
  },

  collapse() {
    this.collapseChildren();
    this.bindChildren(this.children, true);
  },

  getNativeStyles() {
    if (this.__nativeStyles === false) {
      this.__nativeStyles = { ...this.styles.nativeBlockFlow,
        ...this.styles.nativeBlockRet,
        ...this.styles.nativeTextFlow,
        ...this.styles.nativeTextRet
      };
    }

    return this.__nativeStyles;
  },

  getWebStyles() {
    if (this.__webStyles === false) {
      this.__webStyles = { ...this.styles.webTextFlow,
        ...this.styles.webBlockRet
      };
    }

    return this.__webStyles;
  },

  collapseChildren() {
    return;
  },

  snapshot(options = {}) {
    const {
      withStyles = false,
      withNodeIndex = false
    } = options;
    return (0, _tnodeSnapshot.default)(this, {
      withStyles,
      withNodeIndex
    });
  },

  hasClass(className) {
    return this.classes.indexOf(className) > -1;
  },

  toString() {
    return this.snapshot();
  },

  setMarkers(targetMarkers, parentMarkers) {
    var _this$elementModel2, _this$init$context$se, _this$init$context;

    if ((_this$elementModel2 = this.elementModel) !== null && _this$elementModel2 !== void 0 && _this$elementModel2.setMarkersForTNode) {
      this.elementModel.setMarkersForTNode(targetMarkers, parentMarkers, this);
    }

    setMarkersFromAttributes(targetMarkers, parentMarkers, this);
    (_this$init$context$se = (_this$init$context = this.init.context).setMarkersForTNode) === null || _this$init$context$se === void 0 ? void 0 : _this$init$context$se.call(_this$init$context, targetMarkers, parentMarkers, this);
  },

  getReactNativeProps() {
    if (this.__nativeProps === false) {
      var _this$elementModel3;

      const staticFromModel = transformPropsDefinitionsToSwitch((_this$elementModel3 = this.elementModel) === null || _this$elementModel3 === void 0 ? void 0 : _this$elementModel3.reactNativeProps);

      const dynamicFromAttrs = this.__generateNativePropsFromTNode();

      const autoGeneratedProps = mergeSwitches(staticFromModel, dynamicFromAttrs);

      const dynamicFromModel = this.__generateDynamicNativePropsFromModel(autoGeneratedProps);

      this.__nativeProps = mergeSwitches(autoGeneratedProps, dynamicFromModel);
    }

    return this.__nativeProps;
  },

  initialize(init) {
    var _this$attributes$clas;

    this.init = init;
    this.classes = ((_this$attributes$clas = this.attributes.class) === null || _this$attributes$clas === void 0 ? void 0 : _this$attributes$clas.split(/\s+/)) || emptyClasses;
    const parentMarkers = init.parent ? init.parent.markers : _markersPrototype.default.extend();
    this.markers = parentMarkers.extend();
    this.setMarkers(this.markers, parentMarkers, this); // Avoid very long prototype chains by assigning parent to current
    // when current has no own properties

    if (Object.keys(this.markers).length === 0) {
      this.markers = parentMarkers;
    }

    this.styles = init.styles || init.context.stylesMerger.buildStyles(this.attributes.style, this.parentStyles || null, this);
  }

};

const TNodeCtor = function TNode(type, displayName, extraAccessors) {
  this.type = type;
  this.displayName = displayName;
  extraAccessors && Object.defineProperties(this, extraAccessors);
};

TNodeCtor.prototype = prototype;
var _default = TNodeCtor;
exports.default = _default;
//# sourceMappingURL=TNodeCtor.js.map