"use strict";

import React from 'react';
import { View } from 'react-native';
import { useToaster } from '../headless';
import { Toast } from './Toast';
import { useSafeAreaInsets } from 'react-native-safe-area-context';
import { useScreenReader } from '../utils';
import { useKeyboard } from '../utils';
import { jsx as _jsx } from "react/jsx-runtime";
export const Toasts = ({
  overrideDarkMode,
  extraInsets,
  onToastHide,
  onToastPress,
  onToastShow,
  providerKey = 'DEFAULT',
  preventScreenReaderFromHiding,
  defaultStyle,
  globalAnimationType,
  globalAnimationConfig
}) => {
  const {
    toasts,
    handlers
  } = useToaster({
    providerKey
  });
  const {
    startPause,
    endPause
  } = handlers;
  const insets = useSafeAreaInsets();
  const isScreenReaderEnabled = useScreenReader();
  const {
    keyboardShown: keyboardVisible,
    keyboardHeight
  } = useKeyboard();
  if (isScreenReaderEnabled && !preventScreenReaderFromHiding) {
    return null;
  }
  return /*#__PURE__*/_jsx(View, {
    style: {
      position: 'absolute',
      top: insets.top + (extraInsets?.top ?? 0) + 16,
      left: insets.left + (extraInsets?.left ?? 0),
      right: insets.right + (extraInsets?.right ?? 0),
      bottom: insets.bottom + (extraInsets?.bottom ?? 0) + 16
    },
    pointerEvents: 'box-none',
    children: toasts.map(t => /*#__PURE__*/_jsx(Toast, {
      toast: {
        ...t,
        animationType: t.animationType || globalAnimationType || 'timing',
        animationConfig: t.animationConfig || globalAnimationConfig || {
          duration: 300
        }
      },
      startPause: startPause,
      endPause: endPause,
      updateHeight: handlers.updateHeight,
      offset: handlers.calculateOffset(t, {
        reverseOrder: true
      }),
      overrideDarkMode: overrideDarkMode,
      onToastHide: onToastHide,
      onToastPress: onToastPress,
      onToastShow: onToastShow,
      extraInsets: extraInsets,
      defaultStyle: defaultStyle,
      keyboardVisible: keyboardVisible,
      keyboardHeight: keyboardHeight
    }, t.id))
  });
};
//# sourceMappingURL=Toasts.js.map