import { useEffect, useState } from "react";
import { CSSListener, parseCSSValue } from "../core/web/index.js";
const documentStyles = typeof document !== "undefined" ? window.getComputedStyle(document.documentElement) : null;
const getVariableValue = (name) => {
  if (!documentStyles) {
    return void 0;
  }
  const value = documentStyles.getPropertyValue(name).trim();
  if (value === "") {
    return void 0;
  }
  return parseCSSValue(value);
};
let warned = false;
export const useCSSVariable = (name) => {
  const [value, setValue] = useState(getVariableValue(name));
  useEffect(() => {
    const updateValue = () => setValue(getVariableValue(name));
    const themeListenerDispose = CSSListener.addThemeListener(updateValue);
    const classListenerDispose = CSSListener.addListener(":root", updateValue);
    updateValue();
    return () => {
      themeListenerDispose();
      classListenerDispose();
    };
  }, [name]);
  if (value === void 0 && __DEV__ && !warned) {
    warned = true;
    console.warn(
      `We couldn't find your variable ${name}. Make sure it's used at least once in your className, or define it in a static theme as described in the docs: https://docs.uniwind.dev/api/use-css-variable`
    );
  }
  return value;
};
