import { jsx } from "react/jsx-runtime";
import { FlatList as RNFlatList } from "react-native";
import { copyComponentProperties } from "../utils.js";
import { toRNWClassName } from "./rnw.js";
export const FlatList = copyComponentProperties(RNFlatList, (props) => {
  const hasSingleColumn = !("numColumns" in props) || props.numColumns === 1;
  return /* @__PURE__ */ jsx(
    RNFlatList,
    {
      ...props,
      style: [toRNWClassName(props.className), props.style],
      columnWrapperStyle: hasSingleColumn ? void 0 : [toRNWClassName(props.columnWrapperClassName), props.columnWrapperStyle],
      contentContainerStyle: [toRNWClassName(props.contentContainerClassName), props.contentContainerStyle],
      ListFooterComponentStyle: [toRNWClassName(props.ListFooterComponentClassName), props.ListFooterComponentStyle],
      ListHeaderComponentStyle: [toRNWClassName(props.ListHeaderComponentClassName), props.ListHeaderComponentStyle]
    }
  );
});
export default FlatList;
