import { jsx } from "react/jsx-runtime";
import { Pressable as RNPressable } from "react-native";
import { UniwindStore } from "../../core/native/index.js";
import { copyComponentProperties } from "../utils.js";
import { useStyle } from "./useStyle.js";
export const Pressable = copyComponentProperties(RNPressable, (props) => {
  const style = useStyle(props.className, {
    isDisabled: Boolean(props.disabled)
  });
  return /* @__PURE__ */ jsx(
    RNPressable,
    {
      ...props,
      style: (state) => {
        if (state.pressed) {
          return [
            UniwindStore.getStyles(
              props.className,
              { isDisabled: Boolean(props.disabled), isPressed: true }
            ).styles,
            typeof props.style === "function" ? props.style(state) : props.style
          ];
        }
        return [style, typeof props.style === "function" ? props.style(state) : props.style];
      }
    }
  );
});
export default Pressable;
