"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCSSVariable = void 0;
var _react = require("react");
var _native = require("../core/native");
var _types = require("../types");
const getVariableValue = name => {
  return _native.UniwindStore.vars[name];
};
let warned = false;
const useCSSVariable = name => {
  const [value, setValue] = (0, _react.useState)(getVariableValue(name));
  (0, _react.useEffect)(() => {
    const updateValue = () => setValue(getVariableValue(name));
    const dispose = _native.UniwindStore.subscribe(updateValue, [_types.StyleDependency.Theme]);
    updateValue();
    return dispose;
  }, [name]);
  if (value === void 0 && __DEV__ && !warned) {
    warned = true;
    console.warn(`We couldn't find your variable ${name}. Make sure it's used at least once in your className, or define it in a static theme as described in the docs: https://docs.uniwind.dev/api/use-css-variable`);
  }
  return value;
};
exports.useCSSVariable = useCSSVariable;